# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ODKTrace2WKTDialog
                                 A QGIS plugin
 This plugin converts ODK geotraces to Well-Known Text
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-09-07
        git sha              : $Format:%H$
        copyright            : (C) 2019 by Samweli Mwakisambwe
        email                : smwltwesa6@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from .qgis_utilities import (
    display_warning_message_box)
from .exceptions import (
    ImportDialogError)

from qgis.PyQt.QtCore import QSettings

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'odktrace2wkt_dialog_base.ui'))


class ODKTrace2WKTDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(ODKTrace2WKTDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

    def accept(self):
        try:
            valid = self.require_input()

            if valid:
                self.save_state()
                self.done(1)

        except ImportDialogError as exception:
            error_dialog_title = self.tr("Error")

    def require_input(self):
        """Ensure input files has been entered in dialog .

        :raises: ImportDialogError - when
        input file is empty
        """
        filePath = self.inputQgsFileWidget.filePath()

        if filePath is not '':
            if self.is_file_csv(filePath):
                return True
            else:
                display_warning_message_box(
                    self,
                    self.tr('Input Error'),
                    self.tr('Input file must have ".csv" extension'))
                return False
        else:
            display_warning_message_box(
                self,
                self.tr('Error'),
                self.tr('Input file cannot be empty.'))
            return False

    def is_file_csv(self, path):
        """Checks file if has csv extension"""

        filename, file_extension = os.path.splitext(path)

        if file_extension == '.csv':
            return True
        else:
            return False

    def restore_state(self):
        """ Read last state of GUI from configuration file."""
        settings = QSettings()
        try:
            input_file = settings.value('input_file', type=str)
            column = settings.value('column', type=int)
            delimiter = settings.value('delimiter', type=int)

        except TypeError:
            input_file = ''
            column = 0
            delimiter = 0

        self.inputQgsFileWidget.setFilePath(input_file)
        self.column_combo_box.setCurrentIndex(column)
        self.delimiter_combo_box.setCurrentIndex(delimiter)

    def save_state(self):
        """ Store current state of GUI to configuration file """
        settings = QSettings()

        settings.setValue(
            'input_file',
            self.inputQgsFileWidget.filePath()
        )
        settings.setValue(
            'column',
            self.column_combo_box.currentIndex()
        )
        settings.setValue(
            'delimiter',
            self.column_combo_box.currentIndex()
        )