# -*- coding: utf-8 -*-
"""
/***************************************************************************
 ObmConnect
                                 A QGIS plugin
 Plugin for connecting to OpenBioMaps and loading spatial layers.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-07-21
        copyright            : (C) 2025 by Attila Gáspár
        email                : gezsaj@gmail.com
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

import sys
import os

# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load ObmConnect class from file ObmConnect.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    # Add thirdparty to path BEFORE importing the plugin class
    plugin_dir = os.path.dirname(os.path.realpath(__file__))
    thirdparty_path = os.path.join(plugin_dir, 'thirdparty')
    
    if os.path.exists(thirdparty_path) and thirdparty_path not in sys.path:
        sys.path.insert(0, thirdparty_path)
        
    from .obm_connect import ObmConnect
    return ObmConnect(iface)
