# OBM Connect QGIS Plugin

**OBM Connect** is a QGIS plugin that enables users to efficiently access, filter, and visualize biodiversity and environmental data from the OpenBioMaps system (https://openbiomaps.org) directly within the QGIS environment.

## Key Features

* **Custom Query Form & Filter Validation:**  
  A powerful filter form lets users select and download only the required data from the server. Integrated validation ensures only syntactically correct queries are sent. All possible values for each database field are displayed for easy query building.
  
  ![Filter](docs/filter.png)

* **SQL to GraphQL Parser:**  
  The plugin automatically converts user-friendly SQL-like filters into GraphQL queries. This supports advanced features like **polygon-based spatial filtering**. (GraphQL button)

* **Flexible Data Loading:**  
  Support for both spatial (points, lines, polygons) and **non-spatial records**. Non-spatial records are loaded as CSV-backed layers.
  
  ![Tables](docs/tables.png)

* **Integrated Image Viewer:**  
  View associated photographs directly within QGIS using the "Picture" action.
  
  ![Picture Action](docs/picture_action.png)

* **Project-Based Storage:**  
  Manage where your data is saved using the directory selector. Toggling the "Save as temporary" option automatically updates the target path to the current QGIS project directory, streamlining your workspace organization.

 ![Login](docs/connect.png)

* **Multi-Language Support:**  
  The plugin is available in both English and **Hungarian**.

## Important Information

* **Record Visibility:**  
  The number of downloaded records may differ from the count shown in the table list because OpenBioMaps enforces **record-level permissions**. You only download the data you have rights to see.
  
* **Authentication Tokens:**  
  If you encounter terms like Access or Refresh tokens during authentication:
  - **Access Token:** A short-lived key used for immediate data requests.
  - **Refresh Token:** A longer-lived key used to securely renew your access without needing to log in again manually.

* **Map Tool Limitation:**  
  Currently, the "Picture" action tool on the map canvas searches for features only within the **currently active layer**.

## Workflow Benefits

* **Convenient Filtering:**  
  Save time and bandwidth by filtering large datasets on the server before loading.
* **Seamless Authentication:**  
  Automatic login capabilities provide a smooth startup experience.
* **Direct Media Access:**  
  Quickly verify data points by viewing attached field photos without leaving QGIS.

## Summary

OBM Connect for QGIS bridges the gap between the OpenBioMaps database and your GIS workspace, providing an professional-grade tool for researchers and environmental specialists to work with high-quality, curated spatial data.

