# Centralized OBM API configuration and helper builders

DEFAULT_OBM_SERVER = "openbiomaps.org"
API_VERSION = "v3"

# Endpoints / paths
OAUTH_PATH = "/oauth/token.php"
# PDS_PATH_TEMPLATE = "/projects/{project}/v2.6/pds.php"
SERVER_API_PATH = "https://{server}/server-api/{version}/projects"
PROJECT_API_PATH_TEMPLATE = "{project_domain}/api/{version}/"
UNIQUE_VALUES_PATH_TEMPLATE = "{project_domain}/api/{version}/data-tables/{schema}/{table}/{field}/unique-values"
GETPHOTO_PATH_TEMPLATE = "{project_domain}/getphoto?ref="     # ends with '&getfullimage' for original image in picture_action.py

# # Scopes
SCOPE_GET_DATA = "get_data"
SCOPE_WEBPROFILE = "webprofile"

def build_oauth_url(server: str) -> str:
    return f"https://{server}{OAUTH_PATH}"

# def pds_api_url(server: str, project: str, version: str = API_VERSION) -> str:
#     return f"https://{server}{PDS_PATH_TEMPLATE.format(project=project, version=version)}"

def build_projects_url(server: str, version: str = API_VERSION) -> str:
    return SERVER_API_PATH.format(server=server, version=version)

def build_project_api_url(project_domain: str, version: str = API_VERSION) -> str:
    return f"{PROJECT_API_PATH_TEMPLATE.format(project_domain=project_domain, version=version)}"

def build_unique_values_url(project_domain: str, schema: str, table:str, field: str, version: str = API_VERSION) -> str:
    return UNIQUE_VALUES_PATH_TEMPLATE.format(project_domain=project_domain, version=version, schema=schema, table=table, field=field)

def build_getphoto_url(project_domain: str) -> str:
    return GETPHOTO_PATH_TEMPLATE.format(project_domain=project_domain)
    