# Centralized OBM API configuration and helper builders

DEFAULT_OBM_SERVER = "openbiomaps.org"
API_VERSION = "v3"

# Endpoints / paths
OAUTH_PATH = "/oauth/token.php"
# PDS_PATH_TEMPLATE = "/projects/{project}/v2.6/pds.php"
PROJECT_API_PATH_TEMPLATE = "/projects/{project}/api/{version}/"
SERVER_API_PATH = "/server-api/v3/projects"
UNIQUE_VALUES_PATH_TEMPLATE = ("/projects/{project}/api/{version}/data-tables/{schema}/{table}/{field}/unique-values")

# # Scopes
# SCOPE_GET_DATA = "get_data"
# SCOPE_OFFLINE = "offline_access"

def build_oauth_url(server: str) -> str:
    return f"https://{server}{OAUTH_PATH}"

# def pds_api_url(server: str, project: str, version: str = API_VERSION) -> str:
#     return f"https://{server}{PDS_PATH_TEMPLATE.format(project=project, version=version)}"

def build_project_api_url(server: str, project: str, version: str = API_VERSION) -> str:
    return f"https://{server}{PROJECT_API_PATH_TEMPLATE.format(project=project, version=version)}"

def build_projects_url(server: str) -> str:
    return f"https://{server}{SERVER_API_PATH}"

def build_unique_values_url(server: str, project: str, schema: str, table:str, field: str, version: str = API_VERSION) -> str:
    return (
        f"https://{server}"
        f"{UNIQUE_VALUES_PATH_TEMPLATE.format(project=project, version=version, schema=schema, table=table, field=field)}"
    )