# OBM Connect QGIS Plugin

**OBM Connect** is a QGIS plugin that enables users to efficiently access, filter, and visualize biodiversity and environmental data from the OpenBioMaps system (https://openbiomaps.org) directly within the QGIS environment.

## Key Features

* **Custom Query Form:**  
  A powerful filter form lets users select and download only the required data from the server, mimicking the familiar QGIS interface. All possible values for each database field are displayed, making it easy and safe to build queries and filter conditions.

  ![Filter](docs/filter.png)
* **Filter Validation:**  
  Integrated validation ensures only syntactically correct queries are sent, minimizing errors and maximizing data security.
* **SQL to GraphQL Parser:**  
  The plugin automatically converts user-friendly SQL-like filters from the query form into GraphQL queries understood by the new OpenBioMaps API. This enables seamless integration with advanced back-end data access protocols.
* **Geometry Table Visualization:**  
  When accessing project tables, the plugin displays the type of associated geometries (points, lines, polygons) and the names of geometry fields, making project selection and analysis easier.

  ![Tables](docs/tables.png)
* **Automatic Login:**  
  The plugin can automatically connect to the OBM system at QGIS startup, providing a smooth and uninterrupted workflow for end-users.
  
  ![Login](docs/connect.png)

## Workflow Benefits

* **Convenient Filtering:**  
  Users can flexibly and securely filter large datasets before loading them into QGIS, saving time and resources.
* **Enhanced Security:**  
  Built-in validators and authentication mechanisms ensure queries and data handling remain safe.
* **Smarter Data Visualization:**  
  Direct visual feedback on geometry types and field names helps specialist users with selection and deeper spatial analysis.

## Summary

OBM Connect for QGIS adds advanced, user-friendly data access, validation, and visualization capabilities for the OpenBioMaps platform. The direct plugin integration ensures up-to-date, curated environmental datasets are just a few clicks away, enabling researchers and professionals to work more efficiently with clean, relevant data inside QGIS.

