# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'nvdb_endringsset_status_window.ui'
#
# Created by: PyQt5 UI code generator 5.15.4
#
# WARNING: Any manual changes made to this file will be lost when pyuic5 is
# run again.  Do not edit this file unless you know what you are doing.

from PyQt5.QtWidgets import QTableWidgetItem, QAbstractItemView
# from PyQt5 import QtCore, QtGui, QtWidgets
# from PyQt5.QtCore import QObject, pyqtSlot, pyqtSignal

import xml.etree.ElementTree as ET

from qgis.PyQt import uic

import requests, io
import os

FORM_CLASS, BASE_CLASS = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'more_window_status.ui'))


class Ui_MoreWindowStatus(BASE_CLASS, FORM_CLASS):

    def __init__(self):
        super().__init__()

        self.setupUi(self)

        # list of endringssett with nvdb id and endpoint for status
        self.endringssett_list: list = []
        self.token: str = str()  # to store token when feeding
        self.current_nvdbid_index: int = int()  # to track endringsett that has same nvdbid when doing relasjoner, but different status

        # configuring table result widget
        table_result_widget_columns = {'type endringssett', 'nvdbid'}

        self.table_result_widget.setColumnCount(2)

        self.table_result_widget.setHorizontalHeaderLabels(table_result_widget_columns)
        self.table_result_widget.setEditTriggers(QAbstractItemView.NoEditTriggers)
        self.table_result_widget.setSelectionBehavior(QAbstractItemView.SelectRows)

        # connecting signal and slots
        self.table_result_widget.clicked.connect(self.on_clicked)

    def feed_changeset(self, changeset):

        self.populate_table_result(changeset)

        self.token = changeset['token']

        # calculating index
        # if len( self.endringssett_list ) > 0:

        self.current_nvdbid_index = len(self.endringssett_list)

        nvdbid = changeset['target']['current_nvdbid']

        new_endringssett = {

            'nvdbid': str(nvdbid) + '_' + str(self.current_nvdbid_index),
            'endpoint_status': changeset['target']['status_after_sent']
        }

        self.endringssett_list.append(new_endringssett)

        # print(self.endringssett_list)

    def populate_table_result(self, changeset):

        row: int = self.table_result_widget.rowCount()

        self.table_result_widget.setRowCount(row + 1)

        self.table_result_widget.setItem(row, self.getIndexFieldFromColumn('type endringssett'),
                                         QTableWidgetItem(changeset['type']))
        self.table_result_widget.setItem(row, self.getIndexFieldFromColumn('nvdbid'),
                                         QTableWidgetItem(str(changeset['target']['current_nvdbid'])))

    def on_clicked(self, item):

        self.check_status()

    def check_status(self):

        nvdbid = self.table_result_widget.item(self.table_result_widget.currentRow(),
                                               self.getIndexFieldFromColumn('nvdbid')).text()

        formed_nvdbid_index = nvdbid + '_' + str(self.table_result_widget.currentRow())

        # print('current nvdbid formed:', formed_nvdbid_index)

        for changeset in self.endringssett_list:

            if formed_nvdbid_index == changeset['nvdbid']:
                self.show_status(changeset['endpoint_status'])

    def show_status(self, endpoint: str = str()):

        header = {
            'X-Client': 'QGIS Skriv',
            'Type-Content': 'application/xml',
            'Authorization': self.token
        }

        concat_str: str = str()  # to concatenate results

        response = requests.get(endpoint, headers=header)

        # print('response from show_status in more_window_status:', response.text)
        # print('token:', self.token)

        if response.ok:

            file_stream = io.StringIO(response.text)

            try:

                tree = ET.parse(file_stream)

                root = tree.getroot()

                concat_str = str('')
                show_melding = str('')

                for element in root.findall('.//'):

                    if 'vegobjekt' in element.tag:

                        for melding in element.findall('.//'):

                            if 'melding' in melding.tag:
                                show_melding += f'<p style="color:blue">{melding.text}</p>'

                    if 'fremdrift' in element.tag:

                        if 'BEHANDLES' or 'UTFØRT_OG_ETTERBEHANDLET' in element.text:
                            concat_str += f'<p style="color:green">{element.text}</p>'

                        if 'AVVIST' in element.text:
                            concat_str = f'<p style="color:red">{element.text}</p>'

                # if concat_str:
                #     self.statusText.setText(concat_str + show_melding)

            except ET.ParseError:

                concat_str = f'<p style="color:red">prøver igjen</p>'
                show_melding = ''

            if concat_str:
                self.text_result_status.setText(concat_str + show_melding)

    def getIndexFieldFromColumn(self, columnName):

        column_index = 0  # 0 field by default
        columnText = ''

        for _column in range(0, self.table_result_widget.columnCount()):

            columnText = self.table_result_widget.horizontalHeaderItem(_column).text()

            if columnName in columnText:
                column_index = _column

        return column_index
