import re
class Vegobjekt_parser:
    def __init__(self):
        self.endpoint = ""
        self.endpointarr =[]
        self.result = {}
        self.overlappListe = []
        self.filter_list = []
        
    
    #external method, used before getData() to initalize the url we want to parse. Also used in updateUrl method
    def setEndpoint(self, newEndpoint):
       self.result = {}
       self.endpoint =  newEndpoint
       self.endpointarr = self.___preprocessUrl()
       self.overlappListe = []
    
    #internal method, extracts the egenskaper from the current egenskaper element, splits it based on if there are more
    # input example : 1. "(egenskaptype operator verdi)"  2. "(egenskaptype operator verdi) %20AND%20 (egenskaptype operator verdi)"
    # output [{"egenskaptype": egenskaptype, "operator": "operator", "verdi": "verdi")}, {"egenskaptype": egenskaptype, "operator": "operator", "verdi": "verdi")}]
    # output hvis vi har relasjon : [{"relasjon_typer": [relasjon_typer] , "egenskaper" : [egenskaper_liste]}]
    def ___getEgenskap(self, egenskap_data):
            listOfDict = []
            egenskaper = egenskap_data
            egenskaperData = egenskaper

            # we copy the string and preprocess in two ways

            # 1. if we have single egenskap
            if "egenskap" in egenskap_data:
                egenskaper = egenskap_data

            # 2. if we have several egenskaper
            if "AND" in egenskap_data :
                    
                
               
                egenskaper = self.___split_egenskap_into_array(egenskap_data)
                
              
                # if we have "AND or 20AND in the egenskaper will be type(egenskaper) = ([])" , in this case we iterate
                
                for i in range(0, len(egenskaper)):
                    obj = {}
                    
                    if "relasjon" not in egenskaper[i]:
                    
                       
                        egenskaper[i] = self.___getEgenskapHelper_clean(egenskaper[i])
                        obj = self.___getEgenskapHelper_split(egenskaper[i])
                        str = self.___stringify_egenskap(obj)
                       
                        obj["str"] = f"{str}"
                        
                    else:
                        
                        obj = self.___getRelasjon(egenskaper[i])
                    
                    listOfDict.append(obj)
            
           # if egenskaper string just contains a single egenskap, we will end up with type(egenskaper) = (str)
            else:
                
                if "relasjon" not in egenskap_data:
                    egenskaper = self.___getEgenskapHelper_clean(egenskaper)
                    
                    obj = self.___getEgenskapHelper_split(egenskaper)
                    
                    str = self.___stringify_egenskap(obj)
                    obj["str"] = f"{str}"
                    listOfDict.append(obj)
                else:
                    
                    relasjoner_formatted = self.___getRelasjonerHelper(egenskap_data)
                    
                    relasjoner = self.___getRelasjon(relasjoner_formatted)
                    
                    listOfDict.append(relasjoner)
                    
            return listOfDict
    
    # method takes egenskap=(2294=2192) AND relasjon(67, (2123=2314)) -> ["relasjon(67, (2123=2314))", "(2294=2192)"]
    # used to identify egenskap and relasjon
    def ___split_egenskap_into_array(self, input_string):
        egenskapstr = input_string.replace("egenskap=", "")
        matches = []  
        i = 0
        n = len(egenskapstr)
        
        while i < n:
            if egenskapstr[i:i+8] == "relasjon":
                i += 8  
                if egenskapstr[i] == '(':
                    i += 1  
                    depth = 1  
                    start = i  
                    while i < n and depth > 0:
                        if egenskapstr[i] == '(':
                            depth += 1
                        elif egenskapstr[i] == ')':
                            depth -= 1
                        i += 1
                    
                    matches.append('relasjon(' + egenskapstr[start:i-1] + ')')
            # We have found an egenskap, so we need to capture everything inside the parentheses
            elif egenskapstr[i] == '(':
                
                start = i
                i += 1
                
                while i < n and egenskapstr[i] != ')':
                    i += 1
                
                matches.append(egenskapstr[start:i+1])
                i += 1  
            
            else:
                i += 1  
    
        if not any('relasjon' in match for match in matches):
            # Split the entire input string by "AND" (outside of relasjon())
            expressions = [part.strip() for part in input_string.split('AND') if part.strip()]
            matches = expressions  

        
        return matches
        
    
    def ___splitEgenskaper(self, egenskaper):
        
        egenskaperSplitted = egenskaper.split(" AND ")
        
        return egenskaperSplitted
        
    
    # method that takes in a relasjon string. We use this in the getEgenskaper, because relasjon is a egenskap.
    # input example :  "relasjon(67, relasjon(55, (3779 = 4822)))"
    # output example : {"relasjon_typer": [67, 55] , "egenskaper" : [{'type': '3779', 'operator': '=', 'verdi': '4822', 'str': '(3779=4822)'}], "str": "relasjon(67, relasjon(55, (3779 = 4822)))"}
    def ___getRelasjon(self, relasjonerdata):

        # we use a regex to find the types of the relasjoner.
        
        type_pattern = r"relasjon\((\d+),\s*"
        coupled = {}
        relasjon_typer = re.findall(type_pattern, relasjonerdata)
        # we use a regex to find the egenskaper at the end of the relasjoner query.
        egenskap_pattern = r"relasjon\((\d+),\s*(.*)\)\s*$"
        egenskap_match = re.search(egenskap_pattern, relasjonerdata)
        
        last_relasjon = egenskap_match.group(2).strip() if egenskap_match else None
        
        
        egenskaper = relasjonerdata.split(",")[-1]
        
        egenskaper_clean = egenskaper.replace("(", "")
        egenskaper_clean = egenskaper_clean.replace(")", "")
        
       
        # we get the egenskaper here as [{type, operator, verdi}]
        egenskaper_liste = self.___getEgenskap(egenskaper_clean)
        
        # we stringify the egenskaper, and add it to the egenskap dictionary. We need this in later stages of the flow
        egenskaper_liste_str = self.___stringify_egenskap(egenskaper_liste)
       
        relasjon_str = self.___stringify_egenskap({"relasjon_typer": relasjon_typer , "egenskaper" : egenskaper_liste})

        # this is the finished relasjon dictionary
        coupled = {"relasjon_typer": relasjon_typer , "egenskaper" : egenskaper_liste, "str": relasjon_str}
        
            
        
        return coupled
    #internal method, cleans the egenskaper with regex
    def ___getEgenskapHelper_clean(self, egenskaperData):
            #pattern = rf'[\(\)"]|{"egenskap"}'
            #egenskaperData = re.sub(pattern, '', egenskaperData)
            
           
            egenskaperData = egenskaperData.replace('egenskap=', "")
            
            return egenskaperData

    #internal method used in getEgenskaper method, splits the egenskaper based on if its one or more, and based on the operators used
    #input : "(3779 = 4822)"
    #returns a dictionary of the egenskap
    # for now we have hard coded if - elif guarding to split the egenskaper, this could also be done with regex
    def ___getEgenskapHelper_split(self, egenskaperData):
        operator = "ingen operator"
        egenskapVerdi_formatted = []
        
        if "!%3D" in egenskaperData:
            operator = "!="
            egenskapVerdi_formatted = egenskaperData.split("!%3D")
            
        elif "%3D" in egenskaperData:
            operator = "="
            egenskapVerdi_formatted = egenskaperData.split("%3D")
        
        elif  "!=" in egenskaperData:
            operator = "!="
            egenskapVerdi_formatted = egenskaperData.split("!=")
            
        elif  "!" in egenskaperData:
            operator = "!"
            egenskapVerdi_formatted = egenskaperData.split("!")
        
        elif  ">=" in egenskaperData:
            operator = ">="
            egenskapVerdi_formatted = egenskaperData.split(">=")
        
        elif  "<=" in egenskaperData:
            operator = "<="
            egenskapVerdi_formatted = egenskaperData.split("<=")
        
        elif  "%3C" in egenskaperData:
            operator = "<"
            egenskapVerdi_formatted = egenskaperData.split("%3C")
        
        elif  ">" in egenskaperData:
            operator = ">"
            egenskapVerdi_formatted = egenskaperData.split(">")
        
        elif  "<" in egenskaperData:
            operator = "<"
            egenskapVerdi_formatted = egenskaperData.split("<")
        
        elif  "%3E" in egenskaperData:
            operator = ">"
            egenskapVerdi_formatted = egenskaperData.split("%3E")
        
            
        else:
            operator = "="
            egenskapVerdi_formatted = egenskaperData.split("=")
        
        
        type = egenskapVerdi_formatted[0]
        type = type.replace('egenskap', "")
        type = type.strip("()")
        verdi = egenskapVerdi_formatted[1]
        verdi = verdi.strip("()")
        
      
        return {"type" : type, "operator" : operator, "verdi": verdi}

    # internal method that cleans the relasjoner string. Used before getRelasjon method
    def ___getRelasjonerHelper(self, relasjonerData):
        operator = ""
        relasjonerDataFormatted = relasjonerData
        
        if "!%3D" in relasjonerDataFormatted:
            relasjonerDataFormatted = relasjonerDataFormatted.replace("!%3D", "!=")
        
        if "%20" in relasjonerDataFormatted:
              relasjonerDataFormatted = relasjonerDataFormatted.replace("%20", "")
                
        if "%3D" in relasjonerDataFormatted:
              relasjonerDataFormatted = relasjonerDataFormatted.replace("%3D", "=")
        
        if "%3E" in relasjonerDataFormatted:
              relasjonerDataFormatted = relasjonerDataFormatted.replace("%3E", ">")
              
        
        if  "%3C" in relasjonerDataFormatted:
            
              relasjonerDataFormatted = relasjonerDataFormatted.replace("%3C", "<")
        
       
        relasjonerDataFormatted = relasjonerDataFormatted.replace("egenskap=", "")
        
        
        return relasjonerDataFormatted

    # internal method that takes in a overlapp string.
    # input example :  "978(12612=21771)"
    # output example [{'type': '105', 'egenskaper': [{'type': '2021', 'operator': '=', 'verdi': '2738']}, {'type': '978', 'egenskaper': [{'type': '12612', 'operator': '=', 'verdi': '21771'}]
    # it also has the str key as shown with egenskap and relasjon that holds the entire expression, but it's too long to show in this example
    def ___getOverlapp(self, overlapp_data):
           
            pattern_number = r"^overlapp\s*=\s*\d+$"
            
            
            if re.match(pattern_number, overlapp_data):
               
                type = overlapp_data.replace("overlapp=", "")
                
                return {"type":type, "str": f"{type}"}
            # cover case when using string expression
            if 'overlapp="' in overlapp_data:
               
                
                divide_type_and_egenskap = overlapp_data.split("(", 1)
               
                type = divide_type_and_egenskap[0].replace('overlapp="', "", 1)
                egenskap = divide_type_and_egenskap[1]
               
                return {{type}({egenskaper})}

            # main case
            elif 'overlapp=' in overlapp_data:
                    
                    type = ""
                    
                    if "(" in overlapp_data :
                        divide_type_and_egenskap = overlapp_data.split("(", 1)
                        type = divide_type_and_egenskap[0].replace('overlapp=', "", 1)
                        egenskap = "egenskap=" + divide_type_and_egenskap[1]
                        egenskap_liste = self.___getEgenskap(egenskap)
                        
                        
                        egenskaper_liste_str = self.___stringify_egenskap(egenskap_liste)
                        return {"type":type, "egenskaper" : egenskap_liste, "str": f"{type}{egenskaper_liste_str}"}
                    else:
                        
                        type = overlapp_data.replace('overlapp=', "", 1)
                        return {}
                    
    #internal method to connect the strings and arrays and put them into format that filter accepts. This is used in getData mehod and sets the self.filter_list = queries
    #If we have several egenskaper, it will combine them into this format : {"egenskap": "egenskap1 AND egenskap2 and so on....."}
    #If we have several overlapp, it will add tgem one by one them into a query of : overlapp = "{'overlapp': '978(12612=21771)'}, {'overlapp': '922(21412=4212)'}"
    # for single values its just {key:value}. Example : {"srid" : "1583"}
    # entire output could look like this : [{'overlapp': '978(12612=21771)'}, {'egenskap': '(3779=4822) AND relasjon(67, (5277>4) AND (8945<2000)'}, {"srid" : "1583"}]
    def getData_filter_input(self):
        queries = []
        self.filter_list = []
        for k, v in self.result.items():
            
            if type(v) == type([]):
                
                if k == "egenskap":
                   
                   egenskaper = self.___stringify_egenskap(v)
                   
                   queries.append({"egenskap": egenskaper})
                   continue
                elif k == "overlapp":
                    overlapper = []
                    for ov in v:
                       
                       ov_type = ov.get('type')
                       if ov.get("egenskaper"):
                            egenskaper = self.___stringify_egenskap(ov.get("egenskaper"))
                            overlapper.append(f"{ov_type}{egenskaper}")
                       else:
                            overlapper.append(f"{ov_type}")
                       continue
                    queries.append({"overlapp" : overlapper})
                
                elif k != "type":
                    
                    queries.append({k : v})
            
            elif type(v) != type([]) and k != "type" and k != "kartutsnitt":
                    
                    queries.append({k : v})
        # we use this in nvdb_beta_dialog to set the filter values
        self.filter_list = queries
        
        
        
       
        
    
    #external and internal method, we use the thendpoint that has been split into array format and loop through it
    # we must use setEndpoint before using this method. And in the setEndpoint we use ___preprocessUrl() that splits the url
    #the url https://nvdbapiles-v3.test.atlas.vegvesen.no/vegobjekter/581? will be [querystr1, querystr2, .....]
    # we then loop over the endpointarr and use if statments to handle egenskap, overlapp fylke, and kommune
    # we set the  self.result[query_key] = (query string being handled by f.eks getEgenskap, getOverlapp)
    def getData(self):
        self.overlappListe = []
        
        
        for elem in self.endpointarr:
            
            
            # if we find overlapp, handle it and add it to the result dictionary
            if "overlapp" in elem:
                
                self.overlappListe.append(self.___getOverlapp(elem))
                self.result["overlapp"] = self.overlappListe
                continue
                
            
            # if we find egenskap, handle it and add it to the result dictionary
            if "egenskap" in elem:
                
                self.result["egenskap"] = self.___getEgenskap(elem)
                continue
            
            
            
            
         
            # if we find fylke or kommune, handle it and add it to the result dictionary
            if "fylke" in elem or "kommune" in elem:
               
                query_values_result = []
                query_arr = elem.split("=")
                
                query = query_arr[0]
                query_values = query_arr[1]
                if "%2C" in query_values:
                    query_values = query_values.split("%2C")
                    query_values_result = [int(el) for el in query_values]
                
                else:
                    
                    query_values_result = [int(query_values)]
                   
                    
                self.result[query] = query_values_result
                continue
            
            
            uttrykkarr = elem.split("=")
            if len(uttrykkarr) > 1 and "kartutsnitt" not in elem:
                query = uttrykkarr[0]
                query_value = uttrykkarr[1]
               
                self.result[query] = query_value
  
        
        self.result["inkluder"] = 'alle'
        self.getData_filter_input()
        
        
        
        return self.result

    # method we use in more_window when we add a new egenskap, overlapp, relasjon from ui
    # example : User adds egenskap : {'type': '3779', 'operator': '=', 'verdi': '4822'}
    # https://nvdbapiles-v3.test.atlas.vegvesen.no/vegobjekter/581? -> https://nvdbapiles-v3.test.atlas.vegvesen.no/vegobjekter/581?egenskap=(3779=4822)
    # this method will update the endpoint with the result dictionary and call the getData method after doing so.
    # if the user just adds a url, and doesent use ui. We only call getData method. Else we will cal this method.
    def updateUrl(self):
        queries = []
        base = self.endpoint.split("?", 1)[0]
        
        
        for k, v in self.result.items():
           
            if type(v) == type([]):
                
                if k == "egenskap":
                  
                   egenskaper = self.___stringify_egenskap(v)
                   
                   queries.append(f"{k}={egenskaper}")
                elif k == "overlapp":
                   for ov in v:
                       ov_type = ov.get('type')
                       if ov.get('egenskaper'):
                            egenskaper = self.___stringify_egenskap(ov.get("egenskaper"))
                            queries.append(f"{k}={ov_type}{egenskaper}")
                       else:
                            queries.append(f"{k}={ov_type}") 
                
                else:
                    arr_str = [str(elem) for elem in v]
                    arr_joined = "%2C".join(arr_str)
    
                    queries.append(f"{k}={arr_joined}")
            else:
                    if k != "type":
                        queries.append(f"{k}={v}") 
                
         
        queries_as_str = "&".join(queries)
        
        
        self.setEndpoint(base + "?" + queries_as_str)
        
        self.getData()
       
    # internal method that makes a string of the list of egenskaper. We use this in the inputFilter method
    def ___stringify_egenskap(self, egenskaper_list):
        egenskaper_liste_str = ""
        egenskaper_liste_collect = []
        
        # case for if we have more than one egenskap
        if type(egenskaper_list) == type([]):
            for egenskap in egenskaper_list:
                if egenskap.get("relasjon_typer") :
                    relasjon_parsed = self.___stringify_relasjon(egenskap)
                    egenskaper_liste_collect.append(relasjon_parsed)
                else:
                    
                    egenskap_parsed = f"({egenskap['type']}{egenskap['operator']}{egenskap['verdi']})"
                    countLeft = egenskap_parsed.count("(")
                    countRight = egenskap_parsed.count(")")
                    if countLeft == 0:
                        egenskap_parsed = "(" + egenskap_parsed
                        countLeft = 1
                    if countRight == 0:
                        egenskap_parsed = egenskap_parsed + ")"
                        countRight = 1
                    if countLeft > 1:
                        while egenskap_parsed.startswith('(') and egenskap_parsed.count('(') > 1:
                            egenskap_parsed = egenskap_parsed[1:]
                    
                    if countRight > 1:
                        while egenskap_parsed.endswith(')') and egenskap_parsed.count(')') > 1:
                            egenskap_parsed = egenskap_parsed[:-1]
                            
                    egenskaper_liste_collect.append(egenskap_parsed)
                
            egenskaper_liste_str = " AND ".join(egenskaper_liste_collect)
            return egenskaper_liste_str

        # case for if we have single egenskap
        else:
            # we check if the current dictionary is a relasjon
            if egenskaper_list.get("relasjon_typer") :
                # if it is we stringify it with the relasjon method
                 relasjon_parsed = self.___stringify_relasjon(egenskaper_list)
                 return relasjon_parsed
            
            else:
                
                egenskap_parsed = ''.join(map(str, egenskaper_list.values()))
                
                return egenskap_parsed

    # internal method that makes a string of the list of relasjoner. We use this in the stringify_egenskap method
    def ___stringify_relasjon(self, relasjoner):
            
            relasjon_parsed = ""
            egenskaper_liste_str = []
            if relasjoner.get("relasjon_typer") :
                relasjon_array = relasjoner.get("relasjon_typer")
                
                
                egenskaper = ""
                egenskapstr = ""
                if relasjoner.get("egenskaper"):
                
                    egenskaper_liste = relasjoner.get("egenskaper")
                    egenskaper_liste_str = []
                    
                    egenskapstr = ""
                    for egenskap in egenskaper_liste:
                        egenskap_parsed = f"({egenskap['type']}{egenskap['operator']}{egenskap['verdi']})"
                        egenskaper_liste_str.append(egenskap_parsed)
                    
                    egenskapstr = " AND ".join(egenskaper_liste_str)
                
                relasjon_parsed = f"relasjon({relasjon_array[-1]},{egenskap_parsed}))"
                
                
                relasjonstr = ""
                
                count = 0
                for type in relasjon_array:
                    relasjonstr += f"relasjon({type},"
                    count += 1
                
                relasjonstr += f"{egenskapstr}{')' * count}"
                relasjon_parsed = relasjonstr
                
            else:
                egenskap_parsed = f'({"".join(map(str, egenskapelement.values()))})'.strip()
                
            
            return relasjon_parsed
                            
    #internal method, prepares the string for iteration by splitting it on & and ?
    #we assign endpointarr with the return value of this method, when using the setEndpoint method
    #example input : self.endpoint = https://nvdbapiles-v3.test.atlas.vegvesen.no/vegobjekter/581?egenskap=(3779%3D4822)
    #example output : self.endpointarr = ["egenskap=(3779%3D4822)"]
    # we also set the self.result["type"] = 581 in this example
    def ___preprocessUrl(self):
        
        formattedList = self.endpoint
        formattedList = formattedList.replace(" ", "")
        formattedList = formattedList.replace("%20", "")
        formattedList = formattedList.replace("AND", " AND ")
        formattedList = formattedList.split("vegobjekter/")
        self.base_url = formattedList.pop(0)
       
        formattedList = formattedList[0].split("?")
        if(len(formattedList) > 1):
            
            formattedList = formattedList[0].split("&") + formattedList[1].split("&")
    
        self.result["type"] = formattedList[0]
        
        return formattedList
    
    