import xml.etree.ElementTree as ET

#from delvisKorrEgenskaperCase import DelvisKorrEgenskaperCase
from .delvisKorrEgenskaperCase import DelvisKorrEgenskaperCase

class DelvisStedfestCase(DelvisKorrEgenskaperCase):
    def __init__(self, token, data, extra):
        super().__init__(token, data, extra)
        pass

    # additional method
    def formXMLStadfestingVegobjekt(self, vegobjekter, relation, stedfest_type):

        vegobjekt = ET.SubElement(vegobjekter, 'vegobjekt')

        vegobjekt.attrib = {
            'typeId': str(relation['typeid']),
            'nvdbId': str(relation['nvdbid']),
            'versjon': str(relation['versjon'])
        }

        stedfesting_tag = ET.SubElement(vegobjekt, 'stedfesting')

        stedfesting_tag.attrib = {'operasjon': 'oppdater'}

        ###############################################################################

        type_stedfesting: None

        # making subelement punkt, linje or flate
        if 'punkt' in stedfest_type:  # self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting = ET.SubElement(stedfesting_tag, stedfest_type)  # self.extra['stedfest_type'])

        if 'hjelpelinje' in stedfest_type:

            type_stedfesting = ET.SubElement(stedfesting_tag, 'linje')

        elif 'linje' in stedfest_type:  # self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting = ET.SubElement(stedfesting_tag, stedfest_type)  # self.extra['stedfest_type'])


        # for flate it is same as linje geometry type when sending in endringssett
        elif 'flate' in stedfest_type:  # self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting = ET.SubElement(stedfesting_tag, 'linje')

        # adding attributes to punkt, linje or flate sub-elements
        if 'punkt' in stedfest_type:  # self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting.attrib = {
                'veglenkesekvensNvdbId': str(self.extra['stedfest']['location']['veglenkesekvensnvdbid']),
                'posisjon': str(self.extra['stedfest']['location']['posisjon']['fra'])
            }

        elif 'linje' or 'hjelpelinje' or 'flate' in stedfest_type:  # self.extra['stedfest']['position']['stedfest_type']:

            from_pos = min(self.extra['stedfest']['location']['posisjon']['fra'],
                           self.extra['stedfest']['location']['posisjon']['til'])
            to_pos = max(self.extra['stedfest']['location']['posisjon']['fra'],
                         self.extra['stedfest']['location']['posisjon']['til'])

            type_stedfesting.attrib = {
                'veglenkesekvensNvdbId': str(self.extra['stedfest']['location']['veglenkesekvensnvdbid']),
                'fra': str(from_pos),  # be careful here with from and to
                'til': str(to_pos)  # instead of from and to is to and from
            }

        ###############################################################################

        '''
        type_stedfesting = ET.SubElement(stedfesting_tag, stedfest_type)
        
        type_stedfesting.attrib = {
            'veglenkesekvensNvdbId': str( relation['veglenkesekvensid'] ), 
            'posisjon': str( self.extra['stedfest']['location']['posisjon']['fra'] ) #str( self.extra['stedfest']['location']['posisjon'] ) #str( relation['posisjon'] )
        }
        '''

        # adding retning and sideposisjon
        retning = ET.SubElement(type_stedfesting, 'retning')
        retning.text = str(self.extra['stedfest']['location']['retning'])

        if self.extra['object_sideposisjon'][0].get('sideposisjon'):
            sideposisjon = ET.SubElement(type_stedfesting, 'sideposisjon')
            sideposisjon.text = self.extra['object_sideposisjon'][0].get('sideposisjon')

        # adding Validering to XML endringsett
        validering_objekt = ET.SubElement(vegobjekt, 'validering')
        lest_fra_nvdb = ET.SubElement(validering_objekt, 'lestFraNvdb')
        lest_fra_nvdb.text = relation['sist_modifisert']

    # override method
    def formXMLRequest(self, egenskaper_list, active_egenskap=True):
        root = ET.Element('endringssett')
        root.attrib = {'xmlns': 'http://nvdb.vegvesen.no/apiskriv/domain/changeset/v3'}

        nvdb_object_id = str(self.modified_data['nvdbid'])
        version = str(self.modified_data['versjon'])
        nvdb_object_type = str(self.extra['nvdb_object_type'])

        datakatalogversjon = ET.SubElement(root, 'datakatalogversjon')
        datakatalogversjon.text = self.extra['datakatalog_version']

        ansvarlig = ET.SubElement(root, 'ansvarlig')
        ansvarlig.text = self.extra['username']

        delvisKorriger = ET.SubElement(root, 'delvisKorriger')
        vegobjekter = ET.SubElement(delvisKorriger, 'vegobjekter')

        vegobjekt = ET.SubElement(vegobjekter, 'vegobjekt')
        vegobjekt.attrib = {'typeId': nvdb_object_type, 'nvdbId': nvdb_object_id, 'versjon': version}

        # egenskaper = ET.SubElement(vegobjekt, 'egenskaper')

        # adding geometry egenskaper in main object
        # for item in root.findall('.//'):

        #     if 'egenskaper' in item.tag:

        #         for eg_key, eg_value in egenskaper_list.items():

        #             if eg_key == 'Geometri, punkt' or eg_key == 'Geometri, linje' or eg_key == 'Geometri, flate':

        #                 new_egenskap = ET.SubElement(egenskaper, 'egenskap')
        #                 new_egenskap.attrib =  { 'typeId': str(eg_value), 'operasjon': 'oppdater' }

        #                 geometri_child_tag = ET.SubElement(new_egenskap, 'geometri')

        #                 srid_geometri_child_tag = ET.SubElement(geometri_child_tag, 'srid')
        #                 srid_geometri_child_tag.text = '5973'

        #                 wkt_geometri_child_tag = ET.SubElement(geometri_child_tag, 'wkt')
        #                 wkt_geometri_child_tag.text = self.extra['stedfest']['location']['physic_geometry']

        # adding stedfesting to main object in endringssett
        stedfesting_tag = ET.SubElement(vegobjekt, 'stedfesting')

        stedfesting_tag.attrib = {'operasjon': 'oppdater'}

        type_stedfesting: None

        # making subelement punkt, linje or flate
        if 'punkt' in self.extra['stedfest']['position']['stedfest_type']:
            type_stedfesting = ET.SubElement(stedfesting_tag, self.extra['stedfest_type'])

        if 'hjelpelinje' in self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting = ET.SubElement(stedfesting_tag, 'linje')

        elif 'linje' in self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting = ET.SubElement(stedfesting_tag, self.extra['stedfest_type'])


        # for flate it is same as linje geometry type when sending in endringssett
        elif 'flate' in self.extra['stedfest']['position']['stedfest_type']:
            print('hjelpelinje selected 1')

            type_stedfesting = ET.SubElement(stedfesting_tag, 'linje')

        # adding attributes to punkt, linje or flate sub-elements
        if 'punkt' in self.extra['stedfest']['position']['stedfest_type']:

            type_stedfesting.attrib = {
                'veglenkesekvensNvdbId': str(self.extra['stedfest']['location']['veglenkesekvensnvdbid']),
                'posisjon': str(self.extra['stedfest']['location']['posisjon']['fra'])
            }

        elif 'linje' or 'hjelpelinje' or 'flate' in self.extra['stedfest']['position']['stedfest_type']:

            from_pos = min(self.extra['stedfest']['location']['posisjon']['fra'],
                           self.extra['stedfest']['location']['posisjon']['til'])
            to_pos = max(self.extra['stedfest']['location']['posisjon']['fra'],
                         self.extra['stedfest']['location']['posisjon']['til'])

            type_stedfesting.attrib = {
                'veglenkesekvensNvdbId': str(self.extra['stedfest']['location']['veglenkesekvensnvdbid']),
                'fra': str(from_pos),  # be careful here with from and to
                'til': str(to_pos)  # instead of from and to is to and from
            }

        # adding retning and sideposisjon
        retning = ET.SubElement(type_stedfesting, 'retning')

        retning.text = str( self.extra['stedfest']['location']['retning'] )
        
        if self.extra.get('object_sideposisjon'):
            
            retning.text = str(self.extra['stedfest']['location']['retning'])

        if len(self.extra.get('object_sideposisjon')) > 0:

            if self.extra['object_sideposisjon'][0].get('sideposisjon'):
                sideposisjon = ET.SubElement(type_stedfesting, 'sideposisjon')
                sideposisjon.text = self.extra['object_sideposisjon'][0].get('sideposisjon')

        # adding Validering to main object in endringsett
        validering_objekt = ET.SubElement(vegobjekt, 'validering')
        lest_fra_nvdb = ET.SubElement(validering_objekt, 'lestFraNvdb')
        lest_fra_nvdb.text = self.extra['sistmodifisert']

        '''
            Note:
                
                main stadfesting must be added out of the loop and after 
                geometry egenskaper is added, and only childs if it has
                will be included in endrinssett/changeset.
                
                So any call to formXMLStadfestingVegobjekt method will be to create
                a child stadfesting object in the endringssett including:
                
                -> validering sub tag
                -> stadfesting tag
                -> his version and nvdbid with type attributes


        looping throug all of the child road object if it has
        and adding it to the endrinssett
        '''

        # if main stedfesting must include his children stedfest data and only if type is a punkt geometry type
        if self.extra['has_relation'] and self.extra['is_child_included'] and 'punkt' in \
                self.extra['stedfest']['position']['stedfest_type']:
            # then add it

            relation_content = self.extra['relation']

            for relation in relation_content:
                # making road object stedfest
                self.formXMLStadfestingVegobjekt(vegobjekter=vegobjekter, relation=relation,
                                                 stedfest_type=self.extra['stedfest_type'])

        self.xml_string = ET.tostring(root, encoding='utf-8')  # be carefull with the unicode

        # print(self.xml_string)  # debugging info of hole formed XML endringsett

        # emiting signal
        self.endringsett_form_done.emit()
