from qgis.PyQt import uic
from qgis.utils import iface
from qgis.core import QgsProject

from PyQt5.QtWidgets import QTableWidgetItem, QMessageBox, QLineEdit, QComboBox
from PyQt5.QtCore import pyqtSignal, QRegExp
import os
# using in the advanced_filtering_handle_user_input
import re
#user defined modules
from .nvdbLesWrapper import AreaGeoDataParser
from .vegrefStedfestning import VegrefStedfestning
from .more_window_status import Ui_MoreWindowStatus
from .advanced_filtering import Vegobjekt_parser

FORM_CLASS, BASE_CLASS = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'more_window.ui'))

class SourceMoreWindow(BASE_CLASS, FORM_CLASS):
    
    new_relation_event = pyqtSignal(int, str) #signal for sending selected items
    
    unlink_btn_clicked = pyqtSignal() #signal for when unlink btn clicked
    
    logging_btn_moreWindow_clicked = pyqtSignal() #signal when user clicked open window btn

    
    maintab_index_change = pyqtSignal(int) #signal triger when tab change
    
    pick_up_loggin = pyqtSignal() #to deliver login data back and forward
    
    on_new_geo_data = pyqtSignal(dict) #when new geometry available from nvdb_beta_dialog
    
    new_geometry_rcv = pyqtSignal(dict)

    on_fetch_button_clicked = pyqtSignal()
    
    _including_child = pyqtSignal(bool) #when turning including barn checkbox
    
    on_endringsett_correct_active = pyqtSignal(bool)
    on_endringsett_update_active = pyqtSignal(bool)

    advanced_filtering_btn_moreWindow = pyqtSignal(list, int)  # signal for sending advanced filtering data to the filter in main window
    
    def __init__(self, env: str = str()):
        super().__init__()
        
        self.setupUi(self)
        
        #tab widget control flags
        self.location_tab_active:bool = False
        self.relation_tab_active:bool = False
        self.is_user_logged: bool = False
        # self.is_line_position_ready: bool = False
        
        # self.times_checking_vegref_validation: int = int()
        
        #for controlling env, default is test
        self.current_env: str = 'test' #for environment if test or prod, etc default = test
        
        #but if env is set from instantiation then add it!
        if env != '':
            
            self.current_env = env
        
        #making sure that AreaGeoDataParser is initialised to env cooming from main module if diff then test
        # AreaGeoDataParser.set_env( self.current_env )
            
        self.token: str = str() #for token when posting stadfestning, etc
        self.stedfest_type: str = str() #for knowing what type of object was selected in QGIS kart
        self.current_nvdb_object_type: int = int() #for storing nvdb object type from nvdb_beta_dialog module
        # self.position_list: list = [str] #for adding positions when stadfesting line or polygon types
        # self.line_from_to_positions: dict = {} #for adding line from and to positions when ready
        # self.list_of_endringssett: list = [] #to have control with sent endringssett
        self.status_window = None #for status window for stadfesting and sammenkoblingen
        
        #end of tab widget control flags
        
        #setting default tab index flag according to current index
        self.setup_default_tab_index_flags()
        
        #setting default values to table relation show
        self.setup_default_table_relation()
        
        #and notifying to self.more_main_tab widget of the change
        self.more_main_tab.currentChanged.emit(1) # 1 relasjoner tab
        
        #setting some default to UI components
        self.unlink_from_parent_btn.setEnabled(False)
        self.object_id_line.setReadOnly(True)
        self.login_btn_more_window.setEnabled(False)
        self.relocate_vegref_btn.setEnabled(False)
        self.vegref_line_input.setEnabled(False)
        self.fra_vegref_input.setEnabled(False)
        self.til_vegref_input.setEnabled(False)
        self.relocate_line_btn.setEnabled(False)
        self.relation_correct_changeset_btn.toggle()
        
        #making a global scope vegrefStedfestning class instance
        self.vegref_instance = VegrefStedfestning()
        
        #ADVANCED FILTERING SECTION VARIABLES
        
        # making a global scope vegobjekt_parser class instance
        self.vegobjekt_parser_instance = Vegobjekt_parser()
        
        #setting some default to UI components
        self.advanced_filtering_enabled_value = False
        self.advanced_filtering_search_btn.setEnabled(False)
        self.advanced_filtering_egenskap_has_been_added = False
        self.advanced_filtering_relasjon_has_been_added = False
        self.advanced_filtering_change_buttons_disabled()
        self.advanced_filtering_disable_all_buttons()
        
        # initializing global variables
        self.advanced_filtering_egenskap_or_overlapp_cb.addItems(["egenskap", "overlapp", "relasjon"])
        self.advanced_filtering_operator_cb.addItems(["=", "!=", "<", ">", ">=", "<="])
        self.advanced_filtering_all_items_display.addItems([])
        self.possible_children_names = []
        self.possible_children_id = []
        self.listOfnvdbObjects = {}
        self.import_all_vegobject_list = self.fixNVDBObjects()
        self.import_all_vegobject_list.remove("Entreprenør")
        self.import_all_vegobject_list.remove("NVDB dokumentasjon")
        self.vegobject_is_punkt_dict = AreaGeoDataParser.get_datacatalog_stedfesting_is_punkt()
        
        self.import_all_vegobject_list = self.advanced_filtering_filter_combobox(self.import_all_vegobject_list)
        
        #print(self.import_all_vegobject_list)
        self.import_all_vegobject_list_punkt_removed = [x for x in self.import_all_vegobject_list if self.vegobject_is_punkt_dict.get(x).get("nonPunkt")]
        
        self.import_curr_item = {}
        self.import_curr_item_several = {}
        self.current_egenskap = ""
        self.current_selected_item = None
        
        #ADVANCED FILTERING SECTION VARIABLES END
        
        #end of setting default index flag
        
        self.more_main_tab.currentChanged.connect(self.activate_current_tab) #when current tab changes
        self.table_relation_show.clicked.connect(self.item_clicked) #when any item is clicked in table
        self.unlink_from_parent_btn.clicked.connect(self.onUnlink_btn_clicked) #when unlink btn is clicked
        
        #self.unlink_from_parent_btn.clicked.connect(self.display_msg) #comment here (can be call inside self.onUnlink_btn_clicked() method as well
        
        self.login_btn_more_window.clicked.connect(self.onLoggingClicked) #an easy access to login tab from skrivWindow
        
        self.vegref_line_input.returnPressed.connect(self.handle_validation_vegref) #validate when key enter is pressed
        self.vegref_line_input.textChanged.connect(self.handle_validation_vegref) #everytime line edit changes
        
        self.relocate_vegref_btn.clicked.connect(self.sentGeoDataForStedfestning) #when stedfesting punkt
        self.relocate_line_btn.clicked.connect(self.sentGeoDataForStedfestning) #when stedfesting linje
        
        self.fra_vegref_input.textChanged.connect(self.handle_validation_vegref) #when from input lineEdit changes
        self.til_vegref_input.textChanged.connect(self.handle_validation_vegref) #when to input lineEDit changes
        
        self.new_geometry_rcv.connect(self.on_new_geometry) #when signal is emited then execute
        
        self.status_btn.clicked.connect(self.open_status_window) #when opening window

        self.fetch_data_btn.clicked.connect(self.onFetchClicked) #When fetching new data

        self.include_child_check.stateChanged.connect(self.on_including_child) #wether including child or not

        #when user toggle one of the radio btn for endringssett types
        self.relation_correct_changeset_btn.toggled.connect(self.endringssett_type_correct_changed)
        self.relation_update_changeset_btn.toggled.connect(self.endringssett_type_update_changed)
        
        #ADVANCED FILTERING SECTION SIGNALS
        
        self.advanced_filtering_search_btn.clicked.connect(self.main_send_advanced_filtering_data) # when search btn is clicked
        
        self.advanced_filtering_url_input_btn.clicked.connect(self.advanced_filtering_import_url) # when import btn is clicked

        self.advanced_filtering_egenskap_or_overlapp_cb.currentTextChanged.connect(self.advanced_filtering_category_changed) # when category is picked
       
        self.advanced_filtering_all_items_display.itemClicked.connect(self.advanced_filtering_onItemClicked) # when item in display is clicked
        
        self.advanced_filtering_overlapp_verdi_cb.currentTextChanged.connect(self.advanced_filtering_populate_egenskap_combo_box) # when overlapp/rel type is picked

        self.advanced_filtering_save_btn.clicked.connect(self.advanced_filtering_add_item_to_url) # when a query is added to the dict/url
        
        self.advanced_filtering_delete_btn.clicked.connect(self.advanced_filtering_delete_item) # when a selected item is deleted
        
        self.advanced_filtering_overlapp_verdi_cb.currentTextChanged.connect(self.advanced_filtering_handle_user_input) # when overlapp/rel type is picked
        
        self.advanced_filtering_egenskap_type_cb.currentTextChanged.connect(self.advanced_filtering_handle_user_input) # when egenskap type is picked
        
        self.advanced_filtering_egenskap_type_cb.currentTextChanged.connect(self.advanced_filtering_populate_egenskap_values) # when egenskap type is picked
        
        self.advanced_filtering_operator_cb.currentTextChanged.connect(self.advanced_filtering_handle_user_input) # when operator is picked
        
        self.advanced_filtering_egenskap_verdi_lineedit.editingFinished.connect(self.advanced_filtering_handle_user_input) # when egenskap text is picked

        self.advanced_filtering_egenskap_verdi_combobox.currentTextChanged.connect(self.advanced_filtering_handle_user_input) # when egenskap cb is picked
       
        self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.clicked.connect(self.advanced_filtering_add_several_egenskap_enable_comboboxes) # when "legg til egenskap" is pressed
        
        self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.clicked.connect(self.advanced_filtering_add_several_relasjon_enable_comboboxes) # when "legg til relasjon" is pressed
        
        self.advanced_filtering_add_item_btn.clicked.connect(self.advanced_filtering_add_item) # when "bekreft" is pressed 
        
        self.advanced_filtering_reset_btn.clicked.connect(self.advanced_filtering_category_changed) # when "nullstill" is pressed
        
        #ADVANCED FILTERING SECTION SIGNALS END
        
        
        
    def activate_current_tab(self, index):
        
        # print('changing to', index)
        
        if self.more_main_tab.currentIndex() == 0:
            self.location_tab_active = True
            self.relation_tab_active = False

        else:
            self.relation_tab_active = True
            self.location_tab_active = False
        
        #notifying that current tab has changed to nvdb_beta_dialog modulen
        self.maintab_index_change.emit(index)
        

    def action_(self):
        if self.location_tab_active:
            self.relocate_vegobjekter()

        elif self.relation_tab_active:
            self.make_relationship_vegobjekter()

    def relocate_vegobjekter(self):
        # stedfesting code here ...
        pass

    def make_relationship_vegobjekter(self):
        # sammenkobling code here ...
        pass

    def set_realtion_child_id(self, current_object, current_object_type):
        
        self.object_id_line.setText(f"{current_object_type} - {str(current_object)}")
        self.object_id_line_stedfest.setText(f"{current_object_type} - {str(current_object)}")

    def set_current_vref(self, vref):
        self.segments_list.clear()
        if len(vref) == 1:
            self.vegref_lbl.setText(vref[0])
            self.segments_list.clear()
        else:
            for item in vref:
                if item != self.vegref_lbl.text():
                    self.segments_list.addItem(item)


    def feed_data(self, component_type: str = str(), data: dict = {}, active_parent: str = str()):
        if component_type == 'relation':
           #relasjon code here ...
            AreaGeoDataParser.set_env(self.get_current_env()) #setting environment before use
            
            print('location current env in AreaGeoDataParser:', AreaGeoDataParser.get_env())
            
            #getting possible parents
            possible_relation = AreaGeoDataParser.get_possible_parents(int(data.get('objekttype')))
            
            #populating relation component with possible parents
            self.populate_relation_component(possible_relation)

        if component_type == 'location':
            #stedfest code here ...
            self.current_nvdb_object_type = data.get('nvdb_object_type') #data['nvdb_object_type']
            self.stedfest_type = data.get('stedfest_type') #data['stedfest_type']
            
            # print(data)
            
            #enabling UI elements when something is clicked from nvdb_beta_dialog module
            if data.get('stedfest_type') == 'punkt':
        
                self.vegref_line_input.setEnabled(True)
                
                #deactivating line inputs if activated
                if self.fra_vegref_input.isEnabled() or self.til_vegref_input.isEnabled():
                    
                    self.fra_vegref_input.clear()
                    self.til_vegref_input.clear()
                    
                    self.fra_vegref_input.setEnabled(False)
                    self.til_vegref_input.setEnabled(False)
                    
                    # self.vegref_check_label.clear()
                    self.line_vegref_check_label.clear()
                    
                    self.relocate_line_btn.setEnabled(False)
            
            if data.get('stedfest_type') == 'linje' or data.get('stedfest_type') == 'flate' or data.get('stedfest_type') == 'hjelpelinje':
                
                # print('enabling linje UI')
                
                self.fra_vegref_input.setEnabled(True)
                self.til_vegref_input.setEnabled(True)
                
                #deactivating punkt inputs if activated
                if self.vegref_line_input.isEnabled():
                    
                    self.vegref_line_input.clear()
                    
                    self.vegref_line_input.setEnabled(False)
                    
                    # self.line_vegref_check_label.clear()
                    self.vegref_check_label.clear()
                    
                    self.relocate_vegref_btn.setEnabled(False)
            
            # if 'flate' in data['stedfest_type']:
                
            #     print('enabling flate UI')
                
            #     self.fra_vegref_input.setEnabled(True)
            #     self.til_vegref_input.setEnabled(True)
                
            #     #deactivating punkt inputs if activated
            #     if self.vegref_line_input.isEnabled():
                    
            #         self.vegref_line_input.clear()
                    
            #         self.vegref_line_input.setEnabled(False)
        
        if component_type == 'location' and data.get('is_new_geometry') == True:
            
            self.stedfest_type = data.get('stedfest_type')
            
            #we need to re-set env to AreaGeoDataParser again from here.
            #AreaGeoDataParser.set_env(self.get_current_env()) #setting environment before use
            
            print('location when geometry from tools current env in AreaGeoDataParser:', AreaGeoDataParser.get_env())
            
            #GETTING GEOMETRY AS WKT FORMAT STR
            geo = data.get('new_geometry').asWkt()
            
            attribs = {
               'object_type': data.get('nvdb_object_type'),
               'nvdbid': self.get_especific_field_by_name('nvdbid'),
               'stedfest_type': data.get('stedfest_type'),
               'startdato': self.get_especific_field_by_name('sistmodifisert'),
               'new_geo': geo.replace('LineStringZ', 'LineString Z')
            }
            
            # print(attribs)
            
            self.new_geometry_rcv.emit(attribs)
        
        if component_type == 'status':
            
            '''but self.token it maight allready exist, because it's call in handle_ref_validarion method
            when login first time'''
            self.check_loging()
            
            #if window allready exist then just feed
            if self.status_window:
                
                self.status_window.feed_changeset( {'target': data['target'], 'type': data['type'], 'token': self.token} )
            
            #if not then create it, hide it and feed it
            if not self.status_window:
                
                self.open_status_window()
                
                self.status_window.hide()
                
                self.status_window.feed_changeset( {'target': data['target'], 'type': data['type'], 'token': self.token} )
    
    def get_current_env(self):
        return self.current_env
    
    def set_current_env(self, current_env: str = str()):
        curr: str = str()
        
        if 'test' in current_env:
            curr = 'test'
        
        if 'utv' in current_env:
            curr = 'utv'
        
        else:
            print('setting prod env in more_window_instance')
            curr = 'prod'
            
        self.current_env = curr
        
        AreaGeoDataParser.set_env(self.get_current_env())
        
        print('current env:', self.current_env)
        
        print('chaning env in more window', self.get_current_env())
        
    def set_parent_status(self, status_info: dict = {}):
        if not status_info:
            
            self.current_linked_parent_lbl.clear()
            
            self.avvist_lbl.setText("Ikke koblet til mor!")
            self.avvist_lbl.setStyleSheet("color: grey; font: 14pt 'MS Shell Dlg 2';")
            
        if status_info:
            
            self.current_linked_parent_lbl.setText(f"Koblinger - {status_info['parent_id']} - {status_info['parent_name']} - {status_info['parent_nvdbid']}")

    def populate_relation_component(self, data: dict = {}):
        row: int = 0

        self.table_relation_show.setRowCount(len(data))

        for item in data:
            name_item = QTableWidgetItem(item['name'])
            id_item = QTableWidgetItem(str(item['id']))

            self.table_relation_show.setItem(row, 0, id_item)
            self.table_relation_show.setItem(row, 1, name_item)

            row += 1

    def item_clicked(self, item):
        id = int(self.table_relation_show.item(item.row(), 0).text())
        name = self.table_relation_show.item(item.row(), 1).text()
        
        self.new_relation_event.emit(id, name)

    def onUnlink_btn_clicked(self):
        self.unlink_btn_clicked.emit()
        
    # internal own class methods for inside uses
    def setup_default_tab_index_flags(self):
        if self.more_main_tab.currentIndex() == 0:  # 0 stedfesting tab
            self.location_tab_active = True
            self.relation_tab_active = False
            
            print('stedfest tab')

        elif self.more_main_tab.currentIndex() == 1:  # 1 kobling tab
            self.relation_tab_active = True
            self.location_tab_active = False
            
            print('relasjon tab')

        else:
            self.relation_tab_active = True
            self.location_tab_active = False

            
    def setup_default_table_relation(self):
        label_headers = ['Objekttype', 'Navn']
        
        self.table_relation_show.setColumnCount(2)
        self.table_relation_show.setHorizontalHeaderLabels(label_headers)

    def display_msg(self):
        msg = QMessageBox()
        msg.setWindowTitle("Status")
        msg.setText("Operasjon sendt!")
        msg.exec()

    def set_status(self, status):
        
        pass
        
        self.avvist_lbl.clear()

    def set_msg_avvist(self, msg):
        
        self.avvist_lbl.setStyleSheet(f"color: red; font: 10pt 'MS Shell Dlg 2';")
        self.avvist_lbl.setText(msg)

    def set_login_status(self, status):
        if status == "pålogget":
            self.status_innlogging_lbl.setText("Pålogget")
            self.status_innlogging_lbl.setStyleSheet("color: green; font: 14pt 'MS Shell Dlg 2';")
            self.login_btn_more_window.setEnabled(False)
            
        else:
            self.status_innlogging_lbl.setText('må logge på')
            self.status_innlogging_lbl.setStyleSheet("color: red; font: 14pt 'MS Shell Dlg 2';")
            self.login_btn_more_window.setEnabled(True)

    def turn_remove_relation_btn(self, dependant_mor, has_parent: bool = False, status_login: bool = False, extra: dict = {}) -> bool:
        
        self.avvist_lbl.clear()

        if not dependant_mor and has_parent and status_login:
            
            exist_child_inParent = AreaGeoDataParser.check_if_child_exist_in_parent( extra.get('parent_nvdb_type'), extra.get('parent_nvdbid'), extra.get('child_to_compare') )
            
            # print( 'flag exist child in parent:', exist_child_inParent )
            # print( extra )
            
            self.unlink_from_parent_btn.setEnabled(True)
            
            # self.avvist_lbl.setStyleSheet("color: magenta; font: 14pt 'MS Shell Dlg 2';")
            
            '''
            making sure that child do not exist in parent tree relationship, because sometimes
            NVDB Les still showing childre's old parent relationship even if those are not present
            in it's tree's relationship.
            '''
            
            if exist_child_inParent:
                
                # self.avvist_lbl.setText("Vegobjekt har allereder mor, for å lagge til ny mor må slett nåværende!")
            
                self.table_relation_show.setEnabled(True) #False
                
                return True
            
            if not exist_child_inParent:
                
                self.avvist_lbl.setStyleSheet("color: #FEBE10; font: 14pt 'MS Shell Dlg 2';")
                
                self.avvist_lbl.setText("Vegobjektet viser fortsatt den gamle forelderen, selv om det ikke lenger har en forelder!")
                
                self.table_relation_show.setEnabled(True)
                
                self.unlink_from_parent_btn.setEnabled(False)
                
                return False

        else:
            
            self.unlink_from_parent_btn.setEnabled(False)
            
            self.table_relation_show.setEnabled( True )
            
            if dependant_mor:
                
                self.avvist_lbl.setText("må ha forelder, kan ikke fjernes men kan erstattes!")
                
                self.avvist_lbl.setStyleSheet("color: grey; font: 14pt 'MS Shell Dlg 2';")
                
                return True
                
            elif not has_parent:
                
                self.avvist_lbl.setText("Ikke koblet til mor!")
                
                self.avvist_lbl.setStyleSheet("color: grey; font: 14pt 'MS Shell Dlg 2';")
                
                self.table_relation_show.setEnabled(True)

    def onLoggingClicked(self):
        self.logging_btn_moreWindow_clicked.emit()

    def onFetchClicked(self):
        self.on_fetch_button_clicked.emit()
    
    def get_especific_field_by_name(self, field_name)-> str:
        layer = iface.activeLayer()

        especific_field = {}
        nvdbid = None
        
        try:
            
            for feature in layer.selectedFeatures():
                for field in feature.fields():
                    if field_name in field.name():
                        return feature[field.name()]
        
        except AttributeError as ex:
            
            print( ex )

    


    def handle_validation_vegref(self):
        attribs: dict = {}
        check_vegnet: bool = False
            
        '''
        checking if vegref is valid, throug some method calling
        in VegrefStedfestning class
        '''
            
        #if user is logged, then can continue
        self.check_loging()
            
        #setting attribs instance already exist in __init__() method
        self.vegref_instance.set_attributes({'token': self.token})
        
        print('setting this env', self.get_current_env())
        
        # self.vegref_instance.set_env('prod')
        self.vegref_instance.set_env( self.get_current_env() )
        
        #extra
        extra_ = {
                'start_date': self.get_especific_field_by_name('sistmodifisert'),
                'trafikant_gruppe': self.get_especific_field_by_name('trafikantgruppe'),
                'nvdbid': self.get_especific_field_by_name('nvdbid'),
                'type': self.current_nvdb_object_type,
                'versjon': self.get_especific_field_by_name('versjon')
        }

        #if user is logged
        if self.is_user_logged:
                
            #PUNKT case
            if 'punkt' in self.stedfest_type:
                    
                if self.vegref_instance.check_vegref(self.vegref_line_input.text().replace('-', '').lstrip().rstrip()):
                    
                    self.redraw_stedfest_ui(self.stedfest_type, True)
                        
                    attribs = {
                        'stedfest_type': self.stedfest_type,
                        'fra': self.vegref_line_input.text().replace('-', '').lstrip().rstrip()
                    }

                    #print(attribs)

                    self.vegref_instance.get_position(attribs)
                    
                    #stedfestning road object
                    self.vegref_instance.stedfest_object( extra_ )
                
                else:
                    
                    self.redraw_stedfest_ui(self.stedfest_type, False)
        
            #LINJE case
            if 'linje' or 'flate' or 'hjelpelinje' in self.stedfest_type:
                        
                if self.vegref_instance.check_vegref(self.fra_vegref_input.text().replace('-', '').lstrip().rstrip()) and self.vegref_instance.check_vegref(self.til_vegref_input.text().replace('-', '').lstrip().rstrip()):
                    
                    self.redraw_stedfest_ui(self.stedfest_type, True)
                    
                    attribs = {
                        'stedfest_type': self.stedfest_type,
                        'fra': self.fra_vegref_input.text().replace('-', '').lstrip().rstrip(),
                        'til': self.til_vegref_input.text().replace('-', '').lstrip().rstrip()
                    }
                    
                    check_vegnet = self.vegref_instance.get_position(attribs)
                    
                    #stedfestning road object
                    if 'linje' or 'hjelpelinje' in self.stedfest_type:
                        
                        self.vegref_instance.stedfest_object( extra_ )
                
                        # self.vegref_instance.stedfest_object( extra_, True, self.get_geometry_by_nvdbid_fromQGIS(extra_.get('nvdbid') ))
                    
                    if 'flate' in self.stedfest_type:
                        
                        self.redraw_stedfest_ui('linje', True)
                        
                        self.vegref_instance.stedfest_object( extra_, True, self.get_geometry_by_nvdbid_fromQGIS(extra_.get('nvdbid') ))
                    
                    if not check_vegnet:
                        
                        self.check_vegnet_field.setStyleSheet("color: pink; font: 14pt 'MS Shell Dlg 2';")
                        self.check_vegnet_field.setText('Vegreferanse overlapp, en gyldig vegreferanse må benyttes!: Ex: Punkt: EV134 S0D0 m377 Linje: EV134 S0D0 m377-455')
                    
                    if check_vegnet and self.check_vegnet_field.toPlainText() != ' ':
                        
                        self.check_vegnet_field.clear()
                        
                        self.check_vegnet_field.setStyleSheet("background-color: rgb(0, 0, 0, 0);") #black transparent
                else:
                    
                    if 'flate' in self.stedfest_type:
                        
                        self.redraw_stedfest_ui('linje', False) #we re-draw line not matter what, since same UI Elements are being used for flate here
                        
                    if 'linje' in self.stedfest_type:
                        
                        self.redraw_stedfest_ui(self.stedfest_type, False)
                    
                    if 'hjelpelinje' in self.stedfest_type:
                        
                        self.redraw_stedfest_ui('linje', False)
    
    
    def redraw_stedfest_ui(self, stedfest_type: str = str(), active: bool = False) -> None:
        #redraw stedfest ui according to stedfest type and if fail or not
        if 'punkt' in stedfest_type and active:
            
            self.vegref_check_label.setText("valid")
            self.vegref_check_label.setStyleSheet("color: green;")
                    
            # enabling stedfest btn if not valid
            if not self.relocate_vegref_btn.isEnabled():
                
                self.relocate_vegref_btn.setEnabled(True)
            
        if 'punkt' in stedfest_type and not active:
            
            self.vegref_check_label.setText("invalid")
            self.vegref_check_label.setStyleSheet("color: red;")
                    
            #dissabling stedfest linje btn if not valid
            if self.relocate_vegref_btn.isEnabled():
                
                self.relocate_vegref_btn.setEnabled(False)
        
        if 'linje' in stedfest_type and active:
            
            self.line_vegref_check_label.setText("valid")
            self.line_vegref_check_label.setStyleSheet("color: green;")
                    
            #enabling stedfest btn if not valid
            if not self.relocate_line_btn.isEnabled():
                self.relocate_line_btn.setEnabled(True)
            
        if 'linje' in stedfest_type and not active:
            
            self.line_vegref_check_label.setText("invalid")
            self.line_vegref_check_label.setStyleSheet("color: red;")
                    
            #dissabling stedfest linje btn if valid
            if self.relocate_line_btn.isEnabled():
                
                self.relocate_line_btn.setEnabled(False)
                
            
    def check_loging(self):
        '''
        emiting signal to pick up login in main window nvdb_beta_dialog.py modulen,
        if user has already logged in from Skriv_vinduet or sammenkobling tab
        '''
        self.pick_up_loggin.emit()
        
    def set_login_fromNVDBBetaDialog(self, v: bool = False, t: str = str()) -> None:
        self.is_user_logged = v
        self.token = t
        
    def sentGeoDataForStedfestning(self):
        if self.is_user_logged:
            
            try:
                
                data_to_send = {
                    'location': self.vegref_instance.egenskaper_stedfest,
                    'position': self.vegref_instance.geo_parsed
                }
            
                self.on_new_geo_data.emit( data_to_send )
                
            except AttributeError:
                print('source_more_window::sentGeoDataForStedfestning: exception = egenskaper_stedfest do not exist')
    
    def get_geometry_by_nvdbid_fromQGIS(self, nvdbid: int = int()) -> str:

        layer = iface.activeLayer()

        selected_object_fields = {}

        self.current_nvdbid = nvdbid
        
        geometry_found: str = str()

        try:
            
            for feature in layer.selectedFeatures():
        
                for field in feature.fields():
                    
                    if 'nvdbid' in field.name():
                        
                        if str(nvdbid) in str(feature[field.name()]):
                            
                            for feat_field in feature.fields():
                                # print(feat_field.name(), ': ', feature[feat_field.name()])

                                if 'Geometri' in feat_field.name():
                                    
                                    geometry_found = feature.geometry().asWkt()
                                    
                                    if 'Z' or 'z' in geometry_found:
                                        print( 'Z or z found in geometry!' )
                                        
                                        geometry_found = geometry_found.replace( 'Z', '' )
                                        
                                    print( 'geo outside:', geometry_found )

                                    if 'PointZ' in geometry_found:
                                        
                                        geometry_found = geometry_found.replace('Point', 'Point Z')
                    
                                    if 'LineStringZ' in geometry_found:
                                        
                                        geometry_found = geometry_found.replace('LineStringZ', 'LineString Z')

                                    if 'PolygonZ' in geometry_found:
                                        
                                        geometry_found = geometry_found.replace('PolygonZ', 'Polygon Z')
                                        
        except AttributeError as ex:
                
            print( ex )
        
        print( 'final geometry found:', geometry_found )
                
        return geometry_found
    
    def on_new_geometry(self, data: dict = {})-> None:
        
        geometry = self.get_geometry_by_nvdbid_fromQGIS(data.get('nvdbid'))
        
        attribs = {
            'type': data.get('object_type'),
            'nvdbid': data.get('nvdbid'),
            'startdato': data.get('startdato'),
            'geometry': geometry, #data.get('new_geo'),
            'stedfest_type': data.get('stedfest_type'),
            'env': self.get_current_env() if 'test' in self.get_current_env() else ''
        }
        
        print('env in more window:', attribs.get('env'))
        
        #since it is an static method acces, we dont need access to self.instance
        v = VegrefStedfestning.get_vegref_from_wkt(attribs)
    
        print('source_more_window::on_new_geometry:', v)
        
        # print( 'geometry from QGIS:', geometry )
        # print('geometry from signal:', data.get('new_geo'))
        
        #case when is Punkt
        if attribs.get('stedfest_type') == 'punkt':
            
            self.vegref_line_input.setText(v.get('from'))
            
        #case when is Linje or Flate
        if attribs.get('stedfest_type') == 'linje' or attribs.get('stedfest_type') == 'hjelpelinje' or attribs.get('stedfest_type') == 'flate':
    
            self.fra_vegref_input.setText(self.get_vegref_min_max(min_=True, vegref_fra=v.get('from'), vegref_til=v.get('to')))
            self.til_vegref_input.setText(self.get_vegref_min_max(max_=True, vegref_fra=v.get('from'), vegref_til=v.get('to')))
    
    def open_status_window(self):
        
        #opening window
        
        #create new instance if not exist already
        if not self.status_window:
            
            self.status_window = Ui_MoreWindowStatus()
            
            self.status_window.show()
        
        #only show instance if it already exists
        if self.status_window:
            
            self.status_window.show()
    
    def on_including_child(self, state):
        
        s = True if state > 0 else False
        
        self._including_child.emit(s)
    
    def endringssett_type_correct_changed(self, toggle):
        
        self.on_endringsett_correct_active.emit(toggle)
    
    def endringssett_type_update_changed(self, toggle):
        
        self.on_endringsett_update_active.emit(toggle)
    
    def get_vegref_min_max(self, vegref_fra: str = str(), vegref_til: str = str(), min_: bool = False, max_: bool = False):
            
        # vegref_fra = self.fra_vegref_input.text().replace('-', '').lstrip().rstrip()
        # vegref_til = self.til_vegref_input.text().replace('-', '').lstrip().rstrip()
        min_str: str = str()
        max_str: str = str()
        
        meters_fra = vegref_fra.replace('-', '').lstrip().rstrip().split('m')
        meters_til = vegref_til.replace('-', '').lstrip().rstrip().split('m')
        
        #sub mfunction to check digits in vegref
        def contain_numbers(str_vegref):
            return any( ch.isdigit() for ch in str_vegref )
            
        # print('fra:', meters_fra)
        # print('til:', meters_til)
        
        if min_:
            
            '''
            making sure that vegref does not has number digits, 
            otherwise ew need to parse again
            '''
            if contain_numbers( meters_fra[1] ):
                
                min_str = meters_fra[1].split(' ')[0]
                
                min_str = str( max(int(min_str), int(meters_til[1].split(' ')[0])) )
                
                if min_str in vegref_fra:
                
                    return vegref_fra
                
            #normal case when the parsed does not contain numbers
            min_str = str( min(int(meters_fra[1]), int(meters_til[1])) )
                
            if min_str in vegref_fra:
                
                return vegref_fra
            
            return vegref_til
            
        if max_:
            
            '''
            making sure that vegref does not has number digits, 
            otherwise ew need to parse again
            '''
            if contain_numbers( meters_til[1] ):
                
                max_str = meters_til[1].split(' ')[0]
                
                max_str = str( max(int(meters_fra[1].split(' ')[0]), int(max_str)) )
                
                if max_str in vegref_til:
                
                    return vegref_til
                
            #normal case
            max_str = str( max(int(meters_fra[1]), int(meters_til[1])) )
            
            if max_str in vegref_til:
                
                return vegref_til
            
            return vegref_fra

    #method connected to advanced_filtering_search_btn signal. When user clicks the button we will send the filter_data
    # the filter_data comes from the vegobjekt_parser_instance.filter_list.
    # we will also emit the vegobject_type_id, since it is not included in the filter_data
    def main_send_advanced_filtering_data(self):
        filter_data = self.vegobjekt_parser_instance.filter_list
        type = int(self.vegobjekt_parser_instance.result.get("type"))
        self.advanced_filtering_btn_moreWindow.emit(filter_data, type)
        self.advanced_filtering_search_btn.setEnabled(False)

    #method connected to advanced_filtering_url_input_btn signal. When user clicks the button we will import the url
    #we use self.vegobjekt_parser_instance.setEndpoint(urlstring) and self.vegobjekt_parser_instance.getData()
    # after this we have filled the vegobjekt_parser_instance.result dictionary with the current url query values
    def advanced_filtering_import_url(self):
        urlstring = self.advanced_filtering_url_input_lineedit.text()
        
       
        
        pattern = QRegExp(r"^.*vegvesen\.no.*/vegobjekter/\d+(\?.*)?$")
        if len(self.advanced_filtering_url_input_lineedit.text()) == 0:
            self.import_message_label.setText("Vennligst fyll ut feltet med en gyldig lenke")
        
        elif not pattern.exactMatch(self.advanced_filtering_url_input_lineedit.text()):
            self.import_message_label.setText("lenken er ikke gyldig")
            self.vegobjekt_parser_instance.result = {}
            self.advanced_filtering_all_items_display.clear()
            self.advanced_filtering_disable_all_buttons()
            self.advanced_filtering_all_items_display.clearSelection()
        else:
            urlstring = self.advanced_filtering_url_input_lineedit.text()
            self.vegobjekt_parser_instance.setEndpoint(urlstring)
            self.vegobjekt_parser_instance.getData()
            url = self.vegobjekt_parser_instance.endpoint
            
            if int(self.vegobjekt_parser_instance.result.get("type")) in self.listOfnvdbObjects.values():
                if "relasjon(" in url and ("fylke=" in url or "kommune=" in url):
                    self.advanced_filtering_search_btn.setEnabled(False)
                    self.import_message_label.setText("kan ikke ha relasjon sammen med lokasjon")
                else:
                    self.advanced_filtering_egenskap_type_cb.clear()
                    self.import_egenskap_list = AreaGeoDataParser.egenskaper(self.vegobjekt_parser_instance.result.get("type"))
                    self.import_egenskap_list = self.advanced_filtering_filter_combobox(self.import_egenskap_list)
                    self.advanced_filtering_egenskap_type_cb.addItems(self.import_egenskap_list)
                    self.import_message_label.setText("importering av lenke vellykket")
                    self.advanced_filtering_category_changed()
                    self.vegobjekt_parser_instance.updateUrl()
                    self.advanced_filtering_populate_list_of_queries()
                    self.advanced_filtering_delete_btn.setEnabled(True)
                    if self.advanced_filtering_enabled_value:
                    
                        self.advanced_filtering_egenskap_or_overlapp_cb.setEnabled(True)
                        self.advanced_filtering_reset_btn.setEnabled(True)
                        self.advanced_filtering_search_btn.setEnabled(True)
                        self.import_message_label.setText("importering av lenke vellykket")
                    else:
                        self.advanced_filtering_disable_all_buttons()
                        self.import_message_label.setText("huk av Bruk avansert filtrering")
            else:
                self.import_message_label.setText("vegobjekt type oppgitt finnes ikke")
                self.advanced_filtering_disable_all_buttons()
                self.vegobjekt_parser_instance.result = {}
                self.advanced_filtering_all_items_display.clear()
                self.advanced_filtering_change_buttons_disabled()
                
    # method used in main_import_data_from_url() and in advanced_filtering_add_item_to_url()
    # the method fills the string array list that shows the queries to the user with the values of the result dictionary
    # this is just to show the user all of the queries he has in the url
    def advanced_filtering_populate_list_of_queries(self):
            
            self.advanced_filtering_all_items_display.clear()
            for key,value in self.vegobjekt_parser_instance.result.items():
                if type(value) == type([]):
                    
                    for element in value:
                        
                        if type(element) == type({}):
                            if element.get("str"):
                                self.advanced_filtering_all_items_display.addItem(str(key) + " : " + (element).get("str"))
                            else:
                                 self.advanced_filtering_all_items_display.addItem(str(key) + " : " + element.get("type"))
                        else:
                            self.advanced_filtering_all_items_display.addItem(str(key) + " : " + str(element))
                else:
                    
                    self.advanced_filtering_all_items_display.addItem(str(key) + " : " + value)

    # method connected to the import_save_btn sigal.
    # the method used the gloabal variable self.import_curr_item, which is filled with the comboboxes/lineedits from
    # - the user in the advanced_filtering_handle_user_input method
    # we directly add the item to the vegobjekt_parser_instance.result dictionary
    # the button to add new item is only available when user checked "bruk api lenke" in main window, and url is valid
    def advanced_filtering_add_item_to_url(self):
        url = self.vegobjekt_parser_instance.endpoint
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        if (selectedCategory == "relasjon" and ("fylke=" in url or "kommune=" in url)) or ("relasjon(" in url and ("fylke=" in url or "kommune=" in url)):
                    
                    self.import_message_label.setText("kan ikke ha relasjon sammen med lokasjon")
                    self.advanced_filtering_search_btn.setEnabled(False)
        else:
                if self.advanced_filtering_enabled_value:
                    self.import_message_label.setText("importering av lenke vellykket")
                    self.advanced_filtering_egenskap_verdi_to_num()
                    if selectedCategory == "relasjon":
                        selectedCategory = "egenskap"
                                
                    if selectedCategory in self.vegobjekt_parser_instance.result:
                        
                        newArr = self.vegobjekt_parser_instance.result[selectedCategory]
                        
                        newArr.append(self.import_curr_item_several)
                        
                        self.vegobjekt_parser_instance.result[selectedCategory] = newArr
                        self.advanced_filtering_search_btn.setEnabled(True)
                    else:
                       
                        self.vegobjekt_parser_instance.result[selectedCategory] = [self.import_curr_item_several]
                        self.advanced_filtering_search_btn.setEnabled(True)
                   
                    
                   
                    self.advanced_filtering_save_btn.setEnabled(False)
                    self.vegobjekt_parser_instance.updateUrl()
                    self.advanced_filtering_populate_list_of_queries()
                    self.advanced_filtering_url_input_lineedit.setText(self.vegobjekt_parser_instance.endpoint)
                else:
                    self.advanced_filtering_search_btn.setEnabled(False)
                    self.import_message_label.setText("huk av Bruk api lenke i hovedvindu")
                
                self.advanced_filtering_category_changed()
    # method connected to the advanced_filtering_egenskap_or_overlapp_cb sigal.
    # The method performs fills relevant comboboxes and enables them based on the current category
    def advanced_filtering_category_changed(self):
        self.import_curr_item = {}
        self.import_curr_item_several = {}
        self.advanced_filtering_egenskap_has_been_added = False

        self.advanced_filtering_current_item_display.setText("")
        type = self.vegobjekt_parser_instance.result.get("type")
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        
        
        if(selectedCategory == "egenskap"):
            self.advanced_filtering_overlapp_verdi_cb.setEnabled(False)
            self.advanced_filtering_change_egenskaper_buttons_enabled(True)
            egenskaper = AreaGeoDataParser.egenskaper(type)
            egenskaper = self.advanced_filtering_filter_combobox(egenskaper)
            self.advanced_filtering_egenskap_type_cb.clear()
            self.advanced_filtering_egenskap_type_cb.addItems(egenskaper)
            self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
            self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(False)
            self.advanced_filtering_add_item_btn.setEnabled(False)
        elif(selectedCategory == "overlapp"):
            self.advanced_filtering_overlapp_verdi_cb.clear()
            self.advanced_filtering_change_egenskaper_buttons_enabled(False)
            self.advanced_filtering_overlapp_verdi_cb.setEnabled(True)
            self.import_all_vegobject_list = self.advanced_filtering_filter_combobox(self.import_all_vegobject_list)
            
            #here we check if the curr vegobject is a punkt, if it is we apply the vegobject list without punkt
            self.vegobject_is_punkt_dict
            navn = AreaGeoDataParser.get_vegobject_name_from_id(str(type))
            
           
            is_not_Punkt = self.vegobject_is_punkt_dict.get(navn).get("nonPunkt")
               
                
            if is_not_Punkt:
                self.advanced_filtering_overlapp_verdi_cb.addItems(self.import_all_vegobject_list)
                
                
            else:
                self.advanced_filtering_overlapp_verdi_cb.addItems(self.import_all_vegobject_list_punkt_removed)
                
                
                

            self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(True)
            self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(False)
            
            
        elif(selectedCategory == "relasjon"):
    
            self.advanced_filtering_overlapp_verdi_cb.clear()
            self.advanced_filtering_change_egenskaper_buttons_enabled(False)
            self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(True)
            self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
            self.advanced_filtering_overlapp_verdi_cb.setEnabled(False)
            self.advanced_filtering_add_item_btn.setEnabled(False)
            self.advanced_filtering_overlapp_verdi_cb.setEnabled(False)
            if type:
                
                
                
                possible_children = AreaGeoDataParser.get_possible_children_catalog_typeid(type)
                self.possible_children_names = list(map(lambda x: x["navn"], possible_children))
                self.possible_children_id = list(map(lambda x: x["id"], possible_children))
                
            
            #populate the combos
            self.possible_children_names = self.advanced_filtering_filter_combobox(self.possible_children_names)
            self.advanced_filtering_overlapp_verdi_cb.addItems(self.possible_children_names)
            
            
        
        

    def advanced_filtering_delete_item(self):
        if self.current_selected_item:

            category = list(self.current_selected_item.keys())[0]
            string_to_check = (self.current_selected_item[category])
            
            if category == "egenskap" or category == "overlapp":
                arr = self.vegobjekt_parser_instance.result[category]
                filtered_array = [el for el in arr if el.get('str') != string_to_check]
                self.vegobjekt_parser_instance.result[category] = filtered_array
                if len(filtered_array) == 0:
                    self.vegobjekt_parser_instance.result.pop(category)
                self.vegobjekt_parser_instance.updateUrl()
                self.advanced_filtering_populate_list_of_queries()
                self.advanced_filtering_url_input_lineedit.setText(self.vegobjekt_parser_instance.endpoint)

            elif category == "fylke" or category == "kommune":
                arr = self.vegobjekt_parser_instance.result[category]
                filtered_array = [el for el in arr if el != int(string_to_check)]
                self.vegobjekt_parser_instance.result[category] = filtered_array
                if len(filtered_array) == 0:
                    self.vegobjekt_parser_instance.result.pop(category)
                self.vegobjekt_parser_instance.updateUrl()
                
                self.advanced_filtering_populate_list_of_queries()
                self.advanced_filtering_url_input_lineedit.setText(self.vegobjekt_parser_instance.endpoint)
                
            elif category != "inkluder" and category != "type":
                self.vegobjekt_parser_instance.result.pop(category)
                self.vegobjekt_parser_instance.updateUrl()
                self.advanced_filtering_populate_list_of_queries()
                self.advanced_filtering_url_input_lineedit.setText(self.vegobjekt_parser_instance.endpoint)
            self.current_selected_item = {}
            url = self.vegobjekt_parser_instance.endpoint
            if "relasjon(" in url and ("fylke=" in url or "kommune=" in url):
                self.advanced_filtering_search_btn.setEnabled(False)
                self.import_message_label.setText("kan ikke ha relasjon sammen med lokasjon")
            else:
                self.advanced_filtering_search_btn.setEnabled(True)
    def advanced_filtering_onItemClicked(self):
        
        item_text_arr = self.advanced_filtering_all_items_display.currentItem().text().split(" : ")
        item_category = item_text_arr[0]
        item_str = item_text_arr[1]

        
        if self.vegobjekt_parser_instance.result.get(item_category):
            # we check if the key exists
            # if it does we save the key and the str value
            self.current_selected_item = {item_category : item_str}
           
    # method connected to advanced_filtering_overlapp_verdi_cb signal.
    # when the user selects overlapp or relasjon type, this method repopulates to the current relasjon/overlapp vegobj-
    # -type
    def advanced_filtering_populate_egenskap_combo_box(self):
        if(self.advanced_filtering_egenskap_or_overlapp_cb.currentText() == "relasjon" ):
            #print(AreaGeoDataParser.get_env())
            #print(self.get_current_env())
            self.advanced_filtering_egenskap_type_cb.clear()
            arr = self.possible_children_names
            picked_relasjon = self.advanced_filtering_overlapp_verdi_cb.currentText()
            if self.import_curr_item_several.get("relasjon_typer"):
                picked_relasjon = self.import_curr_item_several.get("relasjon_typer")[-1]
                self.egenskaper_liste = AreaGeoDataParser.egenskaper(picked_relasjon)
                self.egenskaper_liste = self.advanced_filtering_filter_combobox(self.egenskaper_liste)
                self.advanced_filtering_egenskap_type_cb.addItems(self.egenskaper_liste)
            else:
                for i in range(0, len(arr)):
                    if picked_relasjon.lower() == arr[i].lower():
                        id = self.possible_children_id[i]
                        self.egenskaper_liste = AreaGeoDataParser.egenskaper(id)
                        self.egenskaper_liste = self.advanced_filtering_filter_combobox(self.egenskaper_liste)
                       
                        self.advanced_filtering_egenskap_type_cb.addItems(self.egenskaper_liste)
                        break
    
        if(self.advanced_filtering_egenskap_or_overlapp_cb.currentText() == "overlapp" ):
            self.advanced_filtering_egenskap_type_cb.clear()
                
            id = self.listOfnvdbObjects.get(self.advanced_filtering_overlapp_verdi_cb.currentText())
            
            egenskaper = AreaGeoDataParser.egenskaper(id)
            egenskaper = self.advanced_filtering_filter_combobox(egenskaper)
            self.advanced_filtering_egenskap_type_cb.addItems(egenskaper)
            
    # Method connected to all of the user ui elements when adding a egenskap/relasjon/overlapp query
    # The method updates the global self.import_curr_item with the current input from the user
    def advanced_filtering_handle_user_input(self):
       
        
        
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
       
        self.advanced_filtering_current_item_display.setText("")
        
        
        o_r_verdi = self.advanced_filtering_overlapp_verdi_cb.currentText()
        eg_type = self.advanced_filtering_egenskap_type_cb.currentText()
        op = self.advanced_filtering_operator_cb.currentText()
        isCombobox = False
        eg_verdi_text = self.advanced_filtering_egenskap_verdi_lineedit.text()
        eg_verdi_combo = self.advanced_filtering_egenskap_verdi_combobox.currentText()
        if self.advanced_filtering_egenskap_verdi_combobox.currentData():
            eg_verdi_combo = self.advanced_filtering_egenskap_verdi_combobox.currentData()
            isCombobox = True
        eg_verdi = eg_verdi_text if eg_verdi_text else ((eg_verdi_combo) if eg_verdi_combo else '')
        
        
        self.advanced_filtering_confirm_btn_controller(o_r_verdi, eg_type, op, eg_verdi, isCombobox)
        
    
        self.current_egenskap = eg_type
        
        if not isCombobox and len(eg_verdi) > 0:
            
            eg_verdi = self.advanced_filtering_handle_egenskap_verdi_textornum(eg_verdi)
        
        
        if isCombobox and self.advanced_filtering_egenskap_type_cb.isEnabled():
            self.advanced_filtering_egenskap_verdi_combobox.setEnabled(True)
            self.advanced_filtering_egenskap_verdi_lineedit.setEnabled(False)
        if not isCombobox and self.advanced_filtering_egenskap_type_cb.isEnabled():
            self.advanced_filtering_egenskap_verdi_lineedit.setEnabled(True)
            self.advanced_filtering_egenskap_verdi_combobox.setEnabled(False)
        
       
        
        if(selectedCategory == "egenskap"):
                
                if len(o_r_verdi)> 0 and len(eg_type) > 0 and len(op) > 0 and len(str(eg_verdi)):
                    self.advanced_filtering_save_btn.setEnabled(True)
                
                self.import_curr_item = {'type': eg_type, 'operator': op, 'verdi': eg_verdi}
                self.import_curr_item_several = self.import_curr_item
        elif (selectedCategory == "overlapp"):
                
                self.import_curr_item = {'type': o_r_verdi, "egenskaper": [{'type': eg_type, 'operator': op, 'verdi': eg_verdi}]}
                
        elif(selectedCategory == "relasjon"):
                
                    
                self.import_curr_item = {"relasjon_typer": [o_r_verdi] , "egenskaper": [{'type': eg_type, 'operator': op, 'verdi': eg_verdi}]}
                
                
               
                
        import_string_builder_str = "".join(str(self.import_curr_item.values()))
        import_string_builder_str = re.sub(r"[',\(\){}]", "", import_string_builder_str)
        import_string_builder_str = import_string_builder_str.replace("dict_values", selectedCategory)
        self.advanced_filtering_current_item_display.setText(import_string_builder_str)
                
        self.advanced_filtering_egenskap_type_from_str_to_num(selectedCategory)

        
        
            
       
    
    # method from main window. Easiest thing was to just copy paste it here
    def fixNVDBObjects(self):
    
        #        all nvdb object types no all objects, to simulate datakatalog id
        nvdbObjects = []

        try:
            nvdbObjects = AreaGeoDataParser.fetchAllNvdbObjects()

            listObjectNames = []
            self.listOfnvdbObjects = {}

            for key, value in nvdbObjects.items():
                listObjectNames.append(key)
                self.listOfnvdbObjects[key] = value

        except Exception:
            print('datakatalog ikke lastet opp!')

        return listObjectNames

    # Method called when user is changing the self.import_curr_item
    # this method is needed because we need the id, and not the string value from egenskap
    # The method updates the global self.import_curr_item["type"] to be the id of the chosen combobox string value
    def advanced_filtering_egenskap_type_from_str_to_num(self, selectedCategory):
        if selectedCategory == "egenskap":
            if self.import_curr_item.get("type"):
                egenskap_type = self.import_curr_item.get("type")
                type = self.vegobjekt_parser_instance.result.get("type")
                egenskaper = AreaGeoDataParser.egenskaper(type)
                self.import_curr_item["type"] = egenskaper.get(egenskap_type)
                self.import_curr_item["str_type"] = egenskap_type
                   
        if selectedCategory == "overlapp":
            
            if self.import_curr_item.get("type"):
                    type_as_str = self.import_curr_item.get("type")
                    
                    type_as_nm = self.listOfnvdbObjects.get(type_as_str)
                    self.import_curr_item["type"] = type_as_nm
                   
                    if self.import_curr_item.get("egenskaper"):
                        
                        egenskap_liste = self.import_curr_item.get("egenskaper")
                        egenskaper = AreaGeoDataParser.egenskaper(type_as_nm)
                        for egenskap in egenskap_liste:
                            
                            if egenskap.get("type"):
                                
                                egenskap_type = egenskap.get("type")
                                if egenskaper.get(egenskap_type):
                                        
                                        egenskap["type"] = egenskaper.get(egenskap_type)
                                        egenskap["str_type"] = egenskap_type
        if selectedCategory == "relasjon":
            if self.import_curr_item.get("relasjon_typer"):
                    relasjons_typer = self.import_curr_item.get("relasjon_typer")
                    newarr = []
                    for rel_type in relasjons_typer:
                       
                        type_as_str = rel_type
                        type_as_nm = self.listOfnvdbObjects.get(type_as_str)
                        newarr.append(type_as_nm)
                        
                    self.import_curr_item["relasjon_typer"] = newarr
                    
                    if self.import_curr_item.get("egenskaper"):
                        last_relasjon_id = newarr[-1]
                        if self.import_curr_item_several.get("relasjon_typer"):
                            last_relasjon_id = self.import_curr_item_several.get("relasjon_typer")[-1]
                        egenskaper = AreaGeoDataParser.egenskaper(last_relasjon_id)
                        egenskap_liste = self.import_curr_item.get("egenskaper")
                        for egenskap in egenskap_liste:
                            
                            if egenskap.get("type"):
                                
                                egenskap_type = egenskap.get("type")
                                if egenskaper.get(egenskap_type):
                                       
                                        egenskap["type"] = egenskaper.get(egenskap_type)
                                        egenskap["str_type"] = egenskap_type
            
    # mehod that populates advanced_filtering_egenskap_verdi_combobox based on the chosen category.
    # the method also locks and unlocks the egenskap_verdi  based on if we have enum or text data expected.
    def advanced_filtering_populate_egenskap_values(self):
        
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        
        
        self.advanced_filtering_egenskap_verdi_combobox.clear()
        self.advanced_filtering_egenskap_verdi_lineedit.clear()
        
        if (self.vegobjekt_parser_instance.result.get("type")) :
            
            if selectedCategory == "egenskap":
                type = self.vegobjekt_parser_instance.result.get("type")
                egenskap_type = self.import_curr_item.get("str_type")
                
                egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
                
                if egenskaper_data:
                    
                    self.advanced_filtering_egenskap_verdi_combobox.clear()
                    for enum_key in egenskaper_data.keys():
                        display_string = str(enum_key) 
                        self.advanced_filtering_egenskap_verdi_combobox.addItem(display_string, enum_key)
                                
                    if egenskaper_data:
                        self.advanced_filtering_egenskap_verdi_combobox.setCurrentIndex(0)
                
              
                    
                    
                    
                
            elif selectedCategory == "overlapp" :
                if self.import_curr_item.get("egenskaper") :
                    type = self.import_curr_item.get("type")
                    egenskap_type = self.import_curr_item.get("egenskaper")[0].get("str_type")
                    egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
                   
                    if egenskaper_data:
                           
                           
                           self.advanced_filtering_egenskap_verdi_combobox.clear()
                           for enum_key in egenskaper_data.keys():
                               display_string = str(enum_key) 
                               self.advanced_filtering_egenskap_verdi_combobox.addItem(display_string, enum_key)
                                
                           if egenskaper_data:
                                self.advanced_filtering_egenskap_verdi_combobox.setCurrentIndex(0)
                                    
                    
                                
                           
                                    
                    
        
            elif selectedCategory == "relasjon" :
                if self.import_curr_item.get("egenskaper") :
                    type = self.import_curr_item.get("relasjon_typer")[-1]
                    if self.import_curr_item_several.get("relasjon_typer"):
                        type = self.import_curr_item_several.get("relasjon_typer")[-1]
                    egenskap_type = self.import_curr_item.get("egenskaper")[0].get("str_type")
                    egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
                    if egenskaper_data:
                           
                          
                           self.advanced_filtering_egenskap_verdi_combobox.clear()
                           for enum_key in egenskaper_data.keys():
                               display_string = str(enum_key) 
                               self.advanced_filtering_egenskap_verdi_combobox.addItem(display_string, enum_key)
                                
                           if egenskaper_data:
                                self.advanced_filtering_egenskap_verdi_combobox.setCurrentIndex(0)
                                
                           
                                    
                    
    
    # method being used in add_item_to_url() method
    # the method converts the geneskap verdi string into the corresponding id.
    def advanced_filtering_egenskap_verdi_to_num(self):
        # senere vil det være mulig å loope gjennom for flere egenskaper/relasjoner, men for nå bare 1
        
            selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
            if selectedCategory == "egenskap":
                type = self.vegobjekt_parser_instance.result.get("type")
                egenskap_type = self.import_curr_item.get("str_type")
                egenskap_value = self.import_curr_item.get("verdi")
                egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
                
                
                
            
                egenskap_value_num = egenskaper_data.get(egenskap_value)
                if egenskap_value_num is not None:
                    self.import_curr_item_several["verdi"] = egenskap_value_num
                
                
            elif selectedCategory == "relasjon" :
                type = self.import_curr_item_several.get("relasjon_typer")[-1]
                
                arr = self.import_curr_item_several.get("egenskaper")
                for ov in arr:
                    egenskap_type = ov.get("str_type")
                    egenskap_value = ov.get("verdi")
                    egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
                    egenskap_value_num = egenskaper_data.get(egenskap_value)
                    
                    if egenskap_value_num is not None:
                        egenskap_value_num = egenskaper_data.get(egenskap_value)
                        ov["verdi"] = egenskap_value_num
                self.import_curr_item_several["egenskaper"] = arr
            elif selectedCategory == "overlapp" :
                type = self.import_curr_item_several.get("type")
                arr = self.import_curr_item_several.get("egenskaper")
                if arr :
                    for ov in arr:
                        
                        egenskap_type = ov.get("str_type")
                        egenskap_value = ov.get("verdi")
                        egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
                        egenskap_value_num = egenskaper_data.get(egenskap_value)
                        
                       
                        if egenskap_value_num is not None:
                            egenskap_value_num = egenskaper_data.get(egenskap_value)
                            ov["verdi"] = egenskap_value_num
                    self.import_curr_item_several["egenskaper"] = arr

    # callback method used in main window, the method is called when user checks the bruk avansert filtrering checkbox
    # the method will block and unblock the lagre endring and import button
    def advanced_filtering_enabled_from_main(self, bool_value):
        self.advanced_filtering_enabled_value = bool_value
        if not bool_value:
            self.advanced_filtering_search_btn.setEnabled(False)
        
        self.advanced_filtering_change_buttons_disabled()
    
    def advanced_filtering_add_several_egenskap_enable_comboboxes(self):
        self.advanced_filtering_change_egenskaper_buttons_enabled(True)
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        
        
        self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(False)
        self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
        self.advanced_filtering_overlapp_verdi_cb.setEnabled(False)
        self.advanced_filtering_egenskap_has_been_added = True
        self.advanced_filtering_add_item_btn.setEnabled(False)
        
        if self.advanced_filtering_egenskap_verdi_combobox.currentData() and self.advanced_filtering_egenskap_type_cb.isEnabled():
            self.advanced_filtering_egenskap_verdi_combobox.setEnabled(True)
            self.advanced_filtering_egenskap_verdi_lineedit.setEnabled(False)
            self.advanced_filtering_add_item_btn.setEnabled(True)
        if not self.advanced_filtering_egenskap_verdi_combobox.currentData() and self.advanced_filtering_egenskap_type_cb.isEnabled():
            self.advanced_filtering_egenskap_verdi_lineedit.setEnabled(True)
            self.advanced_filtering_egenskap_verdi_combobox.setEnabled(False)
            self.advanced_filtering_add_item_btn.setEnabled(False)
            
    def advanced_filtering_add_several_relasjon_enable_comboboxes(self):
        
        
        self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(True)
        self.advanced_filtering_overlapp_verdi_cb.setEnabled(True)
        self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(False)
        self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
        self.advanced_filtering_save_btn.setEnabled(False)
        self.advanced_filtering_add_item_btn.setEnabled(True)
      
    def advanced_filtering_add_item(self):
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        
        if selectedCategory == "relasjon":
            egenskaper = ""
            relasjoner = []
            # check if we are adding egenskap or relasjon
            if self.advanced_filtering_overlapp_verdi_cb.isEnabled():
                 
                if self.import_curr_item_several.get("relasjon_typer"):
                    relasjoner = self.import_curr_item_several.get("relasjon_typer")
                    relasjoner.append(self.import_curr_item["relasjon_typer"][0])
                    self.import_curr_item_several["relasjon_typer"] = relasjoner
                    
                else:
                    relasjoner = self.import_curr_item.get("relasjon_typer")[0]
                    self.import_curr_item_several["relasjon_typer"] = [relasjoner]
                
                type = self.import_curr_item_several.get("relasjon_typer")[-1]
                possible_children = AreaGeoDataParser.get_possible_children_catalog_typeid(type)
                self.possible_children_names = list(map(lambda x: x["navn"], possible_children))
                self.possible_children_id = list(map(lambda x: x["id"], possible_children))
                self.advanced_filtering_overlapp_verdi_cb.clear()
                self.advanced_filtering_populate_egenskap_combo_box()
                self.possible_children_names = self.advanced_filtering_filter_combobox(self.possible_children_names)
                self.advanced_filtering_overlapp_verdi_cb.addItems(self.possible_children_names)
                self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(True)
                self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(True)
            
            if self.advanced_filtering_egenskap_type_cb.isEnabled():
                   
                
                if self.import_curr_item_several.get("egenskaper"):
                    egenskaper = self.import_curr_item_several.get("egenskaper")
                    egenskaper.append(self.import_curr_item["egenskaper"][0])
                    self.import_curr_item_several["egenskaper"] = egenskaper
                else:
                    egenskaper = self.import_curr_item.get("egenskaper")
                    self.import_curr_item_several["egenskaper"] = egenskaper
                self.advanced_filtering_egenskap_has_been_added = True
            if self.advanced_filtering_egenskap_has_been_added:
                
                self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(False)
                self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(True)
                
                self.advanced_filtering_save_btn.setEnabled(True)
                
               
               
            
            else :
                self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(True)
                self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(True)
                self.advanced_filtering_save_btn.setEnabled(False)
            
            relasjoner = self.import_curr_item_several.get("relasjon_typer")
            egenskaperListe = [f"({''.join(map(str, (value for key, value in egenskap.items() if key != 'str_type')))}" for egenskap in egenskaper]
            str_expression = f"kategori: {selectedCategory}, relasjon objekttype: {relasjoner}, egenskaper: {egenskaperListe}"
            self.advanced_filtering_current_item_display.setText(str_expression)
            
        elif selectedCategory == "overlapp":
            egenskaper = ""
            if self.import_curr_item.get("type"):
                type = self.import_curr_item.get("type")
                self.import_curr_item_several["type"] = type
                    
            if self.advanced_filtering_egenskap_type_cb.isEnabled():
                   
                if self.import_curr_item_several.get("egenskaper"):
                    egenskaper = self.import_curr_item_several.get("egenskaper")
                    egenskaper.append(self.import_curr_item["egenskaper"][0])
                    self.import_curr_item_several["egenskaper"] = egenskaper
                    
                else:
                    egenskaper = self.import_curr_item.get("egenskaper")
                    self.import_curr_item_several["egenskaper"] = egenskaper
            egenskaperListe = [f"({''.join(map(str, (value for key, value in egenskap.items() if key != 'str_type')))}" for egenskap in egenskaper]
            str_expression = f"kategori: {selectedCategory}, overlapp objekttype: {type}, egenskaper: {egenskaperListe}"
            self.advanced_filtering_current_item_display.setText(str_expression)
            if self.advanced_filtering_egenskap_has_been_added:
                self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
            else:
                self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(True)
            self.advanced_filtering_egenskap_has_been_added = True
            self.advanced_filtering_change_egenskaper_buttons_enabled(False)
            self.advanced_filtering_save_btn.setEnabled(True)
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        self.advanced_filtering_add_item_btn.setEnabled(False)
        self.advanced_filtering_delete_btn.setEnabled(True)
        self.advanced_filtering_overlapp_verdi_cb.setEnabled(False)
        
        
        
    def advanced_filtering_change_buttons_disabled(self):
        enableButtons = False
        
        if self.vegobjekt_parser_instance.result.get("type") != None and self.advanced_filtering_enabled_value:
            enableButtons = True
        else:
            enableButtons = False
            self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
            self.advanced_filtering_add_several_relasjon_enable_comboboxes_btn.setEnabled(False)
            
            
        self.advanced_filtering_egenskap_or_overlapp_cb.setEnabled(enableButtons)
        self.advanced_filtering_overlapp_verdi_cb.setEnabled(enableButtons)
        self.advanced_filtering_save_btn.setEnabled(enableButtons)
        if enableButtons and self.current_selected_item:
             self.advanced_filtering_delete_btn.setEnabled(enableButtons)
    
    def advanced_filtering_change_egenskaper_buttons_enabled(self,value):
        self.advanced_filtering_egenskap_type_cb.setEnabled(value)
        self.advanced_filtering_operator_cb.setEnabled(value)
        self.advanced_filtering_egenskap_verdi_lineedit.setEnabled(value)
        self.advanced_filtering_egenskap_verdi_combobox.setEnabled(value)
    
    def advanced_filtering_disable_all_buttons(self):
        self.advanced_filtering_change_egenskaper_buttons_enabled(False)
        self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
        self.advanced_filtering_add_several_egenskap_enable_comboboxes_btn.setEnabled(False)
        self.advanced_filtering_add_item_btn.setEnabled(False)
        self.advanced_filtering_reset_btn.setEnabled(False)
        self.advanced_filtering_save_btn.setEnabled(False)
        self.advanced_filtering_delete_btn.setEnabled(False)
        self.advanced_filtering_egenskap_or_overlapp_cb.setEnabled(False)
        self.advanced_filtering_search_btn.setEnabled(False)
    def advanced_filtering_confirm_btn_controller(self, o_r_verdi, eg_type, op, eg_verdi, isCombobox):
        
        # is combobox is a boolean that shows us if the eg_verdi is an enum 
        selectedCategory = self.advanced_filtering_egenskap_or_overlapp_cb.currentText()
        if selectedCategory == "egenskap":
            if  len(eg_type) > 0 and len(op) > 0 and len(str(eg_verdi)) > 0:
                self.advanced_filtering_save_btn.setEnabled(True)
            else:
                self.advanced_filtering_save_btn.setEnabled(False)
        if selectedCategory == "overlapp":
            if self.advanced_filtering_overlapp_verdi_cb.isEnabled():
                self.advanced_filtering_add_item_btn.setEnabled(True)
                
            
            else:
                if len(o_r_verdi)> 0 and len(eg_type) > 0 and len(op) > 0 and len(str(eg_verdi)) > 0:
                    self.advanced_filtering_add_item_btn.setEnabled(True)
                else:
                    self.advanced_filtering_add_item_btn.setEnabled(False)
        if selectedCategory == "relasjon":
            if len(o_r_verdi)> 0 and self.advanced_filtering_overlapp_verdi_cb.isEnabled():
                self.advanced_filtering_add_item_btn.setEnabled(True)
                
                
            if len(o_r_verdi)> 0 and len(eg_type) > 0 and len(op) > 0 and len(str(eg_verdi)) > 0:
                self.advanced_filtering_add_item_btn.setEnabled(True)
        
        if self.advanced_filtering_add_item_btn.isEnabled() or (not (len(eg_type) > 0 and len(op) > 0 and len(str(eg_verdi)) > 0) and self.advanced_filtering_egenskap_type_cb.isEnabled()):
            self.advanced_filtering_save_btn.setEnabled(False)
        
    def advanced_filtering_handle_egenskap_verdi_textornum(self, verdi):
        type = self.vegobjekt_parser_instance.result.get("type")
        egenskap_type = self.import_curr_item.get("str_type")
        
        egenskaper_data = AreaGeoDataParser.especificEgenskaper(type, egenskap_type)
        if AreaGeoDataParser.egenskapDataType() == "Tekst":
            curr_value = self.advanced_filtering_egenskap_verdi_lineedit.text()
            verdi = '"' + verdi + '"'
            
        return verdi
    
    def advanced_filtering_filter_combobox(self, list):
        
        list = [elem for elem in list if "Assosiert" not in elem]
        
        return list