import inspect
import sys
import os

nvdblibrary = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
nvdblibrary = nvdblibrary.replace('\\', '/')
nvdblibrary = nvdblibrary + '/nvdbapi'

## Hvis vi ikke klarer å importere nvdbapiv3 så prøver vi å føye
## mappen nvdblibrary til søkestien.
try:
    import nvdbapiv3
except ModuleNotFoundError:
    print("Fant ikke nvdbapiv3 i sys.path, legger til mappen", nvdblibrary)
    sys.path.append(nvdblibrary)

    try:
        import nvdbapiv3
    except ModuleNotFoundError as e:
        print("\nImport av nvdbapiv3 feiler for", nvdblibrary)
        raise ModuleNotFoundError(
            "==> Variabel nvdblibrary skal peke til mappen https://github.com/LtGlahn/nvdbapi-V3  <==")

    else:
        print("SUKSESS - kan importere nvdbapiv3 etter at vi la til", nvdblibrary, "i sys.path")
else:
    print("HURRA - vi kan importere nvdbapiv3 ")

# PyQt5 libs
from PyQt5.QtWidgets import QCompleter, QVBoxLayout, QLabel, QTableWidgetItem, QAbstractItemView
from PyQt5.QtCore import QDate, QSortFilterProxyModel, pyqtSignal, QAbstractTableModel
from PyQt5.QtGui import QStandardItemModel, QStandardItem

# third party libs
from .nvdbapiV3qgis3 import nvdb2kart, nvdbsok2qgis, url2kart, nvdb2kartListe
from nvdbapiv3 import nvdbFagdata, nvdbVegnett

# user defined libs
from .source_skriv_window import SourceSkrivDialog
from .source_more_window import SourceMoreWindow
from .nvdbLesWrapper import AreaGeoDataParser

# user defined module for custom MVC
from .custom_qstandard_item_model import CustomStandardItemModel

# user defined devils korrigering modules
from .customDelvisKorrRemoveCase import CustomDelvisKorrRemoveCase
from .customKorrSingleAdd import CustomDelvisKorrSingleAdd
from .customDelvisKorrReplaceParent import CustomDelvisKorrReplaceParent
from .delvisStedfestCase import DelvisStedfestCase

# PyQt5 libs
from qgis.PyQt import QtWidgets
from qgis.utils import iface
from qgis.PyQt import uic
from qgis.core import *

# includes need it for development
import xml.etree.ElementTree as ET

import threading
import requests
import json
import time

# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NvdbBetaProductionDialog
                                 A QGIS plugin
 nvdb plugin to filtrate and show objects belonging to the norwegian roads
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-12
        git sha              : $Format:%H$
        copyright            : (C) 2023 by SVV
        email                : alexander.casado@vegvesen.no
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'nvdb_beta_dialog_base.ui'))

class NvdbBetaProductionDialog(QtWidgets.QDialog, FORM_CLASS):
    ready_for_setting_searched_objekt = pyqtSignal(list)

    setting_each_uiItem_inTable = pyqtSignal(int, dict, tuple, dict)

    amount_of_vegobjekter_collected = pyqtSignal(int)

    # remove_road_object_signal = pyqtSignal()

    update_more_window_statusbar = pyqtSignal(int)

    def __init__(self, parent=None):
        """Constructor."""
        super(NvdbBetaProductionDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # setting default road object limit info to 1
        self.limit_roadObject_info_inTable.setValue(1)
        self.label_limiter_info.setText(str(self.limit_roadObject_info_inTable.value()))
        self.limit_roadObject_info_inTable.setEnabled(False)

        self.skrivWindowInstance = None  # making skriv window null
        self.skrivWindowOpened: boolean = False  # making windows opened false
        self.isSourceMoreWindowOpen = False  # making more window flag false
        self.after_possible_parent_selected: bool = False  # to control that parent is or not selected when sammenkobling
        self.after_possible_child_selected: bool = False  # o control that parent is or not selected when sammenkobling
        self.possible_parent_type: int = int()  # to storage possible parent relation from source_more_window
        # self.parent_type_selected_to_relate: int = int() #to connect child to a selected parent
        # self.valid_roadObject_types = False
        self.possible_parent_name = str()  # to store name of possible parent relation
        self.hasChildParentRoadObject = False  # to control whether child road object has or doesn't have a parent
        self.parent_roadObject_linked_nvdbid: int = int()  # for store nvdbid for related parent when sammenkobling
        self.parent_roadObject_linked_type: int = int()  # || type for related parent when sammenkobling
        self.username_session: str = str()  # username session only when attempting to remove relation
        self.current_session_token: dict = {}  # current session tokens for current logged user
        self.possible_selected_parent_nvdbid: int = int()  # possible selected parent nvdbId from QGIS kart layer
        self.cnt_more_window_statusbar: int = int()  # for counting progress for statusbar in source_more_window
        self.current_selected_index_tab: int = int(
            0)  # for checking if stedfest or relasjoner=default tab section in more_window are actives or not
        self.add_relation_changes_sent: bool = False  # to check when add relation endringssett is sent to NVDB
        self.remove_relation_changes_sent: bool = False  # to check when remove relation endringssett is sent to NVDB
        self.replace_relation_changes_sent: bool = False  # to check when replace relation endringssett is sent to NVDB
        self.stedfest_changes_sent: bool = False  # for controlling stedfest only send once
        self.isChildIncludedInChangeset: bool = False  # to control when user include or not children from source_more_window
        self.activate_type_changeset: str = str('correction')  # to control when user toggle korrigering/oppdater by default korrigering
        self.is_data_coming_from_url: bool = False
        self.data_from_imported_url = None

        self.activate_type_changeset: str = str(
            'correction')  # to control when user toggle korrigering/oppdater by default korrigering
        
        self.child_object_nvdbid: int = int()
        
        self.data_already_fetched: bool = False
        #        development starts here
        #        setting up all data need it for starting up

        #        making filter edit box unabled when program start
        self.filterByLineEdit.setEnabled(False)
        self.openSkrivWindowBtn.setEnabled(False)  # setting not enabled before search is done!
        self.changeObjectsSize.setEnabled(False)

        # Use event to stop thread
        self.exit_event = threading.Event()

        self.status_login = False
        self.selected_layer_from_map: list = []
        self.selected_object_from_map: list = []
        self.source_more_window = None
        self.data_fromSelectedObject_from_layer = None
        self.relations = None
        # self.dependant_mor: boolean = False
        # self.active_relation_parent: dict = {}
        self.layers_list: list = []

        #        dictionary with endpoints necessary for environment
        self.environment = {
            'Produksjon': 'https://nvdbapiles-v3.atlas.vegvesen.no',
            'Utvikling': 'https://nvdbapiles-v3.utv.atlas.vegvesen.no',
            'Akseptansetest': 'https://nvdbapiles-v3.test.atlas.vegvesen.no',
            'Systemtest': 'https://nvdbapiles-v3-stm.utv.atlas.vegvesen.no'
        }

        #        creating a QStandardItemModel for being able to connect itemChange() signal
        #        rows, columns and headers will be assigned later on self.setObjectsToUI() method
        self.tableViewResultModel = QStandardItemModel()
        self.mvc_table_model = CustomStandardItemModel()

        #        proxy model, to filter table view data on any column
        self.proxyModel = QSortFilterProxyModel()

        self.proxyModel.setSourceModel(self.mvc_table_model)

        # self.proxyModel.setSourceModel(self.tableViewResultModel)

        self.proxyModel.setFilterKeyColumn(-1)  # -1 means all columns

        self.proxyModel.setFilterCaseSensitivity(0)  # 0 means insensitive

        #        set combo box data to choose environment if production/test/development
        self.comboEnvironment.addItems({'Produksjon', 'Utvikling', 'Akseptansetest'})

        #        selecting a default environment
        self.comboEnvironment.setCurrentText('Produksjon')

        #        setting an environment for default
        AreaGeoDataParser.set_env(self.environment[self.comboEnvironment.currentText()])

        #        setting up combobox default values
        self.operatorCombo.addItems({'ikke verdi', '>', '<', '>=', '<=', '=', '!='})
        self.operatorCombo.setCurrentIndex(-1)

        #        deactivating combobox when starting
        #        self.egenskapBox.setEnabled(False)
        self.operatorCombo.setEnabled(False)
        self.verdiField.setEnabled(False)

        #        deactivating some UI components
        self.searchObjectBtn.setEnabled(False)
        self.visKartCheck.setEnabled(False)

        # make some default settings according miljø
        self.set_default_settings()

        # checking if there is a user session already,
        # and if is then, remove it

        # print(os.environ['remember_loging'])

        try:

            if os.environ.get('logged') and os.environ.get('remember_loging') == 'False':
                print('there is a session !, removing it ...')
                
                os.environ['svv_user_name'] = ''

                os.environ['svv_username'] = ''

                os.environ['svv_pass'] = ''
                os.environ['logged'] = ''

        except KeyError:

            # print('keyerror')
            pass

        #        connecting signals and slots

        #        very important to fetch kommuner when field fylke change
        self.fylkeField.editingFinished.connect(self.checkComunitiesInCounty)

        #        when search button pressed
        self.searchObjectBtn.clicked.connect(self.searchObj)

        #        when vis i kart checkbox active then
        self.visKartCheck.clicked.connect(self.onVisIKart)

        #        noen egenskap i UI skal være not enable til user skriver input
        self.nvdbIdField.editingFinished.connect(self.onIdCatalogEdited)

        #        when an item in table widget is clicked then
        #        self.tableResult.itemClicked.connect(self.onItemClicked)

        self.tableResult.clicked.connect(self.onItemClicked)

        # when scrolling in tableview result
        self.tableResult.verticalScrollBar().valueChanged.connect(self.onScroll)

        #        when egenskap box change current item then
        self.egenskapBox.currentIndexChanged.connect(self.onEgenskapChanged)

        #        when operator box change then
        self.operatorCombo.currentIndexChanged.connect(self.onOperatorChanged)

        #        when filtering the search in real time
        self.filterByLineEdit.textChanged.connect(self.proxyModel.setFilterRegExp)

        #        when current index in miljø combobox changed then
        self.comboEnvironment.currentIndexChanged.connect(self.onComboMiljoChange)

        #        when open button clicked then
        self.openSkrivWindowBtn.clicked.connect(self.openSkrivWindow)

        #        when selecting any feature from the active layer, then
        iface.mapCanvas().selectionChanged.connect(self.onAnyFeatureSelected)

        #        when changing objects size in layer then
        self.changeObjectsSize.valueChanged.connect(self.on_objectSizeOnLayerChange)

        # when QSlider value change then change label_limiter_info
        self.limit_roadObject_info_inTable.valueChanged.connect(
            lambda: self.label_limiter_info.setText(str(self.limit_roadObject_info_inTable.value())))

        # open more window for relation or stedfesting
        self.more_btn.clicked.connect(self.open_more_window)
        
        #        when vis i kart checkbox active then
        self.enable_advanced_filtering_btn.stateChanged.connect(self.toggle_advanced_filtering_enabled)
        self.enable_advanced_filtering_btn.setChecked(False)

        '''
        if child road object alreary has a relation parent then add new relation
        operation is requiered then remove first and then when removing is done
        a remove signal is triggerd so new relation parent can be added to child object
        '''
        # self.remove_road_object_signal.connect(self.replace_single_relation_fromSourceData)

        # self.remove_road_object_signal.connect(self.add_single_relation_fromSourceData)

    #        rest of methods===============================

    def set_default_settings(self):
        print('applying new default settings')
        
        #        autocompletion for nvdb field
        listObjectNames = self.fixNVDBObjects()
        self.setCompleterNVDBObjects(listObjectNames)

        #        autocompletion for fylke field
        listOfCounties = self.fixFylkeObjects()
        self.setCompleterFylkeObjects(listOfCounties)

        #        autocompletion for kommune field
        listOfCommunities = self.fixCommunityObjects()
        self.setCompleterCommunityObjects(listOfCommunities)
        
        #self.data_already_fetched = False
        
        #setting AreaGeoDataParser env again with current selected env
        # AreaGeoDataParser.set_env( self.environment[self.comboEnvironment.currentText()] )

    def fixNVDBObjects(self):
        #        all nvdb object types no all objects, to simulate datakatalog id
        nvdbObjects = []

        try:
            nvdbObjects = AreaGeoDataParser.fetchAllNvdbObjects()

            listObjectNames = []
            self.listOfnvdbObjects = {}

            for key, value in nvdbObjects.items():
                listObjectNames.append(key)
                self.listOfnvdbObjects[key] = value

        except Exception:
            print('datakatalog ikke lastet opp!')

        return listObjectNames

    def fixFylkeObjects(self):
        counties = []

        try:
            counties = AreaGeoDataParser.counties()
            
            listOfCountiesNames = []
            self.listOfCounties = {}
            self.reversListOfCounties = {}

            for key, value in counties.items():
                listOfCountiesNames.append(key)
                self.listOfCounties[key] = value
                self.reversListOfCounties[value] = key

        except Exception:
            print('flyke ikke lastett opp!')

        return listOfCountiesNames

    def fixCommunityObjects(self):
        communities = []

        try:
            communities = AreaGeoDataParser.communities()

            listOfCommunities = []
            self.listOfCommunitiesObjects = {}
            self.reversListOfCommunities = {}

            for key, value in communities.items():
                listOfCommunities.append(key)
                self.listOfCommunitiesObjects[key] = value
                self.reversListOfCommunities[value] = key

        except Exception:
            print('kommuner ikke lastett opp!')

        return listOfCommunities

    def checkComunitiesInCounty(self):
        data = []

        if self.fylkeField.text() == '':
            #            print('empty')
            data = self.fixCommunityObjects()
            self.setCompleterCommunityObjects(data)

        elif self.fylkeField.text() != '':
            text = self.fylkeField.text()
            for key, value in AreaGeoDataParser.communitiesInCounties.items():
                try:

                    if value == self.listOfCounties[text]:
                        data.append(key)

                except Exception:
                    pass

        self.setCompleterCommunityObjects(data)

    def setCompleterNVDBObjects(self, data):
        autoCompleter = QCompleter(data)
        autoCompleter.setCaseSensitivity(False)

        self.nvdbIdField.setCompleter(autoCompleter)

    def setCompleterFylkeObjects(self, data):
        autoCompleter = QCompleter(data)
        autoCompleter.setCaseSensitivity(False)

        self.fylkeField.setCompleter(autoCompleter)

    def setCompleterCommunityObjects(self, data):
        autoCompleter = QCompleter(data)
        autoCompleter.setCaseSensitivity(False)

        self.kommuneField.setCompleter(autoCompleter)

    def searchObj(self):
        if self.exit_event.is_set():
            self.exit_event.clear()
        print("coming from url" + str(self.is_data_coming_from_url))
        self.mvc_table_model.clear_fetch()

        # feeding new list of egenskaper if new search is performed after one object search
        if self.skrivWindowOpened and self.skrivWindowInstance:
            new_list = self.get_new_egenskaper_list(self.nvdbIdField.text())

            self.skrivWindowInstance.feed_new_list_egenskaper_and_data(self.data, new_list)

        #        here search is prepared depending on which filters the user has established

        # clearing tableview results everytime user search new road object
        # if self.tableViewResultModel.rowCount() > 0:
        # self.tableViewResultModel.clear()

        '''
        removing layers just in case there are some actives, before a new search
        only when user is not delivering relation/relasjon (sammenkobling) changes
        Bug Fixed: when user showing road objects in kart after searching first time
        and not when delivering relation modifications
        '''

        # if not self.after_possible_parent_selected and not self.after_possible_child_selected:
        if not self.after_possible_parent_selected:
            self.removeActiveLayers()
            self.layers_list = []
            # self.set_layer_size()

        #        when searchObj execute then vis kart options are enabled and checked is false
        self.visKartCheck.setEnabled(True)
        self.visKartCheck.setChecked(False)

        #        clearing layer map in QGIS in case exists
        # self.removeActiveLayers()

        if self.nvdbIdField.text() != '':
            nvdbId = self.listOfnvdbObjects[self.nvdbIdField.text()]
            self.source_data = nvdbFagdata(int(nvdbId))

            #            --check nvdb environment
            if self.comboEnvironment.currentText() == 'Produksjon':
                self.source_data.miljo('prod')

            if self.comboEnvironment.currentText() == 'Utvikling':
                self.source_data.miljo('utv')

            if self.comboEnvironment.currentText() == 'Akseptansetest':
                self.source_data.miljo('test')

        # case where we sort after the main window ui
        if not self.is_data_coming_from_url:
            
            if self.fylkeField.text() in self.listOfCounties:
                fylke = self.listOfCounties[self.fylkeField.text()]
                self.source_data.filter({'fylke': int(fylke)})

            if self.kommuneField.text() in self.listOfCommunitiesObjects:
                kommune = self.listOfCommunitiesObjects[self.kommuneField.text()]
                self.source_data.filter({'kommune': int(kommune)})

            if self.vegreferanseField.text() != '':
                self.source_data.filter({'vegsystemreferanse': self.vegreferanseField.text()})

            #        only if egenskapbox, operatorBox and verdi fields are populated then
            if self.egenskapBox.currentText() != '' and self.operatorCombo.currentText() != '' and self.verdiField.text() != '':

                #            some aux variables
                egensk = self.listOfEgenskaper[self.egenskapBox.currentText()]
                egenskAndVerdi = ''

                #            some aux variables
                key = self.verdiField.text()
                verdi = self.verdiField.text()
                operator = self.operatorCombo.currentText()

                #            some type checks

                if self.verdierDictionary:
                    verdi = self.verdierDictionary[key]

                if not self.verdierDictionary and AreaGeoDataParser.egenskapDataType() == 'Tall':  # if datatype is integer
                    verdi = int(verdi)

                if not self.verdierDictionary and AreaGeoDataParser.egenskapDataType() != 'Tall':  # otherwise treat it like string
                    verdi = "'" + verdi + "'"

                egenskAndVerdi = f"egenskap({egensk}){operator}{verdi}"

                self.source_data.filter({'egenskap': egenskAndVerdi})

        # case where we sort after the more_window ui elements.
        if self.is_data_coming_from_url:
           
           if len(self.data_from_imported_url) > 0:
                
                for query in self.data_from_imported_url:
                        
                       
                        self.source_data.filter(query)
            
           
                

           
            
        # threading
        target = self.handle_threaded_search_objeckt

        self.thread_search_object = threading.Thread(target=target)

        self.thread_search_object.start()

        # self.thread_search_object.join()

        # warn of search has started
        self.search_status_label.setText('Henter vegobjekter ...')

        # warning of search status has collected road objects
        self.amount_of_vegobjekter_collected.connect(
            lambda vegobjekter_amount: self.search_status_label.setText(f'Hentet {vegobjekter_amount} objekter'))

        # making sure QProgressbar is set to zero before setting new values
        # on a new object search
        if self.search_object_progress_bar.value() >= 0:
            self.search_object_progress_bar.setValue(0)

        # enabling QSlider for road object limiter,
        # it's disabled at the beginning of the program
        self.limit_roadObject_info_inTable.setEnabled(True)

        # connecting signal when objects ready for UI
        self.ready_for_setting_searched_objekt.connect(self.prepareObjectsForUI)

        # this here must be in a function/method
        if self.searchObjectBtn.text() == "Søk Objekt":
            
            self.searchObjectBtn.setText("Avbryt Søk")
            self.searchObjectBtn.setStyleSheet("background-color : red")

        else:
            self.searchObjectBtn.setText("Søk Objekt")
            self.searchObjectBtn.setStyleSheet("background-color : white; color : green")

            self.visKartCheck.setEnabled(False)
            self.limit_roadObject_info_inTable.setEnabled(False)

            # Thread for setting exit_event to true, so search_objects_thread is stopped
            self.thread_avbryt_sok = threading.Thread(self.interrupt_thread())

            self.thread_avbryt_sok.start()

            #        if skriv window is open, then hide it, make it none and set self.skrivWindowOpened false
            # if self.skrivWindowOpened:
            #     self.skrivWindowInstance.hide()

            # self.skrivWindowInstance = None
            # self.skrivWindowOpened = False

            # this btn needs to be disabled if skriv window was opened before the search
            self.openSkrivWindowBtn.setEnabled(False)
            
        self.openSkrivWindowBtn.setEnabled(True)
        
        self.data_already_fetched = True

    def interrupt_thread(self):
        # print("INTERRUPT!")
        # Search has been aborted mid-search
        self.exit_event.set()

    def handle_threaded_search_objeckt(self):
        # retrieve data with applied filters
        steps = 1
        sliced_data = []
        self.data = None
        self.times_to_run: int = 0

        # Display information about amount of objects to be searched
        ant_obj = self.source_data.statistikk()
        self.antall = ant_obj['antall']

        if self.antall and self.antall > 10000:
            self.search_status_label.setText(f"Eksport av,{self.antall}, objekter vil ta tid...")

        self.data = self.source_data.to_records(self.exit_event)
        # self.data = self.source_data.to_records(self.exit_event, vegsegmenter=False, geometri=True)

        if len(self.data) > 0:
            self.mvc_table_model.feed_data(self.data)

        # collecting size of the current object search, it can be different for all the road objects in NVDB
        data_size = len(self.data)

        # setting maximum value to limit_roadObject_info_inTable
        self.limit_roadObject_info_inTable.setMaximum(data_size + 1)

        # emiting signal when total road objects are collected
        self.amount_of_vegobjekter_collected.emit(data_size)

        # checking the data_size
        # to configure limit of info display in table view
        if data_size >= 0 and data_size <= 1000:
            data_size_for_info_inTable = data_size

        else:
            # data_size_for_info_inTable = self.limit_roadObject_info_inTable.value()
            data_size_for_info_inTable = 1000
            # print(f"Data_size is {data_size}")

        # self.limit_roadObject_info_inTable.setValue(self.limit_roadObject_info_inTable.value())
        self.limit_roadObject_info_inTable.setValue(data_size_for_info_inTable)

        self.label_limiter_info.setText(str(self.limit_roadObject_info_inTable.value()))

        # setting QSlider value to max_obj_search
        max_obj_search = self.limit_roadObject_info_inTable.value()

        # slicing data to show in table not in source data to sliced_data = max_obj_search
        # only if it's over that number
        if data_size == max_obj_search:
            sliced_data = self.data[0: max_obj_search: steps]

            self.current_num_road_objects = len(sliced_data)

        if data_size > max_obj_search:
            sliced_data = self.data[0: max_obj_search: steps]

            self.current_num_road_objects = len(sliced_data)

        # if not then, just copy data source to sliced_data anyway
        # without modifying/slicing data size
        elif data_size < max_obj_search:
            sliced_data = self.data

            self.current_num_road_objects = len(sliced_data)
        # print('size: ', len(sliced_data))

        objects_for_ui = self.makeMyDataObjects(sliced_data)

        # undefined behavior when emiting signal, then prepareObjectsForUI method
        # is calling itself multiple times, so self.times_to_run is to control this behavior
        self.times_to_run += 1

        self.ready_for_setting_searched_objekt.emit(objects_for_ui)

    def onScroll(self):
        # Continuously keep feeding data to the table as you scroll down
        if self.tableResult.verticalScrollBar().value() < len(
                self.data) and self.tableResult.verticalScrollBar().value() == self.tableResult.verticalScrollBar().maximum():
            self.mvc_table_model.fetch_more()

    def makeMyDataObjects(self, data):
        listObjects = []

        for element in data:
            for e in enumerate(element):
                key = e[1]
                obj = {key: element[key]}

                listObjects.append(obj)

        return listObjects

    def onVisIKart(self, checked):
        if checked:

            self.source_data.refresh()

            nvdbsok2qgis(self.source_data)
            
            # url2kart('https://nvdbapiles-v3.atlas.vegvesen.no/vegobjekter/581?overlapp=105(egenskap(2021)=2738)&overlapp=978(egenskap(12612)=21771)')

            '''
            on any features's geometry changed, this signal has to be connected after
            road objects are in layer on kart
            '''
            iface.activeLayer().geometryChanged.connect(self.sending_new_geometry_onChanged)

            self.set_layer_size()

        else:
            self.removeActiveLayers()
            self.layers_list = []

            #            when vis i kart option not checked in the current search, then just disable openSkrivWindow button
            self.openSkrivWindowBtn.setEnabled(False)

    def set_layer_size(self):

        self.changeObjectsSize.setEnabled(True)
        self.all_layers = QgsProject.instance().mapLayers().values()

        obj_size = 9

        # making a copy list for checking matching values in loop
        temp_list = self.layers_list.copy()

        try:
            # iterate through the list to check if a layer is already on the map, if so remove that layer else append that layer to the layers_list
            for layer in self.all_layers:
                if layer in temp_list:
                    # print("Removing layer...")

                    self.layers_list.remove(layer)
                    print(self.current_selected_index_tab)
                    if self.source_more_window and self.current_selected_index_tab == 1:
                        if self.after_possible_parent_selected or self.after_possible_child_selected:
                            obj_size = 5

                    else:
                        obj_size = 9
                else:
                    self.layers_list.append(layer)

            list_range = len(self.layers_list) + 1

            for lay in self.layers_list[0:list_range]:
                if len(self.layers_list) <= list_range and obj_size >= 0:
                    iface.setActiveLayer(lay)
                    self.on_objectSizeOnLayerChange(obj_size)

        except AttributeError:
            pass

    def showing_object_in_map(self):
        pass
        # self.v.refresh()
        # nvdbsok2qgis(self.v)

        # self.thread_showing_objekt_iKart.join()

    def onIdCatalogEdited(self):
        self.searchObjectBtn.setEnabled(True)

        #        setting dict of agenskaper objects
        self.listOfEgenskaper = {}

        #        clean egenskaper combobox anyway
        self.egenskapBox.clear()

        if self.listOfEgenskaper:
            self.listOfEgenskaper.clear()  # cleaning before use in case of re-use

        is_nvdbfield_valid = self.verifyNvdbField(self.nvdbIdField.text())
        print('is nvdb field valid: ', is_nvdbfield_valid)

        if is_nvdbfield_valid:
            egenskaper = AreaGeoDataParser.egenskaper(self.listOfnvdbObjects[self.nvdbIdField.text()])

            for key, value in egenskaper.items():
                # print(key,  ' value', value, ' type', type(value))

                self.egenskapBox.addItem(key)
                self.listOfEgenskaper[key] = value

            self.egenskapBox.addItem('ikke verdi')  # adding aditional value to combo

            #     setting size slider widget for objects size not enabled, after features are in layer
            self.changeObjectsSize.setEnabled(False)

    def get_new_egenskaper_list(self, type_name: str = str()):
        new_listOfEgenskaper: dict = {}

        egenskaper = AreaGeoDataParser.egenskaper(self.listOfnvdbObjects[type_name])

        for key, value in egenskaper.items():
            new_listOfEgenskaper[key] = value

        return new_listOfEgenskaper

    def onComboMiljoChange(self):
        
        print('changing to: ', self.comboEnvironment.currentText())

        AreaGeoDataParser.set_env(self.environment[self.comboEnvironment.currentText()])
        
        #if data already fetch, then search again
        if self.data_already_fetched:
            
            #searching again
            self.searchObj()
        
        """
        it's really important to restart some default settings
        each time miljø/env is change.
        """
        self.set_default_settings()

        # feeding new env when this change to source_more_window instance
        if self.source_more_window:
            self.source_more_window.set_current_env(self.comboEnvironment.currentText())
        
        #feed current env from main window in skriv window only if this exist
        if self.skrivWindowInstance:
            print('changing env... in skriv windows !')
            
            self.skrivWindowInstance.miljoCombo.setCurrentText( self.comboEnvironment.currentText() )

    def verifyNvdbField(self, vegobjekt_type):
        for key, value in self.listOfnvdbObjects.items():
            if key == vegobjekt_type:
                return True

        return False

    def prepareObjectsForUI(self, objects):
        if not self.exit_event.is_set():
            self.searchObjectBtn.setText("Søk Objekt")
            self.searchObjectBtn.setStyleSheet("background-color : white; color : green")

        if self.times_to_run == 1:
            columns = self.parseHeaders(objects)
            index = self.indexHaders(columns)

            self.tableViewResultModel.setColumnCount(len(columns))
            self.tableViewResultModel.setHorizontalHeaderLabels(columns)

            # it is better if the range starts from 0 in case only 1 road object is fetched
            self.search_object_progress_bar.setRange(0, self.current_num_road_objects)

            # thread_task_funct = self.threaded_loop_for_preparing_UI
            # thread_args = [objects, index]

            # self.thread_loop = threading.Thread(target = thread_task_funct, args = thread_args)

            # self.setting_each_uiItem_inTable.connect(self.set_objects_to_tableView)

            # self.thread_loop.start()
            # self.thread_loop.join()

            items = []
            row = 0

            try:
                # try starts here ...
                # parsing columns for adding to UI
                columns = self.parseHeaders(objects)
                index = self.indexHaders(columns)

                self.tableViewResultModel.setColumnCount(len(columns))
                self.tableViewResultModel.setHorizontalHeaderLabels(columns)

                for object in objects:
                    for obj in enumerate(object):
                        for idx in index:
                            if obj[1] == idx['header']:
                                # print('headers')

                                if obj[1] == 'fylke':  # if header is fylke, then use name instead of fylke number
                                    numFylke = object[obj[1]]
                                    nameFylke = self.reversListOfCounties[numFylke]
                                    object[obj[1]] = nameFylke

                                if obj[1] == 'kommune':  # if header is kommune, then use name instead of kommune number
                                    numKommune = object[obj[1]]
                                    nameKommune = self.reversListOfCommunities[numKommune]
                                    object[obj[1]] = nameKommune

                                self.tableViewResultModel.setRowCount(row + 1)

                                newItem = QStandardItem(str(object[obj[1]]))

                                self.tableViewResultModel.setItem(row, int(idx['index']), newItem)

                                self.tableResult.setModel(self.proxyModel)

                                if obj[1] == 'geometri':
                                    row = row + 1

                                # set real time filter enabled when search is done searching and setting up objects UI.
                                self.filterByLineEdit.setEnabled(True)
                                self.search_object_progress_bar.setValue(row)

            except Exception:  # try ends here ...
                print('exception!')

        # making it zero again
        self.times_to_run = 0

    def set_objects_to_tableView(self, row, object, obj, idx):
        pass
        # self.tableViewResultModel.setRowCount(row + 1)

        # newItem = QStandardItem(str(object[obj[1]]))

        # self.tableViewResultModel.setItem(row, int(idx['index']), newItem)

        # self.tableResult.setModel(self.proxyModel)

        # setting progressbar value for each table item
        # self.search_object_progress_bar.setValue(row)

        # self.filterByLineEdit.setEnabled(True)

    def parseHeaders(self, objects):
        headers = []
        validHeaders = []

        for obj in objects:
            if obj in headers:
                break

            headers.append(obj)

        for data in headers:
            for key in enumerate(data):
                validHeaders.append(key[1])

        return validHeaders

    def indexHaders(self, headers):
        list = []
        counter = 0

        for header in headers:
            index = {
                'index': counter,
                'header': header
            }

            counter = counter + 1

            list.append(index)

        return list

    def onItemClicked(self, index):
        data = self.substractItemData(index)

        self.copyNvdbId.setText(data['nvdbId'])
        self.copyVegRef.setText(data['vref'])

        #        when click any item then select an object in layer
        nvdbid = data['nvdbId']

        layer = iface.activeLayer()

        if self.visKartCheck.isChecked():

            try:

                for feature in layer.getFeatures():

                    for field in layer.fields():

                        if 'nvdbid' in field.name():

                            if str(nvdbid) in str(feature[field.name()]):
                                layer.select(feature.id())
            except Exception:
                pass

    def substractItemData(self, index):
        # for now, the proxy model is the one in charge of filtering,
        # so the index from proxy model is different from the child model
        # a conversion it's need it from proxy index to child index in the view

        source = self.proxyModel.mapToSource(index)  # so we convert from proxy index to the table model index
        row = source.row()

        nvdbId = None
        vref = None

        try:
            # starts here ...
            for column in range(0, self.tableViewResultModel.columnCount()):
                itemColumHeader = self.tableViewResultModel.horizontalHeaderItem(column)
                if itemColumHeader.text() == 'nvdbId':
                    resultNvdbId = self.tableViewResultModel.item(row, column)
                    nvdbId = resultNvdbId.text()

                elif itemColumHeader.text() == 'vref':
                    resultVref = self.tableViewResultModel.item(row, column)
                    vref = resultVref.text()

        except Exception:
            pass

        return {'nvdbId': nvdbId, 'vref': vref}

    def onEgenskapChanged(self):
        index = self.egenskapBox.currentIndex()

        if self.egenskapBox.itemText(index) != 'ikke verdi':
            #            fetch sub egenskaper for better autocompletion in verdi field
            self.subEgenskaper()
            self.operatorCombo.setEnabled(True)

        else:
            idx = self.operatorCombo.findText('ikke verdi')
            self.operatorCombo.setCurrentIndex(idx)  # on each iteration onOperatorChange method is also called
            self.operatorCombo.setEnabled(False)

    def onOperatorChanged(self):
        if self.operatorCombo.currentText() == 'ikke verdi':
            self.verdiField.clear()
            self.verdiField.setEnabled(False)
            self.operatorCombo.setEnabled(False)

        else:
            self.verdiField.setEnabled(True)

    def removeActiveLayers(self):
        names = [layer.name() for layer in QgsProject.instance().mapLayers().values()]

        for name in names:
            if name != 'OpenStreetMap':
                self.removeL(name)

    def subEgenskaper(self):
        typeid: int = int()

        try:
            typeid = self.listOfnvdbObjects[self.nvdbIdField.text()]

        except Exception:
            pass

        especificEgenskap = self.egenskapBox.currentText()

        verdier = AreaGeoDataParser.especificEgenskaper(typeid, especificEgenskap)

        self.verdierDictionary = {}
        verdierList = []

        #        cleaning verdierDictionary in case of already data in it
        if self.verdierDictionary:
            self.verdierDictionary.clear()

        #        loop through list of verdier and set the auto-completion to verdi field in UI
        for key, value in verdier.items():
            verdierList.append(str(key))  # key should be string type

            self.verdierDictionary[str(key)] = value  # key should be string types

        self.setCompleterVerdierObjects(verdierList)

    def setCompleterVerdierObjects(self, data):
        autoCompleter = QCompleter(data)
        autoCompleter.setCaseSensitivity(False)

        self.verdiField.setCompleter(autoCompleter)

    def removeL(self, name):
        qinst = QgsProject.instance()
        qinst.removeMapLayer(qinst.mapLayersByName(name)[0].id())

        iface.mapCanvas().refresh()

    def openSkrivWindow(self):
        #        only make instance of windows if this is None
        if self.skrivWindowInstance == None:

            try:

                self.skrivWindowInstance = SourceSkrivDialog(self.data, self.listOfEgenskaper, self.comboEnvironment.currentText())

                self.skrivWindowInstance.show()

                self.skrivWindowOpened = True

                self.skrivWindowInstance.userLogged.connect(self.onUserLoggedIn)  # when user logged in
                self.skrivWindowInstance.not_logged.connect(self.onUserNotLoggedIn)  # when user not logged in

            except AttributeError as error:
                print(error)
                pass

        #        only shows windows again if skriv window instance  already exists
        if self.skrivWindowOpened and self.skrivWindowInstance:
            new_list = self.get_new_egenskaper_list(self.nvdbIdField.text())
            self.skrivWindowInstance.feed_new_list_egenskaper_and_data(self.data, new_list)

            self.skrivWindowInstance.show()

    def open_more_window(self):
        c_env: str = str()
        
        if self.source_more_window is None:
            
            if 'Produksjon' in self.comboEnvironment.currentText():
                c_env = 'prod'
            
            if 'Akseptansetest' in self.comboEnvironment.currentText():
                c_env = 'test'
                
            if 'Utvikling' in self.comboEnvironment.currentText():
                c_env = 'utv'
                
            print('passing env:', self.comboEnvironment.currentText(), ' = ', c_env)
            
            self.source_more_window = SourceMoreWindow( c_env )

        self.isSourceMoreWindowOpen = True

        self.source_more_window.show()

        # connecting signals from more_window instance

        self.source_more_window.new_relation_event.connect(self.handle_relation)  # to handle relation when clicked from source_more_window module
        self.source_more_window.unlink_btn_clicked.connect(self.remove_relation_fromSourceData)  # when event un disconnect relation from source_more_window
        self.source_more_window.logging_btn_moreWindow_clicked.connect(self.openSkrivWindow)  # when user open skriv window from more_window
        self.source_more_window.maintab_index_change.connect(self.handle_onTabindex_change)  # every time tab index change from more_window instance
        self.source_more_window.pick_up_loggin.connect(self.pick_up_login_fromMoreWindow)  # for picking up login like tokens for more window module
        self.source_more_window.on_new_geo_data.connect(self.relocate_road_object)  # when new geo data is available to relocate road object
        self.source_more_window.on_fetch_button_clicked.connect(self.refresh_last_data)  # Do new search and updated data
        self.source_more_window._including_child.connect(self.check_if_childIncluded)  # when including child
        self.source_more_window.advanced_filtering_btn_moreWindow.connect(self.get_advanced_filtering_data_fromMoreWindow)  # to handle import when clicked from source_more_window module

        # when a user toggles one of the endringsett types from more_window
        self.source_more_window.on_endringsett_correct_active.connect(self.activate_correct_type_changeset)
        self.source_more_window.on_endringsett_update_active.connect(self.activate_update_type_changeset)

        # self.update_more_window_statusbar.connect(lambda value: self.source_more_window.relation_status_bar.setValue(value))
        self.source_more_window.advanced_filtering_search_btn.setEnabled(self.is_data_coming_from_url)
        self.source_more_window.advanced_filtering_enabled_value = self.is_data_coming_from_url
        
        if self.status_login:
            self.source_more_window.set_login_status(status="pålogget")

        elif not self.status_login:
            self.source_more_window.set_login_status(status="må logge på")

    def get_related_parent(self, nvdbid: int = int()) -> dict:
        # to get the current relationship on the current fetched data
        # from the last search

        relation_collection_parent = {}
        relation_id = None

        for refdata in self.data:

            for key, value in refdata.items():

                if key == 'nvdbId':

                    if str(refdata[key]) == str(nvdbid):

                        for field_name, field_values in refdata.items():

                            if field_name == 'relasjoner':

                                relation_type = None
                                final_parsed_relation = None

                                try:
                                    relation_type = field_values['foreldre']  # parent

                                    '''
                                    if road object has more then 1 relation, then
                                    parsed relation only taking the last relation
                                    
                                    if not then take first and the only realtion
                                    existing
                                    '''
                                    if len(relation_type) > 1:

                                        parsed_relation = relation_type[len(relation_type) - 1]

                                        final_parsed_relation = parsed_relation

                                    elif len(relation_type) == 1:

                                        parsed_relation = relation_type[len(relation_type) - 1]

                                        final_parsed_relation = parsed_relation

                                    ''' 
                                    making sure that current selected child road object has a parent
                                    road object related to, this is just to make the flag to True, for later
                                    use and have a better control.
                                    '''
                                    self.hasChildParentRoadObject = True

                                    # child objects have only one parent in all cases, never more than one
                                    # self.parent_roadObject_linked_nvdbid = final_parsed_relation['vegobjekter']

                                    # =====fixing

                                    # setting env to AreaGeoDataParser
                                    env = self.comboEnvironment.currentText()

                                    AreaGeoDataParser.set_env(env)

                                    # if final_parsed_relation has more than 1 element
                                    for p_nvdbid in final_parsed_relation['vegobjekter']:

                                        child_exist_in_parent = AreaGeoDataParser.check_if_child_exist_in_parent(
                                            final_parsed_relation['type']['id'], p_nvdbid, nvdbid)

                                        if child_exist_in_parent:
                                            self.parent_roadObject_linked_nvdbid = p_nvdbid
                                    # end of fixing

                                    # in case final_parsed_relation has only 1 element
                                    if len(final_parsed_relation['vegobjekter']) == 1:
                                        self.parent_roadObject_linked_nvdbid = final_parsed_relation['vegobjekter'][0]

                                        # print( 'relation found 1:', final_parsed_relation['vegobjekter'][0] )

                                    # print('parent_roadObject_linked_nvdbid', self.parent_roadObject_linked_nvdbid)
                                    # print('final_parsed_relation', final_parsed_relation)

                                    self.parent_roadObject_linked_type = final_parsed_relation['type']['id']
                                    self.parent_roadObject_linked_navn = final_parsed_relation['type']['navn']

                                except IndexError:
                                    '''
                                    turning flag to False anyway, in case of index error
                                    exception, but for now is working, be carefull anyway
                                    '''

                                    self.hasChildParentRoadObject = False

                                    # print("no parent_index_error")

                                    return relation_collection_parent

                                    # return {} #must watch this return
                                    # pass

                                # except when road object does not have a parent
                                except KeyError:
                                    ''' 
                                    turning False again before the return, because when exception is thrown, then
                                    we know that child has no any parent related to
                                    '''
                                    self.hasChildParentRoadObject = False

                                    # print("No parent_key_error")

                                    return {}

                                for item in relation_type:

                                    for item_name, item_value in item.items():

                                        if item_name == 'type':
                                            type = item_value

                                            type_id = type['id']
                                            type_name = type['navn']

                                            relation_collection_parent[type_name] = type_id
        return relation_collection_parent

    def re_paint(self):
        for layer in iface.mapCanvas().layers():
            layer.triggerRepaint()

    def onAnyFeatureSelected(self):

        '''
        Relasjoner:
        
            handling base relation according to if parent is not selected but child is active
            and current tab in more_window is relasjoner/sammenkobling'''
        if not self.after_possible_parent_selected and self.current_selected_index_tab == 1:

            self.handle_relation_after_child_selected()

        # For handling when choosing an object while in stedfest window
        elif not self.after_possible_parent_selected and self.current_selected_index_tab == 0:
            self.list_segment_nvdbid = []
            self.handle_stedfest_after_child_selected()

        '''handling base relation according to if parent is selected and child is active
        and current tab in more_window is relasjoner/sammenkobling'''
        if self.after_possible_parent_selected and self.current_selected_index_tab == 1:
            self.handle_relation_after_parent_selected()

        '''
        stedfesting:
            
            here only some helpers for feeding new data to soruce_more_window, etc
        '''
        if self.current_selected_index_tab == 0:
            
            stedfest_type: str = str()
            
            self.stedfest_changes_sent = False  # making sure flag is restarted

            self.collect_data_forStedfest()
            
            #try:
                
                # stedfest_type = AreaGeoDataParser.get_geometry_type_by_nvdbid(self.child_object_nvdbid, self.child_object_objectid)
            
            stedfest_type = AreaGeoDataParser.get_geometry_type_by_nvdbid(self.child_object_nvdbid, self.child_object_objectid)
            
            #except AttributeError as ex:
                
                # print( ex )
                
            _dictio = {
                'nvdb_object_type': self.child_object_objectid,  # self.listOfnvdbObjects[self.nvdbIdField.text()],
                'stedfest_type': stedfest_type
            }
                
            print(_dictio)
                
            if self.source_more_window:
                self.source_more_window.feed_data('location', _dictio, '')

    def handle_relation_after_child_selected(self):
        # start of relation code

        """
        at start, we turn off some flags for adding and removing road object relationship
        because it turns True before it's turns to False in their on_single_add_completed and on_remove_relation_completed
        """
        self.add_relation_changes_sent = False
        self.remove_relation_changes_sent = False
        self.replace_relation_changes_sent = False

        layer = iface.activeLayer()  # to get the current active layer

        # parent_object_nvdbid: int = int()

        active_relation_parent: dict = {}

        '''
        going through features in current active layer
        and this only happens if possible parent is not selected yet
        from source_more_window instance
        '''

        for feature in layer.selectedFeatures():

            for field in feature.fields():

                # if field.name() == 'nvdbid':
                if 'nvdbid' in field.name():

                    for road_object in self.data:

                        if road_object['nvdbId'] == feature[field.name()]:

                            self.data_fromSelectedObject_from_layer = road_object  # storaging road object just in case

                            self.child_object_nvdbid = road_object['nvdbId']  # can only be declared once

                            self.child_object_objectid = road_object["objekttype"]

                            self.after_possible_child_selected = True

                            if self.source_more_window:
                                self.source_more_window.set_realtion_child_id(self.child_object_nvdbid,
                                                                              self.child_object_objectid)

                            # layer things
                            self.selected_layer_from_map.append(layer.name())

                            self.selected_object_from_map.append(layer.selectedFeatureIds())
                            # end of layer things

                            self.possible_child_name = self.nvdbIdField.text()

                            try:

                                if self.source_more_window:

                                    self.relations = self.get_related_parent(self.child_object_nvdbid)

                                    self.check_if_object_need_parent(self.child_object_objectid)

                                    active_relation_parent = self.relations

                                    # print('active relation parent', active_relation_parent)

                                    # sync with source_more_window instance, to feed more data, in this case related to (relation = sammenkobling)
                                    self.source_more_window.feed_data('relation',
                                                                      self.data_fromSelectedObject_from_layer,
                                                                      active_relation_parent)

                                    '''
                                    creating an status info dict, for populating more window UI elements
                                    when user select a road object from Kart/map in QGIS
                                    '''
                                    parent_status = {"parent_id": self.parent_roadObject_linked_type,
                                                     "parent_name": self.parent_roadObject_linked_navn,
                                                     "parent_nvdbid": self.parent_roadObject_linked_nvdbid
                                                     # self.parent_roadObject_linked_nvdbid[0]
                                                     }

                                    # if no relation was found, then clear status, before sending
                                    if not active_relation_parent:
                                        parent_status.clear()

                                        '''
                                        populating UI elem... status according to if has or not relation
                                        this will be sent anyway has or not relation, but it will populate or clear UI elem...
                                        '''
                                    self.source_more_window.set_parent_status(parent_status)


                            except AttributeError:

                                # print('AttributeError')
                                pass

        '''
        enabling open skriv window button, to make the effect: ONLY
        when an feature from QGIS cart/map is selected
        '''
        self.openSkrivWindowBtn.setEnabled(True)


        

    def handle_stedfest_after_child_selected(self):
        # start of relation code

        # at the start, we turn off some flags for adding and removing road object relationship
        self.add_relation_changes_sent = False
        self.remove_relation_changes_sent = False
        # self.replace_relation_changes_sent = False

        layer = iface.activeLayer()  # to get the current active layer

        '''
        going through features in current active layer
        and this only happens if possible parent is not selected yet
        from source_more_window instance
        '''

        for feature in layer.selectedFeatures():

            for field in feature.fields():

                # if field.name() == 'nvdbid':
                if 'nvdbid' in field.name():

                    for road_object in self.data:

                        if road_object['nvdbId'] == feature[field.name()]:

                            # print(road_object['nvdbId'])
                            # print(road_object['vref'])
                            try:
                                if road_object['vref'] not in self.list_segment_nvdbid:
                                    self.list_segment_nvdbid.append(road_object['vref'])
                            except KeyError as e:
                                # Missing vegsystemreferanse
                                pass

                            self.data_fromSelectedObject_from_layer = road_object  # storaging road object just in case

                            self.child_object_nvdbid = road_object['nvdbId']  # can only be declared once

                            self.child_object_objectid = road_object["objekttype"]

                            self.after_possible_child_selected = True

                            self.selected_layer_from_map.append(layer.name())

                            self.selected_object_from_map.append(layer.selectedFeatureIds())

                            self.possible_child_name = self.nvdbIdField.text()

                            if self.source_more_window:
                                self.source_more_window.set_realtion_child_id(self.child_object_nvdbid, self.child_object_objectid)
                                vref = self.parse_segmented_object(self.list_segment_nvdbid)
                                self.source_more_window.set_current_vref(vref)

        self.openSkrivWindowBtn.setEnabled(True)

    def sort_segment_list(self, unsorted_segments_list):

        temp_list = []
        for item in unsorted_segments_list:
            if item.count('m') > 1:  # If more than one 'm' exists
                # Replace the first occurrence of 'm' with a placeholder
                new_seg = item.replace('m', '%', 1)
                temp_list.append(new_seg)
            else:
                temp_list.append(item)

        # Sorting the vegreferanser based on their value after 'm'
        sorted_list = sorted(temp_list, key=lambda s: int(s.split('m')[1].split('-')[0]))

        return sorted_list

    def parse_segmented_object(self, list_segments_nvdbid):

        sorted_list = self.sort_segment_list(list_segments_nvdbid)

        final_list = []

        if len(sorted_list) > 0:
            segment_groups = []
            current_group = [sorted_list[0]]

            for i in range(1, len(sorted_list)):

                end = int(sorted_list[i - 1].split('m')[1].split('-')[-1])
                start = int(sorted_list[i].split('m')[1].split('-')[0])

                if end == start:  # continuous

                    current_group.append(sorted_list[i])

                else:
                    segment_groups.append(current_group)
                    current_group = [sorted_list[i]]

            segment_groups.append(current_group)

            for group in segment_groups:
                if len(group) > 1:
                    # Parsing segment groups
                    pos_m = group[0].index('m') + 1
                    start_number = group[0][pos_m:group[0].index('-', pos_m)]
                    end_number = group[-1][group[-1].index('-') + 1:]
                    parsed_vref = group[0][:pos_m] + start_number + "-" + end_number
                    final_list.append(parsed_vref)
                else:
                    # Handle groups with only one segment
                    final_list.append(group[0])

            final_list = [item.replace('%', 'm') for item in final_list]


        else:
            final_list.append("MANGLER VEGSYSTEMREFERANSE")

        return final_list

    def handle_relation_after_parent_selected(self):
        """
        do something else with possible parents type and name
        # gotten from source_more_window when possible parent road object is already selected

        from here and on, we have to think how to get the effects
        for next road object we will connect
        """

        layer = iface.activeLayer()  # to get the current active layer

        type_road_object_to_connect_child_to_parent: int = int()

        parent_object_nvdbid: int = int()

        for feature in layer.selectedFeatures():
            for field in feature.fields():

                if field.name() == 'nvdbid':

                    for road_object in self.data:

                        if road_object['nvdbId'] == feature[field.name()]:

                            if road_object['objekttype'] == self.possible_parent_type:
                                parent_object_nvdbid = road_object['nvdbId']
                                # roadObjectTypeChild_toConnect = road_object['objekttype']
                                type_road_object_to_connect_child_to_parent = road_object['objekttype']

                                # print('type passed before')

                                # print('self.possible_parent_type:', self.possible_parent_type)
                                # print('roadObjectTypeChild_toConnect:', roadObjectTypeChild_toConnect)

                                self.possible_selected_parent_nvdbid = parent_object_nvdbid

        '''if possible parent type is equal to object child type
        user want to connect to, then is it a valid parent child relationship connection'''
        if self.possible_parent_type == type_road_object_to_connect_child_to_parent:
            # for now, road object types are both same type,
            # self.valid_roadObject_types = True

            # print('passed')

            '''
                Case when child road objects has or not parent road object
                some road objects still shows old parents relation, eventhoug this
                do not has a related parent, since in self.get_related_parent() method
                we check if road object has a related parent, but this is just data comming
                from Plug-In fetched data in the child side.
                                    
                nvdbLesWrapper module has a class member for making sure that this child
                exist in his parent relationship instead of it's related relation info, fetched
                in Plug-In. And we called this method from source_more_window in self.turn_remove_relation_btn method
            '''
            if not self.hasChildParentRoadObject:
                # print('has not relation or might be the old parent still exist then, adding new ...')
                # it does not has a realtion
                self.add_single_relation_fromSourceData()

            if self.hasChildParentRoadObject:
                # print( 'passed 2' )

                # if it was sent once, now it means that user wants to send again
                # if self.replace_relation_changes_sent:

                self.replace_relation_changes_sent = False

                self.replace_single_relation_fromSourceData()

                # self.replace_relation_changes_sent = False
                # pass

        # enabling open skriv window button, to make the effect: ONLY
        # when any feature from QGIS cart/map is selected
        self.openSkrivWindowBtn.setEnabled(True)

    def check_if_object_need_parent(self, object_type):

        dependant_mor: bool = False

        endpoint = f'https://nvdbapiles-v3.atlas.vegvesen.no/vegobjekttyper/{object_type}?inkluder=stedfesting'

        response = requests.get(endpoint)

        if response.ok:

            result_txt = json.loads(response.text)

            dependant_mor = result_txt["må_ha_mor"]

            try:

                extra = {
                    "parent_nvdb_type": self.parent_roadObject_linked_type,
                    "parent_nvdbid": self.parent_roadObject_linked_nvdbid,  # self.parent_roadObject_linked_nvdbid[0],
                    'child_to_compare': self.child_object_nvdbid
                }

            except KeyError:

                print('keyerror exception raised in nvdb_beta_dialog.py check_if_object...method')

            check_if_child_exist = self.source_more_window.turn_remove_relation_btn(dependant_mor, self.hasChildParentRoadObject, self.status_login, extra)

            if check_if_child_exist:
                self.hasChildParentRoadObject = True

            if not check_if_child_exist:
                self.hasChildParentRoadObject = False

    def handle_relation(self, type: int = int(), name: str = str()):
        self.after_possible_parent_selected = True

        self.possible_parent_type = type
        self.possible_parent_name = name

    def handle_onTabindex_change(self, index):
        self.current_selected_index_tab = index

        print('changing in main window', index)

    def on_remove_relation_completed(self, changeset):

        endpoint = changeset['status_after_sent']

        token = changeset["token"]

        self.get_current_status(endpoint, token)

        data = {
            'target': changeset,
            'type': 'sammekobling' # Grammar Error
        }

        self.feed_status_window(data)

        self.remove_relation_changes_sent = False

        self.refresh_last_data()

    def on_single_add_completed(self, changeset):

        endpoint = changeset['status_after_sent']

        token = changeset["token"]

        self.get_current_status(endpoint, token)

        data = {
            'target': changeset,
            'type': 'sammekobling' # Grammar Error
        }

        self.feed_status_window(data)

        self.after_possible_parent_selected = False  # turning off
        self.add_relation_changes_sent = False

        self.refresh_last_data()

    def on_single_replace_completed(self, changeset):

        endpoint = changeset['status_after_sent']

        token = changeset["token"]

        self.get_current_status(endpoint, token)

        data = {
            'target': changeset,
            'type': 'sammekobling' # Grammar Error
        }

        self.feed_status_window(data)

        self.after_possible_parent_selected = False  # turning off

        self.replace_relation_changes_sent = False

        self.refresh_last_data()

    def on_any_not_sent(self, nvdbid: int(), isSent: bool = False, reason: str = str()):

        start_msg_tag = reason.find('<message>')
        end_msg_tag = reason.rfind('</message>')

        # turning off flags here as well
        self.add_relation_changes_sent = False
        self.remove_relation_changes_sent = False
        self.replace_relation_changes_sent = False

        main_reason = reason[start_msg_tag + len(str('<message>')): end_msg_tag]

        if self.source_more_window:
            self.source_more_window.avvist_lbl.setStyleSheet('color: pink; font: 14pt MS Shell Dlg 2;')

            # self.source_more_window.avvist_lbl.resize(len(main_reason), 29)

            self.source_more_window.avvist_lbl.setText(main_reason)

        # self.feed_status_window(data)

        # self.refresh_last_data()

    def on_stedfest_done(self, changeset):

        data = {
            'target': changeset,
            'type': 'stedfesting'
        }

        self.stedfest_changes_sent = False  # making sure flag is restarted

        self.feed_status_window(data)

        '''
        since not changes are made in stedfest UI after endringsett is sent
        then refresh_last_data method has to be called from a button for now, :)
        '''
        # self.refresh_last_data()

    def refresh_last_data(self):
        """
        Getting updated data with current selected parameters
        """
        
        #only if there was a selected layer
        if len( self.selected_layer_from_map ) > 0:
            
            self.prepare_refresh_search()
            self.searchObj()
            self.thread_search_object.join()
            self.reapply_old_selected_layers()

    def feed_status_window(self, data: dict = {}):

        if self.source_more_window:
            self.source_more_window.feed_data('status', data)

    def add_single_relation_fromSourceData(self):
        """
        adding relationship between parent road object and child object
        will be through a call to a new module, this module will be in a separate file.
        """
        # only happens if child road object selected from QGIS kart has a parent
        # self.after_possible_parent_selected

        # if not self.hasChildParentRoadObject and self.isUserLogged():
        # print('before start adding new')
        # print('add_relation_changes_sent:', self.add_relation_changes_sent)

        if self.isUserLogged() and not self.add_relation_changes_sent:
            print('start adding new')

            # setting AreaGeoDataParser env, before using it
            env = self.comboEnvironment.currentText()

            AreaGeoDataParser.set_env(env)

            username = self.username_session
            parent_nvdbid = self.possible_selected_parent_nvdbid  # self.parent_roadObject_linked_nvdbid[0]
            object_type_id = self.possible_parent_type  # self.parent_roadObject_linked_type
            version = AreaGeoDataParser.get_last_version(parent_nvdbid, object_type_id)

            last_time_road_object_modified = AreaGeoDataParser.get_last_time_modified(object_type_id, parent_nvdbid,
                                                                                      version)
            datacatalog_version = AreaGeoDataParser.get_datacatalog_version(env)
            endpoint = self.get_env_write_endpoint()
            relation = AreaGeoDataParser.get_children_relation_from_parent(object_type_id, parent_nvdbid)
            id_token = self.current_session_token['idToken']
            datacatalog_enumid = AreaGeoDataParser.get_datacatalog_relation_type(object_type_id,
                                                                                 self.possible_child_name)

            child_roadobject_exist: bool = False  # variable flag not in used for now

            '''
            now we have relation data, then now the child road object that was selected from kart in QGIS
            must be tag as a remove child and that's the only one road object sent to be remove from parent.

            If road object do not have relation, then, just add the child road object.
            '''

            # print('relation adding new:', relation)
            # print('parent id:', parent_nvdbid)
            # print('child id:', self.child_object_nvdbid)

            # already modified data
            modified_data = {
                'nvdbid': parent_nvdbid,
                'versjon': version  # last version to road object
            }

            # extra data need it for xml escheme completion
            extra_data = {
                'current_nvdbid': parent_nvdbid,
                'nvdb_object_type': object_type_id,
                'datakatalog_version': datacatalog_version,  # datacatalog current version
                'sistmodifisert': last_time_road_object_modified,
                'username': username,
                'endpoint': endpoint,
                'objekt_navn': 'object_name',  # test name
                'relation': relation,
                'isChildFoundInParent': child_roadobject_exist,
                'datacatalog_enumId': datacatalog_enumid,
                'add_child_nvdbid': self.child_object_nvdbid  # tagging road object to be removed
            }

            # only if child exist in parent relationship
            if not self.add_relation_changes_sent:
                # writing to NVDB changes made in road object relationship
                self.single_delvis_add_relation_instance = CustomDelvisKorrSingleAdd(id_token, modified_data,
                                                                                     extra_data)

                self.single_delvis_add_relation_instance.onEndringsett_fail.connect(self.on_any_not_sent)

                self.single_delvis_add_relation_instance.new_endringsset_sent.connect(self.on_single_add_completed)

                self.single_delvis_add_relation_instance.endringsett_form_done.connect(
                    self.single_delvis_add_relation_instance.prepare_post)

                self.single_delvis_add_relation_instance.formXMLRequest(active_egenskap=False)

                self.add_relation_changes_sent = True

    def replace_single_relation_fromSourceData(self):
        """
        replacing relationship between parent road object and child object
        will be through a call to a new module, this module will be in a separate file.
        """
        print('replace_relation_changes_sent:', self.replace_relation_changes_sent)

        # only happens if child road object selected from QGIS kart has a parent
        # if self.hasChildParentRoadObject and self.isUserLogged():
        if not self.replace_relation_changes_sent and self.isUserLogged():

            print('start replacing')

            # setting AreaGeoDataParser env, before using it
            env = self.comboEnvironment.currentText()

            AreaGeoDataParser.set_env(env)

            username = self.username_session
            parent_nvdbid = self.possible_selected_parent_nvdbid  # self.parent_roadObject_linked_nvdbid[0]
            object_type_id = self.possible_parent_type  # self.parent_roadObject_linked_type
            version = AreaGeoDataParser.get_last_version(parent_nvdbid, object_type_id)
            parent_add_last_modified = AreaGeoDataParser.get_last_time_modified(object_type_id, parent_nvdbid, version)
            datacatalog_version = AreaGeoDataParser.get_datacatalog_version(env)
            endpoint = self.get_env_write_endpoint()
            # relation =                                      AreaGeoDataParser.get_children_relation_from_parent(object_type_id, parent_nvdbid)
            relation_old_parent = AreaGeoDataParser.get_possible_children_types(self.parent_roadObject_linked_type)
            relation_new_parent = AreaGeoDataParser.get_possible_children_types(object_type_id)
            id_token = self.current_session_token['idToken']

            '''
            now we have relation data, then now the child road object that was selected from kart in QGIS
            must be mark as a remove child and that's the only one road object nvdbid sent to be remove from parent
            '''

            target_parent_remove = self.parent_roadObject_linked_nvdbid  # self.parent_roadObject_linked_nvdbid[ len(self.parent_roadObject_linked_nvdbid) -1 ]

            version_parent_remove = AreaGeoDataParser.get_last_version(target_parent_remove,
                                                                       self.parent_roadObject_linked_type)

            parent_remove_last_modified = AreaGeoDataParser.get_last_time_modified(self.parent_roadObject_linked_type,
                                                                                   target_parent_remove,
                                                                                   version_parent_remove)

            # print('relation in replace relation', relation)
            # print('parent id:', parent_nvdbid)
            # print('child id:', self.child_object_nvdbid)

            # modified data
            '''modified_data = {
                    'nvdbid': parent_nvdbid,
                    'versjon': version  # last version to road object
            }'''

            # extra data need it for xml escheme completion
            extra_data = {
                'env': env,
                'start_date': QDate.currentDate().toString('yyyy-MM-dd'),
                'endringsett_mode': self.activate_type_changeset,  # 'update', #'correction',
                'add_to_parent': parent_nvdbid,  # parent_nvdbid,
                'current_nvdbid': target_parent_remove,
                'version_old_parent_type': self.parent_roadObject_linked_type,
                'version_new_parent_type': object_type_id,
                # 'nvdb_object_type_add_parent': self.parent_type_selected_to_relate,
                'datakatalog_version': datacatalog_version,  # datacatalog current version
                'sistmodifisert_add': parent_add_last_modified,
                'sistmodifisert_remove': parent_remove_last_modified,
                'username': username,
                'endpoint': endpoint,
                'objekt_navn': 'object_name',  # test name
                'relation_old_parent': relation_old_parent,
                'relation_new_parent': relation_new_parent,
                'child_nvdbid': self.child_object_nvdbid,
                'remove_from_parent': target_parent_remove,  # self.parent_roadObject_linked_nvdbid[1]
                'road_object_name': self.possible_child_name
            }

            # print( extra_data )

            # self.replace_relation_changes_sent = True

            # only if vegobjekt is not there
            # if not self.replace_relation_changes_sent and relation:
            if not self.replace_relation_changes_sent:
                print('sending replacement')

                # writing to NVDB changes made in road object relationship
                self.single_delvis_replace_relation_instance = CustomDelvisKorrReplaceParent(id_token, {},
                                                                                             extra_data)  # modified_data

                self.single_delvis_replace_relation_instance.onEndringsett_fail.connect(self.on_any_not_sent)

                self.single_delvis_replace_relation_instance.new_endringsset_sent.connect(
                    self.on_single_replace_completed)

                self.single_delvis_replace_relation_instance.endringsett_form_done.connect(
                    self.single_delvis_replace_relation_instance.prepare_post)

                self.single_delvis_replace_relation_instance.formXMLRequest(active_egenskap=False)

                self.replace_relation_changes_sent = True

    def remove_relation_fromSourceData(self) -> None:
        """
        removing relationship between parent road object and child object
        will be through a call to a new module, this module will be in a separate file
        and will contain a class with a static member method, signals a slots
        """

        # turning off remove flag here, because it gets to on_remove... before it's turned to True in here down...
        # self.remove_relation_changes_sent = False

        # print('remove_relation_changes_sent: ', self.remove_relation_changes_sent)
        # print('current_selected_index_tab:', self.current_selected_index_tab)

        # only happens if child road object selected from QGIS kart has a parent
        # if self.hasChildParentRoadObject and self.isUserLogged():
        if self.isUserLogged() and not self.remove_relation_changes_sent:

            # print('preparing to remove')

            # setting AreaGeoDataParser env, before using it
            env = self.comboEnvironment.currentText()

            AreaGeoDataParser.set_env(env)

            username = self.username_session
            parent_nvdbid = self.parent_roadObject_linked_nvdbid  # self.parent_roadObject_linked_nvdbid[0]
            version = AreaGeoDataParser.get_last_version(parent_nvdbid, self.parent_roadObject_linked_type)
            object_type_id = self.parent_roadObject_linked_type

            last_time_road_object_modified = AreaGeoDataParser.get_last_time_modified(object_type_id, parent_nvdbid,
                                                                                      version)
            datacatalog_version = AreaGeoDataParser.get_datacatalog_version(env)
            endpoint = self.get_env_write_endpoint()
            relation = AreaGeoDataParser.get_children_relation_from_parent(object_type_id, parent_nvdbid)
            id_token = self.current_session_token['idToken']

            '''
            now we have relation data, then now the child road object that was selected from kart in QGIS
            must be mark as a remove child and that's the only one road object nvdbid sent to be remove from parent
            '''
            child_in_parent_nvdbid_found: int = int()  # to store child to remove
            is_child_found = False  # flag not in used for now

            # print('relations in removing', relation)
            # print('parent id:', parent_nvdbid)
            # print('child id:', self.child_object_nvdbid)

            if relation:

                # print('has relation')

                for datacatalog_id, items in relation.items():

                    for nvdbid_ in items['vegobjekter']:

                        if nvdbid_ == self.child_object_nvdbid:
                            # print('road object to remove found')

                            child_in_parent_nvdbid_found = nvdbid_
                            is_child_found = True

                # already modified data
                modified_data = {
                    'nvdbid': parent_nvdbid,
                    'versjon': version  # last version to road object
                }

                # extra data need it for xml escheme completion
                extra_data = {
                    'current_nvdbid': parent_nvdbid,
                    'nvdb_object_type': object_type_id,
                    'datakatalog_version': datacatalog_version,  # datacatalog current version
                    'sistmodifisert': last_time_road_object_modified,
                    'username': username,
                    'endpoint': endpoint,
                    'objekt_navn': 'object_name',  # test name
                    'relation': relation,
                    'remove_child_nvdbid': self.child_object_nvdbid if child_in_parent_nvdbid_found == 0 else child_in_parent_nvdbid_found
                }

                # print(is_child_found)

            # if child is found, then remove it
            if not self.remove_relation_changes_sent:
                # if is_child_found and not self.remove_relation_changes_sent:

                # print('trying sending remove')

                # writing to NVDB changes made in road object relationship
                self.delvis_remove_relation_instance = CustomDelvisKorrRemoveCase(id_token, modified_data, extra_data)

                self.delvis_remove_relation_instance.onEndringsett_fail.connect(self.on_any_not_sent)

                self.delvis_remove_relation_instance.new_endringsset_sent.connect(self.on_remove_relation_completed)

                self.delvis_remove_relation_instance.endringsett_form_done.connect(
                    self.delvis_remove_relation_instance.prepare_post)

                self.delvis_remove_relation_instance.formXMLRequest(active_egenskap=False)

                self.remove_relation_changes_sent = True  # turning on flag for add new relation

            # if not is_child_found:
            #     print('adding insted of removing ...')
            #     self.add_single_relation_fromSourceData()

            #     self.remove_relation_changes_sent = False #turning off flag for add new relation

    def relocate_road_object(self, geo_data: dict = {}):
        """
        Stedfestning:

            handling stedfestning according if current active tab in
            more_window is stedfestning tab and not relation tab
        """

        self.stedfest_changes_sent = False

        if self.current_selected_index_tab == 0 and self.isUserLogged():
            # collect necessary data for endringssett

            # getting stedfest type
            stedfest_type = AreaGeoDataParser.get_geometry_type_by_nvdbid(self.child_object_nvdbid,
                                                                          self.child_object_objectid)

            # setting AreaGeoDataParser env, before using it
            env = self.comboEnvironment.currentText()

            username = self.username_session
            child_nvdbid = self.child_object_nvdbid
            object_type_id = self.child_object_objectid
            version = AreaGeoDataParser.get_last_version(child_nvdbid, object_type_id)
            datacatalog_version = AreaGeoDataParser.get_datacatalog_version(env)
            last_time_road_object_modified = AreaGeoDataParser.get_last_time_modified(object_type_id, child_nvdbid,
                                                                                      version)
            endpoint = self.get_env_write_endpoint()
            datacatalog_enumid = AreaGeoDataParser.get_datacatalog_relation_type(child_nvdbid, self.possible_child_name)
            id_token = self.current_session_token['idToken']
            relation = AreaGeoDataParser.get_childRelationMetaData(object_type_id, child_nvdbid)
            object_sideposition = AreaGeoDataParser.get_parent_sideposisjon_og(object_type_id, child_nvdbid)

            # modified data
            modified_data = {
                'nvdbid': child_nvdbid,
                'versjon': version  # last version to road object
            }

            # extra data need it for xml escheme completion
            extra_data = {
                'current_nvdbid': child_nvdbid,
                'nvdb_object_type': object_type_id,
                'datakatalog_version': datacatalog_version,  # datacatalog current version
                'sistmodifisert': last_time_road_object_modified,
                'username': username,
                'endpoint': endpoint,
                'objekt_navn': 'object_name',  # test name
                'datacatalog_enumId': datacatalog_enumid,
                'stedfest': geo_data,
                'stedfest_type': stedfest_type,  # for now
                'object_sideposisjon': object_sideposition,
                'is_child_included': self.isChildIncludedInChangeset,
                'has_relation': True if len(relation) > 0 else False,
                'relation': relation
            }

            # print('================extra_data================', extra_data)
            # print('flag value:', self.stedfest_changes_sent)

            # making delvis korrigering stedfestning instance

            if not self.stedfest_changes_sent:
                # print('passed')

                self.delvisStedfest_instance = DelvisStedfestCase(id_token, modified_data, extra_data)

                # connecting signals of delvis instance

                # self.delvisStedfest_instance.onEndringsett_fail.connect(self.on_any_not_sent)

                self.delvisStedfest_instance.new_endringsset_sent.connect(self.on_stedfest_done)

                self.delvisStedfest_instance.endringsett_form_done.connect(self.delvisStedfest_instance.prepare_post)

                # preparing for sending data to NVDB

                self.delvisStedfest_instance.formXMLRequest(self.listOfEgenskaper)

                self.stedfest_changes_sent = True

    def collect_data_forStedfest(self):
        layer = iface.activeLayer()  # to get the current active layer

        try:

            for feature in layer.selectedFeatures():

                for field in feature.fields():

                    if field.name() == 'nvdbid':

                        for road_object in self.data:

                            if road_object['nvdbId'] == feature[field.name()]:
                                self.child_object_nvdbid = road_object['nvdbId']  # can only be declared once
                                self.child_object_objectid = road_object["objekttype"]
                                self.possible_child_name = self.nvdbIdField.text()

        except AttributeError:
            pass

    def reapply_old_selected_layers(self):

        self.onVisIKart(True)

        self.visKartCheck.setChecked(True)

        self.openSkrivWindowBtn.setEnabled(True)

        names = [layer.name() for layer in QgsProject.instance().mapLayers().values()]

        for name in names:

            if name == self.selected_layer_from_map[-1]:
                layer = QgsProject.instance().mapLayersByName(self.selected_layer_from_map[-1])[0]

                iface.setActiveLayer(layer)

                break

        layer.select(self.selected_object_from_map[-1])

        self.onAnyFeatureSelected()

        # parent_status = self.get_related_parent(self.child_object_nvdbid)
        """
        if self.source_more_window:
            
            try:
                parent_status = {"parent_id": self.parent_roadObject_linked_type,
                                 "parent_name": self.parent_roadObject_linked_navn,
                                 "parent_nvdbid": self.parent_roadObject_linked_nvdbid[0]
                                 }

                self.source_more_window.set_parent_status(parent_status)
                
                self.check_if_object_need_parent(self.child_object_objectid)
                
            except AttributeError:
                
                print('Attribute Error')
        """
        self.after_possible_parent_selected = False

    def prepare_refresh_search(self):

        # layer = iface.activeLayer()
        
        # selected_features: list = []
        
        # selected_features = layer.selectedFeatures()
        
        # print('selected features size:', len( selected_features) )
        print('current layer size:', len( self.selected_layer_from_map ))
        
        #only if any feaure is selected in QGIS kart/layer
        if len( self.selected_layer_from_map ) > 0:
            
            self.searchObjectBtn.setText("Søk Objekt")
            self.removeActiveLayers()
            self.layers_list = []

            current_layer = self.selected_layer_from_map[-1]
            position = current_layer.find("_")

            if position != -1:
                split_layer = current_layer[:position]
                # print("split_layer", split_layer)
                self.nvdbIdField.setText(split_layer)

            else:
                # print("last_layer", self.selected_layer_from_map[-1])
                self.nvdbIdField.setText(self.selected_layer_from_map[-1])

    def get_current_status(self, endpoint, token):
        # get the xml response
        response = requests.get(endpoint, headers={'Authorization': f'Bearer {token}'})
        print("Endpoint: ", endpoint)
        if response.ok:

            # parsing the response
            root = ET.fromstring(response.text)

            for child in root:
                if "fremdrift" in child.tag:
                    status = child.text
                    # display the status_message in mer vindu
                    break

            if status == "AVVIST":
                # Finding the error message
                melding = root.find('.//{http://nvdb.vegvesen.no/apiskriv/domain/changeset/v3}melding').text

                position = melding.find(",")
                if position != -1:
                    split_melding = melding[:position]

                    # print("Melding:", split_melding)

                    self.source_more_window.set_msg_avvist(split_melding)

                else:
                    self.source_more_window.set_msg_avvist(melding)

        elif not response.ok:
            print("response not ok!", response.status_code)
            pass

    def isUserLogged(self):
        # first checking if user is logged in
        isLogged: bool = False

        try:

            if self.current_session_token['idToken']:
                isLogged = True

        except KeyError:
            return isLogged

        return isLogged

    def get_env_write_endpoint(self):
        currentMiljo = self.comboEnvironment.currentText()
        url = None

        if 'Produksjon' in currentMiljo:
            url = 'https://nvdbapiskriv.atlas.vegvesen.no/rest/v3/endringssett'

        if 'Akseptansetest' in currentMiljo:
            url = 'https://nvdbapiskriv.test.atlas.vegvesen.no/rest/v3/endringssett'

        if 'Utvikling' in currentMiljo:
            url = 'https://nvdbapiskriv.utv.atlas.vegvesen.no/rest/v3/endringssett'

        return url

    def onUserLoggedIn(self, username, token):

        self.username_session = username
        self.current_session_token = token

        # make it decouple, into another function

        if self.source_more_window:
            self.source_more_window.set_login_status(status="pålogget")

            self.status_login = True

    def onUserNotLoggedIn(self):

        self.status_login = False

        if self.source_more_window:
            self.source_more_window.set_login_status(status="må logge på")
            # tester push & pull rights

    def on_objectSizeOnLayerChange(self, value):
        layer = iface.activeLayer()
        renderer = layer.renderer()

        symbol = None  # for symbol
        symbolColor = None  # for symbol color
        properties = None
        
        try:
            
            #       getting properties from the features already in layer
            properties = renderer.symbol().symbolLayers()[0].properties()
        
        except AttributeError as ex:
            
            print( ex )
            
            return
            
        #        looping to find color key and substracting color, for later use
        #        and avoid change of color when resizing the features in the current layer
        for key, val in properties.items():
            if key == 'color':
                symbolColor = val

        if renderer.symbol().type() == QgsSymbol.Fill:
            symbol = QgsFillSymbol.createSimple({'outline_width': value, 'color': symbolColor})
            renderer.setSymbol(symbol)

        if renderer.symbol().type() == QgsSymbol.Marker:
            symbol = QgsMarkerSymbol.createSimple({'size': value, 'color': symbolColor})
            renderer.setSymbol(symbol)

        if renderer.symbol().type() == QgsSymbol.Line:
            symbol = QgsLineSymbol.createSimple({'line_width': value, 'color': symbolColor})
            renderer.setSymbol(symbol)

        # show the change
        layer.triggerRepaint()

    def get_especific_field_by_name(self, field_name: str = str()):
        layer = iface.activeLayer()

        found_field_name: str = str()  # in case not value found then return at least field name

        especific_field = {}

        for feature in layer.selectedFeatures():
            for field in feature.fields():
                if field_name in field.name():
                    return feature[field.name()]

    def pick_up_login_fromMoreWindow(self) -> None:

        bool_option: bool = False

        token = self.current_session_token.get('idToken', 'empty')

        if token != 'empty':
            bool_option = True
            self.source_more_window.set_login_fromNVDBBetaDialog(bool_option, token)

        else:
            self.source_more_window.set_login_fromNVDBBetaDialog()

    def sending_new_geometry_onChanged(self, id, geo):
        
        print('sending new geometry')
        
        stedfest_type = AreaGeoDataParser.get_geometry_type_by_nvdbid(self.child_object_nvdbid, self.child_object_objectid)
        
        print('sending new geometry', stedfest_type)

        stedfest_type = AreaGeoDataParser.get_geometry_type_by_nvdbid(self.child_object_nvdbid, self.child_object_objectid)
        
        data = {
            'is_new_geometry': True,
            'new_geometry': geo,
            'nvdb_object_type': self.child_object_objectid,  # self.listOfnvdbObjects[self.nvdbIdField.text()],
            'stedfest_type': stedfest_type
        }

        if self.source_more_window:
            self.source_more_window.feed_data('location', data)

    def check_if_childIncluded(self, is_included):

        # print('isChildIncludedInChangeset = ', is_included)

        self.isChildIncludedInChangeset = is_included

    def activate_correct_type_changeset(self, toggle):

        if toggle:
            self.activate_type_changeset = 'correction'
            # print(self.activate_type_changeset)

    def activate_update_type_changeset(self, toggle):

        if toggle:
            self.activate_type_changeset = 'update'
            # print(self.activate_type_changeset)

    #method that recieves an array of queries and a int of type id from the more_window
    def get_advanced_filtering_data_fromMoreWindow(self, urldata, urltype):
        nvdbId = urltype
        #self.source_data = nvdbFagdata(nvdbId)
        
        if len(urldata) > 0:
            
            type: int = int()
            name: str = str()
            # we now recieve an array
            for name_, id in self.listOfnvdbObjects.items():
                if id == urltype:
                    type = id
                    name = name_
    
            
            # type = self.data_from_imprted_url.get("type")
            
            self.nvdbIdField.setText(name)
            
            #emiting is done, so egenskaper can be loaded.
            self.nvdbIdField.editingFinished.emit()
            
            self.data_from_imported_url = urldata
            self.is_data_comming_from_url = True
            
            
            self.searchObj()
    
    # enable and disable ui elements based on true/false value of the bruklenke checkbox
    # also changing the is_data_coming_from_url bool that is being used to control if we search with user input or url
    def toggle_advanced_filtering_enabled(self):
        if self.enable_advanced_filtering_btn.isChecked():
            self.nvdbIdField.setEnabled(False)
            self.searchObjectBtn.setEnabled(False)
            self.is_data_coming_from_url = True
            self.nvdbIdField.setEnabled(False)
            if self.isSourceMoreWindowOpen :
                self.source_more_window.advanced_filtering_enabled_from_main(True) 
        else:
            if self.isSourceMoreWindowOpen :
                self.source_more_window.advanced_filtering_enabled_from_main(False)
            
            self.is_data_coming_from_url = False
            self.searchObjectBtn.setEnabled(True)
            self.nvdbIdField.setEnabled(True)

        
        