import io
import json
import requests


class AreaGeoDataParser:
    def __init__(self):
        pass

    @classmethod
    def counties(self) -> dict:
        #        adding some headers
        dict = {}
        data = ''
        header = {'X-Client': 'ny klient Les'}
        response = requests.get(self.get_env() + '/omrader/fylker.json?srid=5973', headers=header)

        if response.ok:
            data = response.text

            parsed = json.loads(data)
            dict = {}

            for iteration in parsed:
                dict[iteration['navn']] = iteration['nummer']

            return dict

    @classmethod
    def communities(self) -> dict:
        #        adding some headers
        dict = {}
        data = ''
        header = {'X-Client': 'ny klient Les'}
        response = requests.get(self.get_env() + '/omrader/kommuner.json?srid=5973', headers=header)

        if response.ok:
            data = response.text

            parsed = json.loads(data)

            self.communitiesInCounties = {}

            for iteration in parsed:
                dict[iteration['navn']] = iteration['nummer']
                self.communitiesInCounties[iteration['navn']] = iteration['fylke']

            return dict

    @classmethod
    def fetchAllNvdbObjects(self) -> dict:
        dict = {}
        objectTypesEndPoint = self.get_env() + "/vegobjekttyper.json"

        #        adding some headers
        header = {'X-Client': 'ny klient Les'}
        response = requests.get(objectTypesEndPoint, headers=header)

        if response.ok:
            data = response.text

            parsedData = json.loads(data)

            for item in parsedData:
                dict[item['navn']] = item['id']

        return dict

    @classmethod
    def egenskaper(self, datakatalogId: int) -> dict:
        listOfNames = {}
        endpointObjectType = self.get_env() + "/vegobjekttyper/" + str(datakatalogId)

        #        adding some headers
        header = {'X-Client': 'ny klient Les'}
        data = requests.get(endpointObjectType, headers=header)

        if data.ok:
            raw = data.text
            parsed = json.loads(raw)

            egenskapType = parsed['egenskapstyper']

            for item in egenskapType:
                listOfNames[item['navn']] = item['id']

        return listOfNames

    @classmethod
    def especificEgenskaper(self, datakatalogId, egenskapName) -> dict:
        listOfEspecificProps = {}
        endpointObjectType = self.get_env() + "/vegobjekttyper/" + str(datakatalogId)

        #        adding some headers
        header = {'X-Client': 'ny klient Les'}
        data = requests.get(endpointObjectType, headers=header)

        if data.ok:
            raw = data.text

            parsed = json.loads(raw)

            egenskapType = parsed['egenskapstyper']

            for item in egenskapType:
                if item['navn'] == egenskapName:
                    for name, props in item.items():
                        if name == 'datatype':
                            self.especificEgenskapDataType = props

                        if name == 'tillatte_verdier':
                            for especificProp in props:
                                listOfEspecificProps[especificProp['verdi']] = especificProp['id']

        return listOfEspecificProps

    @classmethod
    def egenskapDataType(self):
        return self.especificEgenskapDataType

    @classmethod
    def set_env(self, env: str) -> None:
        self.env = env

    @classmethod
    def get_possible_parents(self, type: int = 0) -> list:
        road_objects_possible_parents: list = []

        endpoint = self.get_env() + '/' + 'vegobjekttyper' + '/' + str(type)
        header = {
            'ContentType': 'application/json',
            'X-Client': 'ny klient Les'
        }
        params = {'inkluder': 'relasjonstyper'}

        response = requests.get(endpoint, headers=header, params=params)

        relationtype = None

        if response.ok:
            for in_content in response.json():
                if in_content == 'relasjonstyper':
                    relationtype = response.json()[in_content]
        try:
            if relationtype:
                foreldre = relationtype['foreldre']

                for object_type in foreldre:
                    for items, value_items in object_type.items():
                        if items == 'innhold':
                            # type_field = object_type[items]['type']['navn']

                            type_object_id = object_type[items]['type']['id']
                            type_object_name = object_type[items]['type']['navn']

                            form_dict_type = {'id': type_object_id, 'name': type_object_name}

                            # clear any element different from id or name elements
                            road_objects_possible_parents.append(form_dict_type)

        except:
            pass

        return road_objects_possible_parents

    @classmethod
    def get_possible_children_types(self, road_object_type: int = int()) -> list:

        endpoint = self.get_env() + f'/vegobjekttyper/{road_object_type}'

        header = {
            'X-Client': 'QGIS LES'
        }

        params = {'inkluder': 'relasjonstyper'}

        possible_children: list = []

        response = requests.get(endpoint, headers=header, params=params)

        # print( response.text )

        if response.ok:

            children = json.loads(response.text)['relasjonstyper']['barn']

            for child in children:
                # print('catalog id:', child['id'], 'catalog name:', child['navn'].split(' ')[1])

                possible_children.append({'catalog_id': child['id'], 'catalog_name': child['navn'].split(' ')[1]})

        return possible_children

    @classmethod
    def get_children_relation_from_parent(self, p_type: int = int(), p_nvdbid: int = int()):
        endpoint = self.get_env() + '/' + 'vegobjekter' + '/' + str(p_type) + '/' + str(p_nvdbid)

        # print( endpoint )

        header = {
            'ContentType': 'application/json',
            'X-Client': 'ny klient Les'
        }

        params = {'inkluder': 'relasjoner'}

        response = requests.get(endpoint, headers=header, params=params)

        # print( response.text )

        list_of_roadobjects: list = []
        plugin_dict: dict = {}
        list_id: dict = {}

        if response.ok:

            response_plugin = json.loads(response.text)
            # print(f"Response_plugin: {response_plugin}")

            try:

                list_of_roadobjects = response_plugin["relasjoner"]["barn"][0]["vegobjekter"]

                # getting the object_id of the child objects
                list_id = response_plugin["relasjoner"]["barn"][0]["id"]

            except KeyError:
                # no child object, then just return
                return

            # create a dict with the data put together
            plugin_dict = {list_id: {"vegobjekter": list_of_roadobjects}}

            """# CASE OF SWAGGER OUTPUT

                        print(response.text)
                        response_swagger = json.loads(response.text)

                        # getting length of the list containing the child objects
                        length_vegobjekter = len(response_swagger["relasjoner"]["barn"][0]["vegobjekter"])

                        # list to contain child objects
                        list_of_roadobjects = []

                        for i in range(0, length_vegobjekter):
                            # adding each child object to the list
                            list_of_roadobjects.append(response_swagger["relasjoner"]["barn"][0]["vegobjekter"][i]["id"])

                        # getting the object_id of the child objects
                        list_id = [response_swagger["relasjoner"]["barn"][0]["id"]]

                        # create a dict with the data put together
                        swagger_dict = {list_id: {"vegobjekter": list_of_roadobjects}}
                        print(swagger_dict)
            """

            return plugin_dict

    @classmethod
    def check_if_child_exist_in_parent(self, p_type: int = int(), p_nvdbid: int = int(),
                                       c_nvdbid_comp: int = int()) -> bool:

        relation = self.get_children_relation_from_parent(p_type, p_nvdbid)

        if relation:

            for key in relation.keys():

                for child in relation.get(key)['vegobjekter']:

                    if child == c_nvdbid_comp:
                        return True

        return False

    @classmethod
    def get_datacatalog_relation_type(self, object_type_id: int = int(), type_name: str = str()) -> int:
        endpoint = self.get_env(version='v4') + '/datakatalog/api/v1/vegobjekttyper/' + str(object_type_id)

        header = {
            'ContentType': 'application/json',
            'X-Client': 'QGIS'
        }

        params = {'inkluder': 'relasjonstyper'}

        response = requests.get(endpoint, headers=header, params=params)

        if response.ok:
            resp_json = json.loads(response.text)

            for child in resp_json['relasjonstyper']['barn']:
                # print(f"Child: {child['innhold']['type']['navn']}")

                if child['innhold']['type']['navn'] == type_name:
                    # print("Found!")

                    return child['innhold']['id']

        return 0
    
    

    @classmethod
    def get_geometry_type_by_nvdbid(self, nvdbid: int = int(), type_id: int = int()) -> str:

        endpoint = self.get_env() + f'/vegobjekter/{type_id}/{nvdbid}'

        headers = {'X-Client': 'QGIS-LES'}
        params = {'inkluder': 'geometri'}

        response = requests.get(endpoint, headers=headers, params=params)

        if response.ok:

            data = response.json()['geometri']

            geometry_type = data.get('wkt').split(' ')[0]

            if 'LINESTRING' in geometry_type:
                return 'linje'

            if 'POLYGON' in geometry_type:
                return 'flate'

            if 'POINT' in geometry_type:
                return 'punkt'

            # not need it, because in API response any of Flate or Hjelpelinje types are treat it like linje
            # if 'HJELPELINJE' in geometry_type:

            #     return 'hjelpelinje'

    @classmethod
    def get_last_version(self, p_nvdbid: int = int(), p_type_id: int = int()):
        endpoint = self.get_env() + '/' + 'vegobjekter' + '/' + str(p_type_id) + '/' + str(p_nvdbid)

        header = {
            'ContentType': 'application/json',
            'X-Client': 'ny klient Les'
        }

        params = {'inkluder': 'metadata'}

        response = requests.get(endpoint, headers=header, params=params)
        version: int = int()

        if response.ok:
            data = json.loads(response.text)

            metadata = data['metadata']
            version = metadata['versjon']

            return version

    @classmethod
    def get_env(self, version: str = 'v3') -> str:
        currentMiljo = self.env.lower()  # this variable value must be already set, before use with, object.set_env() method
        master_endpoint: str = str()

        lesUrl = None

        # deciding which endpoint version
        if version == 'v3':
            master_endpoint = 'https://nvdbapiles-v3.'

        elif version == 'v4':
            master_endpoint = 'https://nvdbapiles.'

        if 'prod' or 'Produksjon' in currentMiljo:
            lesUrl = master_endpoint + 'atlas.vegvesen.no'

        if 'test' in currentMiljo:
            lesUrl = master_endpoint + 'test.atlas.vegvesen.no'

        if 'utv' in currentMiljo:
            lesUrl = master_endpoint + 'utv.atlas.vegvesen.no'

        return lesUrl

    @classmethod
    def get_datacatalog_version(self, currentMiljo):
        header = {'X-Client': 'QGIS NVDB Skriv'}
        json_data = None

        if 'Produksjon' in currentMiljo:
            url = 'https://nvdbapiles-v3.atlas.vegvesen.no'

        if 'Akseptansetest' in currentMiljo:
            url = 'https://nvdbapiles-v3.test.atlas.vegvesen.no'

        if 'Utvikling' in currentMiljo:
            url = 'https://nvdbapiles-v3.utv.atlas.vegvesen.no'

        endpoint = url + '/vegobjekttyper/versjon'

        response = requests.get(endpoint, headers=header)

        if response.status_code:
            raw_data = response.text
            json_data = json.loads(raw_data)

            return json_data['versjon']

        return 'datakatalog version not found'

    @classmethod
    def get_last_time_modified(self, type, nvdbid, versjon):
        endpoint = self.get_env() + '/' + 'vegobjekter' + '/' + str(type) + '/' + str(nvdbid) + '/' + str(versjon)

        header = {
            'Content-Type': 'application/xml',
            'X-Client': 'ny klient Les'
        }

        response = requests.get(endpoint, headers=header)

        if response.ok:

            json_data = json.loads(response.text)

            for data in json_data:
                if data == 'metadata':
                    for key, value in json_data[data].items():
                        if key == 'sist_modifisert':
                            return value

        # return appended_parents

    @classmethod
    def get_start_slutt_dato(self, type: int = int(), nvdbid: int = int(), versjon: int = int()) -> dict:

        start_date: str = str()
        end_date: str = str()

        endpoint = self.get_env() + '/' + 'vegobjekter' + '/' + str(type) + '/' + str(nvdbid) + '/' + str(versjon)

        header = {
            'Content-Type': 'application/xml',
            'X-Client': 'ny klient Les'
        }

        response = requests.get(endpoint, headers=header)

        if response.ok:

            json_data = json.loads(response.text)

            for data in json_data:

                if data == 'metadata':

                    for key, value in json_data[data].items():

                        if key == 'startdato':
                            start_date = value

                        if key == 'sluttdato':
                            end_date = value

        return {'start_date': start_date, 'end_date': end_date}

    @classmethod
    def get_childRelationMetaData(self, forelder_typeid, forelder_nvdbid):

        list_dict = []

        header = {
            'X-Client': 'QGIS-Les'
        }

        endpoint_parent = self.get_env('v4') + str(
            f"/vegobjekter/{forelder_typeid}/{forelder_nvdbid}?srid=5973&inkluder=relasjoner&dybde=1")

        request = requests.get(endpoint_parent, headers=header)

        if request.ok:
            # print("Parent request is ok!")
            response = json.loads(request.text)
            try:
                for barn in response['relasjoner']['barn']:
                    barn_typeid = barn['type']['id']
                    for i in barn['vegobjekter']:
                        barn_nvdbid = i
                        barn_navn = barn['type']['navn']
                        data = self.get_childBoundary(forelder_typeid)
                        for obj in data:
                            dict_posisjoner = {}
                            if obj == barn_navn:
                                if data[obj] == "JA":
                                    endpoint_child = self.get_env('v4') + str(
                                        f"/vegobjekter/{barn_typeid}/{barn_nvdbid}")
                                    request = requests.get(endpoint_child)
                                    if request.ok:
                                        response = json.loads(request.text)
                                        vegobjekt_posisjon = response['egenskaper'][0]['relativPosisjon']
                                        vegobjekt_veglenkesekvensid = response['egenskaper'][0]["veglenkesekvensid"]
                                        vegobjekt_versjon = response['metadata']['versjon']
                                        vegobjekt_sistmodifisert = response['metadata']['sist_modifisert']

                                        dict_posisjoner['nvdbid'] = barn_nvdbid
                                        dict_posisjoner['posisjon'] = vegobjekt_posisjon
                                        dict_posisjoner['typeid'] = barn_typeid
                                        dict_posisjoner['veglenkesekvensid'] = vegobjekt_veglenkesekvensid
                                        dict_posisjoner['versjon'] = vegobjekt_versjon
                                        dict_posisjoner['sist_modifisert'] = vegobjekt_sistmodifisert

                                    elif not request.ok:
                                        # print(f"Error fetching child object: {request.status_code}")
                                        print(f"Error fetching child object: {request.text}")

                                if dict_posisjoner not in list_dict:
                                    list_dict.append(dict_posisjoner)


            except KeyError as e:
                print(f"KeyError: {str(e)}")
        elif not request.ok:
            # print(f"Error fetching parent object: {request.status_code}")
            print('error in get_childRelationMetaData:', request.text)

        return list_dict

    @classmethod
    def get_childBoundary(self, foreldre_typeid):
        dict_innenformor = {}

        header = {
            'X-Client': 'QGIS'
        }

        endpoint = self.get_env('v3') + str(f"/vegobjekttyper/{foreldre_typeid}?inkluder=relasjonstyper")
        request = requests.get(endpoint, headers=header)

        if request.ok:
            response = json.loads(request.text)
            for barn in response["relasjonstyper"]["barn"]:
                try:
                    if barn["innhold"]["innenfor_mor"]:
                        dict_innenformor[barn['innhold']['type']['navn']] = barn['innhold']['innenfor_mor']

                except KeyError:
                    dict_innenformor[barn['innhold']['type']['navn']] = "NEI"

            return dict_innenformor


        elif not request.ok:
            print(f"Error: {request.status_code}")

    @classmethod
    def get_parent_sideposisjon_og(self, foreldre_typeid, foreldre_nvdbid) -> list[dict]:
        endpoint = self.get_env('v4') + str(f"/vegobjekter/{foreldre_typeid}/{foreldre_nvdbid}")

        response = requests.get(endpoint)

        if response.status_code == 200:
            return response.json()['lokasjon']['stedfestinger']
    
    @classmethod
    def get_possible_children_catalog_typeid(self, road_object_type: int = int()) -> list:
        childre: list[dict] = []
        endpoint = self.get_env() + f'/vegobjekttyper/{road_object_type}'

        header = {
            'X-Client': 'QGIS LES'
        }

        params = {'inkluder': 'relasjonstyper'}

        possible_children: list = []

        response = requests.get(endpoint, headers=header, params=params)

        

        if response.ok:

            children = json.loads(response.text)['relasjonstyper']['barn']

            for child in children:
             innhold = child.get('innhold')
             if innhold:
                 type = innhold.get('type')
                
                 children.append( type )
         

        return children
    @classmethod
    def get_vegobject_name_from_id(self, road_object_type: int = int()) -> list:
        
        endpoint = self.get_env() + f'/vegobjekttyper/{road_object_type}'
        name= ""
        header = {
            'X-Client': 'QGIS LES'
        }

        params = {'inkluder': 'relasjonstyper'}

        

        response = requests.get(endpoint, headers=header, params=params)

        

        if response.ok:

            name = json.loads(response.text)["navn"]

          
         

        return name
    
    @classmethod
    def get_datacatalog_stedfesting_is_punkt(self) -> int:
        endpoint = self.get_env(version='v3') + '/vegobjekttyper'

        header = {
            'ContentType': 'application/json',
            'X-Client': 'QGIS'
        }

        params = {'inkluder': 'stedfesting'}

        response = requests.get(endpoint, headers=header, params=params)

        if response.ok:
            resp_json = json.loads(response.text)
            #print(resp_json)
            dict = {}
            for vegobj in resp_json:
                if vegobj.get("stedfesting"):
                    if vegobj.get("stedfesting").get("innhold"):
                        dict[vegobj.get("navn")] = {"id": vegobj.get("id"), "nonPunkt": True}
                    else:
                        dict[vegobj.get("navn")] = {"id": vegobj.get("id"), "nonPunkt": False}
                else:
                    dict[vegobj.get("navn")] = {}
            
            return dict
                    

        return {}
        
        