import xml.etree.ElementTree as ET

#from delvisKorrEgenskaperCase import DelvisKorrEgenskaperCase
#from nvdbLesWrapper import AreaGeoDataParser

from .delvisKorrEgenskaperCase import DelvisKorrEgenskaperCase
from .nvdbLesWrapper import AreaGeoDataParser

class CustomDelvisKorrReplaceParent(DelvisKorrEgenskaperCase):
    def __init__(self, token, data, extra):
        super().__init__(token, data, extra)
        pass

    # additional method
    def make_XMLRelation_road_object(self, vegobjekt, sistmodifisert: str = str(), old_parent_nvdbid: int = int(),
                                     new_parent_nvdbid: int = int(), operation_type: str = str(),
                                     road_object_type: int = int(), relation: list = []):

        # checking if parent nvdbid to use is old or the new one
        parent_nvdbid = old_parent_nvdbid if old_parent_nvdbid != 0 else new_parent_nvdbid

        # checking and assigning slett or ny operasjon
        operation = operation_type if operation_type == 'slett' else 'ny'

        vegobjekt = ET.SubElement(vegobjekt, 'vegobjekt')

        # version = AreaGeoDataParser.get_last_version(parent_nvdbid, self.extra['nvdb_object_type'])
        version = AreaGeoDataParser.get_last_version(parent_nvdbid, road_object_type)
        # version = nvdbLesWrapper.AreaGeoDataParser.get_last_version(parent_nvdbid, road_object_type)

        if self.extra['endringsett_mode'] == 'update':
            vegobjekt.attrib = {
                'overskriv': 'JA' if operation_type == 'slett' else 'NEI',

                'typeId': str(road_object_type),  # str(self.extra['nvdb_object_type']),
                'nvdbId': str(parent_nvdbid),
                'versjon': str(version)  # str(self.modified_data['versjon'])
            }

        if self.extra['endringsett_mode'] == 'correction':
            vegobjekt.attrib = {
                'typeId': str(road_object_type),  # str(self.extra['nvdb_object_type']),
                'nvdbId': str(parent_nvdbid),
                'versjon': str(version)  # str(self.modified_data['versjon'])
            }

        validering_objekt = ET.SubElement(vegobjekt, 'validering')

        lest_fra_nvdb = ET.SubElement(validering_objekt, 'lestFraNvdb')
        lest_fra_nvdb.text = sistmodifisert  # self.extra['sistmodifisert']

        # if endringssett is type of delvis oppdatert, then add gyldighetsperiode tag
        if self.extra['endringsett_mode'] == 'update':

            # date = AreaGeoDataParser.get_start_slutt_dato(self.extra['nvdb_object_type'], parent_nvdbid, version)
            date = AreaGeoDataParser.get_start_slutt_dato(road_object_type, parent_nvdbid, version)
            # date = nvdbLesWrapper.AreaGeoDataParser.get_start_slutt_dato(road_object_type, parent_nvdbid, version)

            gyldighetsperiode = ET.SubElement(vegobjekt, 'gyldighetsperiode')

            start_date = ET.SubElement(gyldighetsperiode, 'startdato')
            start_date.text = self.extra['start_date']  # date['start_date']

            '''we still ned to check date because of live data in vegobjekt can change
            and has or not sluttdato, because we know that most of the road object
            has startdato but not all of those has sluttdato'''
            if date.get('end_date'):
                end_date = ET.SubElement(gyldighetsperiode, 'sluttdato')
                end_date.text = self.extra.get('end_date')  # date['end_date']

        '''
        adding relations to the parent road object
            
        Note: when adding relation to a road object, convention is that
        parent object must add child as a relation to it and not the other way around.
        '''
        # relation = self.extra['relation']
        # relation_catalog = self.extra['relation']
        relation_catalog = relation

        # print( 'relation:', relation_catalog )

        # new code here
        relations_egenskap = ET.SubElement(vegobjekt, 'assosiasjoner')

        for catalog in relation_catalog:
            
            if self.extra.get('road_object_name') == catalog.get('catalog_name'):
                # print( 'found catalog' )

                relation = ET.SubElement(relations_egenskap, 'assosiasjon')
                relation.attrib = {'typeId': str(catalog.get('catalog_id')), 'operasjon': 'oppdater'}

                sub_relation = ET.SubElement(relation, 'nvdbId')
                sub_relation.attrib = {'operasjon': operation}

                sub_relation.text = str(str(self.extra['child_nvdbid']))

        # end of new code
        # if relations:

        #     # print( 'adding relasjoner' )

        #     relations_egenskap = ET.SubElement(vegobjekt, 'assosiasjoner')

        #     for enum_catalog_type_nvdb, item in relations.items():
        #         #Note: for each relation or assosiasjon a sub or new assosiasjon must be added individual if need it.

        #         #remove existing child
        #         relation = ET.SubElement(relations_egenskap, 'assosiasjon')
        #         relation.attrib = {'typeId': str(enum_catalog_type_nvdb), 'operasjon': 'oppdater'}

        #         sub_remove_relation = ET.SubElement(relation, 'nvdbId')
        #         sub_remove_relation.attrib = { 'operasjon':  operation }

        #         sub_remove_relation.text = str( str( self.extra['child_nvdbid'] ) )

        # return vegobjekt

    # override method
    def formXMLRequest(self, active_egenskap=True):

        # setting env to AreaGeoDataParser class
        AreaGeoDataParser.set_env(self.extra['env'])
        # nvdbLesWrapper.AreaGeoDataParser.set_env(self.extra['env'])

        root = ET.Element('endringssett')

        root.attrib = {'xmlns': 'http://nvdb.vegvesen.no/apiskriv/domain/changeset/v3'}

        # nvdb_object_id = str(self.modified_data['nvdbid'])
        # version = str(self.modified_data['versjon'])
        # nvdb_object_type = str(self.extra['nvdb_object_type'])

        datakatalogversjon = ET.SubElement(root, 'datakatalogversjon')

        datakatalogversjon.text = self.extra['datakatalog_version']

        ansvarlig = ET.SubElement(root, 'ansvarlig')

        ansvarlig.text = self.extra['username']

        # delvisKorriger = ET.SubElement(root, 'delvisKorriger')
        type_endringssett: str = str()

        # making sure what type of endringssett if delvis korrigering or oppdater
        if self.extra['endringsett_mode'] == 'correction':
            type_endringssett = ET.SubElement(root, 'delvisKorriger')

        if self.extra['endringsett_mode'] == 'update':
            type_endringssett = ET.SubElement(root, 'delvisOppdater')

        # vegobjekter = ET.SubElement(delvisKorriger, 'vegobjekter')
        vegobjekter = ET.SubElement(type_endringssett, 'vegobjekter')

        # making a vegobjekt with ny relation operation
        self.make_XMLRelation_road_object(vegobjekter,
                                          sistmodifisert=self.extra['sistmodifisert_remove'],
                                          old_parent_nvdbid=0,
                                          new_parent_nvdbid=self.extra['remove_from_parent'],
                                          operation_type='slett',
                                          road_object_type=self.extra['version_old_parent_type'],
                                          relation=self.extra['relation_old_parent'])

        # making a vegobjekt with slett relation operation
        self.make_XMLRelation_road_object(vegobjekter,
                                          sistmodifisert=self.extra['sistmodifisert_add'],
                                          new_parent_nvdbid=self.extra['add_to_parent'],
                                          operation_type='ny',
                                          road_object_type=self.extra['version_new_parent_type'],
                                          relation=self.extra['relation_new_parent'])

        self.xml_string = ET.tostring(root, encoding='utf-8')  # be careful with the unicode

        # print(self.xml_string)  # debugging info of hole formed XML endringssett

        self.endringsett_form_done.emit()
