from qgis.core import QgsProcessingProvider, QgsApplication
from qgis.PyQt.QtGui import QIcon
import os

class NTLCarbonToolboxProvider(QgsProcessingProvider):
    def __init__(self, iface=None):
        super().__init__()
        self.iface = iface

    def initGui(self):
        QgsApplication.processingRegistry().addProvider(self)

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self)

    def id(self):
        return 'ntl_carbon_analysis_toolbox'

    def name(self):
        return self.tr('Radiance2Carbon (R2C)')

    def icon(self):
        path = os.path.join(os.path.dirname(__file__), 'icon.png')
        return QIcon(path)

    def loadAlgorithms(self):
        from .algorithms.ntl_carbon_analysis_toolbox import NTLCarbonToolbox
        self.addAlgorithm(NTLCarbonToolbox())

