# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Non_electrical_vehicle
                                 A QGIS plugin
 This plugin calculates number of non electrical vehicles
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-05-16
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Truong Anh Huy LE
        email                : huymop.lee@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QFileDialog
import os
from qgis.core import *
from qgis.gui import *
import pandas as pd
import geopandas as gpd
import openpyxl
from openpyxl import *


# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .Non_electrical_vehicle_dialog import Non_electrical_vehicleDialog
import os.path


class Non_electrical_vehicle:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'Non_electrical_vehicle_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Non_electrical_vehicle')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Non_electrical_vehicle', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToVectorMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/Non_electrical_vehicle/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Non_electrical_vehicle'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginVectorMenu(
                self.tr(u'&Non_electrical_vehicle'),
                action)
            self.iface.removeToolBarIcon(action)

    def select_output_file(self):
        filename, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file ", "", '*.shp')
        self.dlg.lineEdit_2.setText(filename)

    def select_data_file(self):
        excel, _filter = QFileDialog.getSaveFileName(
            self.dlg, "Select output file ", "", '*.xlsx')
        self.dlg.lineEdit.setText(excel)



    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = Non_electrical_vehicleDialog()
            self.dlg.pushButton.clicked.connect(self.select_output_file)
            self.dlg.pushButton_2.clicked.connect(self.select_data_file)
        layers = QgsProject.instance().layerTreeRoot().children()
        self.dlg.comboBox.clear()
        self.dlg.comboBox.addItems([layer.name() for layer in layers])

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            
            excel_file = self.dlg.lineEdit.text()
            wb = load_workbook(filename = excel_file, read_only = True, data_only = True)
            ws_AME = wb['AME']
            ws_AMS = wb['AMS']

            Electrique_VL_AME = []
            Electrique_PL_AME = []
            Electrique_VL_AMS = []
            Electrique_PL_AMS = []

            for i in range(2,38):
                VL_AME = ws_AME.cell(row = i, column = 4)
                Electrique_VL_AME.append(VL_AME.value)
                PL_AME = ws_AME.cell(row = i, column = 14)
                Electrique_PL_AME.append(PL_AME.value)
                VL_AMS = ws_AMS.cell(row = i, column = 4)
                Electrique_VL_AMS.append(VL_AMS.value)
                PL_AMS = ws_AMS.cell(row = i, column = 14)
                Electrique_PL_AMS.append(PL_AMS.value)

            selectedLayerIndex = self.dlg.comboBox.currentIndex()
            Input = layers[selectedLayerIndex].layer()
            #Input_layer = QgsVectorLayer(Input, '', 'ogr')
            Input_path = Input.dataProvider().dataSourceUri()
            Output_path = self.dlg.lineEdit_2.text()

            source_data = gpd.read_file(Input_path)
            destination_data = gpd.GeoDataFrame(source_data, crs=source_data.crs)
            destination_data.to_file(Output_path)


            Année = self.dlg.spinBox.value()
            Scenario = self.dlg.comboBox_2.currentText()

            layer = QgsVectorLayer(Output_path, '', 'ogr')
            pv = layer.dataProvider()

            #Définir les plages de concentration
            fields = layer.fields()



            #Créer les nouveaux champs
            pv.addAttributes([QgsField('VL', QVariant.Int), QgsField('PL', QVariant.Int)])
            layer.updateFields()



            #Définir le contexte du calcul
            context = QgsExpressionContext()
            context.appendScopes(QgsExpressionContextUtils.globalProjectLayerScopes(layer))

            n = int(Année) - 2015
            #Calculer véhicules non électriques
            with edit(layer):
                if Scenario == 'AME':
                    for f in layer.getFeatures():
                        f['VL'] = f['CFCAR'] * (100 - Electrique_VL_AME[n]) / 100
                        f['PL'] = f['CFHEAVY'] * (100 - Electrique_PL_AME[n]) / 100
                        f['CFCAR'] = f['VL']
                        f['CFHEAVY'] = f['PL']
                        f['CFALL'] = f['CFCAR'] + f['CFHEAVY']
                        layer.updateFeature(f)
                else:
                    for f in layer.getFeatures():
                        f['VL'] = f['CFCAR'] * (100 - Electrique_VL_AMS[n]) / 100
                        f['PL'] = f['CFHEAVY'] * (100 - Electrique_PL_AMS[n]) / 100
                        f['CFCAR'] = f['VL']
                        f['CFHEAVY'] = f['PL']
                        f['CFALL'] = f['CFCAR'] + f['CFHEAVY']
                        layer.updateFeature(f)

            res = layer.dataProvider().deleteAttributes([53, 54, 55])
            layer.updateFields()



            self.iface.messageBar().pushMessage( "Success", "Output file written at "+ Output_path,level = Qgis.Success, duration = 3)
