# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NoisePrediction
                                 A QGIS plugin
 This plugin estimates the noisel level by distances and barriers as BS:5228 standard.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-12
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Htet Arkar Soe
        email                : htetarkar.env.2016@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Htet Arkar Soe'
__date__ = '2022-02-12'
__copyright__ = '(C) 2022 by Htet Arkar Soe'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import processing
import os
import inspect
from qgis.core import QgsProcessingAlgorithm
from qgis.PyQt.QtGui import QIcon
from qgis.utils import iface

from qgis.core import QgsProcessing
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterEnum

class GetSampleData(QgsProcessingAlgorithm):

    def initAlgorithm(self, config):
        #self.addParameter(QgsProcessingParameterEnum('ChooseSample', 'Choose Sample', options=['Scenario 1','Scenario 2'], allowMultiple=True, defaultValue=[]))
        pass
    def processAlgorithm(self, parameters, context, model_feedback):
        results = {}
        Receptor = os.path.join(os.path.dirname(__file__), 'dataset/receptors_zone_sample.shp')
        Dem = os.path.join(os.path.dirname(__file__), 'dataset/srtm30m_sample.tif')
        Stat_lulc = os.path.join(os.path.dirname(__file__), 'dataset/receptors_lulcstatistic_sample.csv')
        lulc = os.path.join(os.path.dirname(__file__), 'dataset/receptors_lulc_sample.shp')

        iface.addRasterLayer(Dem,'')
        iface.addVectorLayer(Receptor,'','ogr')
        landuse = iface.addVectorLayer(lulc,'','ogr')
        iface.addVectorLayer(Stat_lulc,'','ogr')
        
        #Set Layer Style
        alg_params = {
            'INPUT': landuse,
            'STYLE': os.path.join(os.path.dirname(__file__), 'style/Receptors_LULC.qml')
        }
        processing.run('native:setlayerstyle', alg_params, context=context, feedback=model_feedback, is_child_algorithm=True)
        return results

    def name(self):
        return 'Get Sample Data'

    def displayName(self):
        return 'Get Sample Data'

    def group(self):
        return ''

    def groupId(self):
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'sample.png')))
        return icon
        
    def shortHelpString(self):
        return 

    def createInstance(self):
        return GetSampleData()
