# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NoisePrediction
                                 A QGIS plugin
 This plugin estimates the noisel level by distances and barriers as BS:5228 standard.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-12
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Htet Arkar Soe
        email                : htetarkar.env.2016@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Htet Arkar Soe'
__date__ = '2022-02-12'
__copyright__ = '(C) 2022 by Htet Arkar Soe'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import processing
import os
import inspect

from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterRasterLayer
from qgis.core import QgsProcessingParameterPoint
from qgis.core import QgsProcessingParameterVectorLayer
from qgis.core import QgsProcessingParameterNumber
from qgis.core import QgsProcessingParameterCrs
from qgis.core import QgsProcessingParameterFile
from qgis.core import QgsProcessingParameterFeatureSink
from qgis.core import QgsProcessingParameterBoolean
from qgis.core import QgsProcessingParameterDefinition
from qgis.core import QgsExpression,QgsProcessingParameterEnum
import processing


class Calculatebs5228(QgsProcessingAlgorithm):

    def initAlgorithm(self, config):
        self.addParameter(QgsProcessingParameterRasterLayer('DemFile', 'Digital Elevation Model - Dem File(.tif)', defaultValue=None))
        self.addParameter(QgsProcessingParameterPoint('CreatingNoiseSourcePoint', 'Create Noise Source Point On Map Canvas', defaultValue=''))
        self.addParameter(QgsProcessingParameterVectorLayer('Receptorlanduse', 'Receptor Areas/Polygon (residential & industrial)', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('ObserverHeight', 'Noise Source Height (meter)', type=QgsProcessingParameterNumber.Double, minValue=0, maxValue=1000, defaultValue=None))
        param = QgsProcessingParameterCrs('CRS', 'CRS (Choose PCS)', defaultValue='EPSG:32646')
        param.setFlags(param.flags() | QgsProcessingParameterDefinition.FlagAdvanced)
        self.addParameter(param)
        self.addParameter(QgsProcessingParameterNumber('HorizontalGridValue', 'Horizontal Haxagon Grid Value For Output Resolution (meter) **Should exceed DEM resolution', type=QgsProcessingParameterNumber.Integer, minValue=30, maxValue=1000, defaultValue=200))
        self.addParameter(QgsProcessingParameterNumber('VerticalGridValue', 'Vertical Haxagon Grid Value For Output Resolution (meter) **Should exceed DEM resolution', type=QgsProcessingParameterNumber.Integer, minValue=30, maxValue=1000, defaultValue=200))
        self.addParameter(QgsProcessingParameterNumber('NoiseLevelFromSoruce', 'Significant Noise Level From Activity Soruce (dBA)', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=200, defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('ReflectionValue', 'Reflection Value (0 or 3)', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=10, defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('ProjectDuration', 'Project Duration Hour (1 - 24)', type=QgsProcessingParameterNumber.Integer, minValue=1, maxValue=48, defaultValue=None))
        self.addParameter(QgsProcessingParameterNumber('ActivityDuration', 'Activity Operation Hour (1 -24)', type=QgsProcessingParameterNumber.Integer, minValue=1, maxValue=48, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('NoiseSource', 'Noise Source Point (set style)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, defaultValue=None))
        self.addParameter(QgsProcessingParameterFeatureSink('NoiselevelByDistance', 'NoiseLevel By Distance (set style)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        #self.addParameter(QgsProcessingParameterFeatureSink('NoiseLevelByThredsholdLimit', 'Noise Level By Thredshold Limit (set style)', type=QgsProcessing.TypeVectorAnyGeometry, createByDefault=True, supportsAppend=True, defaultValue=None))
        #self.addParameter(QgsProcessingParameterBoolean('VERBOSE_LOG', 'Verbose logging', optional=True, defaultValue=False))
        self.addParameter(QgsProcessingParameterEnum('Ground', 'Select Ground Type For Noise Attenuation', 
                            options=['soft ground','hard ground'], 
                            allowMultiple=False, defaultValue=None
                            ))
        self.addParameter(QgsProcessingParameterNumber('SoftPercent', 'Soft Ground Percentage (0-100) *Zero Value for worst case scenario', type=QgsProcessingParameterNumber.Integer, minValue=0, maxValue=100, defaultValue=25))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(28, model_feedback)
        results = {}
        outputs = {}

        # Create layer from point
        alg_params = {
            'INPUT': parameters['CreatingNoiseSourcePoint'],
            'OUTPUT': parameters['NoiseSource']
        }
        outputs['CreateLayerFromPoint'] = processing.run('native:pointtolayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['NoiseSource'] = outputs['CreateLayerFromPoint']['OUTPUT']
        
        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}
            
        # Set layer style
        alg_params = {
            'INPUT': outputs['CreateLayerFromPoint']['OUTPUT'],
            'STYLE': os.path.join(os.path.dirname(__file__), 'style/NoiseSource.qml')
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        
        # Reproject_NoiseSrc
        alg_params = {
            'INPUT': outputs['CreateLayerFromPoint']['OUTPUT'],
            'OPERATION': '',
            'TARGET_CRS': parameters['CRS'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Reproject_noisesrc'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(2)
        if feedback.isCanceled():
            return {}

        # Warp (reproject)
        alg_params = {
            'DATA_TYPE': 0,
            'EXTRA': '',
            'INPUT': parameters['DemFile'],
            'MULTITHREADING': False,
            'NODATA': None,
            'OPTIONS': '',
            'RESAMPLING': 0,
            'SOURCE_CRS': None,
            'TARGET_CRS': parameters['CRS'],
            'TARGET_EXTENT': None,
            'TARGET_EXTENT_CRS': None,
            'TARGET_RESOLUTION': None,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['WarpReproject'] = processing.run('gdal:warpreproject', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(3)
        if feedback.isCanceled():
            return {}

        # Reproject_Receptor
        alg_params = {
            'INPUT': parameters['Receptorlanduse'],
            'OPERATION': '',
            'TARGET_CRS': parameters['CRS'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Reproject_receptor'] = processing.run('native:reprojectlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(4)
        if feedback.isCanceled():
            return {}

        # Viewshed
        alg_params = {
            'BAND': 1,
            'EXTRA': '',
            'INPUT': outputs['WarpReproject']['OUTPUT'],
            'MAX_DISTANCE': 100000,
            'OBSERVER': parameters['CreatingNoiseSourcePoint'],
            'OBSERVER_HEIGHT': parameters['ObserverHeight'],
            'OPTIONS': '',
            'TARGET_HEIGHT': 1,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Viewshed'] = processing.run('gdal:viewshed', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(5)
        if feedback.isCanceled():
            return {}

        # Create grid
        alg_params = {
            'CRS': parameters['CRS'],
            'EXTENT': outputs['Reproject_receptor']['OUTPUT'],
            'HOVERLAY': 0,
            'HSPACING': parameters['HorizontalGridValue'],
            'TYPE': 4,
            'VOVERLAY': 0,
            'VSPACING': parameters['VerticalGridValue'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['CreateGrid'] = processing.run('native:creategrid', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(6)
        if feedback.isCanceled():
            return {}

        # Extract by location
        alg_params = {
            'INPUT': outputs['CreateGrid']['OUTPUT'],
            'INTERSECT': outputs['Reproject_receptor']['OUTPUT'],
            'PREDICATE': [0,4,5,6,7],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ExtractByLocation'] = processing.run('native:extractbylocation', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        #results['Extracted'] = outputs['ExtractByLocation']['OUTPUT']

        feedback.setCurrentStep(7)
        if feedback.isCanceled():
            return {}

        # Centroids
        alg_params = {
            'ALL_PARTS': False,
            'INPUT': outputs['ExtractByLocation']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Centroids'] = processing.run('native:centroids', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(8)
        if feedback.isCanceled():
            return {}

        # Zonal statistics
        alg_params = {
            'COLUMN_PREFIX': '_',
            'INPUT': outputs['ExtractByLocation']['OUTPUT'],
            'INPUT_RASTER': outputs['Viewshed']['OUTPUT'],
            'RASTER_BAND': 1,
            'STATISTICS': [5,6,2,8,9],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['ZonalStatistics'] = processing.run('native:zonalstatisticsfb', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(9)
        if feedback.isCanceled():
            return {}

        # Intersection
        alg_params = {
            'INPUT': outputs['Centroids']['OUTPUT'],
            'INPUT_FIELDS': QgsExpression('\'id\'').evaluate(),
            'OVERLAY': outputs['Reproject_receptor']['OUTPUT'],
            'OVERLAY_FIELDS': QgsExpression('\'zone\'').evaluate(),
            'OVERLAY_FIELDS_PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Intersection'] = processing.run('native:intersection', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(10)
        if feedback.isCanceled():
            return {}

        # Sample raster values
        alg_params = {
            'COLUMN_PREFIX': 'elv',
            'INPUT': outputs['Intersection']['OUTPUT'],
            'RASTERCOPY': outputs['WarpReproject']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['SampleRasterValues'] = processing.run('native:rastersampling', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(11)
        if feedback.isCanceled():
            return {}

        # Distance to nearest hub (points)
        alg_params = {
            'FIELD': 'id',
            'HUBS': outputs['Reproject_noisesrc']['OUTPUT'],
            'INPUT': outputs['SampleRasterValues']['OUTPUT'],
            'UNIT': 0,
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['DistanceToNearestHubPoints'] = processing.run('qgis:distancetonearesthubpoints', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(12)
        if feedback.isCanceled():
            return {}

        # Join attributes Point
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'FIELD': 'id',
            'FIELDS_TO_COPY': [''],
            'FIELD_2': 'id',
            'INPUT': outputs['DistanceToNearestHubPoints']['OUTPUT'],
            'INPUT_2': outputs['ZonalStatistics']['OUTPUT'],
            'METHOD': 1,
            'PREFIX': ''
        }
        outputs['JoinAttributesPoint'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(13)
        if feedback.isCanceled():
            return {}

        # Join attributes_polygon
        alg_params = {
            'DISCARD_NONMATCHING': True,
            'FIELD': 'id',
            'FIELDS_TO_COPY': [''],
            'FIELD_2': 'id',
            'INPUT': outputs['ZonalStatistics']['OUTPUT'],
            'INPUT_2': outputs['DistanceToNearestHubPoints']['OUTPUT'],
            'METHOD': 1,
            'PREFIX': '',
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['JoinAttributes_polygon'] = processing.run('native:joinattributestable', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(14)
        if feedback.isCanceled():
            return {}

        # calculate_distMeter
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dist_m',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,
            'FORMULA': 'round(\"HubDist\" ,2)',
            'INPUT': outputs['JoinAttributes_polygon']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_distmeter'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(15)
        if feedback.isCanceled():
            return {}

        # calculate_distdBA
        if parameters['Ground'] == 0:
            alg_params = {
                'FIELD_LENGTH': 5,
                'FIELD_NAME': 'dBA_dist',
                'FIELD_PRECISION': 0,
                'FIELD_TYPE': 1,
                'FORMULA': '25*log10( \"dist_m\" /10)-2',
                'INPUT': outputs['Calculate_distmeter']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }
        elif parameters['Ground'] == 1:
            alg_params = {
                'FIELD_LENGTH': 5,
                'FIELD_NAME': 'dBA_dist',
                'FIELD_PRECISION': 0,
                'FIELD_TYPE': 1,
                'FORMULA': '20*log10( \"dist_m\" /10)',
                'INPUT': outputs['Calculate_distmeter']['OUTPUT'],
                'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
            }

        outputs['Calculate_distdba'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(16)
        if feedback.isCanceled():
            return {}

        # calculate_dBA percent of soft ground
        softpercent = parameters['SoftPercent']/100
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'soft_percent',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': '{}*((25*log10(\"dist_m\" /10)-2)-(20*log10( \"dist_m\"/10)))'.format(softpercent),
            'INPUT': outputs['Calculate_distdba']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_distdbaPercent'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(17)
        if feedback.isCanceled():
            return {}
            
        # calculate_src
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dBA_src',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,
            'FORMULA': parameters['NoiseLevelFromSoruce'],
            'INPUT': outputs['Calculate_distdbaPercent']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_src'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(18)
        if feedback.isCanceled():
            return {}

        # calculate_scn
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dBA_scn',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'CASE \r\nWHEN \"_max\"=255 THEN 5\r\nWhen \"_max\"=0 THEN 10\r\nEND',
            'INPUT': outputs['Calculate_src']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_scn'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(19)
        if feedback.isCanceled():
            return {}

        # calculate_reflect
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dBA_reflect',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': parameters['ReflectionValue'],
            'INPUT': outputs['Calculate_scn']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_reflect'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(20)
        if feedback.isCanceled():
            return {}

        # calculate_duration
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dur_hr',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': parameters['ProjectDuration'],
            'INPUT': outputs['Calculate_reflect']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_duration'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(21)
        if feedback.isCanceled():
            return {}

        # calculate_operation
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'op_hr',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 0,
            'FORMULA': parameters['ActivityDuration'],
            'INPUT': outputs['Calculate_duration']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_operation'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(22)
        if feedback.isCanceled():
            return {}

        # calculate_durationPercent
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dur_percent',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': '(\"op_hr\" /\"dur_hr\") * 100',
            'INPUT': outputs['Calculate_operation']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_durationpercent'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(23)
        if feedback.isCanceled():
            return {}

        # calculate_correction
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dBA_corrt',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': 'CASE \r\nWHEN \"dur_percent\"= 100 THEN 0\r\nWHEN \"dur_percent\" <100 AND \"dur_percent\">= 80 THEN 1 \r\nWHEN \"dur_percent\" <80 AND \"dur_percent\" >= 60 THEN 2\r\nWHEN \"dur_percent\" <60 AND \"dur_percent\" >= 50 THEN 3\r\nWHEN \"dur_percent\" <50 AND \"dur_percent\" >= 40 THEN 4\r\nWHEN \"dur_percent\" <40 AND \"dur_percent\" >= 30 THEN 5\r\nWHEN \"dur_percent\" <30 AND \"dur_percent\" >= 25 THEN 6\r\nWHEN \"dur_percent\" <25 AND \"dur_percent\" >= 20 THEN 7\r\nWHEN \"dur_percent\" <20 AND \"dur_percent\" >= 16 THEN 8\r\nWHEN \"dur_percent\" <16 AND \"dur_percent\" >= 13 THEN 9\r\nWHEN \"dur_percent\" <13 AND \"dur_percent\" >= 10 THEN 10\r\nWHEN \"dur_percent\" <10 THEN 15 \r\nEND\r\n',
            'INPUT': outputs['Calculate_durationpercent']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_correction'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(24)
        if feedback.isCanceled():
            return {}

        # calculate_resultantdBA
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dBA_resultant',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': '\"dBA_src\" - \"dBA_dist\" - \"soft_percent\" - \"dBA_scn\" + \"dBA_reflect\" ',
            'INPUT': outputs['Calculate_correction']['OUTPUT'],
            'OUTPUT': QgsProcessing.TEMPORARY_OUTPUT
        }
        outputs['Calculate_resultantdba'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(25)
        if feedback.isCanceled():
            return {}

        # calculate_ActivitydBA
        alg_params = {
            'FIELD_LENGTH': 5,
            'FIELD_NAME': 'dBA_activity',
            'FIELD_PRECISION': 0,
            'FIELD_TYPE': 1,
            'FORMULA': '\"dBA_resultant\" - \"dBa_corrt\" ',
            'INPUT': outputs['Calculate_resultantdba']['OUTPUT'],
            'OUTPUT': parameters['NoiselevelByDistance']
        }
        outputs['Calculate_activitydbaD'] = processing.run('native:fieldcalculator', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        results['NoiselevelByDistance'] = outputs['Calculate_activitydbaD']['OUTPUT']

        feedback.setCurrentStep(26)
        if feedback.isCanceled():
            return {}

        # Set layer style
        alg_params = {
            'INPUT': outputs['Calculate_activitydbaD']['OUTPUT'],
            'STYLE': os.path.join(os.path.dirname(__file__), 'style/CalculatedNoiseLevel.qml')
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results

    def name(self):
        return 'Calculate-BS:5228'

    def displayName(self):
        return 'Calculate Noise Level From Site'

    def group(self):
        return ''

    def groupId(self):
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'logo.png')))
        return icon
        
    def shortHelpString(self):
        return """<html><body><h2>Algorithm description</h2>
<p>This plugin estimates the noisel level by distances and barriers as BS:5228 standard.
Noise Estimation From Point Source Algorithm
British Standard - BS 5228-1:2009+A1:2014

Factors For consideration
1) the sound power outputs of processes and plant; 
2) the periods of operation of processes and plant; 
3) the distances from sources to receiver; 
4) the presence of screening by barriers; 
5) the reflection of sound; 
6) soft ground attenuation. 

Other factors such as meteorological conditions (particularly wind speed and direction) and atmospheric absorption can also influence the level of noise received. The estimation of the effects of these factors is complicated, not least because of interaction between these factors, and is beyond the scope of this standard.</p>


        Developed by: Htet Arkar Soe
        Date: 2022-02-14
        email: htetarkar.env.2016@gmail.com 
</p></body></html>"""

    def createInstance(self):
        return Calculatebs5228()
