# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NoisePrediction
                                 A QGIS plugin
 This plugin estimates the noisel level by distances and barriers as BS:5228 standard.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-02-12
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Htet Arkar Soe
        email                : htetarkar.env.2016@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Htet Arkar Soe'
__date__ = '2022-02-12'
__copyright__ = '(C) 2022 by Htet Arkar Soe'


from qgis.core import QgsProcessing
from qgis.core import QgsProcessingAlgorithm
from qgis.core import QgsProcessingMultiStepFeedback
from qgis.core import QgsProcessingParameterVectorLayer
import processing
import os
import inspect
from qgis.PyQt.QtGui import QIcon

class threshold_algorithm(QgsProcessingAlgorithm):

    def initAlgorithm(self, config=None):
        self.addParameter(QgsProcessingParameterVectorLayer('AlgorithmOutputVectorLayer', 'Algorithm Output Vector Layer', types=[QgsProcessing.TypeVectorPolygon], defaultValue=None))

    def processAlgorithm(self, parameters, context, model_feedback):
        # Use a multi-step feedback, so that individual child algorithm progress reports are adjusted for the
        # overall progress through the model
        feedback = QgsProcessingMultiStepFeedback(2, model_feedback)
        results = {}
        outputs = {}

        # Set layer style
        alg_params = {
            'INPUT': parameters['AlgorithmOutputVectorLayer'],
            'STYLE': os.path.join(os.path.dirname(__file__), 'style/NoiseLevelThreshold.qml')
        }
        outputs['SetLayerStyle'] = processing.run('native:setlayerstyle', alg_params, context=context, feedback=feedback, is_child_algorithm=True)

        feedback.setCurrentStep(1)
        if feedback.isCanceled():
            return {}

        # Load layer into project
        alg_params = {
            'INPUT': outputs['SetLayerStyle']['OUTPUT'],
            'NAME': 'IFC General EHS Guideline'
        }
        outputs['LoadLayerIntoProject'] = processing.run('native:loadlayer', alg_params, context=context, feedback=feedback, is_child_algorithm=True)
        return results

    def name(self):
        return 'EHS-Guideline'

    def displayName(self):
        return 'Set Style:IFC EHS Guideline'

    def group(self):
        return ''
        
    def icon(self):
        cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]
        icon = QIcon(os.path.join(os.path.join(cmd_folder, 'ifc_logo.png')))
        return icon
        
    def groupId(self):
        return ''
        
    def shortHelpString(self):
        return """<html><body><h2>Algorithm description</h2>
<p>Environmental, Health, and Safety (EHS) Guidelines
Two Receptor Zones:
--(R) Residential; Institutional; Educational
--(I) Industrial; Commercial

Guideline for both day and night:
**(R) 55 LAeq (dBA) - Daytime (7:00 - 22:00)
**(I) 70 LAeq (dBA) - Daytime (7:00 - 22:00)

**(R) 45 LAeq (dBA) - Nighttime (22:00 - 7:00)
**(I) 70 LAeq (dBA) - Nighttime (22:00 - 7:00)
</p></body></html>"""
    def createInstance(self):
        return threshold_algorithm()
