# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PrzechwycWysokosc
                                 A QGIS plugin
 Pozwala na sprawdzenie wysokości terenu w danym punkcie na odatwie API GUGiK NMT
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-10-15
        git sha              : $Format:%H$
        copyright            : (C) 2019 by EnviroSolutions Sp. z o.o.
        email                : office@envirosolutions.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, Qt
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction, QToolBar, QApplication, QShortcut, QWidget, QLabel, QDialog, QComboBox
from PyQt5 import uic
from qgis.gui import QgsMapToolEmitPoint
from qgis.core import QgsProject, QgsCoordinateReferenceSystem, QgsCoordinateTransform, Qgis, QgsSettings
from .qgis_feed import QgisFeedDialog

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the DockWidget
from .przechwyc_wysokosc_dockwidget import PrzechwycWysokoscDockWidget
import os.path
from .nmt_api import NmtAPI

"""Wersja wtyczki"""
plugin_version = '1.3.6'
plugin_name = 'Przechwyć Wysokość'


class PrzechwycWysokosc:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """

        self.settings = QgsSettings() 

        if Qgis.QGIS_VERSION_INT >= 31000:
            from .qgis_feed import QgisFeed
            self.selected_industry = self.settings.value("selected_industry", None)
            show_dialog = self.settings.value("showDialog", True, type=bool)

            if self.selected_industry is None and show_dialog:
                self.showBranchSelectionDialog()

            select_indust_session = self.settings.value('selected_industry')

            self.feed = QgisFeed(selected_industry=select_indust_session, plugin_name=plugin_name)
            self.feed.initFeed()

        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'PrzechwycWysokosc_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&EnviroSolutions')
        # TODO: We are going to let the user set this up in a future iteration
        self.toolbar = self.iface.mainWindow().findChild(QToolBar, 'EnviroSolutions')

        if not self.toolbar:
            self.toolbar = self.iface.addToolBar(u'EnviroSolutions')
            self.toolbar.setObjectName(u'EnviroSolutions')

        #print "** INITIALIZING PrzechwycWysokosc"

        self.pluginIsActive = False
        self.dockwidget = None
        
        self.project = QgsProject.instance()
        self.canvas = self.iface.mapCanvas()
        # out click tool will emit a QgsPoint on every click
        self.clickTool = QgsMapToolEmitPoint(self.canvas)
        self.clickTool.canvasClicked.connect(self.canvas_clicked)
        # --------------------------------------------------------------------------


    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('PrzechwycWysokosc', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):

        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action


    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/przechwyc_wysokosc/icons/icon_pw.svg'
        self.add_action(
            icon_path,
            text=self.tr(u'Przechwyć Wysokość'),
            callback=self.run,
            parent=self.iface.mainWindow())


    def onClosePlugin(self):
        """Cleanup necessary items here when plugin dockwidget is closed"""

        #print "** CLOSING PrzechwycWysokosc"

        # disconnects
        self.dockwidget.closingPlugin.disconnect(self.onClosePlugin)

        # remove this statement if dockwidget is to remain
        # for reuse if plugin is reopened
        # Commented next statement since it causes QGIS crashe
        # when closing the docked window:
        # self.dockwidget = None

        self.pluginIsActive = False


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""

        #print "** UNLOAD PrzechwycWysokosc"

        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&EnviroSolutions'),
                action)
            #self.iface.removeToolBarIcon(action)
            self.toolbar.removeAction(action)

        # remove the toolbar
        del self.toolbar


    def run(self):
        """Run method that loads and starts the plugin"""

        if not self.pluginIsActive:
            self.pluginIsActive = True

            #print "** STARTING PrzechwycWysokosc"

            # dockwidget may not exist if:
            #    first run of plugin
            #    removed on close (see self.onClosePlugin method)

            if self.dockwidget == None:
                # Create the dockwidget (after translation) and keep reference
                self.dockwidget = PrzechwycWysokoscDockWidget()

            # Eventy
            self.dockwidget.captureButton.clicked.connect(self.captureButton_clicked)
            self.dockwidget.copyButton.clicked.connect(self.copyButton_clicked)
            # connect to provide cleanup on closing of dockwidget
            self.dockwidget.closingPlugin.connect(self.onClosePlugin)

            # informacje o wersji
            self.dockwidget.setWindowTitle('%s %s' % (plugin_name, plugin_version))
            self.dockwidget.lbl_pluginVersion.setText('%s %s' % (plugin_name, plugin_version))

            # show the dockwidget
            # TODO: fix to allow choice of dock location
            self.iface.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)
            self.dockwidget.show()

    def showBranchSelectionDialog(self):
        self.qgisfeed_dialog = QgisFeedDialog()

        if self.qgisfeed_dialog.exec_() == QDialog.Accepted:
            self.selected_branch = self.qgisfeed_dialog.comboBox.currentText()
            
            #Zapis w QGIS3.ini
            self.settings.setValue("selected_industry", self.selected_branch)  
            self.settings.setValue("showDialog", False) 

    def captureButton_clicked(self):
        """
        Funkcja uaktywnia funkcjonalność klikania na mapie punktu po kliknięciu przycisku 'Przechwytuj'
        """
        self.canvas.setMapTool(self.clickTool)


    def copyButton_clicked(self):
        """
        Funkcja kopiuje zczytane współrzędne do schowka
        """
        
        cb = QApplication.clipboard()
        cb.clear(mode=cb.Clipboard)
        cb.setText("(%s, %s)" % (self.dockwidget.coordsEdit.text(),
                                 self.dockwidget.heightEdit.text()), mode=cb.Clipboard)
        self.iface.messageBar().pushMessage("Sukces:",
                                            'Skopiowano współrzedne x,y,h do schowka',
                                            level=Qgis.Success, duration=3)


    def canvas_clicked(self, point):
        """
        Funkcja odpowiadająca za ściągnięcie współrzędnych dla klikniętego punktu na mapie
        """
        
        coords = "{}, {}".format(point.x(), point.y())

        self.dockwidget.coordsEdit.setText(coords)
        self.canvas.unsetMapTool(self.clickTool)
        self.captureHeight(point)


    def captureHeight(self, point):
        """
        Funkcja na bazie odczytanego punktu zczytuje wysokość
        """
        
        projectCrs = self.project.crs()
        crsDest = QgsCoordinateReferenceSystem("EPSG:2180")  # PL 1992
        xform = QgsCoordinateTransform(projectCrs, crsDest, self.project)
        point1992 = xform.transform(point)
        h = NmtAPI.getHbyXY(y=point1992.x(), x=point1992.y())
        if h is None:
            #błąd usługi lub brak połączenia z internetem
            self.iface.messageBar().pushMessage("Błąd usługi:",
                                                'Brak połączenia z serwerem, sprawdź czy działa połączenie z internetem',
                                                level=Qgis.Critical, 
                                                duration=10)
        else:
            self.dockwidget.heightEdit.setText(h)
