# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NinMapperDockWidget
                                 A QGIS plugin
 Natur i Norge (NiN) mapping tool.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2024-05-03
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Lasse Keetz, Peter Horvath, Anne B. Nilsen
        email                : test@dev.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import csv
import re  #search string
from pathlib import Path
from . import create_gpkg as cgpkg
from . import project_setup as ps

from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal
from qgis.gui import QgsFileWidget
# from PyQt5 import QtWidgets, uic
from PyQt5.QtCore import Qt  # Import Qt from PyQt5.QtCore
from PyQt5.QtGui import QDesktopServices
from PyQt5.QtCore import QUrl #for linking to github
from PyQt5.QtWidgets import (
    QMessageBox, QComboBox, QListWidget,
    QListWidgetItem, QGroupBox, QCheckBox, QRadioButton, QHBoxLayout
)

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'nin_qgis_plugin_dialog_base.ui'
))


class NinMapperDialogWidget(QtWidgets.QDialog, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, canvas, parent=None):
        """Constructor."""

        super(NinMapperDialogWidget, self).__init__(parent)
        self.canvas = canvas

        self.setupUi(self)

        # Connect the button action to the create_geopackage method
        self.changeProjectSettingsButton.clicked.connect(self.load_project)

        # Access the combo box for Selecting Type and Selecting Hovedtypegruppe
        self.comboBox = self.findChild(QComboBox, 'SelectType')
        self.selectHovetypegrupperWidget = self.findChild(
            QListWidget,
            'SelectHovedtypegrupper'
        )
        self.selectMappingScale = self.findChild(
            QComboBox,
            'SelectMappingScale'
        )

        # WMS checkbox handling
        self.wms_box_group = self.findChild(QGroupBox, 'groupBoxWMS')
        self.wms_check_box_names = [
            'checkBoxNorgeTopo',
            'checkBoxNorgeTopoGraa',
            'checkBoxNiB',
        ]

        # Load the first combo box
        self.load_type_combo_box()

        # Connect the first combo box selection change to a handler
        self.comboBox.currentIndexChanged.connect(
            self.on_type_combo_box_changed
        )

        # Initialize selected type variable
        self.selected_type_id = None

        # Populate the mapping scale combo box
        self.load_mapping_scale_combo_box()

        # Initialize .gpkg path variable
        self.geopackage_path = None
        self.file_widget = self.findChild(
            QgsFileWidget,
            'gpkgFilePicker'
        )
        # Set to None to force user to make a selection
        self.file_widget.setFilePath(None)

        # Set UI default values
        self.set_ui_default_values()

        # Connect help button
        self.helpButton.clicked.connect(self.open_help_url)
    
    def open_help_url(self):
        QDesktopServices.openUrl(QUrl("https://geco-nhm.github.io/nin-qgis-plugin/"))

    def load_type_combo_box(self):

        # Path to the typer CSV file
        csv_root = Path(__file__).parent / 'csv' / \
            'attribute_tables'

        self.type_combo_data = {}  # To store data for the type combo box

        # Access the combo box
        # the objectName of your QComboBox
        self.comboBox = self.findChild(QComboBox, 'SelectType')

        # Path to the CSV file
        typer_path = csv_root / 'typer_attribute_table.csv'

        # Read the CSV file and add items to the combo box
        with open(typer_path, newline='', encoding='utf-8') as typefile:
            reader = csv.DictReader(typefile)
            for row in reader:
                self.comboBox.addItem(row['navn'], row['kode_id'])
                self.type_combo_data[row['kode_id']] = row['navn']

    def get_selected_type_id(self) -> str:
        '''
        Returns the "typer" fid's selected in the UI.
        '''
        return self.selected_type_id

    def on_type_combo_box_changed(self, index):
        self.selected_type_id = self.comboBox.itemData(index)
        self.load_hovedtypegruppe_list_widget()

    def load_hovedtypegruppe_list_widget(self):
        # Path to the hovedtypegrupper CSV file
        csv_root = Path(__file__).parent / 'csv' / 'attribute_tables'
        htgr_file_path = csv_root / 'hovedtypegrupper_attribute_table.csv'
        self.selectHovetypegrupperWidget.clear()  # Clear the second combo box
        # Read the CSV file and add items to the combo box
        with open(htgr_file_path, newline='', encoding='utf-8') as htgrfile:
            reader = csv.DictReader(htgrfile)
            for row in reader:
                # Filtering the rows based on the selected item in the "Type combo box".
                if row['typer_fkey'] == str(self.comboBox.currentIndex()):
                    # Creating a new list item for each matching row.
                    item = QListWidgetItem(row['navn'])
                    # Setting the display text and additional data for the list item.
                    item.setData(Qt.UserRole, row['kode_id'])
                    # Making the list item checkable and setting its initial check state.
                    item.setFlags(item.flags() | Qt.ItemIsUserCheckable)
                    # Set initial state to unchecked
                    item.setCheckState(Qt.Unchecked)
                    # Adding the list item to the QListWidget.
                    self.selectHovetypegrupperWidget.addItem(item)

    # DEBUG
    # print the selected items from the listWidget
    def get_selected_htgr_items(self):
        selected_items = []
        for index in range(self.selectHovetypegrupperWidget.count()):
            item = self.selectHovetypegrupperWidget.item(index)
            if item.checkState() == Qt.Checked:
                selected_items.append({
                    'display_text': item.text(),
                    # Retrieve associated data
                    'kode_id': item.data(Qt.UserRole)
                })

        return selected_items

    def load_mapping_scale_combo_box(self):
        self.selectMappingScale.addItems(
            ["grunntyper", "M005", "M020", "M050"]  # grunntyper becomes default
        )

    def file_location_selected(self):
        '''
        Path handling executed when users pick a file location in
        the file picker widget.
        '''

        file_suffix = ".gpkg"

        selected_path = Path(self.file_widget.filePath()).resolve()  # convert relative path to absolute
        print(selected_path)
        # Check if the directory exists
        if (not selected_path.parent.exists()):
            raise ValueError(
                f"""
                '{selected_path} is not a valid path for a new .gpkg file!
                """
            )
        # Obsolete: Fiel suffix is set after adding the mapping scale to the filename further down
        # # Append .gpkg suffix if necessary. GPKG is set as filter in QtDesigner for the QgsFileWidget
        # if selected_path.suffix != file_suffix:
            # selected_path = selected_path.with_suffix(file_suffix)

        self.geopackage_path = selected_path

    def set_ui_default_values(self):
        '''Defines default values for UI'''

        # Set 'typer' combo box default
        self.comboBox.setCurrentIndex(
            self.comboBox.findText("C-PE-NA Natursystem", Qt.MatchFixedString)
        )

        # Setting default values for QListWidget
        # The items you want to be selected by default
        items_to_select = ["NA-T Fastmarkssystemer"]
        for item_to_select in items_to_select:
            items = self.selectHovetypegrupperWidget.findItems(
                item_to_select, Qt.MatchExactly
            )
            for item in items:
                # This sets the item as selected
                item.setCheckState(Qt.Checked)

    def load_project(self) -> None:
        '''
        Loads project settings
        '''
        crs = ''  #Iniate
        # Alt. 1 Retrieve CRS from radiobutton
        # for i in range(self.horizontalLayoutCRS.count()):
             # widget = self.horizontalLayoutCRS.itemAt(i).widget()
             # if isinstance(widget, QRadioButton) and widget.isChecked():
                 # # print(f"Checked RadioButton: {widget.text()}")
                 # # break
                 # QMessageBox.information(
                        # None,
                        # "Koordinatsystem valgt",
                        # widget.text()
                    # )
                 # return

        # Alt. 2 Retrieve CRS from radiobutton (If The radiobutton text is 'UTM 32 (25832)', then match.group(1) = 25832 i.e. the EPSG-code)
        for radiobutton in self.findChildren(QRadioButton):          # Iterate through all the children of type QRadioButton and check which one is checked
            if radiobutton.isChecked():
                match = re.search(r'\((\d+)\)', radiobutton.text())  # Use regular expression to find the number within parentheses
                crs = "EPSG:" + match.group(1)                      # match.group(1) extract the number from the ()

        # CRS must be chosen
        if crs == '':
            QMessageBox.information(
                None,
                "Intet koordinatsystem valgt",
                "Velg koordinatsystem"
            )
            return
 
        # Retrieve user selection in WMS checkboxes
        wms_settings = {
            box: self.wms_box_group.findChild(QCheckBox, box).isChecked()
            for box in self.wms_check_box_names
        }

        if not self.get_selected_htgr_items():
            QMessageBox.information(
                None,
                "Ingen hovedtypegruppe(r) valgt",
                "Velg hovedtypegruppe(r) som skal kartlegges"
            )
            return

        # passing the selected "Type" from the UI
        # per 11.07.24: type kan ikke settes til NULL (tom)
        if not self.get_selected_type_id():
            QMessageBox.information(
                None,
                "Ingen type valgt",
                "Velg type som skal kartlegges"
            )
            return

        # TODO: remove comments when done testing
        if self.file_widget.filePath():
            self.file_location_selected()
        else:
            QMessageBox.information(
                None,
                "Ingen filsti angitt",
                "Angi lovlig .gpkg-filsti"
            )
            return

        # Including the mapping scale in the filename
        fpath_str = self.file_widget.filePath() # filepath as string
        fpath = Path(fpath_str)                 # filepath as data
        basename = fpath.stem
        path = fpath.parent
        new_fname = basename + "_" + self.selectMappingScale.currentText() + ".gpkg"  # Creates a new filename incl. mapping scale and file suffix (grunntyper is default currentText)
        new_path = path / new_fname             # filepath and filename
        self.geopackage_path = new_path         # Sets the new geopackagefile-path (name and desitination of the gpkg-file to be saved)
        # Print variables to the python-console during testing
        # print(f"filstistreng: {fpath_str}")     # C:\adhoc\aa.gpkg
        # print(f"filsti: {path}")                # C:\adhoc
        # print(f"basenavn: {basename}")          # aa
        # print(f"nytt filnavn: {new_fname}")     # aa_grunntyper.gpkg
        # print(f"ny filsti: {new_path}")         # C:\adhoc\bb_grunntyper.gpkg

        # Run create_gpkg.py
        cgpkg.main(
            selected_mapping_scale=self.selectMappingScale.currentText(),
            gpkg_path=self.geopackage_path,
            proj_crs=crs,
        )

        # Run project_setup.py
        ps.main(
            selected_items=self.get_selected_htgr_items(),
            selected_type_id=self.get_selected_type_id(),
            gpkg_path=self.geopackage_path,
            canvas=self.canvas,
            proj_crs=crs,
            wms_settings=wms_settings,
            selected_mapping_scale=self.selectMappingScale.currentText(),
        )

    def closeEvent(self, event) -> None:
        self.closingPlugin.emit()
        event.accept()
