<?xml version="1.0" encoding="UTF-8"?>
<StyledLayerDescriptor xmlns="http://www.opengis.net/sld" version="1.1.0" xmlns:se="http://www.opengis.net/se" xsi:schemaLocation="http://www.opengis.net/sld http://schemas.opengis.net/sld/1.1.0/StyledLayerDescriptor.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:ogc="http://www.opengis.net/ogc" xmlns:xlink="http://www.w3.org/1999/xlink">
  <NamedLayer>
    <se:Name>Fortøyningsinnretning</se:Name>
    <UserStyle>
      <se:Name>Fortøyningsinnretning</se:Name>
      <se:FeatureTypeStyle>
        <se:Rule>
          <se:Name>Fortøyningsinnretning_ukjent</se:Name>
          <se:Description>
            <se:Title>Fortøyningsinnretning ukjent maksbelastning</se:Title>
          </se:Description>
          <ogc:Filter xmlns:ogc="http://www.opengis.net/ogc">
            <ogc:Or>
                <ogc:PropertyIsNull>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                </ogc:PropertyIsNull>
                <ogc:PropertyIsEqualTo>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>0</ogc:Literal>
                </ogc:PropertyIsEqualTo>
                <ogc:PropertyIsEqualTo>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>9999</ogc:Literal>
                </ogc:PropertyIsEqualTo>
                <ogc:PropertyIsEqualTo>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>-9999</ogc:Literal>
                </ogc:PropertyIsEqualTo>
            </ogc:Or>
          </ogc:Filter>
          <se:MaxScaleDenominator>1500</se:MaxScaleDenominator>
          <se:PointSymbolizer>
            <se:Graphic>
              <!--Parametric SVG-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_graa.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0?fill=%23000000&amp;fill-opacity=1&amp;outline=%23232323&amp;outline-opacity=1&amp;outline-width=0.2" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Plain SVG fallback, no parameters-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_graa.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Well known marker fallback-->
              <se:Mark>
                <se:WellKnownName>square</se:WellKnownName>
                <se:Stroke>
                  <se:SvgParameter name="stroke">#232323</se:SvgParameter>
                  <se:SvgParameter name="stroke-width">0.2</se:SvgParameter>
                </se:Stroke>
              </se:Mark>
              <se:Size>12</se:Size>
            </se:Graphic>
          </se:PointSymbolizer>
        </se:Rule>
        <se:Rule>
          <se:Name>Fortøyningsinnretning_51-999</se:Name>
          <se:Description>
            <se:Title>Fortøyningsinnretning 51-999 tonn</se:Title>
          </se:Description>
          <ogc:Filter xmlns:ogc="http://www.opengis.net/ogc">
            <ogc:And>
                <ogc:PropertyIsGreaterThanOrEqualTo>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>51</ogc:Literal>
                </ogc:PropertyIsGreaterThanOrEqualTo>
                <ogc:PropertyIsLessThan>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>1000</ogc:Literal>
                </ogc:PropertyIsLessThan>
            </ogc:And>
          </ogc:Filter>
          <se:MaxScaleDenominator>1500</se:MaxScaleDenominator>
          <se:PointSymbolizer>
            <se:Graphic>
              <!--Parametric SVG-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_groenn.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0?fill=%23000000&amp;fill-opacity=1&amp;outline=%23232323&amp;outline-opacity=1&amp;outline-width=0.2" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Plain SVG fallback, no parameters-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_groenn.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Well known marker fallback-->
              <se:Mark>
                <se:WellKnownName>square</se:WellKnownName>
                <se:Stroke>
                  <se:SvgParameter name="stroke">#232323</se:SvgParameter>
                  <se:SvgParameter name="stroke-width">0.2</se:SvgParameter>
                </se:Stroke>
              </se:Mark>
              <se:Size>12</se:Size>
            </se:Graphic>
          </se:PointSymbolizer>
        </se:Rule>
        <se:Rule>
          <se:Name>Fortøyningsinnretning_20-50</se:Name>
          <se:Description>
            <se:Title>Fortøyningsinnretning 20-50 tonn</se:Title>
          </se:Description>
          <ogc:Filter xmlns:ogc="http://www.opengis.net/ogc">
            <ogc:And>
                <ogc:PropertyIsGreaterThanOrEqualTo>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>20</ogc:Literal>
                </ogc:PropertyIsGreaterThanOrEqualTo>
                <ogc:PropertyIsLessThan>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>51</ogc:Literal>
                </ogc:PropertyIsLessThan>
            </ogc:And>
          </ogc:Filter>
          <se:MaxScaleDenominator>1500</se:MaxScaleDenominator>
          <se:PointSymbolizer>
            <se:Graphic>
              <!--Parametric SVG-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_blaa.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0?fill=%23000000&amp;fill-opacity=1&amp;outline=%23232323&amp;outline-opacity=1&amp;outline-width=0.2" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Plain SVG fallback, no parameters-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_blaa.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Well known marker fallback-->
              <se:Mark>
                <se:WellKnownName>square</se:WellKnownName>
                <se:Stroke>
                  <se:SvgParameter name="stroke">#232323</se:SvgParameter>
                  <se:SvgParameter name="stroke-width">0.2</se:SvgParameter>
                </se:Stroke>
              </se:Mark>
              <se:Size>12</se:Size>
            </se:Graphic>
          </se:PointSymbolizer>
        </se:Rule>
        <se:Rule>
          <se:Name>Fortøyningsinnretning_1-19</se:Name>
          <se:Description>
            <se:Title>Fortøyningsinnretning 1-19 tonn</se:Title>
          </se:Description>
          <ogc:Filter xmlns:ogc="http://www.opengis.net/ogc">
            <ogc:And>
                <ogc:PropertyIsGreaterThan>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>0</ogc:Literal>
                </ogc:PropertyIsGreaterThan>
                <ogc:PropertyIsLessThan>
                    <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                    <ogc:Literal>20</ogc:Literal>
                </ogc:PropertyIsLessThan>
            </ogc:And>
          </ogc:Filter>
          <se:MaxScaleDenominator>1500</se:MaxScaleDenominator>
          <se:PointSymbolizer>
            <se:Graphic>
              <!--Parametric SVG-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_oransje.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0?fill=%23000000&amp;fill-opacity=1&amp;outline=%23232323&amp;outline-opacity=1&amp;outline-width=0.2" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Plain SVG fallback, no parameters-->
              <se:ExternalGraphic>
                <se:OnlineResource xlink:href="https://register.geonorge.no/symbol/files/havnesymboler/fortoeyningsinnretning_oransje.svg?fill=#2e1edc&amp;fill-opacity=1&amp;outline=#232323&amp;outline-opacity=1&amp;outline-width=0" xlink:type="simple"/>
                <se:Format>image/svg+xml</se:Format>
              </se:ExternalGraphic>
              <!--Well known marker fallback-->
              <se:Mark>
                <se:WellKnownName>square</se:WellKnownName>
                <se:Stroke>
                  <se:SvgParameter name="stroke">#232323</se:SvgParameter>
                  <se:SvgParameter name="stroke-width">0.2</se:SvgParameter>
                </se:Stroke>
              </se:Mark>
              <se:Size>12</se:Size>
            </se:Graphic>
          </se:PointSymbolizer>
        </se:Rule>
      </se:FeatureTypeStyle>
    </UserStyle>
  </NamedLayer>
</StyledLayerDescriptor>
