<StyledLayerDescriptor version="1.1.0" xsi:schemaLocation="http://www.opengis.net/sld http://schemas.opengis.net/sld/1.1.0/StyledLayerDescriptor.xsd"
    xmlns="http://www.opengis.net/sld"
    xmlns:ogc="http://www.opengis.net/ogc"
    xmlns:se="http://www.opengis.net/se"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <NamedLayer>
        <se:Name>havneomrade</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Havneområde</se:Name>
                    <se:MaxScaleDenominator>100000000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#ff0000</se:SvgParameter>
                            <se:SvgParameter name="fill-opacity">0.00</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#505050</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>fender</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Flytefender</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>fendertype</ogc:PropertyName>
                            <ogc:Literal>flytefender</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Ukjent</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>fendertype</ogc:PropertyName>
                            <ogc:Literal>annenFender</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Gruppe 1</se:Name>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Gruppe 2</se:Name>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Gruppe 3</se:Name>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>kaiomrade</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>asfalt/annet</se:Name>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#bfbfbf</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#1f78b4</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>betong</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>kaidekketype</ogc:PropertyName>
                            <ogc:Literal>betong</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#bfbfbf</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#1f78b4</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>stein</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>kaidekketype</ogc:PropertyName>
                            <ogc:Literal>belegningssteinHeller</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#bfbfbf</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#1f78b4</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>tredekke</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>kaidekketype</ogc:PropertyName>
                            <ogc:Literal>tredekke</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#bfbfbf</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#1f78b4</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>lastbegrensningsomrade</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>asfalt/annet, ingen vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#bfbfbf</se:SvgParameter>
                            <se:SvgParameter name="fill-opacity">0.00</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>asfalt, øvre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#b2df8a</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>asfalt, midtre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#a6cee3</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>asfalt, nedre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#fdbf6f</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>betong, ingen vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>betong, øvre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#b2df8a</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#33a02c</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>betong, midtre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#a6cee3</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#1f78b4</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>betong, nedre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#fdbf6f</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#ff7f00</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>stein, ingen vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>stein, øvre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#b2df8a</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#33a02c</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#33a02c</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>stein, midtre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#a6cee3</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#1f78b4</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#1f78b4</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>stein, nedre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#fdbf6f</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#ff7f00</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#ff7f00</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>tredekke, ingen vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#636363</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>tredekke, øvre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#b2df8a</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#33a02c</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>tredekke, midtre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#a6cee3</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#1f78b4</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>tredekke, nedre vekt</se:Name>
                    <se:MaxScaleDenominator>10000.000000</se:MaxScaleDenominator>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#fdbf6f</se:SvgParameter>
                        </se:Fill>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e5031e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:PolygonSymbolizer>
                    <se:PolygonSymbolizer>
                        <se:Fill>
                            <se:SvgParameter name="fill">#ff7f00</se:SvgParameter>
                        </se:Fill>
                    </se:PolygonSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>havnegjerde</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Havnegjerde</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#232323</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Havnegjerde ikke-permanent</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#232323</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:GraphicStroke>
                                <se:Graphic>
                                    <se:Mark>
                                        <se:WellKnownName>circle</se:WellKnownName>
                                        <se:Fill>
                                            <se:SvgParameter name="fill">#f0f0f0</se:SvgParameter>
                                        </se:Fill>
                                    </se:Mark>
                                    <se:Size>5</se:Size>
                                </se:Graphic>
                            </se:GraphicStroke>
                            <se:SvgParameter name="stroke">#f0f0f0</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">5.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:GraphicStroke>
                                <se:Graphic>
                                    <se:Mark>
                                        <se:WellKnownName>circle</se:WellKnownName>
                                        <se:Fill>
                                            <se:SvgParameter name="fill">#f0f0f0</se:SvgParameter>
                                        </se:Fill>
                                    </se:Mark>
                                    <se:Size>5</se:Size>
                                </se:Graphic>
                            </se:GraphicStroke>
                            <se:SvgParameter name="stroke">#f0f0f0</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">5.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>kaiomradegrense</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Kaiområdegrense</se:Name>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#1f78b4</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>lastbegrensningsomradegrense</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Lastbegrensningsområdegrense</se:Name>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#e31a1c</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">1.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>kaifront</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Kaifront</se:Name>
                    <se:MaxScaleDenominator>25000.000000</se:MaxScaleDenominator>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#00416e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">3.00</se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Rampe</se:Name>
                    <se:MaxScaleDenominator>25000.000000</se:MaxScaleDenominator>
                    <se:LineSymbolizer>
                        <se:Stroke>
                            <se:SvgParameter name="stroke">#00416e</se:SvgParameter>
                            <se:SvgParameter name="stroke-width">3.00</se:SvgParameter>
                            <se:SvgParameter name="stroke-dasharray">3.00 5.00 </se:SvgParameter>
                        </se:Stroke>
                    </se:LineSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>fortoyningsinnretning</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Fortøyningsinnretning ukjent maksbelastning</se:Name>
                    <ogc:Filter>
                        <ogc:Or>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>maksbelastning</ogc:PropertyName>
                                <ogc:Literal></ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:Or>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Fortøyningsinnretning 51-999 tonn</se:Name>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Fortøyningsinnretning 20-50 tonn</se:Name>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Fortøyningsinnretning 1-19 tonn</se:Name>
                    <se:MaxScaleDenominator>1500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>kran</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>annen</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>krantype</ogc:PropertyName>
                            <ogc:Literal>annen</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>havnekran</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>krantype</ogc:PropertyName>
                            <ogc:Literal>havnekran</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>mobilkran</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>krantype</ogc:PropertyName>
                            <ogc:Literal>mobilkran</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>el-kobling</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Annen</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Landstrøm</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                            <ogc:Literal>landstrøm</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Strømskap</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                            <ogc:Literal>strømskap</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Ladeanlegg</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                            <ogc:Literal>ladeanlegg</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>VA-uttak</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Annen</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>vauttakstype</ogc:PropertyName>
                            <ogc:Literal>annen</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Ferskvann</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>vauttakstype</ogc:PropertyName>
                            <ogc:Literal>ferskvann</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
   
    <NamedLayer>
        <se:Name>beredskapspunkt</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Fare</se:Name>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Brannvesen</se:Name>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Brannslukking</se:Name>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Varslingssentral</se:Name>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Annen</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>beredskapstype</ogc:PropertyName>
                            <ogc:Literal>annen</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Nødplakat Infopunkt</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>beredskapstype</ogc:PropertyName>
                            <ogc:Literal>nødplakatInfopunkt</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Redningsbøye</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>beredskapstype</ogc:PropertyName>
                            <ogc:Literal>redningsbøye</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Stige</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>beredskapstype</ogc:PropertyName>
                            <ogc:Literal>stige</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Oljelenser</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>beredskapstype</ogc:PropertyName>
                            <ogc:Literal>oljelenser</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Båtshake</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>beredskapstype</ogc:PropertyName>
                            <ogc:Literal>båtshake</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Førstehjelp</se:Name>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Samlingsplass</se:Name>
                    <se:MaxScaleDenominator>2500.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>drivstofftilkobling</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Annen fast</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Bensin fast</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>bensin</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>fast</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>BensinDiesel fast</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>bensinDiesel</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>fast</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Diesel fast</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>diesel</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>fast</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>LNG fast</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>LNG</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>fast</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Annen mobil</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Bensin mobil</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>bensin</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>mobil</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>BensinDiesel fast</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>bensinDiesel</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>mobil</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Diesel mobil</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>diesel</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>mobil</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>LNG mobil</se:Name>
                    <ogc:Filter>
                        <ogc:And>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>drivstofftype</ogc:PropertyName>
                                <ogc:Literal>LNG</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                            <ogc:PropertyIsEqualTo>
                                <ogc:PropertyName>tilkoblingstype</ogc:PropertyName>
                                <ogc:Literal>mobil</ogc:Literal>
                            </ogc:PropertyIsEqualTo>
                        </ogc:And>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
    <NamedLayer>
        <se:Name>avfallspunkt</se:Name>
        <UserStyle>
            <se:FeatureTypeStyle>
                <se:Rule>
                    <se:Name>Annen</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>AsfaltSteinImpregnertTre</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>ElektronikkLyserør</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>PapirPlastGlassMetall</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>FarligAvfall</se:Name>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Matavfall</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>avfallstype</ogc:PropertyName>
                            <ogc:Literal>matavfall</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
                <se:Rule>
                    <se:Name>Mobilt avfallspunkt</se:Name>
                    <ogc:Filter>
                        <ogc:PropertyIsEqualTo>
                            <ogc:PropertyName>avfallstype</ogc:PropertyName>
                            <ogc:Literal>mobil</ogc:Literal>
                        </ogc:PropertyIsEqualTo>
                    </ogc:Filter>
                    <se:MaxScaleDenominator>5000.000000</se:MaxScaleDenominator>
                    <se:PointSymbolizer>
                    </se:PointSymbolizer>
                </se:Rule>
            </se:FeatureTypeStyle>
        </UserStyle>
    </NamedLayer>
</StyledLayerDescriptor>

