# coding: utf-8

"""
    Oppdateringsgrensesnitt for SFKB

    # NGIS-OpenAPI  Grov oversikt over funksjonalitet:   - Hente liste over tilgjengelige datasett    - Hente metadata for et bestemt datasett   - Hente data fra et bestemt datasett     - Med lesetilgang eller skrivetilgang (medfører låsing)       - områdebegrensning       - egenskapsspørring (begrenset i første versjon til bygningsnummer eller lokalid)   - Lagre data til et bestemt datasett     - Operasjoner som håndteres: nytt objekt, endre objekt og slett objekt  ## Generelle prinsipper for systemet  ### Delt geometri  Flater består av avgrensningslinjer som ligger lagret som egne objekter. På den måten kan en linje avgrense ingen, én eller flere flater. Det er likevel slik at flater hentes ut og lagres med egen geometri for å gjøre det enklere å tegne opp datene, men ved endring av (delte) linjer og flater må det tas hensyn til delt geometri. Forsøk på endring av linje eller flate uten tilsvarende endring av evt. delt geometri vil bli avvist av systemet.  ### Låsing  Dette er nærmere beskrevet i de aktuelle kallene.  Foreløpig er det kun `user_lock` som er støttet. Det betyr at data må hentes ut med `user_lock` før de kan sendes inn med endringer.  ### Porsjonering  All uthenting av feature-objekter vil kunne bli porsjonert av serveren, se `limit`-parameteret.   ### Koordinatsystemer og transformasjon  Dersom annet koordinatsystem enn det som ligger i dataset skal brukes (se `GET /datasets/{datasetId}`) må koordinatsystem angis med `crs_EPSG`-parameteret. Dette styrer data som sendes inn, data som hentes ut og koordinatsystemet i `bbox`-parameteret i kallet. For å bytte rekkefølge på aksene brukes `crs_normalized_for_visualization`-parameteret.   # noqa: E501

    OpenAPI spec version: 1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class FeaturesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_dataset_feature(self, x_client_product_version, dataset_id, lokal_id, references, **kwargs):  # noqa: E501
        """Hent ut en bestemt feature fra et dataset  # noqa: E501

        Henter ut en bestemt feature med mulighet for å få med refererte objekter for redigering.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_feature(x_client_product_version, dataset_id, lokal_id, references, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_client_product_version: Brukes for å kunne identifisere klienten som er brukt (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str lokal_id: Identifikasjon.Lokalid til objektet (required)
        :param str references: Angir hvilke refererte features som skal hentes ut i tillegg til feature det spørres direkte etter med lokalid.  Punkter har ingen referanser, og parameteret påvirker derfor ikke uthenting av et punkt.  `none` - Ingen refererte features hentes ut. Ingen ekstra features låses. - Flater får *ikke* med linje-features til avgrensningskurver.  `direct` - Features med direkte referanser hentes ut. Kun direkte referanser låses. - Kurver får med features til flater som bruker kurven i avgrensningen, samt de andre linje-features til avgrensningskurvene i flatene. Både kurven og alle flatene låses, men ikke de andre linje-features i avgrensningen i flatene. - Flater får med alle linje-features til avgrensningskurvene i flaten. Kun flaten låses.  `all` - Features med direkte og indirekte tilhørende referanser hentes ut. Alle referanser som hentes ut låses. - Kurver får i tillegg til referanser fra `direct` også med:   - flate-features som har avgrensningskurver som begynner eller slutter i valgt linjes endepunkter    - linje-features i flate-features i forrige pkt som begynner eller slutter i valgt linjes endepunkter  - Flater får samme referanser som i `direct`. Både flaten og alle avgrensningskurvene låses.  (required)
        :param str locking_type: Angir låsetype som skal brukes (foreløpig er kun `user_lock` støttet). Krever at brukeren har skrivetilgang mot dataset'et.  *user_lock*  Hver bruker har én lås per dataset. Hver gang data hentes ut med `user_lock` legges objektene til denne låsen.  Alle objekter i låsen låses opp neste gang brukeren skriver data til dataset'et.  Låsen vil fjernes neste gang brukeren skriver data til dataset'et med `user_lock`, eller dersom låsen slettes. 
        :param int limit: Angir grense for antall objekter som skal returneres av gangen. Hvert dataset har en øvre grense som vil overstyre det klienten ber om, eller brukes dersom klienten ikke angir dette parameteret.  Dersom resultatet inneholder flere objekter enn grensen, vil responsen inneholde en lenke med `rel=next` i [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header. Denne lenken skal brukes direkte (det er ikke tillatt å tolke lenken ytterligere) for å hente ut neste del av resultatet, som vil være tilsvarende. De siste objektene fra operasjonen er hentet ut når resultatet ikke lenger inneholder en [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header med `rel=next`. 
        :param int crs_epsg: Angir EPSG-kode for koordinatsystemet til koordinatene som sendes inn i spørringen (f.eks i bbox), som sendes inn som data, og som sendes tilbake. Påkrevd dersom bbox-parameteret brukes. 
        :param bool normalized_for_visualization: Angir at rekkefølgen på x- og y-aksen skal være snudd mot det som er spesifisert i EPSG-koden. 
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_feature_with_http_info(x_client_product_version, dataset_id, lokal_id, references, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_feature_with_http_info(x_client_product_version, dataset_id, lokal_id, references, **kwargs)  # noqa: E501
            return data

    def get_dataset_feature_with_http_info(self, x_client_product_version, dataset_id, lokal_id, references, **kwargs):  # noqa: E501
        """Hent ut en bestemt feature fra et dataset  # noqa: E501

        Henter ut en bestemt feature med mulighet for å få med refererte objekter for redigering.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_feature_with_http_info(x_client_product_version, dataset_id, lokal_id, references, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_client_product_version: Brukes for å kunne identifisere klienten som er brukt (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str lokal_id: Identifikasjon.Lokalid til objektet (required)
        :param str references: Angir hvilke refererte features som skal hentes ut i tillegg til feature det spørres direkte etter med lokalid.  Punkter har ingen referanser, og parameteret påvirker derfor ikke uthenting av et punkt.  `none` - Ingen refererte features hentes ut. Ingen ekstra features låses. - Flater får *ikke* med linje-features til avgrensningskurver.  `direct` - Features med direkte referanser hentes ut. Kun direkte referanser låses. - Kurver får med features til flater som bruker kurven i avgrensningen, samt de andre linje-features til avgrensningskurvene i flatene. Både kurven og alle flatene låses, men ikke de andre linje-features i avgrensningen i flatene. - Flater får med alle linje-features til avgrensningskurvene i flaten. Kun flaten låses.  `all` - Features med direkte og indirekte tilhørende referanser hentes ut. Alle referanser som hentes ut låses. - Kurver får i tillegg til referanser fra `direct` også med:   - flate-features som har avgrensningskurver som begynner eller slutter i valgt linjes endepunkter    - linje-features i flate-features i forrige pkt som begynner eller slutter i valgt linjes endepunkter  - Flater får samme referanser som i `direct`. Både flaten og alle avgrensningskurvene låses.  (required)
        :param str locking_type: Angir låsetype som skal brukes (foreløpig er kun `user_lock` støttet). Krever at brukeren har skrivetilgang mot dataset'et.  *user_lock*  Hver bruker har én lås per dataset. Hver gang data hentes ut med `user_lock` legges objektene til denne låsen.  Alle objekter i låsen låses opp neste gang brukeren skriver data til dataset'et.  Låsen vil fjernes neste gang brukeren skriver data til dataset'et med `user_lock`, eller dersom låsen slettes. 
        :param int limit: Angir grense for antall objekter som skal returneres av gangen. Hvert dataset har en øvre grense som vil overstyre det klienten ber om, eller brukes dersom klienten ikke angir dette parameteret.  Dersom resultatet inneholder flere objekter enn grensen, vil responsen inneholde en lenke med `rel=next` i [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header. Denne lenken skal brukes direkte (det er ikke tillatt å tolke lenken ytterligere) for å hente ut neste del av resultatet, som vil være tilsvarende. De siste objektene fra operasjonen er hentet ut når resultatet ikke lenger inneholder en [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header med `rel=next`. 
        :param int crs_epsg: Angir EPSG-kode for koordinatsystemet til koordinatene som sendes inn i spørringen (f.eks i bbox), som sendes inn som data, og som sendes tilbake. Påkrevd dersom bbox-parameteret brukes. 
        :param bool normalized_for_visualization: Angir at rekkefølgen på x- og y-aksen skal være snudd mot det som er spesifisert i EPSG-koden. 
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_client_product_version', 'dataset_id', 'lokal_id', 'references', 'locking_type', 'limit', 'crs_epsg', 'normalized_for_visualization']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_feature" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_client_product_version' is set
        if ('x_client_product_version' not in params or
                params['x_client_product_version'] is None):
            raise ValueError("Missing the required parameter `x_client_product_version` when calling `get_dataset_feature`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_dataset_feature`")  # noqa: E501
        # verify the required parameter 'lokal_id' is set
        if ('lokal_id' not in params or
                params['lokal_id'] is None):
            raise ValueError("Missing the required parameter `lokal_id` when calling `get_dataset_feature`")  # noqa: E501
        # verify the required parameter 'references' is set
        if ('references' not in params or
                params['references'] is None):
            raise ValueError("Missing the required parameter `references` when calling `get_dataset_feature`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'lokal_id' in params:
            path_params['lokalId'] = params['lokal_id']  # noqa: E501

        query_params = []
        if 'locking_type' in params:
            query_params.append(('locking_type', params['locking_type']))  # noqa: E501
        if 'references' in params:
            query_params.append(('references', params['references']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'crs_epsg' in params:
            query_params.append(('crs_EPSG', params['crs_epsg']))  # noqa: E501
        if 'normalized_for_visualization' in params:
            query_params.append(('normalized_for_visualization', params['normalized_for_visualization']))  # noqa: E501

        header_params = {}
        if 'x_client_product_version' in params:
            header_params['X-Client-Product-Version'] = params['x_client_product_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.kartverket.sosi+gml; version=1.0', 'application/vnd.kartverket.sosi+json; version=1.0'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{datasetId}/features/{lokalId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_feature_attributes(self, dataset_id, lokal_id, **kwargs):  # noqa: E501
        """Hent ut egenskapene til en bestemt feature fra et dataset  # noqa: E501

        Henter ut alle egenskapene til en bestemt feature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_feature_attributes(dataset_id, lokal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: UUID of the dataset to get (required)
        :param str lokal_id: Identifikasjon.Lokalid til objektet (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_feature_attributes_with_http_info(dataset_id, lokal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_feature_attributes_with_http_info(dataset_id, lokal_id, **kwargs)  # noqa: E501
            return data

    def get_dataset_feature_attributes_with_http_info(self, dataset_id, lokal_id, **kwargs):  # noqa: E501
        """Hent ut egenskapene til en bestemt feature fra et dataset  # noqa: E501

        Henter ut alle egenskapene til en bestemt feature.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_feature_attributes_with_http_info(dataset_id, lokal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dataset_id: UUID of the dataset to get (required)
        :param str lokal_id: Identifikasjon.Lokalid til objektet (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'lokal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_feature_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_dataset_feature_attributes`")  # noqa: E501
        # verify the required parameter 'lokal_id' is set
        if ('lokal_id' not in params or
                params['lokal_id'] is None):
            raise ValueError("Missing the required parameter `lokal_id` when calling `get_dataset_feature_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'lokal_id' in params:
            path_params['lokalId'] = params['lokal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.kartverket.ngis.attributes+json; version=1.0'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{datasetId}/features/{lokalId}/attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dataset_features(self, x_client_product_version, dataset_id, references, **kwargs):  # noqa: E501
        """Hent ut features fra et dataset  # noqa: E501

        Henter en liste over alle dataset som brukeren har lese- eller skrivetilgang til.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_features(x_client_product_version, dataset_id, references, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_client_product_version: Brukes for å kunne identifisere klienten som er brukt (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str references: Angir hvilke refererte features som skal hentes ut i tillegg til feature det spørres direkte etter med lokalid.  Punkter har ingen referanser, og parameteret påvirker derfor ikke uthenting av et punkt.  `none` - Ingen refererte features hentes ut. Ingen ekstra features låses. - Flater får *ikke* med linje-features til avgrensningskurver.  `direct` - Features med direkte referanser hentes ut. Kun direkte referanser låses. - Kurver får med features til flater som bruker kurven i avgrensningen, samt de andre linje-features til avgrensningskurvene i flatene. Både kurven og alle flatene låses, men ikke de andre linje-features i avgrensningen i flatene. - Flater får med alle linje-features til avgrensningskurvene i flaten. Kun flaten låses.  `all` - Features med direkte og indirekte tilhørende referanser hentes ut. Alle referanser som hentes ut låses. - Kurver får i tillegg til referanser fra `direct` også med:   - flate-features som har avgrensningskurver som begynner eller slutter i valgt linjes endepunkter    - linje-features i flate-features i forrige pkt som begynner eller slutter i valgt linjes endepunkter  - Flater får samme referanser som i `direct`. Både flaten og alle avgrensningskurvene låses.  (required)
        :param str locking_type: Angir låsetype som skal brukes (foreløpig er kun `user_lock` støttet). Krever at brukeren har skrivetilgang mot dataset'et.  *user_lock*  Hver bruker har én lås per dataset. Hver gang data hentes ut med `user_lock` legges objektene til denne låsen.  Alle objekter i låsen låses opp neste gang brukeren skriver data til dataset'et.  Låsen vil fjernes neste gang brukeren skriver data til dataset'et med `user_lock`, eller dersom låsen slettes. 
        :param BoundingBox bbox: Henter ut objekter i et bestemt område (angitt med et rektangel)  Dette kan være aktuelt for å få ut alle objekter som ikke er direkte knyttet til et objekt, som f.eks mønelinje og takkant til en bygning.  Merk: I kombinasjon med `bbox` blir alltid `references` satt til `none` 
        :param int crs_epsg: Angir EPSG-kode for koordinatsystemet til koordinatene som sendes inn i spørringen (f.eks i bbox), som sendes inn som data, og som sendes tilbake. Påkrevd dersom bbox-parameteret brukes. 
        :param bool normalized_for_visualization: Angir at rekkefølgen på x- og y-aksen skal være snudd mot det som er spesifisert i EPSG-koden. 
        :param int limit: Angir grense for antall objekter som skal returneres av gangen. Hvert dataset har en øvre grense som vil overstyre det klienten ber om, eller brukes dersom klienten ikke angir dette parameteret.  Dersom resultatet inneholder flere objekter enn grensen, vil responsen inneholde en lenke med `rel=next` i [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header. Denne lenken skal brukes direkte (det er ikke tillatt å tolke lenken ytterligere) for å hente ut neste del av resultatet, som vil være tilsvarende. De siste objektene fra operasjonen er hentet ut når resultatet ikke lenger inneholder en [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header med `rel=next`. 
        :param str cursor: Brukes til porsjonering av data
        :param str query: ### Filter på egenskaper og/eller objekttype for å begrense hvilke features som hentes ut.  Spørrespråket er basert på [RQL](https://github.com/persvr/rql).  Foreløpig støttes kun `eq` og `in` for bestemte objekttyper og egenskaper.  Eksemplene inneholder alle støttede spørringer. 
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dataset_features_with_http_info(x_client_product_version, dataset_id, references, **kwargs)  # noqa: E501
        else:
            (data) = self.get_dataset_features_with_http_info(x_client_product_version, dataset_id, references, **kwargs)  # noqa: E501
            return data

    def get_dataset_features_with_http_info(self, x_client_product_version, dataset_id, references, **kwargs):  # noqa: E501
        """Hent ut features fra et dataset  # noqa: E501

        Henter en liste over alle dataset som brukeren har lese- eller skrivetilgang til.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dataset_features_with_http_info(x_client_product_version, dataset_id, references, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_client_product_version: Brukes for å kunne identifisere klienten som er brukt (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str references: Angir hvilke refererte features som skal hentes ut i tillegg til feature det spørres direkte etter med lokalid.  Punkter har ingen referanser, og parameteret påvirker derfor ikke uthenting av et punkt.  `none` - Ingen refererte features hentes ut. Ingen ekstra features låses. - Flater får *ikke* med linje-features til avgrensningskurver.  `direct` - Features med direkte referanser hentes ut. Kun direkte referanser låses. - Kurver får med features til flater som bruker kurven i avgrensningen, samt de andre linje-features til avgrensningskurvene i flatene. Både kurven og alle flatene låses, men ikke de andre linje-features i avgrensningen i flatene. - Flater får med alle linje-features til avgrensningskurvene i flaten. Kun flaten låses.  `all` - Features med direkte og indirekte tilhørende referanser hentes ut. Alle referanser som hentes ut låses. - Kurver får i tillegg til referanser fra `direct` også med:   - flate-features som har avgrensningskurver som begynner eller slutter i valgt linjes endepunkter    - linje-features i flate-features i forrige pkt som begynner eller slutter i valgt linjes endepunkter  - Flater får samme referanser som i `direct`. Både flaten og alle avgrensningskurvene låses.  (required)
        :param str locking_type: Angir låsetype som skal brukes (foreløpig er kun `user_lock` støttet). Krever at brukeren har skrivetilgang mot dataset'et.  *user_lock*  Hver bruker har én lås per dataset. Hver gang data hentes ut med `user_lock` legges objektene til denne låsen.  Alle objekter i låsen låses opp neste gang brukeren skriver data til dataset'et.  Låsen vil fjernes neste gang brukeren skriver data til dataset'et med `user_lock`, eller dersom låsen slettes. 
        :param BoundingBox bbox: Henter ut objekter i et bestemt område (angitt med et rektangel)  Dette kan være aktuelt for å få ut alle objekter som ikke er direkte knyttet til et objekt, som f.eks mønelinje og takkant til en bygning.  Merk: I kombinasjon med `bbox` blir alltid `references` satt til `none` 
        :param int crs_epsg: Angir EPSG-kode for koordinatsystemet til koordinatene som sendes inn i spørringen (f.eks i bbox), som sendes inn som data, og som sendes tilbake. Påkrevd dersom bbox-parameteret brukes. 
        :param bool normalized_for_visualization: Angir at rekkefølgen på x- og y-aksen skal være snudd mot det som er spesifisert i EPSG-koden. 
        :param int limit: Angir grense for antall objekter som skal returneres av gangen. Hvert dataset har en øvre grense som vil overstyre det klienten ber om, eller brukes dersom klienten ikke angir dette parameteret.  Dersom resultatet inneholder flere objekter enn grensen, vil responsen inneholde en lenke med `rel=next` i [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header. Denne lenken skal brukes direkte (det er ikke tillatt å tolke lenken ytterligere) for å hente ut neste del av resultatet, som vil være tilsvarende. De siste objektene fra operasjonen er hentet ut når resultatet ikke lenger inneholder en [`Link`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Link)-header med `rel=next`. 
        :param str cursor: Brukes til porsjonering av data
        :param str query: ### Filter på egenskaper og/eller objekttype for å begrense hvilke features som hentes ut.  Spørrespråket er basert på [RQL](https://github.com/persvr/rql).  Foreløpig støttes kun `eq` og `in` for bestemte objekttyper og egenskaper.  Eksemplene inneholder alle støttede spørringer. 
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_client_product_version', 'dataset_id', 'references', 'locking_type', 'bbox', 'crs_epsg', 'normalized_for_visualization', 'limit', 'cursor', 'query']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataset_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'x_client_product_version' is set
        if ('x_client_product_version' not in params or
                params['x_client_product_version'] is None):
            raise ValueError("Missing the required parameter `x_client_product_version` when calling `get_dataset_features`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_dataset_features`")  # noqa: E501
        # verify the required parameter 'references' is set
        if ('references' not in params or
                params['references'] is None):
            raise ValueError("Missing the required parameter `references` when calling `get_dataset_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []
        if 'locking_type' in params:
            query_params.append(('locking_type', params['locking_type']))  # noqa: E501
        if 'bbox' in params:
            query_params.append(('bbox', params['bbox']))  # noqa: E501
        if 'crs_epsg' in params:
            query_params.append(('crs_EPSG', params['crs_epsg']))  # noqa: E501
        if 'normalized_for_visualization' in params:
            query_params.append(('normalized_for_visualization', params['normalized_for_visualization']))  # noqa: E501
        if 'references' in params:
            query_params.append(('references', params['references']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501

        header_params = {}
        if 'x_client_product_version' in params:
            header_params['X-Client-Product-Version'] = params['x_client_product_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.kartverket.sosi+gml; version=1.0', 'application/vnd.kartverket.sosi+json; version=1.0'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{datasetId}/features', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset_feature_attributes(self, body, dataset_id, lokal_id, **kwargs):  # noqa: E501
        """Endre egenskapene til en bestemt feature i et dataset  # noqa: E501

        Oppdaterer alle egenskapene til en bestemt feature i et dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_feature_attributes(body, dataset_id, lokal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str lokal_id: Identifikasjon.Lokalid til objektet (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_feature_attributes_with_http_info(body, dataset_id, lokal_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_feature_attributes_with_http_info(body, dataset_id, lokal_id, **kwargs)  # noqa: E501
            return data

    def update_dataset_feature_attributes_with_http_info(self, body, dataset_id, lokal_id, **kwargs):  # noqa: E501
        """Endre egenskapene til en bestemt feature i et dataset  # noqa: E501

        Oppdaterer alle egenskapene til en bestemt feature i et dataset.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_feature_attributes_with_http_info(body, dataset_id, lokal_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str lokal_id: Identifikasjon.Lokalid til objektet (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id', 'lokal_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset_feature_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_dataset_feature_attributes`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `update_dataset_feature_attributes`")  # noqa: E501
        # verify the required parameter 'lokal_id' is set
        if ('lokal_id' not in params or
                params['lokal_id'] is None):
            raise ValueError("Missing the required parameter `lokal_id` when calling `update_dataset_feature_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'lokal_id' in params:
            path_params['lokalId'] = params['lokal_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.kartverket.ngis.attributes+json; version=1.0'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.kartverket.ngis.attributes+json; version=1.0'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{datasetId}/features/{lokalId}/attributes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dataset_features(self, body, x_client_product_version, dataset_id, **kwargs):  # noqa: E501
        """Endre features i et dataset  # noqa: E501

        Henter en liste over alle dataset som brukeren har lese- eller skrivetilgang til.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_features(body, x_client_product_version, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: Optional description in *Markdown* (required)
        :param str x_client_product_version: Brukes for å kunne identifisere klienten som er brukt (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str locking_type: Angir låsetype som skal brukes (foreløpig er kun `user_lock` støttet). Krever at brukeren har skrivetilgang mot dataset'et.  *user_lock*  Hver bruker har én lås per dataset. Hver gang data hentes ut med `user_lock` legges objektene til denne låsen.  Alle objekter i låsen låses opp neste gang brukeren skriver data til dataset'et.  Låsen vil fjernes neste gang brukeren skriver data til dataset'et med `user_lock`, eller dersom låsen slettes. 
        :param int crs_epsg: Angir EPSG-kode for koordinatsystemet til koordinatene som sendes inn i spørringen (f.eks i bbox), som sendes inn som data, og som sendes tilbake. Påkrevd dersom bbox-parameteret brukes. 
        :param bool normalized_for_visualization: Angir at rekkefølgen på x- og y-aksen skal være snudd mot det som er spesifisert i EPSG-koden. 
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dataset_features_with_http_info(body, x_client_product_version, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dataset_features_with_http_info(body, x_client_product_version, dataset_id, **kwargs)  # noqa: E501
            return data

    def update_dataset_features_with_http_info(self, body, x_client_product_version, dataset_id, **kwargs):  # noqa: E501
        """Endre features i et dataset  # noqa: E501

        Henter en liste over alle dataset som brukeren har lese- eller skrivetilgang til.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dataset_features_with_http_info(body, x_client_product_version, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param object body: Optional description in *Markdown* (required)
        :param str x_client_product_version: Brukes for å kunne identifisere klienten som er brukt (required)
        :param str dataset_id: UUID of the dataset to get (required)
        :param str locking_type: Angir låsetype som skal brukes (foreløpig er kun `user_lock` støttet). Krever at brukeren har skrivetilgang mot dataset'et.  *user_lock*  Hver bruker har én lås per dataset. Hver gang data hentes ut med `user_lock` legges objektene til denne låsen.  Alle objekter i låsen låses opp neste gang brukeren skriver data til dataset'et.  Låsen vil fjernes neste gang brukeren skriver data til dataset'et med `user_lock`, eller dersom låsen slettes. 
        :param int crs_epsg: Angir EPSG-kode for koordinatsystemet til koordinatene som sendes inn i spørringen (f.eks i bbox), som sendes inn som data, og som sendes tilbake. Påkrevd dersom bbox-parameteret brukes. 
        :param bool normalized_for_visualization: Angir at rekkefølgen på x- og y-aksen skal være snudd mot det som er spesifisert i EPSG-koden. 
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'x_client_product_version', 'dataset_id', 'locking_type', 'crs_epsg', 'normalized_for_visualization']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dataset_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_dataset_features`")  # noqa: E501
        # verify the required parameter 'x_client_product_version' is set
        if ('x_client_product_version' not in params or
                params['x_client_product_version'] is None):
            raise ValueError("Missing the required parameter `x_client_product_version` when calling `update_dataset_features`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if ('dataset_id' not in params or
                params['dataset_id'] is None):
            raise ValueError("Missing the required parameter `dataset_id` when calling `update_dataset_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []
        if 'locking_type' in params:
            query_params.append(('locking_type', params['locking_type']))  # noqa: E501
        if 'crs_epsg' in params:
            query_params.append(('crs_EPSG', params['crs_epsg']))  # noqa: E501
        if 'normalized_for_visualization' in params:
            query_params.append(('normalized_for_visualization', params['normalized_for_visualization']))  # noqa: E501

        header_params = {}
        if 'x_client_product_version' in params:
            header_params['X-Client-Product-Version'] = params['x_client_product_version']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.kartverket.ngis.edit_features_summary+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/vnd.kartverket.sosi+wfs-t; version=1.0', 'application/vnd.kartverket.sosi+json; version=1.0'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/datasets/{datasetId}/features', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
