# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.PyQt.QtCore import QCoreApplication,QVariant
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination,
                       QgsSpatialIndex,
                       QgsGeometry,
                       QgsFeature
                       )
import codecs

class ConnecteursGeo(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    STOPS = 'STOPS'
    NOEUDS = 'NOEUDS'
    STOP_ID='STOP_ID'
    NODE_ID='NODE_ID'
    TEXTE_ORI='TEXTE_ORI'
    TEXTE_DES='TEXTE_DES'
    MODE_ORI='MODE_ORI'
    MODE_DES='MODE_DES'
    RAYON='RAYON'
    VITESSE='VITESSE'
    NOMBRE='NOMBRE'
    CONNECTEURS='CONNECTEURS'
    MAX_NB='MAX_NB'
    LONG_0='LONG_0'
    FIELD_SIZE='FIELD_SIZE'
    SYM='SYM'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.STOPS,
                self.tr('Stops'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        self.addParameter(
            QgsProcessingParameterField(
                self.STOP_ID,
                self.tr('Stop_id'),
                parentLayerParameterName=self.STOPS,
                
            )
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.TEXTE_ORI,
                self.tr('i-text'),
                "t"
            )
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.MODE_ORI,
                self.tr('i-mode'),
                "t"
            )             
        )
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.NOEUDS,
                self.tr('Nodes'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        self.addParameter(
            QgsProcessingParameterField(
                self.NODE_ID,
                self.tr('node_id'),
                parentLayerParameterName=self.NOEUDS,
                
            )
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.TEXTE_DES,
                self.tr('j-text'),
                "m"
            ) 
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.MODE_DES,
                self.tr('j-mode'),
                "m"
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.RAYON,
                self.tr('Radius(m)'),
                QgsProcessingParameterNumber.Double,
                defaultValue=1000

                
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.VITESSE,
                self.tr('Speed'),
                QgsProcessingParameterNumber.Double,
                defaultValue=4

                
            )
        )            
        self.addParameter(
            QgsProcessingParameterNumber(
                self.MAX_NB,
                self.tr('Maximum number'),
                QgsProcessingParameterNumber.Integer,
                defaultValue=1

                
            )
        )
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.LONG_0,
                self.tr('Null length connectors'),
                defaultValue=False

                
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.SYM,
                self.tr('Balanced'),
                defaultValue=False

                
            )
        )

        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.CONNECTEURS,
                self.tr('Connectors file'),
                QgsProcessing.TypeVectorLine
                
            )
        )            

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        arrets = self.parameterAsSource(parameters, self.STOPS, context)
        stop_id=self.parameterAsFields(parameters,self.STOP_ID,context)[0]
        noeuds = self.parameterAsSource(parameters, self.NOEUDS, context)
        node_id=self.parameterAsFields(parameters,self.NODE_ID,context)[0]
        mode_i=self.parameterAsString(parameters,self.MODE_ORI,context)
        mode_j=self.parameterAsString(parameters,self.MODE_DES,context)
        texte_i=self.parameterAsString(parameters,self.TEXTE_ORI,context)
        texte_j=self.parameterAsString(parameters,self.TEXTE_DES,context)
        rayon=self.parameterAsDouble(parameters,self.RAYON,context)
        vitesse=self.parameterAsDouble(parameters,self.VITESSE,context)
        nb_max=self.parameterAsInt(parameters,self.MAX_NB,context)
        table_noeuds=self.parameterAsVectorLayer(parameters, self.NOEUDS, context)
        #size=self.parameterAsInt(parameters,self.FIELD_SIZE,context)
        l0=self.parameterAsBool(parameters,self.LONG_0,context)
        sym=self.parameterAsBool(parameters,self.SYM,context)

        # Compute the number of steps to display within the progress bar and
        # get features from source
        ##a=fenetre.split(",")
        ##fenetre2=QgsRectangle(float(a[0]),float(a[2]),float(a[1]),float(a[3]))
        arr=[a for a in arrets.getFeatures()]
        nb=len(arr)
        
        crsSrc = QgsCoordinateReferenceSystem('EPSG:'+str(table_noeuds.crs().postgisSrid()))
        dist_unit=QgsUnitTypes.fromUnitToUnitFactor(crsSrc.mapUnits(),QgsUnitTypes.DistanceMeters)
        rayon=rayon
        
        
        index=QgsSpatialIndex(noeuds.getFeatures())
        index2=QgsSpatialIndex(arrets.getFeatures())
        champs=QgsFields()
        champs.append(QgsField('i',QVariant.String))
        champs.append(QgsField('j',QVariant.String))
        champs.append(QgsField('ij',QVariant.String))
        champs.append(QgsField(self.tr('length'),QVariant.Double))
        champs.append(QgsField(self.tr('time'),QVariant.Double))
        champs.append(QgsField(self.tr('mode'),QVariant.String))

        (table_connecteurs,dest_id) = self.parameterAsSink(parameters, self.CONNECTEURS,context,champs, QgsWkbTypes.LineString, noeuds.sourceCrs())
        nom_fichier=dest_id
        fichier_connecteurs=os.path.splitext(nom_fichier)[0]+".txt"
        sortie=codecs.open(fichier_connecteurs,"w",encoding="utf-8")
        nbc=0
        for i,n in enumerate(arr):
            near=index.nearestNeighbor(n.geometry().centroid().asPoint(),nb_max)
            feedback.setProgress(i*100/nb)
            if len(near)>0:
                for k,nearest in enumerate(near):
                    if k<nb_max:
                        f=noeuds.getFeatures(request=QgsFeatureRequest(nearest))
                        test_sym=1
                        for j, g in enumerate(f):
                            if sym==True:
                                retour=index2.nearestNeighbor(g.geometry().centroid().asPoint(),nb_max)
                                if n.id() not in retour:
                                    test_sym=0
                            if test_sym==1:
                                if j==0:
                                    l=n.geometry().distance(g.geometry())*dist_unit
                                    id_node=str(g.attribute(node_id))
                                    id_stop=str(n.attribute(stop_id))
                                    id_ij=id_stop+'-'+id_node
                                    id_ji=id_node+'-'+id_stop
                                    if l<rayon:
                                        nbc+=1
                                        gline=QgsGeometry.fromPolylineXY([QgsPointXY(n.geometry().centroid().asPoint()),QgsPointXY(g.geometry().centroid().asPoint())])
                                        hline=QgsGeometry.fromPolylineXY([QgsPointXY(g.geometry().centroid().asPoint()),QgsPointXY(n.geometry().centroid().asPoint())])

                                        fline=QgsFeature()
                                        fline.setGeometry(gline)
                                        if l0==True:
                                            ll=0
                                        else:
                                            ll=gline.length()*dist_unit
                                        moda=unicode(mode_i)+unicode(mode_j)
                                        if vitesse<=0:
                                            fline.setAttributes([id_stop,id_node,id_ij, ll/1000,0.0,moda])
                                        else:
                                            fline.setAttributes([id_stop,id_node,id_ij, ll/1000,ll*60/(vitesse*1000),moda])
                                        fline2=QgsFeature()
                                        fline2.setGeometry(hline)
                                        modb=unicode(mode_j)+unicode(mode_i)
                                        if vitesse<=0:
                                            fline2.setAttributes([id_node,id_stop,id_ji, ll/1000,0,modb])
                                        else:
                                            fline2.setAttributes([id_node,id_stop,id_ji, ll/1000,ll*60/(vitesse*1000),modb])
                                        table_connecteurs.addFeature(fline)
                                        table_connecteurs.addFeature(fline2)
                                        if vitesse>0:
                                            sortie.write(id_node+';'+id_stop+';'+str((60/vitesse)*(ll/1000.0))+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+modb+';'+modb+'\n')
                                            sortie.write(id_stop+';'+id_node+';'+str((60/vitesse)*(ll/1000.0))+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+moda+';'+moda+'\n')
                                        else:
                                            sortie.write(id_node+';'+id_stop+';'+str(0.0)+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+modb +';'+modb+'\n')
                                            sortie.write(id_stop+';'+id_node+';'+str(0.0)+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+moda+';'+moda+'\n')
        feedback.setProgressText(unicode(nbc)+"/"+unicode(nb)+self.tr(" connected nodes"))
        sortie.close()
        return {'output': dest_id}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'build_connectors'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Build connectors')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Network')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Network'
		
    def shortHelpString(self):
        return self.tr("""
        Generate a layer of linear objects corresponding to connections between two ponts layers (e.g. PT stops and roads nodes)
        
        Parameters:
            stops : stops layer
			stop_id: stop id
			nodes: nodes layer
			node_id: node id
			radius: search radius(m)
			i-text: text at node i (start node)
			i-mode: mode at node i (start node)
			j-text: text at node j (end node)
			j-mode: mode at node j (end node)
			speed: travel speed on connectors (0= infinite speed)
			connectors file: name of the resulting connectors layer
			NB: the tool generates in the same time a txt file in Musliw format (same name as connectors file with txt extension)
			
        """)
    
    def tr(self, string):
        return QCoreApplication.translate('ConnecteursGeo', string)

    def createInstance(self):
        return ConnecteursGeo()
