# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
import sys
import inspect
import shutil

from qgis.core import QgsProcessingAlgorithm, QgsApplication, QgsSettings
from qgis.PyQt.QtCore import QCoreApplication, QSettings
from qgis.PyQt.QtWidgets import QApplication,QMenu,QAction
from qgis.PyQt.QtGui import QIcon
from .networks_provider import NetworksProvider
cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class NetworksPlugin(object):

    def __init__(self):
        self.provider = None

    def initProcessing(self):
        locale = QSettings().value('locale/userLocale')
        
        if locale==None:
            locale='en'
        else: 
            locale=locale[-2:].lower()
        
        os.chdir(os.path.dirname(__file__))
        
        rep=QgsApplication.qgisSettingsDirPath()
        if rep is not None:
            rep=rep+'/processing/models/'
            os.chdir(rep+'/../../python/plugins/networks')
            test_langue=False
            for i in os.listdir():
                if i.endswith('_{0}.model3'.format(locale)):
                    test_langue=True
            for i in os.listdir():
                if test_langue==True:
                    if i.endswith('_{0}.model3'.format(locale)):
                        shutil.copy(i,rep)
                else:
                    if i.endswith('_en.model3'.format(locale)):
                        shutil.copy(i,rep)
                    
        self.provider=NetworksProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)
    
    def initGui(self):
        self.initProcessing()

    def unload(self):
        try:
            QgsApplication.processingRegistry().removeProvider(self.provider)
        except:
            pass
