# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import datetime
from PyQt5.QtCore import QCoreApplication
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination)
import io
import os 

class IsolatedNodes(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    NOEUDS = 'NOEUDS'
    NODE_ID = 'NODE_ID'
    RESEAU = 'RESEAU'
    NUM_RESEAU='NUM_RESEAU'
    NOEUDS_UTILES='NOEUDS_UTILES'
    
    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.NOEUDS,
                self.tr('Nodes'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        self.addParameter(
            QgsProcessingParameterField(
                self.NODE_ID,
                self.tr('Node Id'),
                parentLayerParameterName=self.NOEUDS
               
            )
        )
        
        self.addParameter(
            QgsProcessingParameterFile(
                self.RESEAU,
                self.tr('Musliw network'),
                extension="TXT"
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.NUM_RESEAU,
                self.tr('Network Id'),
                QgsProcessingParameterNumber.Integer,
                0
            )
        )
       
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.NOEUDS_UTILES,
                self.tr('Connected nodes'),
            )
        )

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """
        
        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        noeuds= self.parameterAsVectorLayer(parameters, self.NOEUDS, context)
        reseau = self.parameterAsFile(parameters, self.RESEAU,context)
        node_id= self.parameterAsFields(parameters, self.NODE_ID,context)[0]
        num_reseau=self.parameterAsInt(parameters, self.NUM_RESEAU,context)
        champs2=noeuds.fields()
        (sortie,dest_id)=self.parameterAsSink(parameters, self.NOEUDS_UTILES,context,champs2, QgsWkbTypes.Point, noeuds.crs())
        
        fichier_reseau=io.open(reseau,encoding="utf-8")
        self.no={}
        
        subnets=[]
        n=0
        res=open(os.path.splitext(dest_id)[0]+".txt","w")
        feedback.setProgressText("Analyse des graphes...")
        for ligne in fichier_reseau:
            e=ligne.split(";")
            if e[0] not in self.no:
                self.no[e[0]]=[e[1]]
            else:
                if e[1] not in self.no[e[0]]:
                    self.no[e[0]].append(e[1])
            if e[1] not in self.no:
                self.no[e[1]]=[e[0]]
            else:
                if e[0] not in self.no[e[1]]:
                    self.no[e[1]].append(e[0])
        for num in self.no:
            s=-1
            for k,subnet in enumerate(subnets):
                if num in subnet:
                    s=k
                    break
            if s==-1:
                subnets.append(set())
                subnets[n].add(num)
                fil=set()
                fil.add(num)
                while len(fil)>0:
                    pivot=fil.pop()
                    for j in self.no[pivot]:
                        if j not in fil and j not in subnets[n]:
                            fil.add(j)
                            subnets[n].add(j)
                n+=1                        
                    
                
        reseaux=sorted(subnets,key=lambda x:len(x), reverse=True)
        nodes=noeuds.getFeatures()
        
        for i in nodes:
            if i[node_id] in reseaux[num_reseau]:
                sortie.addFeature(i)
        feedback.setProgressText("Au total il y a {0} réseaux disjoints".format(len(reseau)))
        for k,i in enumerate(reseaux):
            feedback.setProgressText("Réseau {0}: {1} noeuds connectés".format(k,len(i)))
            res.write(str(k)+" "+str(len(i))+"\n"+str(i)+"\n")
        res.close()
        del sortie            

        return {self.NOEUDS:self.NOEUDS_UTILES}

    def successeurs(self, i):
        subnet=set()
        for j in self.no[i]:
            if j not in subnet:
                subnet.add(j)
                self.successeurs(j)
        return subnet
    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'isolated_nodes'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Isolated nodes')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Network')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Network'

    def tr(self, string):
        return QCoreApplication.translate('IsolatedNodes', string)
        
    def shortHelpString(self):
        return self.tr("""
        Create a layer of connected nodes from a nodes layer (ex: generated by the build graph algorithm) and a Musliw network. The algorithm build the different graphs corresponding to the Musliw network 
        and create a node layer corresponding to the graph having the largest number of nodes. The interest of this algorithm is to analyse the connections of graph and 
        to prevent a Musliw computation based on an isolated node
		
        Parameters:
            Nodes: nodes layer (ex: generated by the build graph algorithm )
			Node id: Field that contains the node Id
            Musliw Network: A Musliw network with corresponding node id corresponding to the nodes layer id
            Network Id: Number of the network graph to select for conencted nodes (networks are sorted by the number of connected nodes. 0 (default value)  is the largest
            Connected nodes: Name of the output nodes layer generated from the graph with the largest number of nodes
            
            
        """)

    def createInstance(self):
        return IsolatedNodes()
