# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import datetime
from PyQt5.QtCore import QCoreApplication
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination)
import codecs
import numpy

class MatrixDoubleList(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    POLES_O = 'POLES_O'
    ID_O = 'ID_O'
    POLES_D = 'POLES_D'
    ID_D = 'ID_D'
    NB_PASSAGERS='NB_PASSAGERS'
    JOUR='JOUR'
    DEBUT_PERIODE='DEBUT_PERIODE'
    FIN_PERIODE='FIN_PERIODE'
    INTERVALLE='INTERVALLE'
    DEPART='DEPART'
    LABEL='LABEL'
    SORTIE='SORTIE'
    
    
    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.POLES_O,
                self.tr('Origins'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterField(
                self.ID_O,
                self.tr('Origins node ID'),
                parentLayerParameterName=self.POLES_O,
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.POLES_D,
                self.tr('Destinations'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        
        self.addParameter(
            QgsProcessingParameterField(
                self.ID_D,
                self.tr('Destinations node ID'),
                parentLayerParameterName=self.POLES_D,
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.NB_PASSAGERS,
                self.tr('Demand'),
                QgsProcessingParameterNumber.Double,
                defaultValue=1.0,
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.JOUR,
                self.tr('Day'),
                QgsProcessingParameterNumber.Integer,
                defaultValue=1,
            )
        )       
        
        self.addParameter(
            QgsProcessingParameterString(
                self.DEBUT_PERIODE,
                self.tr('Start time'),
                defaultValue=str.format("{0}:00:00",datetime.datetime.now().hour)
                
            )
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.FIN_PERIODE,
                self.tr('End time'),
                defaultValue=str.format("{0}:00:00",datetime.datetime.now().hour+1)
                
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.INTERVALLE,
                self.tr('Step'),
                QgsProcessingParameterNumber.Double,
                defaultValue=15,
            )
        )
        self.addParameter(
            QgsProcessingParameterEnum(
                self.DEPART,
                self.tr("Departure/Arrival"),
                [self.tr('Departure'),self.tr('Arrival')],
                defaultValue=0
            )
        )    
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.LABEL,
                self.tr("OD label?"),
                False
            )
        )          

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        self.addParameter(
            QgsProcessingParameterFileDestination(
                self.SORTIE,
                self.tr('Musliw matrix'),
                '*.txt'
            )
        )
        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        nodes_a = self.parameterAsSource(parameters, self.POLES_O, context)
        id_o = self.parameterAsFields(parameters, self.ID_O,context)[0]
        nodes_b= self.parameterAsSource(parameters, self.POLES_D, context)
        id_d = self.parameterAsFields(parameters, self.ID_D,context)[0]
        nb_passagers=self.parameterAsDouble(parameters,self.NB_PASSAGERS,context)
        jour=self.parameterAsInt(parameters,self.JOUR,context)
        h1=self.parameterAsString(parameters,self.DEBUT_PERIODE,context)
        h2=self.parameterAsString(parameters,self.FIN_PERIODE,context)
        intervalle=self.parameterAsDouble(parameters,self.INTERVALLE,context)
        depart=self.parameterAsEnum(parameters,self.DEPART,context)
        label2=self.parameterAsBool(parameters,self.LABEL,context)
        fichier_matrice = self.parameterAsFileOutput(parameters, self.SORTIE,context)

        
        # Compute the number of steps to display within the progress bar and
        # get features from source
        ##a=fenetre.split(",")
        ##fenetre2=QgsRectangle(float(a[0]),float(a[2]),float(a[1]),float(a[3]))
        matrice=open(fichier_matrice,"w")
        if depart==0:
            d="d"
        else:
            d="a"
        h1=h1.strip().split(':')
        h2=h2.strip().split(':')
        debut_periode=int(h1[0])*60.0+int(h1[1])+int(h1[2])/60.0
        fin_periode=int(h2[0])*60.0+int(h2[1])+int(h2[2])/60.0
        
        liste_nodes_a=set()
        liste_nodes_b=set()
        
        feedback.setProgressText(self.tr('writing Musliw matrix...'))
        if d=="d":
            for i in nodes_a.getFeatures():
                liste_nodes_a.add(i[id_o])
            for i in nodes_b.getFeatures():
                liste_nodes_b.add(i[id_d])
            for n,i in enumerate(liste_nodes_a):
                feedback.setProgress(100*n/len(liste_nodes_a))
                for k in numpy.arange(debut_periode,fin_periode,intervalle) :
                    for u,j in enumerate(liste_nodes_b):
                        if label2==True:
                            matrice.write(";".join([str(z) for z in [i,j,nb_passagers,jour,k,d,str(j)+"-"+str(i)]])+"\n")
                        else:
                            matrice.write(";".join([str(z) for z in [i,j,nb_passagers,jour,k,d]])+"\n")
        elif d=="a":
            for i in nodes_a.getFeatures():
                liste_nodes_a.add(i[id_o])
            for i in nodes_b.getFeatures():
                liste_nodes_b.add(i[id_d])
            for n,i in enumerate(liste_nodes_b):
                feedback.setProgress(100*n/len(liste_nodes_b))
                for k in numpy.arange(debut_periode,fin_periode,intervalle) :
                    for u,j in enumerate(liste_nodes_a):
                        if label2==True:
                            matrice.write(";".join([str(z) for z in [j,i,nb_passagers,jour,k,d,str(j)+"-"+str(i)]])+"\n")
                        else:
                            matrice.write(";".join([str(z) for z in [j,i,nb_passagers,jour,k,d]])+"\n")

        matrice.close()
        
          
        return {self.POLES_O:self.POLES_D}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'musliw_matrix_double_list'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Musliw matrix double list')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Matrix')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Matrix'

    def tr(self, string):
        return QCoreApplication.translate('MatrixDoubleList', string)
        
    def shortHelpString(self):
        return self.tr("""
        Generates a Musliw matrix from two point layers and a period of time (from start time to end time with a step in minutes)
        the script generates a rectangular matrix (NxM od). The first layer (N records) corresponds to origins and the second layer (M records) to destinations
		
        Parameters:
            Origins: origin nodes  (corresponding to nodes layer or the graph )
			Origins node id: Field that contains the node Id of the origin nodes
            Destinations: destination nodes  (corresponding to nodes layer or the graph )
			Destinations node id: Field that contains the node Id of the origin nodes
            Demand: number of passengers for assignment
            Day: number of the day in the calendar (1 first day of the calendar)
            Start time: Beginning of the time period
            Step: Step time in minutes
            Departure/Arrival: Departure (from Start point to end point forward) - Arrival (from end point to start point backward)
            OD label: If True an origin-destination ID will be written combining o and d IDs separated by a '-'
            Musliw matrix: Musliw matrix name (text file with ";" separator 
        """)

    def createInstance(self):
        return MatrixDoubleList()
