# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterFile)
import codecs

class Inverser(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    
    RESEAU = 'RESEAU'
    RESULTAT='RESULTAT'
    AJOUTER_AU_RESEAU='AJOUTER_AU_RESEAU'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        
        self.addParameter(
           QgsProcessingParameterVectorLayer(
                self.RESEAU,
                self.tr('Network'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.RESULTAT,
                self.tr('Reverted network'),
                QgsProcessing.TypeVectorLine
                
            )
        )
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.AJOUTER_AU_RESEAU,
                self.tr('Add to network?'),
                False
                
            )
        )

        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).

        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        #couche = self.parameterAsSource(parameters, self.INPUT, context)
        reseau = self.parameterAsVectorLayer(parameters, self.RESEAU, context)
        ajouter_au_reseau=self.parameterAsBool(parameters,self.AJOUTER_AU_RESEAU,context)
        layer=reseau
        features=[i for i in layer.getFeatures()]
        champs=layer.dataProvider().fields()
        noms_champs=[i.name() for i in champs]
        (table_inverse,resultat) = self.parameterAsSink(parameters, self.RESULTAT,context,champs, QgsWkbTypes.LineString, reseau.sourceCrs())
        if ajouter_au_reseau:
            layer.startEditing()
            layer.beginEditCommand(self.tr("Add direction '2'"))
        for f in features:
            geom = f.geometry()
            geom.convertToMultiType()
            nodes = geom.asMultiPolyline()
            nodes.reverse()
            for points in nodes:
                points.reverse() 
            newgeom = QgsGeometry.fromMultiPolylineXY(nodes)
            f.setGeometry(newgeom)
            if 'i' in noms_champs and 'j' in noms_champs:
                k=(f['i'],f['j'])
                f['j'],f['i']=k
                if 'ij' in noms_champs:
                    f['ij']=f['i']+'-'+f['j']
            table_inverse.addFeature(f)
            if ajouter_au_reseau:
                layer.addFeature(f)
        if ajouter_au_reseau:
            layer.endEditCommand()
        return {self.RESULTAT:resultat}



    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'reverse'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Reverse arcs')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Network')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Network'

    def tr(self, string):
        return QCoreApplication.translate('Inverser', string)
        
    def shortHelpString(self):
        return self.tr("""
        Reverse arc directions and update i, j and ij fields to preserve the graph consistency
        
        
        Parameters:
            network : network layer (linear objects)
			reverted network: name of the reverted network layer
            add_to_network: if True adds the reverted network to the initial one
        """)

    def createInstance(self):
        return Inverser()
