# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination,
                       QgsSpatialIndex,
                       QgsGeometry,
                       QgsFeature,
                       QgsCoordinateTransform,
                       QgsCoordinateReferenceSystem
                       )
import codecs

class CreateUpdateLinks(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    RESEAU = 'RESEAU'
    FICHIER_TEMPS = 'FICHIER_TEMPS'
    TEMPS_TERMINAL='TEMPS_TERMINAL'
    WINDOW= 'WINDOW'
    OUTPUT='OUTPUT'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        #e=iface.mapCanvas().extent()
        #etendue=str(tuple([e.xMinimum(),e.xMaximum(), e.yMinimum(), e.yMaximum()]))[1:-1]
        

        self.addParameter(
            QgsProcessingParameterVectorLayer(
                self.RESEAU,
                self.tr('Network'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        self.addParameter(
            QgsProcessingParameterFile(
                self.FICHIER_TEMPS,
                self.tr('Travel times file'),
            )
        )
        self.addParameter(
            QgsProcessingParameterExtent(
                self.WINDOW,
                self.tr('Extent'),
                #etendue
            )
        )
            

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.TEMPS_TERMINAL,
                self.tr('Initial/final waiting time?'),
                False
            )
        )
        
        
        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.OUTPUT,
                self.tr('Result network'),
                QgsProcessing.TypeVectorLine
                
            )
        )
        

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        reseau = self.parameterAsVectorLayer(parameters, self.RESEAU, context)
        fichier_temps=self.parameterAsFile(parameters,self.FICHIER_TEMPS,context)
        temps_terminal = self.parameterAsBool(parameters, self.TEMPS_TERMINAL, context)
        fenetre_source=self.parameterAsExtent(parameters,self.WINDOW, context)
        
        champs=reseau.fields()
        noms_champs=[]
        #lecture du nom des champs
        for f in champs:
            noms_champs.append(f.name())

        #ajout des champs ti et tj s'ils ne font pas partie de la liste de champs
        champs2=reseau.fields()
        if u"ti" not in noms_champs:
            champs2.append(QgsField("ti",QVariant.Double))
        if u"tj" not in noms_champs:
            champs2.append(QgsField("tj",QVariant.Double))
        if  u"ij" not in noms_champs:
            champ2.append(QgsField("ij",QVariant.String))
            
        #initialisation de la table sortie
        (resultat,dest_id) = self.parameterAsSink(parameters, self.OUTPUT,context,champs2, QgsWkbTypes.MultiLineString, reseau.crs())
        

        fichier=codecs.open(fichier_temps,"r","utf-8")
        simple=QgsSimplifyMethod()
        simple.setMethodType(QgsSimplifyMethod.PreserveTopology)
        simple.setThreshold(5)
        
        src=QgsProject.instance().crs()
        dest=QgsCoordinateReferenceSystem(reseau.crs())
        xtr=QgsCoordinateTransform(src,dest,QgsProject.instance())
        fenetre=xtr.transformBoundingBox(fenetre_source)

        request=(QgsFeatureRequest().setFilterRect(fenetre).setSimplifyMethod(simple))



            #reseau.addAttribute(QgsField("ij",QVariant.String))





        colonnes={}
        links={}
        for k,i in enumerate(fichier):
            elements=i.strip('\n').strip("\r").split(";")
            ncols=len(elements)
            if k==0:
                for j in range(ncols):
                    colonnes[elements[j]]=j
            else:
                t=elements[colonnes["temps"]].replace(",",".")
                u=elements[colonnes["ti"]].replace(",",".")
                ij=elements[colonnes["ij"]]
                if temps_terminal==False:
                    if str(ij) not in links:
                        links[str(ij)]=(1e38,0,1e38)
                    if float(t)<links[str(ij)][0]:
                        links[str(ij)]=(float(t),0,float(u))
                else:
                    if str(ij) not in links:
                        links[str(ij)]=(1e38,0)
                    tatt1=elements[colonnes["tatt1"]].replace(",",".")
                    if float(t)-float(tatt1)<links[str(ij)][0]-links[str(ij)][1]:
                        links[str(ij)]=(float(t),float(tatt1),float(u))
        fichier.close()

        n=reseau.featureCount()
        feedback.setProgressText(self.tr("updating ti and tj..."))

        valid={}

        for k,f in enumerate(reseau.getFeatures(request)):
            feedback.setProgress((k+1)*100/n)
            res=QgsFeature(champs2)
            num=f.id()
            for ch in noms_champs:
                res[ch]=f[ch]
            res.setGeometry(f.geometry())
            #temps=float(f["temps"])
            ij=f["i"]+'-'+f["j"]
            res['ij']=ij
            if ij in links:
                ti=links[f["ij"]][0]-links[f["ij"]][1]
                tj=links[f["ij"]][2]-links[f["ij"]][1]
                """if start==0:
                    valid={ida : tj, idb: ti}
                    reseau.changeAttributeValues(num,valid)
                    #reseau.changeAttributeValue(num, reseau.dataProvider().fieldNameMap()[champ_tj],ti)
                    #reseau.changeAttributeValue(num, reseau.dataProvider().fieldNameMap()[champ_ti],ti-temps)
                else:"""
                res['tj']=ti
                res['ti']=tj
                #valid={ida : tj, idb : ti}
                #reseau.changeAttributeValues(num,valid)
                #reseau.changeAttributeValue(num, reseau.dataProvider().fieldNameMap()[champ_ti],ti)
                #reseau.changeAttributeValue(num, reseau.dataProvider().fieldNameMap()[champ_tj],ti-temps)
            else:
                ti=NULL
                res['tj']=ti
                res['ti']=ti
                #valid={ida : ti, idb : ti}
                #reseau.changeAttributeValues(num,valid)
                
                #reseau.changeAttributeValue(num, reseau.dataProvider().fieldNameMap()[champ_ti],ti)
                #reseau.changeAttributeValue(num, reseau.dataProvider().fieldNameMap()[champ_tj],ti)
            resultat.addFeature(res)

            feedback.setProgress((k+1)*100/n)            



        feedback.setProgress(100)     
        return {self.RESEAU: reseau.sourceName()}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'create_update_links'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr("Create updated links")

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Network')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Network'

    def tr(self, string):
        return QCoreApplication.translate('CreateUpdateLinks', string)
        
    def shortHelpString(self):
        return self.tr("""
        Read the travel times file ".._temps.txt" computed by Musliw and creates a the network layer with i-node and j-node travel times from travel time file included
		        
        Parameters:
            layer : network layer (linear objects)
			travel times file: travel times text file ..._temps.txt generated by Musliw
            extent: window that defines the updated links  (only those inside the window)
            departure/arrival: departure if "d" in Musliw matrix, arrival if "a"
            initial/final waiting time: in order to take into account or not inital/final waiting time (tatt1)
            result network: name of the network layer subset with updated travel times (ti & tj)
        """)
    def createInstance(self):
        return CreateUpdateLinks()
