# -*- coding: utf-8 -*-
import subprocess
import os,sys,stat
import processing
import gc

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterEnum,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterVectorLayer,
                       QgsProcessingParameterFileDestination,
                       QgsProcessingParameterFile)
import codecs

class CalculMusliw(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.
    
    RESEAU = 'RESEAU'
    MATRICE='MATRICE'
    PARAMETRES='PARAMETRES'
    PENALITES='PENALTIES'
    SORTIE='SORTIE'
    DOWNLOAD='DOWNLOAD'
    WAIT='WAIT'
    
    
    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """
        
        self.addParameter(
            QgsProcessingParameterFile(
                self.RESEAU,
                self.tr('Musliw network')
            )
        )
        self.addParameter(
            QgsProcessingParameterFile(
                self.MATRICE,
                self.tr('Musliw matrix')
            )
        )
        self.addParameter(
            QgsProcessingParameterFile(
                self.PARAMETRES,
                self.tr('Musliw parameters')
            )
        )
        self.addParameter(
            QgsProcessingParameterFile(
                self.PENALITES,
                self.tr('Musliw penalties'),
                optional=True
            )
        )
        self.addParameter(
            QgsProcessingParameterFileDestination(
                self.SORTIE,
                self.tr('Output'),
                "*.txt"
                
            )
        )
        
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.DOWNLOAD,
                self.tr('Accept to download Musliw binary from Github'),
                False
            )
        )

        self.addParameter(
            QgsProcessingParameterBoolean(
                self.WAIT,
                self.tr('Force waiting the end of calculations'),
                True
            )
        )
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).

        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        #couche = self.parameterAsSource(parameters, self.INPUT, context)
        reseau = self.parameterAsFile(parameters, self.RESEAU, context)
        matrice = self.parameterAsFile(parameters, self.MATRICE, context)
        parametres = self.parameterAsFile(parameters, self.PARAMETRES, context)
        penalites = self.parameterAsFile(parameters, self.PENALITES, context)
        sortie=os.path.splitext(self.parameterAsFileOutput(parameters, self.SORTIE, context))[0]
        download=self.parameterAsBool(parameters,self.DOWNLOAD,context)
        wait=self.parameterAsBool(parameters,self.WAIT,context)
        
        if download==True:
            feedback.setProgressText(self.tr("Downloading Muslic binary"))
            processing.run("native:filedownloader", {'URL':'https://github.com/crocovert/muslic/raw/master/Muslic/bin/x64/Release/Muslic.exe','OUTPUT':os.path.dirname(__file__)+"/Muslic.exe"})
            feedback.setProgressText(self.tr("Muslic downloaded succesfully"))
        
        
        if sys.platform.startswith('win'):
            prog=os.path.dirname(__file__)+"/Muslic.exe"
            cmd=[prog,reseau,matrice,sortie,parametres]

        elif sys.platform.startswith('linux'):
            prog=os.path.join(os.path.dirname(__file__),"Muslic.exe")
            st = os.stat(prog)
            os.chmod(prog, st.st_mode | stat.S_IEXEC)
            cmd=["mono",prog,reseau,matrice,sortie,parametres]


      
        CREATE_NO_WINDOW = 0x08000000
        DETACHED_PROCESS = 0x00000008
        feedback.setProgressText(self.tr("Multimodal calculations... That could take some time"))
        if len(penalites)==0:
            musliw_test=subprocess.Popen(cmd)
        else:
            cmd.append(penalites)
            feedback.setProgressText(str(cmd))
            musliw_test=subprocess.Popen(cmd)
        if wait==True:
            musliw_test.wait()
        gc.collect()
        return {'SORTIE': sortie}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'musliw_calculation'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Musliw computation')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Computations')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Computations'

    def tr(self, string):
        return QCoreApplication.translate('CalculMusliw', string)
	
    def shortHelpString(self):
        return self.tr("""
        Perform a calculation of multimodal accessibility and routing
		Can download the Muslic.exe binary for multimodal routing and accessibility computation (if checked)
        Produce output files (semi-column separated files (if selected in parameters):
        . Origin destination results file "_od.txt"
        . Cumulative times on arcs "_temps.txt" (usefull for isochron maps)
        . Detailed paths "_chemins.txt" 
        . Assignment results file on links "_aff.txt"
        . Log file "_log.txt"
        . Parameters files "_param.txt"
        . results on services "_services.txt"
        . cumulative times on nodes "_noeuds.txt"
        
        Parameters:
            network : Musliw network
            matrix: Musliw matrix
            parameters: Musliw parameters
            penalties: Musliw penalties and transfers file
			output : Mulsiw results file (without extension)
            Accept to download Muslic binary: If checked, the algorithm will download Muslic.exe on the github repository
        """)

    def createInstance(self):
        return CalculMusliw()
