# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Networks
                                 A QGIS plugin
 Networks
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-02-26
        copyright            : (C) 2018 by Patrick Palmier
        email                : patrick.palmier@cerema.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Patrick Palmier'
__date__ = '2018-02-26'
__copyright__ = '(C) 2018 by Patrick Palmier'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from PyQt5.QtCore import QCoreApplication,QVariant
from qgis.core import *
from qgis.utils import *
from qgis.core import (QgsProcessing,
                       QgsFeatureSink,
                       QgsProcessingAlgorithm,
                       QgsProcessingParameterFeatureSource,
                       QgsProcessingParameterFeatureSink,
                       QgsProcessingParameterNumber,
                       QgsProcessingParameterBoolean,
                       QgsProcessingParameterString,
                       QgsProcessingParameterExtent,
                       QgsProcessingParameterField,
                       QgsProcessingParameterExpression,
                       QgsProcessingParameterFileDestination,
                       QgsSpatialIndex,
                       QgsGeometry,
                       QgsFeature
                       )
import codecs

class AutoConnecteurs(QgsProcessingAlgorithm):
    """
    This is an example algorithm that takes a vector layer and
    creates a new identical one.

    It is meant to be used as an example of how to create your own
    algorithms and explain methods and variables used to do it. An
    algorithm like this will be available in all elements, and there
    is not need for additional work.

    All Processing algorithms should extend the QgsProcessingAlgorithm
    class.
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    OUTPUT = 'OUTPUT'
    NODES = 'NODES'
    NODE_ID='NODE_ID'
    MODE='MODE'
    RAYON='RAYON'
    VITESSE='VITESSE'
    CONNECTEURS='CONNECTEURS'

    def initAlgorithm(self, config):
        """
        Here we define the inputs and output of the algorithm, along
        with some other properties.
        """

        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.NODES,
                self.tr('Nodes'),
                [QgsProcessing.TypeVectorPoint]
            )
        )
        self.addParameter(
            QgsProcessingParameterField(
                self.NODE_ID,
                self.tr('node_id'),
                parentLayerParameterName=self.NODES,
                type=QgsProcessingParameterField.String
            )
        )
        self.addParameter(
            QgsProcessingParameterString(
                self.MODE,
                self.tr('mode'),
                "m"
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.RAYON,
                self.tr('Radius(m)'),
                QgsProcessingParameterNumber.Double,
                defaultValue=1000

                
            )
        )
        self.addParameter(
            QgsProcessingParameterNumber(
                self.VITESSE,
                self.tr('Speed'),
                QgsProcessingParameterNumber.Double,
                defaultValue=4

                
            )
        )            

        self.addParameter(
            QgsProcessingParameterFeatureSink(
                self.CONNECTEURS,
                self.tr('Connectors file'),
                QgsProcessing.TypeVectorLine
                
            )
        )            

        # We add a feature sink in which to store our processed features (this
        # usually takes the form of a newly created vector layer when the
        # algorithm is run in QGIS).
        

    def processAlgorithm(self, parameters, context, feedback):
        """
        Here is where the processing itself takes place.
        """

        # Retrieve the feature source and sink. The 'dest_id' variable is used
        # to uniquely identify the feature sink, and must be included in the
        # dictionary returned by the processAlgorithm function.
        noeuds = self.parameterAsSource(parameters, self.NODES, context)
        num=self.parameterAsFields(parameters,self.NODE_ID,context)[0]
        mode=self.parameterAsString(parameters,self.MODE,context)
        rayon=self.parameterAsDouble(parameters,self.RAYON,context)
        vitesse=self.parameterAsDouble(parameters,self.VITESSE,context)

        # Compute the number of steps to display within the progress bar and
        # get features from source
        ##a=fenetre.split(",")
        ##fenetre2=QgsRectangle(float(a[0]),float(a[2]),float(a[1]),float(a[3]))
        
        index=QgsSpatialIndex(noeuds.getFeatures())
        champs=QgsFields()
        champs.append(QgsField('i',QVariant.String,len=15))
        champs.append(QgsField('j',QVariant.String,len=15))
        champs.append(QgsField('longueur',QVariant.Double))
        champs.append(QgsField('temps',QVariant.Double))
        champs.append(QgsField('mode',QVariant.String,len=10))
        f={feature.id(): feature for (feature) in noeuds.getFeatures()}

        (table_connecteurs,dest_id) = self.parameterAsSink(parameters, self.CONNECTEURS,context,champs, QgsWkbTypes.LineString, noeuds.sourceCrs())
        nom_fichier=dest_id
        fichier_connecteurs=os.path.splitext(nom_fichier)[0]+".txt"
        sortie=codecs.open(fichier_connecteurs,"w",encoding="utf-8")
        nb=len(f)
        nbc=0
        for i,n in enumerate(noeuds.getFeatures()):
            near=index.intersects(QgsRectangle(n.geometry().buffer(rayon,12).boundingBox()))
            feedback.setProgress(i*100/nb)
            if len(near)>0:
                for fid in near:
                    g=f[fid]
                    if not(n[num]==g[num]):
                        l=n.geometry().distance(g.geometry())
                        id_node=unicode(g.attribute(num))
                        id_stop=unicode(n.attribute(num))
                        if l<rayon:
                            nbc+=1
                            gline=QgsGeometry.fromPolylineXY([QgsPointXY(n.geometry().centroid().asPoint()),QgsPointXY(g.geometry().centroid().asPoint())])
                            hline=QgsGeometry.fromPolylineXY([QgsPointXY(g.geometry().centroid().asPoint()),QgsPointXY(n.geometry().centroid().asPoint())])

                            fline=QgsFeature()
                            fline.setGeometry(gline)
                            ll=gline.length()
                            mode=unicode(mode)
                            if vitesse<=0:
                                fline.setAttributes([id_stop,id_node, ll/1000,0,mode])
                            else:
                                fline.setAttributes([id_stop,id_node, ll/1000,ll*60/(vitesse*1000),mode])
                            table_connecteurs.addFeature(fline)
                            if vitesse>0:
                                sortie.write(id_node+';'+id_stop+';'+str((60/vitesse)*(ll/1000.0))+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+mode+';'+mode+'\n')
                                sortie.write(id_stop+';'+id_node+';'+str((60/vitesse)*(ll/1000.0))+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+mode+';'+mode+'\n')
                            else:
                                sortie.write(id_node+';'+id_stop+';'+str(0.0)+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+mode +';'+mode+'\n')
                                sortie.write(id_stop+';'+id_node+';'+str(0.0)+';'+str(ll/1000.0)+';-1;-1;-1;-1;-1;'+mode+';'+mode+'\n')


        
        feedback.setProgressText(unicode(nbc)+"/"+unicode(nb)+self.tr(" connected nodes"))
        sortie.close()
        return {self.OUTPUT: dest_id}


    def name(self):
        """
        Returns the algorithm name, used for identifying the algorithm. This
        string should be fixed for the algorithm, and must not be localised.
        The name should be unique within each provider. Names should contain
        lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'auto_connectors'

    def displayName(self):
        """
        Returns the translated algorithm name, which should be used for any
        user-visible display of the algorithm name.
        """
        return self.tr('Auto-connectors')

    def group(self):
        """
        Returns the name of the group this algorithm belongs to. This string
        should be localised.
        """
        return self.tr('Network')

    def groupId(self):
        """
        Returns the unique ID of the group this algorithm belongs to. This
        string should be fixed for the algorithm, and must not be localised.
        The group id should be unique within each provider. Group id should
        contain lowercase alphanumeric characters only and no spaces or other
        formatting characters.
        """
        return 'Network'
		
    def shortHelpString(self):
        return self.tr("""
        Generate a layer of linear objects corresponding to connections between points closest within a layer (e.g. PT stops)
        
        Parameters:
            nodes : nodes layer
			node_id: node id
			radius: search radius(m)
			mode: mode at node
			speed: travel speed on connectors (0= infinite speed)
			connectors file: name of the resulting connectors layer
			NB: the tool generates in the same time a txt file in Musliw format (same name as connectors file with txt extension)
			
        """)
    
    def tr(self, string):
        return QCoreApplication.translate('AutoConnecteurs', string)

    def createInstance(self):
        return AutoConnecteurs()
