# -*- coding: utf-8 -*-

"""
/***************************************************************************
 NetworkGT
                                 A QGIS plugin
 The NetworkGT (Network Geometry and Typology) Toolbox is a set of tools designed for the geometric and topological analysis of fracture networks.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-08-22
        copyright            : (C) 2019 by Bjorn Nyberg
        email                : bjorn.nyberg@uib.no
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Bjorn Nyberg'
__date__ = '2019-08-22'
__copyright__ = '(C) 2019 by Bjorn Nyberg'

__revision__ = '$Format:%H$'

import os
from qgis.core import QgsProcessingProvider
from qgis.PyQt.QtGui import QIcon

#Install
from .networkgt.configureNetworkGT import configureNetworkGT

#Sampling Tools
from .networkgt.sampling.Simple_Grid import ContourGrid
from .networkgt.sampling.Simple_Line_Grid import LineGrid

#Geometry Tools
from .networkgt.geometry.Line_Frequency import LineFrequency
from .networkgt.geometry.Distribution_Analysis import DistributionAnalysis
from .networkgt.geometry.Sets import Sets
from .networkgt.geometry.rose_diagrams import RoseDiagrams
from .networkgt.geometry.Histogram import Histogram
from .networkgt.geometry.Tortuosity import Tortuosity

#Topology Tools
from .networkgt.topology.TB import TBlocks
from .networkgt.topology.BI import IBlocks
from .networkgt.topology.Clusters import Clusters
from .networkgt.topology.Topology_Parameters import TopologyParameters
from .networkgt.topology.Branches_Nodes import BranchesNodes
from .networkgt.topology.ShortestPathway import ShortestPathway

#Digitising Tools
from .networkgt.digitising.SnapYNodes import SnapYNodes
from .networkgt.digitising.SnapNodes import SnapNodes
from .networkgt.digitising.Fracture_Number import Fracture_Lines
from .networkgt.digitising.Repair import RepairTool
from .networkgt.digitising.Fracture_Network import Fracture_Network
from .networkgt.digitising.Thresholding import Thresholding
from .networkgt.digitising.Extend_Trim import ExtendTrim
from .networkgt.digitising.SimplifyNetwork import SimplifyNetwork

#Flow Tools
from .networkgt.flow.Flow1D import Flow1D
from .networkgt.flow.Flow2D import Flow2D
from .networkgt.flow.permTensor import permTensor
from .networkgt.flow.permTensorPlot import permTensorPlot
from .networkgt.flow.percolation import Percolation
from .networkgt.flow.aperture import Aperture

class NetworkGTProvider(QgsProcessingProvider):

    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(configureNetworkGT())
        self.addAlgorithm(TopologyParameters())
        self.addAlgorithm(BranchesNodes())
        self.addAlgorithm(DistributionAnalysis())
        self.addAlgorithm(LineFrequency())
        self.addAlgorithm(LineGrid())
        self.addAlgorithm(ContourGrid())
        self.addAlgorithm(Sets())
        self.addAlgorithm(RoseDiagrams())
        self.addAlgorithm(TBlocks())
        self.addAlgorithm(IBlocks())
        self.addAlgorithm(Clusters())
        self.addAlgorithm(RepairTool())
        self.addAlgorithm(SnapNodes())
        self.addAlgorithm(SnapYNodes())
        self.addAlgorithm(Histogram())
        self.addAlgorithm(Tortuosity())
        self.addAlgorithm(ShortestPathway())
        self.addAlgorithm(Flow1D())
        self.addAlgorithm(Flow2D())
        self.addAlgorithm(Fracture_Network())
        self.addAlgorithm(Fracture_Lines())
        self.addAlgorithm(Aperture())
        self.addAlgorithm(permTensor())
        self.addAlgorithm(permTensorPlot())
        self.addAlgorithm(Percolation())
        self.addAlgorithm(ExtendTrim())
        self.addAlgorithm(Thresholding())
        self.addAlgorithm(SimplifyNetwork())


    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'NetworkGT'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('NetworkGT')

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        iconPath = os.path.join( os.path.dirname(__file__),'icons', 'icon.png')
        return QIcon(iconPath)

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
