# -*- coding: utf-8 -*-

"""
/***************************************************************************
 kisters_processing
                                 A QGIS plugin
 This is the processing toolkit for the network store
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2022-05-28
        copyright            : (C) 2022 by Attila Bibok / KISTERS North America
        email                : attila.bibok@kisters.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = "Attila Bibok / KISTERS North America"
__date__ = "2022-05-28"
__copyright__ = "(C) 2022 by Attila Bibok / KISTERS North America"

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = "$Format:%H$"

from qgis.core import QgsProcessingProvider
from .kisters_processing_model_generation import (
    kisters_processingAlgorithm,
    kisters_processingGenerateMappings,
)

from .kisters_processing_network_store import (
    NetworkLoadFromStoreAlgorithm,
    NetworkCreateInStoreAlgorithm,
    NetworkExportAlgorithm,
    NetworkDeleteInStoreAlgorithm,
)

from .kisters_processing_datasphere import DataSphereLoadRasterAlgorithm
from .kisters_processing_datasphere import (
    DatasphereBuildClassificationLayersAlgorithm,
    DatasphereLoadLocationsAlgorithm,
)
from .kisters_processing_settings import (
    ArrayStorageSaveConfigAlgorithm,
    ArrayStorageDeleteConfigAlgorithm,
    DatasphereSaveConfigAlgorithm,
    DatasphereDeleteConfigAlgorithm,
    NetworkStoreSaveConfigAlgorithm,
    NetworkStoreDeleteConfigAlgorithm,
)

from .kisters_processing_arraystorage import (
    ArrayStorageLoadRasterAlgorithm,
    ArrayStorageListTimeseriesAlgorithm,
    ArrayStorageListTimestampsAlgorithm,
    ArrayStorageDeleteMetaAlgorithm,
    ArrayStorageDeleteDataAlgorithm,
    ArrayStorageUploadClassificationAlgorithm,
    ArrayStorageListClassificationsAlgorithm,
    ArrayStorageDeleteClassificationAlgorithm,
    ArrayStorageBuildClassificationLayersAlgorithm,
)


from qgis.PyQt.QtGui import QIcon
import os

pluginPath = os.path.dirname(__file__)


class kisters_processingProvider(QgsProcessingProvider):
    def __init__(self):
        """
        Default constructor.
        """
        QgsProcessingProvider.__init__(self)

    def unload(self):
        """
        Unloads the provider. Any tear-down steps required by the provider
        should be implemented here.
        """
        pass

    def loadAlgorithms(self):
        """
        Loads all algorithms belonging to this provider.
        """
        self.addAlgorithm(kisters_processingAlgorithm())
        # add additional algorithms here
        self.addAlgorithm(kisters_processingGenerateMappings())

        # network store
        self.addAlgorithm(NetworkLoadFromStoreAlgorithm())
        self.addAlgorithm(NetworkCreateInStoreAlgorithm())
        self.addAlgorithm(NetworkExportAlgorithm())
        self.addAlgorithm(NetworkDeleteInStoreAlgorithm())

        # Datasphere
        self.addAlgorithm(DataSphereLoadRasterAlgorithm())
        self.addAlgorithm(DatasphereBuildClassificationLayersAlgorithm())
        self.addAlgorithm(DatasphereLoadLocationsAlgorithm())
        # Settings
        self.addAlgorithm(ArrayStorageSaveConfigAlgorithm())
        self.addAlgorithm(ArrayStorageDeleteConfigAlgorithm())
        self.addAlgorithm(DatasphereSaveConfigAlgorithm())
        self.addAlgorithm(NetworkStoreSaveConfigAlgorithm())
        self.addAlgorithm(DatasphereDeleteConfigAlgorithm())
        self.addAlgorithm(NetworkStoreDeleteConfigAlgorithm())

        # Arraystorage
        # ArrayStorage
        self.addAlgorithm(ArrayStorageLoadRasterAlgorithm())
        self.addAlgorithm(ArrayStorageListTimeseriesAlgorithm())
        self.addAlgorithm(ArrayStorageListTimestampsAlgorithm())
        self.addAlgorithm(ArrayStorageDeleteMetaAlgorithm())
        self.addAlgorithm(ArrayStorageDeleteDataAlgorithm())
        self.addAlgorithm(ArrayStorageUploadClassificationAlgorithm())
        self.addAlgorithm(ArrayStorageListClassificationsAlgorithm())
        self.addAlgorithm(ArrayStorageDeleteClassificationAlgorithm())
        self.addAlgorithm(ArrayStorageBuildClassificationLayersAlgorithm())

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return "Kisters"

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr("Kisters")

    def icon(self):
        """
        Should return a QIcon which is used for your provider inside
        the Processing toolbox.
        """
        return QIcon(os.path.join(pluginPath, "icon.png"))

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()
