import { defineConfig } from 'vite'
import { svelte } from '@sveltejs/vite-plugin-svelte'
import { viteSingleFile } from 'vite-plugin-singlefile'
import { injectQWebChannel } from './inject-webchannel.js'

// ✅ Export a function that receives the `mode` parameter
export default defineConfig(({ mode }) => {
  return {
    base: './',
    plugins: [
      svelte(),
      viteSingleFile(),
      injectQWebChannel()
    ],
    build: {
      outDir: `dist-${mode}`,
      target: "es2018",
      emptyOutDir: true,
      assetsInlineLimit: Infinity,
      rollupOptions: {
        // keep manualChunks undefined for single-file
      }
    }
  };
});
