# Network Store QGIS plugin

Experimental QGIS tools for working with the KISTERS network-store backend, Datasphere rasters, and ArrayStorage. The plugin ships a toolbar for common workflows, a dockable JSON editor, and a Processing provider with reusable algorithms.

## Requirements
- QGIS 3.24+ with QtWebEngine available.
- A running network-store API (defaults to `http://127.0.0.1:8888`). The toolbar can start/stop a local service if the `network-store` CLI is installed (PATH, `~/.pyenv/shims`, or via `distrobox-host-exec`).
- Standard Python deps bundled with QGIS (`requests`, `sip`, `PyQt5`, etc.). If you installed QGIS via apt and need extra Python packages, start QGIS through `qgis_with_venv.sh` to attach your venv. Flatpak builds are not supported because of sandboxing.

## Install / enable
- Clone this repository.
- Copy the folder into your QGIS profile’s plugin directory  
  - Linux: `/home/$USER/.local/share/QGIS/QGIS3/profiles/default/python/plugins`  
  - Windows: `C:\Users\$USER\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins`
- Restart QGIS, then enable **Network Store Plugin** under Plugins → Manage and Install Plugins.
- If you downloaded the versioned release zips, then use the Plugins → Install from ZIP feature.

## What you get in QGIS
- **Network Store toolbar**
  - *Load Datasphere raster* – (bulk) fetches available products and downloads GeoTIFFs with band-aware handling: detects multiband (z) products, tags layer names `(MB)` vs `(sb)`, and applies Datasphere classifications on band 1 by default.
  - *Start/stop network-store service* – runs `network-store start --store filesystem --store-type analytics --port 8888` (or `stop`) using the detected CLI; updates the icon based on service status.
  - *Export layers to JSON* – pick a loaded network group, then export it to JSON (v2), legacy JSON, or GeoJSON. The dialog derives `base_url` and `network_id` from the WFS layer sources.
  - *Create new network* – POSTs a blank network to the store and optionally loads it into the project.
  - *Get layers from network store* – loads all WFS layers for a network ID into grouped buckets (`Nodes`, `Links`, `Polygons`, `Controls`) and applies any matching styles from `styles/default/` (or the selected style set).
  - *Manage network styles* – copy/rename/delete style sets and apply a style set to already loaded networks.
  - *Show JSON Editor* – opens a dockable JSON form/ACE editor for the selected feature of a network layer. Requires a single selected feature in an editable layer; schemas are pulled from the running network-store (`/network-store/schemas/<app>`).
- **ArrayStore toolbar**
  - *Load raster* – forecast-aware loader that fetches timeseries, auto-selects the latest ensemble run, refreshes available timestamps, and downloads GeoTIFFs. Supports optional dispatch_info/member, now detects multiband (z) products, tags layer names `(MB)` vs `(sb)`, and applies ArrayStorage classifications on band 1 by default.
  - *Show available raster timeseries* – fetches ArrayStorage rasterTimeSeries and adds a layer; optional geometry (from `geometryWkt`/`boundingBox`) is reprojected to EPSG:4326 and styled via `styles/default/_arraystorage_raster_geometries.qml`.
  - *Delete* – deletes ArrayStorage data (optionally ranged) and, when full data is removed, metadata. Metadata delete is blocked unless all data is deleted. Connection presets (config selector) are available across ArrayStorage dialogs.
- **Processing provider (Kisters)** – reusable algorithms under Processing → Toolbox:
  - Networks: load network from store, create network in store, export network, delete network in store.
  - Datasphere: load raster (bulk), import locations from Datasphere; multiband-aware (MB/sb labelling, classification on band 1).
  - ArrayStorage: load raster (fcst/obs, MB/sb labelling), list time series (with optional geometry), list timestamps, delete metadata, delete data.

## Tips for using the JSON editor
- Ensure the network-store API is reachable (start it from the toolbar if needed).
- Select exactly one feature in a network layer and toggle editing before saving.
- The panel mirrors fields back into layer attributes (top-level and `config_obj` keys); status is shown inline in the dock.

## Development notes
- New dialogs can be designed with Qt Designer and loaded via the existing `.ui` files.
- Default styles and the icon set are bundled in `styles/default/` and `icons/` and are copied into the profile on plugin load. Additional style sets live under `styles/<style_set>/`.
- `pb_tool`/`make` can build resources; see `metadata.txt` and `Makefile` for packaging hints.
