from qgis.PyQt.QtCore import QObject, pyqtSignal, pyqtSlot


class JSONEditorBridge(QObject):
    # JS -> Python: emit when user clicks Save in the page
    saveRequested = pyqtSignal(dict)

    @pyqtSlot(str, str)
    def onSave(self, json_text: str, source: str):
        """Called by JS: window.backend.onSave(JSON.stringify(data), 'jsoneditor')"""
        import json

        try:
            data = json.loads(json_text)
            self.saveRequested.emit(data)
        except Exception:
            # optional: log or ignore
            pass

    @pyqtSlot("QVariantMap")
    def applyTheme(self, theme):
        # no-op here; we just call into JS
        pass
