// src/qwc.js
export function setupQWebChannel () {
  if (window.__qwc_ready) return; // idempotent

  function init() {
    // Wait until Qt layer has the transport
    if (!(window.qt && window.QWebChannel && window.qt.webChannelTransport)) {
      requestAnimationFrame(init);
      return;
    }

    // Only initialize once
    if (window.__qwc_ready) return;
    new window.QWebChannel(window.qt.webChannelTransport, (channel) => {
      window.backend = channel.objects.backend || window.backend;
      window.__qwc_ready = true;
    });
  }

  init();
}
