# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NetworkStorePluginDialog
                                 A QGIS plugin
 export layers to kisters network store
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-01-18
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Attila Bibok
        email                : Attila.bibok@kisters.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from qgis.core import QgsProject, QgsLayerTreeNode, QgsWkbTypes

from .utils import extract_features

from typing import List, Tuple

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS_POST, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "network_store_dialog_post.ui")
)


class NetworkStorePluginDialogPost(QtWidgets.QDialog, FORM_CLASS_POST):
    def __init__(self, parent=None):
        """Constructor."""
        super(NetworkStorePluginDialogPost, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.mLineEdit_networkID.setValue("ganga_sys2_hydrologic")
        self.mLineEdit_baseURL.setValue("http://127.0.0.1:8009/network-store")

        self.group_comboBox.addItem("")
        root = (
            QgsProject.instance().layerTreeRoot()
        )  # get the root node of the layer tree
        for node in root.children():  # iterate through the child nodes of the root node
            if (
                node.nodeType() == QgsLayerTreeNode.NodeType.NodeGroup
            ):  # check if the node is a layer group
                self.group_comboBox.addItem(
                    node.name()
                )  # add the group to the list of groups

    def post_network(self, nodes: list = [], links: list = []) -> bool:
        """_summary_

        Returns:
            bool: _description_
        """
        # get ui member vars
        network_id = self.mLineEdit_networkID.value()
        base_url = self.mLineEdit_baseURL.value()
        username = self.mLineEdit_user.value()
        password = self.mLineEdit_password.value()

        # import deps
        from kisters.water.rest_client import RESTClient
        from kisters.water.rest_client.auth import OpenIDConnect
        from kisters.network_store.client.network import Network

        if username == "" and password == "":
            rest_client = RESTClient(url=base_url)
        else:
            rest_client = RESTClient(
                url=base_url,
                authentication=OpenIDConnect(
                    client_id=username,
                    client_secret=password,
                ),
            )
        network = Network(network_id, rest_client)
        network._network_resource = network._network_resource[1:]
        network._resource = network._resource[1:]

        network.drop(purge=True)
        network.save_nodes(nodes)
        network.save_links(links)

    def parse_layers(self, layers: List) -> Tuple[List, ...]:
        """_summary_

        Returns:
            tuple[list,...]: A tuple of lists of parsed elements:
        """
        links = []
        nodes = []
        for layer in layers:
            if layer.nodeType() == QgsLayerTreeNode.NodeType.NodeGroup:
                # group nodes have nothing to extract
                continue
            else:
                if layer.name() in [""]:
                    pass
                else:
                    elements = extract_features(layer=layer.layer())
                    gt = layer.layer().geometryType()
                    if gt == QgsWkbTypes.PointGeometry:
                        nodes += elements
                    elif gt == QgsWkbTypes.LineGeometry:
                        links += elements
        return links, nodes
