# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NetworkStorePluginDialog
                                 A QGIS plugin
 export layers to kisters network store
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-01-18
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Attila Bibok
        email                : Attila.bibok@kisters.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS_GET, _ = uic.loadUiType(
    os.path.join(os.path.dirname(__file__), "network_store_dialog_get.ui")
)


class NetworkStorePluginDialogGet(QtWidgets.QDialog, FORM_CLASS_GET):
    def __init__(self, parent=None):
        """Constructor."""
        super(NetworkStorePluginDialogGet, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        self.mLineEdit_networkID.setValue("ganga_sys2_hydrologic")
        self.mLineEdit_baseURL.setValue("http://127.0.0.1:8009/network-store")

    def get_network(self) -> tuple[list, list]:
        # get ui member vars
        network_id = self.mLineEdit_networkID.value()
        base_url = self.mLineEdit_baseURL.value()
        username = self.mLineEdit_user.value()
        password = self.mLineEdit_password.value()

        # import deps
        from kisters.water.rest_client import RESTClient
        from kisters.water.rest_client.auth import OpenIDConnect
        from kisters.network_store.client.network import Network

        if username == "" and password == "":
            rest_client = RESTClient(url=base_url)
        else:
            rest_client = RESTClient(
                url=base_url,
                authentication=OpenIDConnect(
                    client_id=username,
                    client_secret=password,
                ),
            )
        network = Network(network_id, rest_client)
        network._network_resource = network._network_resource[1:]
        network._resource = network._resource[1:]

        nodes = network.get_nodes()
        links = network.get_links()

        return (nodes, links)
