# Network Store QGIS plugin. 

This repo

## How to use:

 - Clone the repository
 - Copy the repository to the plugins folder of your QGIS install
   - LINUX: /home/$USERNAME/.local/share/QGIS/QGIS3/profiles/default/python/plugins
   - Windows: C:\Users\$USERNAME\AppData\Roaming\QGIS\QGIS3\profiles\default\python\plugins
 - Restart QGIS if it was running before copying the repo
 - Enable the plugin in the plugin manager:
   - Plugins -> Manage and Install plugins -> Installed -> Check the checkbox next to "Network Store Plugin"

## What the plugin contains:

 - The base menu under  Plugins -> Network Store Plugin
   - Highly custom functionality should be placed here
 - Processing provider in the processing toolbox:
   - Reusable pieces of code / algorithms should be included here. eg.: Cross section generation, Topology validation etc.
   - The input dialogs and parameters are standardized. No need to create a new *.ui file in the processing provider.
 - Parametrized Icon set for the model-library.water elements (and a bit more)

## Missing functionality / TODOs:

 - Switching between different model libraries (water/wastewater)
 - Option to create virtual layers rather than using a local geopackage
 - include all the element class properties as attributes. All the lists and non-parseable datatypes should be exported as JSON text.
 - export layers to network store
   - by group rather than selecting them by one-by-one


New dialogs ( .ui files) can be created using Qt Designer.

Default styles are distributed with the plugin, including the icon set.

Known bugs:
 - pyQgis 3.24: QgsMapLayerComboBox filters should be set after the dialog is initialized. Do not explicitly set it in the .ui file!

### Acknowledgement:

Base plugin was created by Plugin Builder plugin in QGIS
(C) 2011-2018 GeoApt LLC - geoapt.com

For more information, see the PyQGIS Developer Cookbook at:
http://www.qgis.org/pyqgis-cookbook/index.html