from re import S
from kisters.network_store.model_library.water import links, nodes
from kisters.network_store.model_library.water.links import *
from kisters.network_store.model_library.water.nodes import *
from typing import Literal
import inspect as i


def is_dunder(name: str):
    if (
        len(name) > 4
        and name.isascii()
        and name.startswith("__")
        and name.endswith("__")
    ):
        return True
    else:
        return False


def is_private(name: str):
    if (
        len(name) > 1
        and name.isascii()
        and name.startswith("_")
        and not name.startswith("__")
    ):
        return True
    else:
        return False


def is_public(name: str):
    if not is_private(name) and not is_dunder(name):
        return True
    else:
        return False


def get_links() -> list:
    result = []
    for obj in i.getmembers(links):
        if i.isclass(obj[1]) and not is_dunder(obj[0]) and not is_private(obj[0]):
            if issubclass(obj[1], links._BaseLink):
                result.append(obj)
    return result


def get_nodes() -> list:
    result = []
    for obj in i.getmembers(nodes):
        if i.isclass(obj[1]) and not is_dunder(obj[0]) and not is_private(obj[0]):
            if issubclass(obj[1], nodes._BaseNode):
                result.append(obj)
    return result


def get_schema(basetype: Literal["nodes", "links"]):
    if basetype == "nodes":
        return [globals()[n[0]].schema() for n in get_nodes()]
    if basetype == "links":
        return [globals()[n[0]].schema() for n in get_links()]


def get_class_schema(basetype: Literal["nodes", "links"], classname: str):
    schemas = get_schema(basetype)
    for s in schemas:
        if s["title"] == classname:
            return s
    return False


def main():
    print("Links:")
    link_classes = get_links()
    print(link_classes)
    print("Nodes:")
    node_classes = get_nodes()
    print(link_classes)

    # if (issubclass(link_classes[0][1],links._BaseLink)):
    #     print(link_classes[0][1].__mro__)
    link_schemas = [globals()[l[0]].schema() for l in link_classes]
    node_schemas = [globals()[n[0]].schema() for n in node_classes]
    for schema in link_schemas:
        print(
            f"{schema['title']} properties: {[key for key in schema['properties'].keys()]}"
        )

    x = globals()
    schema = globals()["Pipe"].schema()
    js = globals()["Pipe"].schema_json(indent=2)

    print("Nodes:")
    print(get_nodes())


if __name__ == "__main__":
    main()
