# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NDVItoVariableNitrogenApplicationMap
                                 A QGIS plugin
 This plugin was developed for producing variable nitrogen application maps based index value.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-25
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Emir Memic
        email                : emir_memic@windowslive.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .ndvi_to_variable_nitrogen_application_map_dialog import NDVItoVariableNitrogenApplicationMapDialog
import os.path

# me
from qgis.utils import reloadPlugin
from qgis.analysis import QgsZonalStatistics
from qgis.core import *
from qgis.utils import *
import processing
from PyQt5.QtGui import QFont, QColor
from qgis.PyQt import *
from qgis.PyQt.QtWidgets import QMessageBox

import matplotlib.pyplot as plt
import numpy as np

import datetime as dt
from datetime import datetime
import matplotlib.dates as mdates

from itertools import islice
import numpy as np
import re

from PyQt5.QtCore import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *

#from random import randrange
from scipy.stats import norm, linregress , stats 
import statistics


from qgis.PyQt.QtCore import QEventLoop

class NDVItoVariableNitrogenApplicationMap:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            #'NDVItoVariableNitrogenApplicationMap_{}.qm'.format(locale))
            'ndvi_to_variable_nitrogen_application_map_{}.qm'.format(locale[0:2]))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&NDVI to Variable Nitrogen Application Map')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        #return QCoreApplication.translate('NDVItoVariableNitrogenApplicationMap', message)
        return QCoreApplication.translate('ndvi_to_variable_nitrogen_application_map', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/ndvi_to_variable_nitrogen_application_map/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'From NDVI to variable N application map'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&NDVI to Variable Nitrogen Application Map'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = NDVItoVariableNitrogenApplicationMapDialog()

        #### me-start - connect qt interface signals to parts of the code
        reloadPlugin('ndvi_to_variable_nitrogen_application_map')
        print ('run ndvi_to_variable_nitrogen_application_map plugin')

        self.dlg.pushButton.clicked.connect(self.image_analysis)
        self.dlg.pushButton_2.clicked.connect(self.calculate_time_series_trend)
        self.dlg.pushButton_2.clicked.connect(self.plot_figures)
        self.dlg.pushButton_4.clicked.connect(self.nitrogen_prescriptions)
        self.dlg.pushButton_6.clicked.connect(self.guide_to_user)
        self.dlg.pushButton_7.clicked.connect(self.scale_Napp_to_actual_size_of_grid)
        self.dlg.pushButton_8.clicked.connect(self.select_output_directory_manually)
        self.dlg.comboBox_3.currentIndexChanged.connect(self.add_output_dir_automatically)
        self.dlg.listWidget_4.clicked.connect(self.find_INDEX_min_max_mean)
        self.dlg.listWidget_4.currentItemChanged.connect(self.find_INDEX_min_max_mean)        
        self.dlg.lineEdit_6.textChanged.connect(self.calculate_Napp_distribution)
        self.dlg.lineEdit_6.textChanged.connect(self.fictive_setup_prevent_incosistency)

        # flags for reusing part of the code for two different tasks
        self.gIndexMap = False
        self.gNappMap = False

        self.dlg.checkBox_2.setChecked(True)
        self.dlg.checkBox_4.setChecked(True)

        self.dlg.lineEdit_7.setEnabled(False)
        self.dlg.lineEdit_8.setEnabled(False)
        self.dlg.lineEdit_9.setEnabled(False)
        self.dlg.lineEdit_10.setEnabled(False)
        self.dlg.lineEdit_11.setEnabled(False)
        self.dlg.lineEdit_12.setEnabled(False)        

        self.dlg.lineEdit_7.setText('N')
        self.dlg.lineEdit_8.setText('N')
        self.dlg.lineEdit_9.setText('N')
        self.dlg.lineEdit_10.setText('N')
        self.dlg.lineEdit_11.setText('N')
        self.dlg.lineEdit_12.setText('N')    
        
        self.dlg.checkBox_2.clicked.connect(self.yield_maximising_N_opt)
        self.dlg.checkBox_3.clicked.connect(self.yield_equalising_N_opt)

        self.dlg.checkBox_4.clicked.connect(self.select_variable_Nitrogen_application_flag)
        self.dlg.checkBox_5.clicked.connect(self.select_variable_Yield_application_flag)

        self.dlg.listWidget_2.clear()
        self.dlg.listWidget_3.clear()
        self.dlg.comboBox.clear()
        #self.dlg.comboBox_2.clear()
        
        # add available layers into interface
        layers = self.iface.mapCanvas().layers()
        listOfLayers = []
        for layer in layers:
            listOfLayers.append(str(layer.name()))
            QCoreApplication.processEvents()
        
        self.dlg.comboBox_3.addItems(listOfLayers)
        
        self.dlg.listWidget_2.addItems(listOfLayers)
        self.dlg.listWidget_2.sortItems()        
        #self.dlg.comboBox.addItems(['mean','median','count','sum', 'stdev', 'min', 'max'])
        self.dlg.comboBox.addItems(['mean']) #,'median','count','sum', 'stdev', 'min', 'max'])
        #self.dlg.comboBox_2.addItems(['green','red','blue'])
        #self.dlg.comboBox_4.addItems(['red','green','blue'])

        self.dlg.listWidget_2.setCurrentRow(0)        
        #### me-end

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def guide_to_user(self):
        # guide to user pushbutton
        QMessageBox.information(None, 'Guide to user!', 
        '1. - Input layer - site-specific units deliniated (e.g. shape file) based on which zonal statistics are calculated. THIS INPUT CANNOT BE IN ZIPPED FILE AND IT CANNOT BE ON LOCATION WHRE QGIS PLUGIN DOESNT HAVE PREMISSION OF ACCESS.\n'
        + '   - Input raster - raster image providing pixel based info (e.g. NDVI .TIFF file) for deliniated areas used for zonal statistics.\n\n'
        + '2. - Image analysis - produces raster based on initial site-specific polygon deliniation. Here user can setup number of index clases that are calculated based on layer-specific index min and max, or from 0 to 1, with color.\n\n'
        + '3. - Calculate time-series trends (optional - works only if date strings are in raster names included) - raster values added into time-series figure, and saved in FigureSaved dir.\n\n'
        + '4. - Initilising analysis, either 4.1 Variable N application seutp (N) or 4.2 Variable Yield pottential setup (Y) - based on variable index values.\n\n'
        + '4.1- Variable N application setup (N) - based on in-field variablity a user can define min and max (N) prescription that will be allocated to index values in relative terms, or user automatically generated min and max N, which are based on percentage difference between index mean and min and max.\n\n'
        + '4.2- Variable Yield potential setup (Y) - based on in-field variablity a user can define min and max yield (Y) potential zones that will be allocated to index values in relative terms, or user automatically generated min and max yield, which are based on percentage difference between index mean and min and max.\n\n'
        + '   - Method selection - "Maximising" for (4.1 selection) - N application rates method. Yield maximising N application rate will allocate more N to polygons with higher index values, and "Equalising" for (4.1 selection) will allocate more N to the polygons with lower index values.\n\n'
        + '   - Method selection - "Maximising" for (4.2 selection) - Yield potential rates. "Maximising" yield potential rates will allocate more Yield to polygons with higher index values.\n\n'
        + '   - Process Maps - push button will process data and produce maps and save them in SavePDFs directory, which is located in main output directory.\n' 
        + '   - Scale amounts to actual size of grid - push button recalculates amounts based on real "area" size of defined deliniated grids.\n'        
        )


    def select_variable_Nitrogen_application_flag(self):
        self.dlg.checkBox_4.setChecked(True)
        self.dlg.checkBox_5.setChecked(False)
        
        self.dlg.checkBox_3.setEnabled(True)

        self.dlg.checkBox_2.setChecked(True)
        self.dlg.checkBox_3.setChecked(False)
        
        self.dlg.lineEdit_6.setText('70')
        self.dlg.lineEdit_7.setText('N')
        self.dlg.lineEdit_8.setText('N')
        self.dlg.lineEdit_9.setText('N')
        self.dlg.lineEdit_10.setText('N')
        self.dlg.lineEdit_11.setText('N')
        self.dlg.lineEdit_12.setText('N')         

    def select_variable_Yield_application_flag(self):
        self.dlg.checkBox_4.setChecked(False)
        self.dlg.checkBox_5.setChecked(True)
        
        self.dlg.checkBox_3.setEnabled(False)
        
        self.dlg.checkBox_2.setChecked(True)
        self.dlg.checkBox_3.setChecked(False)
        
        self.dlg.lineEdit_6.setText('7000')
        self.dlg.lineEdit_7.setText('Y')
        self.dlg.lineEdit_8.setText('Y')
        self.dlg.lineEdit_9.setText('Y')
        self.dlg.lineEdit_10.setText('Y')
        self.dlg.lineEdit_11.setText('Y')
        self.dlg.lineEdit_12.setText('Y')  

    def add_output_dir_automatically(self):       
        selectedLayer = str(self.dlg.comboBox_3.currentText())    
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]

        myfilepath = polygonLayer.source()
        #myfilepath = myfilepath.strip('/vsizip/')
        myfilepath = os.path.normpath(myfilepath)    
        myfilepath = os.path.dirname(myfilepath)
        
        if '.zip' in myfilepath:
            myfilepath = os.path.dirname(myfilepath)
            #myfilepath = os.path.dirname(os.path.dirname(myfilepath))
            print ('me path', myfilepath)
            QMessageBox.warning(None, 'Potential probelm with output directory path!', '...because of Input layer shape file might be zipped. Unzipp Input layer shape file, load unzipped shape file into QGIS Lyers and start the plugin again!')    
 
        myfilepath = os.path.normpath(myfilepath) 
        print ('myfilepath input image', myfilepath) 
        self.dlg.lineEdit_5.setText(str(myfilepath))

    def select_output_directory_manually(self):
        ###### find directroy
        selectWorkingDir = QFileDialog.getExistingDirectory()
        selectWorkingDir = os.path.normpath(selectWorkingDir)
        print ('selected dir', selectWorkingDir)
            
        selectWorkingDir = selectWorkingDir 
        selectWorkingDir = os.path.normpath(selectWorkingDir)
        self.dlg.lineEdit_5.setText(selectWorkingDir)

    def yield_maximising_N_opt(self):
        self.dlg.checkBox_2.setChecked(True)
        self.dlg.checkBox_3.setChecked(False)
        
    def yield_equalising_N_opt(self):
        self.dlg.checkBox_2.setChecked(False)
        self.dlg.checkBox_3.setChecked(True)
        
    def image_analysis(self):
        print('image_analysis - start')
        self.dlg.textBrowser.append("Section 1. and 2.:")
        
        self.dlg.listWidget_3.clear()
        self.dlg.listWidget_4.clear()

        numberOfSelectedLayers = len(self.dlg.listWidget_2.selectedItems())
        print ('numberOfSelectedLayers-------', numberOfSelectedLayers)
        percentInc = 100/int(numberOfSelectedLayers)
        percent = 0 

        self.dlg.progressBar.setValue(1)
        #progress = 0 
        self.dlg.progressBar.setMinimum(percent)
        self.dlg.progressBar.setMaximum(percent)
        self.dlg.progressBar.setValue(percent)
        listOfLayersForLater = []
        meCounterCheck = 0
        for selectedImage in self.dlg.listWidget_2.selectedItems():
            selectedLayer1 = selectedImage.text()          
            
            meCounterCheck = meCounterCheck + 1
            print ('meCounterCheck' ,meCounterCheck, 'current image', selectedLayer1)
            percent = percent + percentInc
            
            selectedLayer = str(self.dlg.comboBox_3.currentText())            
            polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
            print ('polygonLayer----------', polygonLayer)
                        
            # specify raster filename
            layer=QgsProject.instance().mapLayersByName(selectedLayer1)[0]
            iface.setActiveLayer(layer)        
            activeLayer = self.iface.activeLayer()
            myfilepath1= iface.activeLayer().dataProvider().dataSourceUri()
            print ('myfilepath input image', myfilepath1)                
            inputLayerName = str(self.dlg.listWidget_2.currentItem().text())
            rasterLayer = QgsRasterLayer(myfilepath1, 'raster')

            # clean attrbute table of template layer - important
            fields = []
            for field in polygonLayer.fields():
                idx = polygonLayer.dataProvider().fieldNameIndex(field.name())
                fields.append(idx)
            print ( fields)   
            fields.remove(0)
            print ( fields)
            polygonLayer.dataProvider().deleteAttributes(fields)
            polygonLayer.updateFields()
            
            zoneStat = QgsZonalStatistics(polygonLayer, rasterLayer, rasterBand=1,
                                                                                    stats=QgsZonalStatistics.Statistics(
                                                                                    QgsZonalStatistics.Count | 
                                                                                    QgsZonalStatistics.Sum | 
                                                                                    QgsZonalStatistics.Mean | 
                                                                                    QgsZonalStatistics.Median |               
                                                                                    QgsZonalStatistics.StDev | 
                                                                                    QgsZonalStatistics.Min | 
                                                                                    QgsZonalStatistics.Max                               
                                                                                    )).calculateStatistics(None)


            # added here to use directly ndvi calculated from copernicus - start - test this additionally
            date = str(selectedLayer1).split('_')[-1]
            if date == 'NDVI': # or date == 'EVI':
                match = re.search(r'\d{4}-\d{2}-\d{2}', selectedLayer1)
                date = datetime.strptime(match.group(), '%Y-%m-%d').date()
                print ('date', date)                    
                dateName = str(date).split('-')[1] + '-' + str(date).split('-')[2] + '-' + str(date).split('-')[0]
                print ('dateName---------', dateName)
                selectedLayer1 = selectedLayer1 + '_' + dateName
            # added here to use directly ndvi calculated from copernicus - end             

            result=processing.run("native:buffer",{'INPUT':polygonLayer,
                                                    'DISTANCE': -1.0,   # brush of weird polygon edges                                                 
                                                    'OUTPUT':'memory:{}'.format(str(selectedLayer) + '-' + str(selectedLayer1))})             
            QgsProject.instance().addMapLayer(result['OUTPUT'])

            listOfLayersForLater.append(str(selectedLayer) + '-' + str(selectedLayer1))
                        
            ############################################ add labels to the active layer - start
            layer = iface.activeLayer()
            layer_settings  = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            text_format.setFont(QFont("Arial", 10))
            text_format.setSize(12)

            layer_settings.setFormat(text_format)
            layer_settings.fieldName = str(self.dlg.comboBox.currentText()) #"mean"
            layer_settings.isExpression = True
            #layer_settings.placement = 1
            layer_settings.formatNumbers = True  # checkbox
            layer_settings.decimals = 3 #2  # decimals number
            layer_settings.enabled = True
            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            
            layer.setLabelsEnabled(True)
            layer.setLabeling(layer_settings)
            layer.triggerRepaint()
            
            QgsProject.instance().reloadAllLayers()
            ############################################ add labels to the active layer - end
            
            ############################################ coloring different polygons based of field value - start     
            print ('me1')
            layer = iface.activeLayer()

            QCoreApplication.processEvents()

            myRangeList= [] 

            myTargetField = str(self.dlg.comboBox.currentText()) #"Yield"
            
            myMin= 0 
            myMax= 1 

            ##############
            if self.dlg.checkBox_6.isChecked():
                for field in layer.fields():
                    idxIN = layer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))  

                listOfValues = []
                for feature in layer.getFeatures():                    
                    print ('field', feature.id(), 'value',feature.attributes()[idxIN])
                    listOfValues.append(float(feature.attributes()[idxIN]))
                
                myMin = np.min(listOfValues)
                myMax = np.max(listOfValues)
                myMean = np.mean(listOfValues)
                
                print ('myMin--', myMin)
                print ('myMax--', myMax)
                print ('myMean--', myMean)
                
            ############

            print  ('myMin', myMin, 'myMax', myMax)   

            colorMeSelected = str(self.dlg.comboBox_2.currentText()).split('-')[0]       
            classMeNumber = int(self.dlg.lineEdit.text()) #4
            classMe = 'Class'

            classMeDiscStep = (myMax - myMin) / classMeNumber
            #colorMeIntDiscStep = int((255 - 5) / classMeNumber)
            colorMeIntDiscStep = int((255 - 5) / (classMeNumber -1))
            redMe = 255 + colorMeIntDiscStep - 1
            greenMe = 255 + colorMeIntDiscStep - 1
            blueMe = 255 + colorMeIntDiscStep - 1
            
            for i in range(1, classMeNumber+1):

                if colorMeSelected == 'R':            
                    redMe = 255 #redMe
                    greenMe = greenMe - colorMeIntDiscStep
                    blueMe = blueMe - colorMeIntDiscStep
                if colorMeSelected == 'G':            
                    redMe = redMe - colorMeIntDiscStep
                    greenMe = 255 #greenMe
                    blueMe = blueMe - colorMeIntDiscStep                              
                if colorMeSelected == 'B':            
                    redMe = redMe - colorMeIntDiscStep
                    greenMe = greenMe - colorMeIntDiscStep
                    blueMe = 255 #blueMe 
                
                myMin= myMin
                # added 0.00001 to the range myMin and myMax distorts ratios a bit, but it fixes highest myMax range not beeing included in the color map    
                myMax= myMin + (classMeDiscStep) #+ 0.00001
                
                #myLabel = classMe + '_' + str(i) + ': ' + str(round(myMin,2)) + '-' + str(round(myMax, 2))   #'Group 1'
                myLabel = classMe + '_' + str(i) + ': ' + str(myMin) + '-' + str(myMax)   #'Group 1'    
                myColour= QtGui.QColor(redMe,greenMe,blueMe) #)'#FF0000') #'#ffee00') 
                mySymbol1= QgsSymbol.defaultSymbol(layer.geometryType()) 
                mySymbol1.setColor(myColour) 
                #mySymbol1.setOpacity(myOpacity) 
                myRange1= QgsRendererRange(myMin,myMax,mySymbol1,myLabel) 
                myRangeList.append(myRange1)
                                     
                myMin = myMax        
                print('R'+ str(redMe) + ' G'+ str(greenMe) + ' B'+ str(blueMe))     
                print ('myRangeList--------', str(myRangeList))
                
            myRenderer= QgsGraduatedSymbolRenderer('',myRangeList) 
            myClassificationMethod= QgsApplication.classificationMethodRegistry().method("EqualInterval")

            myRenderer.setClassificationMethod(myClassificationMethod) 
            myRenderer.setClassAttribute(myTargetField) 
           
            layer.setRenderer(myRenderer)        
            layer.triggerRepaint()
                   
            QgsProject.instance().reloadAllLayers()

            self.dlg.progressBar.setMaximum(100)
            self.dlg.progressBar.setValue(int(round(percent)))
            QCoreApplication.processEvents()
                     
            self.dlg.textBrowser.append('      *' + str(selectedLayer) + '-' + str(selectedLayer1) + '- Image Analysed and Layer added to Legend!')

        QCoreApplication.processEvents()
        print ('listOfLayersForLater list', listOfLayersForLater)    
        self.dlg.listWidget_3.addItems(listOfLayersForLater)
        self.dlg.listWidget_4.addItems(listOfLayersForLater)
        self.dlg.listWidget_3.selectAll()
        self.dlg.listWidget_4.setCurrentRow(0)
        ############################################ coloring different polygons based of field value - end    

    def find_INDEX_min_max_mean(self):
        
        selectedLayer = self.dlg.listWidget_4.currentItem()
        selectedLayer = selectedLayer.text()
        print ('selectedLayer selectedLayer', selectedLayer)
        layer = QgsProject.instance().mapLayersByName(selectedLayer)[0]

        for field in layer.fields():
            idxIN = layer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))

        listOfValues = []
        for feature in layer.getFeatures():                    
            #print ('field', feature.id(), 'value',feature.attributes()[idxIN])
            listOfValues.append(float(feature.attributes()[idxIN]))
        
        myMin = np.min(listOfValues)
        myMax = np.max(listOfValues)
        myMean = np.mean(listOfValues)

        print ('myMin---------', myMin)
        print ('myMax----------', myMax)
        print ('myMean----------', myMean)
        
        self.myMinMeM = myMin  
        self.myMaxMeM = myMax
        self.myMeanMeM = myMean

        QgsProject.instance().reloadAllLayers()
        layer.triggerRepaint()
        QCoreApplication.processEvents()


        try:
            self.calculate_Napp_distribution()
        except:
            self.dlg.textBrowser.append('Problem while auto setup of Napp distrubiotion. Manual setup required.')

    def fictive_setup_prevent_incosistency(self):
        # fictive seutp in case of manual entry of the field specific value to create min and max lower and higher then avarage
        if self.dlg.checkBox.isChecked():
            self.dlg.lineEdit_3.setText(str(int( int(self.dlg.lineEdit_6.text())*0.9 )))
            self.dlg.lineEdit_4.setText(str(int( int(self.dlg.lineEdit_6.text())*1.1 )))
            
    def calculate_Napp_distribution(self):
####################
        print ('self.myMinMe',  self.myMinMeM)
        print ('self.myMaxMe',  self.myMaxMeM)
        print ('self.myMeanMe', self.myMeanMeM)            

        lowPerc = (self.myMeanMeM - self.myMinMeM)/self.myMinMeM
        highPerc = (self.myMaxMeM - self.myMeanMeM)/self.myMeanMeM

        print ('lowPerc', lowPerc)
        print ('highPerc', highPerc)
        
        reduceConv = int(self.dlg.lineEdit_6.text()) - (int(self.dlg.lineEdit_6.text()) * lowPerc)
        increaseConv = int(self.dlg.lineEdit_6.text()) + (int(self.dlg.lineEdit_6.text()) * highPerc)

        print ('reduceConv', reduceConv)
        print ('increaseConv', increaseConv)
        
        if not self.dlg.checkBox.isChecked():
            self.dlg.lineEdit_3.setText(str(int(reduceConv)))
            self.dlg.lineEdit_4.setText(str(int(increaseConv)))

        # # fictive seutp in case of manual entry of the field specific value to create min and max lower and higher then avarage
        # if self.dlg.checkBox.isChecked():
            # self.dlg.lineEdit_3.setText(str(int( int(self.dlg.lineEdit_6.text())*0.9 )))
            # self.dlg.lineEdit_4.setText(str(int( int(self.dlg.lineEdit_6.text())*1.1 )))
        
        QCoreApplication.processEvents()
############################# 


    def calculate_time_series_trend(self):
        
        self.dlg.textBrowser.append('\nSection 3.:')

        self.gIndexMap = True
        self.gNappMap = False

        selectedLayer = str(self.dlg.comboBox_3.currentText())    
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        fc = polygonLayer.featureCount()
        print ('fc', fc)

        percentInc = 100/fc
        percent = 0        

        myfilepath = str(self.dlg.lineEdit_5.text())
        print ('myfilepath input image', myfilepath) 

        try:
            os.mkdir(myfilepath + '/SaveFigures')
        except:
            print ('dir exist')
        
        self.dlg.textBrowser.append('   Time-series trends of each grid and avarage will be saved in - ' + str(myfilepath) + ' - in "SaveFigures" directory')     

        with open('{}/Eavaluation.txt'.format(myfilepath), 'w') as writestatistics:
           
            for i in range(1, fc+1):
                percent = percent + percentInc            
                print ('percent----', percent)
                
                
                for selectedImage in self.dlg.listWidget_3.selectedItems():
                    selectedLayer = selectedImage.text()
                    
                    date = str(selectedLayer).split('_')[-1]  
                    date = date.replace('-', '/') 

                    
                    activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
                    #print ('activeLayer',activeLayer)
                    
                    for field in activeLayer.fields():
                        idx = activeLayer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))                
                    #print ('idx', idx)

                    for feature in activeLayer.getFeatures():        
                        if float(feature.id()) == i:
                            print ('field', feature.id(), 'value',feature.attributes()[idx])   

                            writestatistics.write(str(i) + '\t' + str(date)  + '\t' + str(float(feature.attributes()[idx])) + '\n')
                    QCoreApplication.processEvents()
                    QgsProject.instance().reloadAllLayers() 

                    

                self.dlg.progressBar_3.setValue(int(round(percent)))
                QCoreApplication.processEvents()

            QCoreApplication.processEvents() 

        self.pdf_summary()

        self.dlg.textBrowser.append('   Time-series trends for each grid Evaluated!')



    def plot_figures(self):
        print ('plot and save figures')

        selectedLayer = str(self.dlg.comboBox_3.currentText())    
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        fc = polygonLayer.featureCount()
        print ('fc', fc)

        myfilepath = str(self.dlg.lineEdit_5.text())
        print ('myfilepath input image', myfilepath) 

        for i in range (1, 2):
            listOfDates = []
            countObsMe = []
            with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                for line in islice(readToA, 0, None):
                    # print ('line', line)
                    gridId = line.split()[0]
                    if str(i) == gridId:
                        print ('line', line)
                        dateToList = line.split()[1]
                        #dateToList = dateToList.replace('-', '/')
                        listOfDates.append(dateToList)
                        countObsMe.append(dateToList.split('/')[-1])
        print ('listOfDates', listOfDates)                
        newList = sorted([dt.datetime.strptime(d,'%m/%d/%Y').date() for d in listOfDates])
        print ('newList', newList)
        countMe = len(newList)
        print ('countMe', countMe)

        ################# color i am not sure if this is good and how slow it is have to check with more years 
        colorMeTimeS = []
        yearsToUse = []
        c = np.random.rand(3,)
        colorMeTimeS.append(c)
        
        firstYear = newList[0]
        LL = str(firstYear).split('-')[0]
        yearsToUse.append(LL)
        for L in newList:
            LL = str(L).split('-')[0]
            try:
                if LL != oldLL:
                    c = np.random.rand(3,)
                    colorMeTimeS.append(c)
                    yearsToUse.append(LL)
            except:
                pass
            oldLL = LL
        print ('yearsToUse', yearsToUse)
        print ('colorMeTimeS', colorMeTimeS) 

#############
################
        nObs = []
        for i in yearsToUse:
            print ('i', i)
            print ('countObsMe', countObsMe)
            numberOfObS = countObsMe.count(i)
            nObs.append(str(i) + '_' + str(numberOfObS))
        print ('nObs', nObs)    
############
############

        colorYear = []
        idxCol = 0
        for yearColor in yearsToUse:
            idxCol +=1
            idx = yearColor + '_' + str(idxCol)
            colorYear.append(idx)
        print ('colorYear' ,colorYear)    

        colorIndexToUse = 0
        ###################
       
        percentInc = 100/fc
        percent = 0
        #fc = 6
        for i in range (1, fc+1):
            percent = percent + percentInc
            #c = np.random.rand(3,)
            listValues = []
            dateList = []
##########    
            nYearsMe = int(len(yearsToUse))    
            firstListValues = []
            firstDateList = []

#############              
            
            fig = plt.figure()
            plt.ylabel(str(self.dlg.comboBox.currentText())) #'value')
            plt.xlabel('DOY')
            plt.gca().set_ylim([0,1.2])
            plt.gca().set_xlim([0,365])
            plt.xticks(np.arange(0, 366, 30))
            me = 0
##############    
            countListElM = 0
            countYearsObsList = 0
            positionLabel = 1.2
###############                
            
            for L in newList:
                LL = str(L).split('-')[0]
                try:
                    if LL != oldLL:
                        listValues = []
                        dateList = []
                        me = 0
                        #c = np.random.rand(3,)
#####################                
                        countListElM = 0
                        countYearsObsList = countYearsObsList +1
                        #c = np.random.rand(3,)
###################                         
                        
                except:
                    pass
                me = me + 1    
                with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                    for line in islice(readToA, 0, None):
                        dateToList = line.split()[1]
                        convertedDate = dt.datetime.strptime(dateToList,'%m/%d/%Y').date()
                        doy = int(convertedDate.strftime('%j'))
                        gridId = line.split()[0]
                        value = line.split()[2]
                        if str(i) == gridId:                
                            if L == convertedDate:
                                listValues.append(float(value))
                                dateList.append(int(doy))
############################## 
                                countListElM += 1   
                                if LL == yearsToUse[0]:
                                    firstListValues.append(float(value))
                                    firstDateList.append(int(doy))                      
##################################                                    
                                
                ################# color                
                for checkColorr in colorYear:                    
                    if str(LL) == checkColorr.split('_')[0]:
                        print ('checkColorrC-----------', 'LL', LL,  checkColorr.split('_')[0], 'idx color', checkColorr.split('_')[1])
                        colorIndexToUse = int(checkColorr.split('_')[1]) - 1
                c = colorMeTimeS[colorIndexToUse]
                ################# color                
                #plt.plot(dateList, listValues, linestyle='--', marker='o', color = c, label=str(LL) if me == int(countMe/2) else "")
                plt.plot(dateList, listValues, linestyle='--', marker='o', color = c, label=str(LL) if me == 1 else "") # else conditions is to keep legend clean
                
                
                oldLL = LL
                
#################################        
                #print ('listValues',listValues)
                #print ('dateList', dateList)
                
                print ('---------countListElM', countListElM)
                print ('---------countYearsObsList', countYearsObsList)
                print (nObs[countYearsObsList-1])
                print (str(nObs[countYearsObsList-1]).split('_')[1])
                keepOnlyLastRMSE = str(nObs[countYearsObsList-1]).split('_')[1]
                keepOnlyFirstRMSE = str(nObs[countYearsObsList-1]).split('_')[0]
                if str(countListElM) == str(keepOnlyLastRMSE):
                    positionLabel = positionLabel - 0.05
                    print ('firstListValues', firstListValues)
                    print ('firstDateList', firstDateList)

                    print ('dateList', dateList)

                    ndviInterpolate = np.interp(dateList, firstDateList, firstListValues)
                    print('ndviInterpolate', ndviInterpolate)

                    plt.plot(dateList, ndviInterpolate, "*r")

                    print ('listValues', listValues)
                    print ('ndviInterpolate', ndviInterpolate)
                    
                    RMSE = np.sqrt(((ndviInterpolate - listValues).astype('double') ** 2).mean())
                    print ('RMSE', RMSE)
                    nRMSE = RMSE/np.array(listValues).mean()
                    print ('nRMSE', nRMSE)
                    plt.text(1, positionLabel, str(keepOnlyFirstRMSE) + ' : '  + 'RMSE=' + str(round(RMSE, 3)) + ' ; ' +'nRMSE=' + str(round(nRMSE, 3)) + ' ; n:' + str(len(ndviInterpolate)) , fontsize=10)
##################################                
                
            plt.legend(loc='upper right')    
            #saveHere = str(i) + '_.png'
            saveHere = str(myfilepath) + '/SaveFigures' + '/' +str(i) + '__.png'
            plt.savefig(saveHere)
            self.dlg.progressBar_2.setValue(int(round(percent)))
            QCoreApplication.processEvents()

        QCoreApplication.processEvents() 

        # box plottting
        print ('listOfDates', listOfDates)
        print ('newList', newList)
        print ('yearsToUse', yearsToUse)
        print ('colorMeTimeS', colorMeTimeS)        
        
        #if self.dlg.checkBox.isChecked():
        figureall = plt.figure()

        plt.ylabel(str(self.dlg.comboBox.currentText()) + ', black dotted line is mean')
        plt.gca().set_ylim([0,1])

        firstY = yearsToUse[0]
        firstYc = 0
        labelCFirstElemenLgend = 0
        whiskerCount = 0
        labelWc = []
        labelWv = []

        labelWcF = []
        labelWvF = []            
        
        meansLineA = []
        for Lbox in newList:
            LL = str(Lbox).split('-')[0]
            print ('LL me', LL)
            #whiskerCount = whiskerCount + 1   
            labelCFirstElemenLgend = labelCFirstElemenLgend + 1
            if firstY != LL:
                firstYc = firstYc + 1
                firstY = LL
                
                labelWc = []                    
                meansLineA = []
                
                labelCFirstElemenLgend = 1
                
            colorMe = colorMeTimeS[firstYc]
            
            whiskerCount = whiskerCount + 1
            
            print ('Lbox', Lbox)
            LboxList = []
            with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                for line in islice(readToA, 0, None):
                    dateToList = line.split()[1]
                    convertedDate = dt.datetime.strptime(dateToList,'%m/%d/%Y').date() 
                    if Lbox == convertedDate:
                        #print ('Lbox matched')
                        getValue = line.split()[2]
                        LboxList.append(float(getValue))
            
            plt.boxplot(LboxList, positions=[whiskerCount], patch_artist=True, 
                    boxprops=dict(facecolor=colorMe, color=colorMe), 
                    showmeans = True, meanline = True, meanprops = dict(color = "black", linewidth = 1.5, linestyle = 'dotted')) #, notch=True)
              

            labelWc.append(whiskerCount)
            labelWv.append(Lbox)

            labelWcF.append(whiskerCount)
            labelWvF.append(Lbox)  
            
            meanL = np.mean(LboxList)
            meansLineA.append(meanL)
        
            plt.plot(labelWc, meansLineA, color=colorMe, label=str(LL) if labelCFirstElemenLgend == 1 else "")
        
        print ('labelWc', labelWc)
        print ('labelWv', labelWv)
        print ('meansLineA', meansLineA)
        plt.legend(loc='upper left')
        plt.xticks(labelWcF, labelWvF, fontsize=6)
        plt.xticks(rotation=15)

        saveHere = str(myfilepath) + '/SaveFigures' + '/' + 'BoxPlot.png'
        plt.savefig(saveHere, dpi=600) 

        #################
        #################
        print ('------------- lines------------')
        figureallLines = plt.figure()

        plt.ylabel(str(self.dlg.comboBox.currentText()) + ', black dotted line is mean')
        plt.gca().set_ylim([0,1])

        plt.xlabel('DOY')
        plt.gca().set_xlim([0,365])
        plt.xticks(np.arange(0, 366, 30))

        firstY = yearsToUse[0]
        firstYc = 0
        labelCFirstElemenLgend = 0
        whiskerCount = 0
        labelWc = []

        meansLineA = []
        for Lbox in newList:
            LL = str(Lbox).split('-')[0]
            print ('LL me', LL)
            #whiskerCount = whiskerCount + 1   
            labelCFirstElemenLgend = labelCFirstElemenLgend + 1
            if firstY != LL:
                firstYc = firstYc + 1
                firstY = LL
                
                labelWc = []                    
                meansLineA = []
                
                labelCFirstElemenLgend = 1
                
            colorMe = colorMeTimeS[firstYc]
            
            whiskerCount = whiskerCount + 1
            
            print ('Lbox', Lbox)
            LboxList = []
            with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                for line in islice(readToA, 0, None):
                    dateToList = line.split()[1]
                    convertedDate = dt.datetime.strptime(dateToList,'%m/%d/%Y').date() 
                    if Lbox == convertedDate:
                        #print ('Lbox matched')
                        getValue = line.split()[2]
                        LboxList.append(float(getValue))
                        doy = int(convertedDate.strftime('%j'))

            labelWc.append(doy) #whiskerCount) 
            
            meanL = np.mean(LboxList)
            meansLineA.append(meanL)
        
            plt.plot(labelWc, meansLineA, linestyle='--', marker='o', color=colorMe, label=str(LL) if labelCFirstElemenLgend == 1 else "")
            print ('plotting the line')
            print ('labelWc-------', labelWc)
            print ('meansLineA--------', meansLineA)
        plt.legend(loc='upper left')

        saveHere = str(myfilepath) + '/SaveFigures' + '/' + 'BoxPlotLines.png'
        plt.savefig(saveHere, dpi=600) 

        self.dlg.listWidget_4.setCurrentRow(0)

        self.dlg.textBrowser.append('   Time-series trends for each grid of all selected Layers saved in SaveFigures directory!')

    #####################  pdf      
    def pdf_summary(self):

        #selectedLayer = str(self.dlg.listWidget.currentItem().text())
        selectedLayer = str(self.dlg.comboBox_3.currentText())    
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]

        #myfilepathP = polygonLayer.source()
        #myfilepathP = os.path.dirname(myfilepathP)
        myfilepathP = str(self.dlg.lineEdit_5.text())
        print ('myfilepathP input image', myfilepathP) 

        try:
            os.mkdir(myfilepathP + '/SavePDFs')
        except:
            print ('dir exist')

        myfilepathPd = myfilepathP + '/SavePDFs' 
        print ('myfilepathPd', myfilepathPd)
        
        myfilepathPd = os.path.normpath(myfilepathPd)
        print ('myfilepathPd norm', myfilepathPd)

        self.dlg.textBrowser.append('\n   Simple map photos will be saved in - ' + str(myfilepathPd) + ' - in directory')

        QCoreApplication.processEvents()
        QgsProject.instance().reloadAllLayers()
         
        mapping = '_mapping'
        
        if self.gIndexMap == True:
            mapping = '_indexMap'
        if self.gNappMap == True:
            mapping = '_NappMap'           

        useListWidget = self.dlg.listWidget_3.selectedItems()
        #if self.dlg.checkBox_5.isChecked():
        if self.gNappMap == True:
            useListWidget = self.dlg.listWidget_4.selectedItems()
        for selectedImage in useListWidget: #self.dlg.listWidget_3.selectedItems():
            selectedLayer = selectedImage.text()
            print ('--------------------------0------------------------')
            #QgsProject.instance().reloadAllLayers()
            QCoreApplication.processEvents()
            vlayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
            vlayer.triggerRepaint()
            iface.setActiveLayer(vlayer)
            
            #vlayer.triggerRepaint()                  
            QCoreApplication.processEvents()             

            #image_location = os.path.join(QgsProject.instance().homePath(), str(selectedLayer) + '.png') #"render.png")            
            #image_location = os.path.join(myfilepathPd, str(selectedLayer) + str(mapping) + '.png') #"render.png")
            image_location = os.path.join(myfilepathPd, str(selectedLayer) + str(mapping) + '.png') #"render.png")
            print ('image_location', image_location)
            QCoreApplication.processEvents()
            print ('vlayer', vlayer)
            options = QgsMapSettings()
            options.setLayers([vlayer])
            options.setBackgroundColor(QColor(255, 255, 255))
            options.setOutputSize(QSize(800, 600))
            options.setExtent(vlayer.extent())
            QCoreApplication.processEvents()
            render = QgsMapRendererParallelJob(options)
            QCoreApplication.processEvents()

            render.start()
            render.waitForFinished()
            img = render.renderedImage()
            img.save(image_location, "png")
            
            self.dlg.textBrowser.append('      *' + str(selectedLayer) + '- Index Map Saved!')
            
            # def finished():
                # img = render.renderedImage()
                # for feature in vlayer.getFeatures():
                   # print (feature.id())
                   # #self.dlg.textBrowser.append(str(feature.id()))
                # #img.save(image_location, "png")
                # img.save(image_location)                                
                # QCoreApplication.processEvents()
                # print("saved")
                # self.dlg.textBrowser.append('      *' + str(selectedLayer) + '- Index Map Saved!')
                # #return                
            # QCoreApplication.processEvents()           
            # render.finished.connect(finished) 
            # render.start()           
            #QCoreApplication.processEvents()           
            # loop = QEventLoop()            
            # render.finished.connect(loop.quit)            
            
            QCoreApplication.processEvents()
            vlayer.triggerRepaint() 
            print ('--------------------------1------------------------')
            QCoreApplication.processEvents()
            
        ##############################               

    def nitrogen_prescriptions(self):

        print ('N prescriptions')
        self.dlg.textBrowser.append('\nSection 4.:')
        self.dlg.textBrowser.append('   Nitrogen prescriptions running...')
        
        # percent = 0
        # self.dlg.progressBar_4.setValue(1)
        # self.dlg.progressBar_4.setMinimum(percent)
        # self.dlg.progressBar_4.setMaximum(percent)
        # self.dlg.progressBar_4.setValue(percent)         

        self.gIndexMap = False
        self.gNappMap = True

        selectedLayer = str(self.dlg.comboBox_3.currentText())    
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]

        #myfilepathP = polygonLayer.source()
        #myfilepathP = os.path.dirname(myfilepathP)
        myfilepathP = str(self.dlg.lineEdit_5.text())
        print ('myfilepathP input image', myfilepathP) 

        try:
            os.mkdir(myfilepathP + '/SavePDFs')
        except:
            print ('dir exist')

        myfilepathPd = myfilepathP + '/SavePDFs' 
        print ('myfilepathPd', myfilepathPd)
        
        myfilepathPd = os.path.normpath(myfilepathPd)
        print ('myfilepathPd norm', myfilepathPd)


                
        for selectedImage in self.dlg.listWidget_4.selectedItems():
            selectedLayer = selectedImage.text()
            self.dlg.textBrowser.append('      *' + str(selectedLayer) + ' - processing...')
            #activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
            # self.find_INDEX_min_max_mean()
            # QgsProject.instance().reloadAllLayers()
            # QCoreApplication.processEvents()
        
            # self.calculate_Napp_distribution()
            # QgsProject.instance().reloadAllLayers()
            # QCoreApplication.processEvents()

            percent = 0
            self.dlg.progressBar_4.setValue(1)
            self.dlg.progressBar_4.setMinimum(percent)
            self.dlg.progressBar_4.setMaximum(percent)
            self.dlg.progressBar_4.setValue(percent) 
            
            #selectedLayer = str(self.dlg.listWidget_4.currentItem().text())            
            activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
            
            # this one changes the active layer... form of refresh qgis list
            iface.setActiveLayer(activeLayer)
            
            QCoreApplication.processEvents()
            
            for field in activeLayer.fields():
                idx = activeLayer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))                

            listOfValues = []
            for feature in activeLayer.getFeatures():                    
                print ('field', feature.id(), 'value',feature.attributes()[idx])
                listOfValues.append(float(feature.attributes()[idx]))


            myMin = np.min(listOfValues)
            myMax = np.max(listOfValues)
            myMean = np.mean(listOfValues)

            print ('myMin---------', myMin)
            print ('myMax----------', myMax)
            print ('myMean----------', myMean)
            
            self.myMinMeM = myMin  
            self.myMaxMeM = myMax
            self.myMeanMeM = myMean

            self.calculate_Napp_distribution()
            #QgsProject.instance().reloadAllLayers()
            QCoreApplication.processEvents()            
            #myMin = np.min(listOfValues)
            #myMax = np.max(listOfValues)
            
            print ('myMin', myMin)
            print ('myMax', myMax)

            myMinLow = myMin
            myMaxHihg = myMax
            myMaxHihgEnd = myMax

            print ('myMin', myMin)
            print ('myMax', myMax)
            print ('myMaxHihgEnd', myMaxHihgEnd)
            
            Napplication = 'Napp'

            provider = activeLayer.dataProvider()
            #area_field = QgsField('Yield', QVariant.Int)
            area_field = QgsField(Napplication, QVariant.Int)
            provider.addAttributes([area_field])
            #layer.updateFields()
            idxN = provider.fieldNameIndex(Napplication)
            
            QgsProject.instance().reloadAllLayers()

            classMeNumber = int(self.dlg.lineEdit_2.text())
            classMeDiscStep = (myMax - myMin) / classMeNumber
            
            NminInp = int(self.dlg.lineEdit_3.text())       
            NmaxInp = int(self.dlg.lineEdit_4.text()) 
            NincInp = (NmaxInp - NminInp) / (classMeNumber - 1) 
            
            graphingDistribution = []
            boxPlotNumber = 1
            yAxisPlaceHolderForJitter = []
            
            countHm = 0

            fc = polygonLayer.featureCount()
            print ('fc', fc)            
            percentInc = 100/fc        
           
            QCoreApplication.processEvents()
            
            for feature in activeLayer.getFeatures():        
                attrs = feature.attributes()
                
                #lenstr = len(str(feature.attributes()[idx]).split(".")[1])
                #print ('length of decimals', lenstr)
                
                countHm = countHm + 1
                
                percent = percent + percentInc 
               
                myMin = myMinLow #np.min(listOfValues)
                myMax = myMaxHihg #np.max(listOfValues)            

                NminInp = int(self.dlg.lineEdit_3.text())       
                NmaxInp = int(self.dlg.lineEdit_4.text()) 

                if self.dlg.checkBox_3.isChecked():
                    NminInp = NmaxInp
                
                tryThis = False
                for i in range(1, classMeNumber+1):
                    #print ('----------------------------')

                    myMin= myMin
                    myMax= myMin + (classMeDiscStep)
                    
                    # lenstr = len(str(feature.attributes()[idx]).split(".")[1])
                    # print ('length of decimals', lenstr)
                    # #feature.attributes()[idx]

                    # myMin= round(float(myMin), lenstr)
                    # myMax= round(float(myMin + (classMeDiscStep)), lenstr)                      
                    
                    applicationNrate = NminInp
                    
                    #if round(float(feature.attributes()[idx]), 3) >= round(myMin, 3) and round(float(feature.attributes()[idx]), 3) < round(myMax, 3):
                    if float(feature.attributes()[idx]) >= myMin and float(feature.attributes()[idx]) < myMax:
                        attrsM = {idxN : int(applicationNrate)}
                        activeLayer.dataProvider().changeAttributeValues({feature.id() : attrsM})
                        QCoreApplication.processEvents()
                        
                        graphingDistribution.append(float(applicationNrate))

                        jitterAdded = np.random.normal(boxPlotNumber, 0.04)
                        yAxisPlaceHolderForJitter.append(jitterAdded)
                        print ('match found')    
                        tryThis = True

                    print ('     countHm', countHm, 'class number', i, 'value',str(feature.attributes()[idx]))
                    print ('     myMin', str(myMin), 'myMax', str(myMax), 'applicationNrate', applicationNrate)

                    if self.dlg.checkBox_2.isChecked():
                        NminInp = NminInp + NincInp

                    if self.dlg.checkBox_3.isChecked():
                        NminInp = NminInp - NincInp
                    
                    myMin = myMax 
                    
                    print ('----------------------------')
                    
                # get the last max due to condition min <=  and   < max
                #    if round(float(feature.attributes()[idx]), 3) == round(myMaxHihgEnd, 3):
                #    if float(feature.attributes()[idx]) == round(float(myMaxHihgEnd), lenstr): # and countHm == fc: 
                # tryThis condition was setup beacause of the condition myMin myMax and classStep decimals cause double count of max N - keept it until you figure out better solution
                #    if float(feature.attributes()[idx]) == myMaxHihgEnd and tryThis == False: # and countHm == fc:
                if tryThis == False: # and countHm == fc:      
                    attrsM = {idxN : int(applicationNrate)}
                    activeLayer.dataProvider().changeAttributeValues({feature.id() : attrsM})
                    QCoreApplication.processEvents()
                    
                    graphingDistribution.append(float(applicationNrate))

                    jitterAdded = np.random.normal(boxPlotNumber, 0.04)
                    yAxisPlaceHolderForJitter.append(jitterAdded)
                    print ('match found - of max') 
                    self.dlg.textBrowser.append('          - Grid: ' + str(countHm) + ' potential problem with N value assignment to index value')
                    # 
                #print ('----------------------------')
                
                self.dlg.progressBar_4.setMaximum(100)
                self.dlg.progressBar_4.setValue(int(round(percent)))
                
                QgsProject.instance().reloadAllLayers()
                activeLayer.triggerRepaint()
                QCoreApplication.processEvents()
            
            print ('graphingDistribution', graphingDistribution)
            
            ############################################ add labels to the active layer - start
            
            layer = iface.activeLayer()
            layer_settings  = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            text_format.setFont(QFont("Arial", 10))
            text_format.setSize(12)

            layer_settings.setFormat(text_format)
            layer_settings.fieldName = Napplication  #"N-app"
            layer_settings.isExpression = True
            #layer_settings.placement = 1
            layer_settings.formatNumbers = True  # checkbox
            layer_settings.decimals = 1  # decimals number
            layer_settings.enabled = True
            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            
            layer.setLabelsEnabled(True)
            layer.setLabeling(layer_settings)
            
            layer.triggerRepaint()
            
            QgsProject.instance().reloadAllLayers()
            QCoreApplication.processEvents()
            ############################################ add labels to the active layer - end 

            layer = iface.activeLayer()
            fni = layer.fields().indexFromName(Napplication) #'nom')
            unique_values = layer.uniqueValues(fni)

            unique_values = sorted(unique_values)

            if self.dlg.checkBox_3.isChecked():
                unique_values = sorted(unique_values, reverse=False)    

            print ('unique_values', unique_values)

            colorMeSelected = str(self.dlg.comboBox_4.currentText()).split('-')[0]
            
            colorMeIntDiscStep = int((255 - 5) / (int(len(unique_values)) - 1))
            print ('colorMeIntDiscStep', colorMeIntDiscStep, str(int(len(unique_values))))
            redMe = 255 + colorMeIntDiscStep - 1 
            greenMe = 255 + colorMeIntDiscStep - 1
            blueMe = 255 + colorMeIntDiscStep - 1
            #colorMeIntDiscStep = int((255 - 5) / int(len(unique_values))) -1

            # fill categories
            categories = []
            
            saveColorMapL = []
            
            for unique_value in unique_values:

                # generate color palat - initial for loop element added at the beggining to accomodate missstep of for loop
                if colorMeSelected == 'R':            
                    redMe = 255 #redMe
                    greenMe = greenMe - colorMeIntDiscStep
                    blueMe = blueMe - colorMeIntDiscStep
                if colorMeSelected == 'G':            
                    redMe = redMe - colorMeIntDiscStep
                    greenMe = 255 #greenMe
                    blueMe = blueMe - colorMeIntDiscStep                              
                if colorMeSelected == 'B':            
                    redMe = redMe - colorMeIntDiscStep
                    greenMe = greenMe - colorMeIntDiscStep
                    blueMe = 255 #blueMe 

                # initialize the default symbol for this geometry type
                symbol = QgsSymbol.defaultSymbol(layer.geometryType())
                
                # configure a symbol layer
                layer_style = {}
                layer_style['color'] = '%d, %d, %d' % (int(redMe), int(greenMe), int(blueMe)) #(randrange(0, 256), randrange(0, 256), randrange(0, 256))
                #print (layer_style['color'])
                #layer_style['outline'] = '#000000'
                #layer_style['color'] = redMe, greenMe, blueMe
                print (layer_style['color'])
                #layer_style['outline'] = '#000000'
                symbol_layer = QgsSimpleFillSymbolLayer.create(layer_style)

                # replace default symbol layer with the configured one
                #if symbol_layer is not None:
                symbol.changeSymbolLayer(0, symbol_layer)

                # create renderer object
                # category = QgsRendererCategory(unique_value, symbol, str(unique_value))
                category = QgsRendererCategory(unique_value, symbol, str(unique_value))            

                # entry for the list of category items
                categories.append(category)

                myColorH = [redMe/255, greenMe/255, blueMe/255]
                
                saveColorMapL.append(myColorH)

            # create renderer object
            renderer = QgsCategorizedSymbolRenderer(Napplication, categories)

            # assign the created renderer to the layer
            #if renderer is not None:
            layer.setRenderer(renderer)

            layer.triggerRepaint()
            QgsProject.instance().reloadAllLayers()


            #######################

            numberOfObsPerYear = int(len(graphingDistribution)) # 1
            print ('--numberOfObsPerYear', numberOfObsPerYear)
            c = 'blue'

            boxPlotListAll = []

            figure, axis = plt.subplots(2,1, gridspec_kw={'height_ratios': [2, 1]})
          
            steps_parameter = 1

            boxPlotListAll.append(graphingDistribution)

            arrayMe = np.array(graphingDistribution)

            arrayMeMin = min(arrayMe)
            arrayMeMax = max(arrayMe)

            arrangedMe = np.arange(arrayMeMin, arrayMeMax, steps_parameter)
            meanMe = statistics.mean(arrayMe)
            medianMe = statistics.median(arrayMe)
            sdMe = statistics.stdev(arrayMe)   

            axis[0].plot(arrangedMe, norm.pdf(arrangedMe, meanMe, sdMe),
                    label='grids' + ' (n={})'.format(int(numberOfObsPerYear)) +'\n' + '(Std.dev.:{})'.format(int(sdMe)) +'\n' + '(Field avg.:{})'.format(int(meanMe)), color=c)

            axis[0].axvline(meanMe, color=c, linestyle='dashed', linewidth=1)
            axis[1].axvline(meanMe, linestyle='dashed', color=c, linewidth=1)
            axis[1].scatter(arrayMe, yAxisPlaceHolderForJitter, color=c, alpha=0.5, marker='o', s=10)
            
            b = axis[1].boxplot(boxPlotListAll, vert=0)
       
            axis[1].set_xlabel('Distribution of rates [kg ha$^{-1}$]', fontsize=11)       
            axis[0].legend(loc='center left', bbox_to_anchor=(0.8, 0.5), facecolor='white', framealpha=1.0)    
            figure.savefig('{}/{}_DistributionMe.jpg'.format(myfilepathPd, selectedLayer)) #, dpi=300)
            
            ############

            nrates = np.array(graphingDistribution)
            numberOfnrates = int(len(graphingDistribution))

            mu = statistics.mean(nrates)
            sigma = statistics.stdev(nrates)
            num_bins = int(len(unique_values))
            
            print ('num_bins', num_bins)

            fig, ax = plt.subplots()

            n, bins, patches = ax.hist(nrates, num_bins, density=True, edgecolor='white', linewidth=2)
            y = ((1 / (np.sqrt(2 * np.pi) * sigma)) * np.exp(-0.5 * (1 / sigma * (bins - mu))**2))
            ax.plot(bins, y, '--')
            ax.set_xlabel('Value')
            ax.set_ylabel('Probability density')
            ax.set_title('Histogram of normal distribution sample: 'fr'$\mu={mu:.0f}$, $\sigma={sigma:.0f}$')
            fig.tight_layout()
            fig.savefig('{}/{}_Distribution.jpg'.format(myfilepathPd, selectedLayer)) #, dpi=300)

            ########################
            print ('saveColorMapL', saveColorMapL)
            fig = plt.figure()        
            #plt.hist(nrates) #, bins=25, density=True, alpha=0.6, color='b')

            labels, counts = np.unique(nrates, return_counts=True)
            plt.bar(labels, counts, width=NincInp-1, align='center', color=saveColorMapL, edgecolor='black')
            plt.gca().set_xticks(labels)

            # for labels, value in enumerate(counts):
                # plt.text(value, labels, str(value))
            for iB in range(len(labels)):
                #plt.text(iB, counts[iB], counts[iB], ha = 'center')
                plt.annotate(str(counts[iB]), xy=(labels[iB],counts[iB]), ha='center', va='bottom', fontsize=14)

            plt.xticks(rotation=90)
            #plt.autoscale(tight=True)
            
            #plt.grid(axis = "y")
            plt.xlabel('Simulated rates (kg)', fontsize=14)
            plt.ylabel('Number of corresponding rates', fontsize=14)
            plt.xticks(fontsize=14)
            plt.yticks(fontsize=14)
            plt.tight_layout()    
            fig.savefig('{}/{}_SimulateRates_Legend.jpg'.format(myfilepathPd, selectedLayer)) #, dpi=300)

            ############## this is functional code - not sure if usefull
            
            ndviXaxis = []
            NappYaxis = []
            
            layer = iface.activeLayer()
            for field in layer.fields():
                idxIN = layer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))  

            idxN = provider.fieldNameIndex(Napplication)

            #listOfValues = []
            for feature in layer.getFeatures():                    
                print ('field pull', feature.id(), 'value index',feature.attributes()[idxIN])
                print ('field pull', feature.id(), 'value Napp',feature.attributes()[idxN])
                #listOfValues.append(float(feature.attributes()[idxIN]))
                ndviXaxis.append(float(feature.attributes()[idxIN]))
                NappYaxis.append(float(feature.attributes()[idxN]))

            fig = plt.figure()
            plt.scatter(ndviXaxis, NappYaxis)
            
            x = np.array(ndviXaxis)
            y = np.array(NappYaxis)

            res = stats.linregress(x, y)
            #plt.plot(x, res.intercept + res.slope*x, 'r', label='fitted line')
            plt.plot(x, res.intercept + res.slope*x, 'r')       
            print ('intercept', res.intercept, 'slope', res.slope)
           
            plt.suptitle('Fitted line slope: ' + str(round(res.slope, 2)))
            
            plt.xlim(0,1)
            
            plt.xlabel('Index values')
            plt.ylabel('Simulated rates')        
            fig.savefig('{}/{}_SimulatedRates.jpg'.format(myfilepathPd, selectedLayer))
            ###############

            QgsProject.instance().reloadAllLayers()
            layer.triggerRepaint()
            QCoreApplication.processEvents()

        self.pdf_summary()

        self.dlg.textBrowser.append('   Nitrogen prescriptions finishd.')
        
    def scale_Napp_to_actual_size_of_grid(self):
        print ('scale n to actual grid size')
        self.dlg.textBrowser.append('\n   Nitrogen applications resaclling according to size of grid running...')
        
        selectedLayer = str(self.dlg.listWidget_4.currentItem().text())            
        activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        
        iface.setActiveLayer(activeLayer)

        Napplication = 'Napp'
        provider = activeLayer.dataProvider()
        #area_field = QgsField('Yield', QVariant.Int)
        area_field = QgsField(Napplication, QVariant.Int)
        provider.addAttributes([area_field])
        #layer.updateFields()
        idxN = provider.fieldNameIndex(Napplication)


        NapplicationA = 'actualNkg'
        provider = activeLayer.dataProvider()
        #area_field = QgsField('Yield', QVariant.Int)
        area_field = QgsField(NapplicationA, QVariant.Double, 'double', 5, 2)
        provider.addAttributes([area_field])
        #layer.updateFields()
        idxNactual = provider.fieldNameIndex(NapplicationA)
        
        QgsProject.instance().reloadAllLayers()

        
        lyr_crs = activeLayer.crs()

        lyrCRS = activeLayer.crs().authid() # returns a reference to the active QgsMapLayer
        print('lyrCRS', lyrCRS)

        elps_crs = QgsCoordinateReferenceSystem()
        elps_crs.createFromUserInput('WGS84')
        #elps_crs.createFromUserInput(lyrCRS)

        trans_context = QgsCoordinateTransformContext()
        #trans_context.calculateDatumTransforms(lyr_crs, elps_crs) # this one was depricated
        trans_context.calculateCoordinateOperation(lyr_crs, elps_crs)

        area = QgsDistanceArea()
        area.setEllipsoid('WGS84')
        #area.setEllipsoid(lyrCRS)
        area.setSourceCrs(lyr_crs, trans_context)        
        
        QCoreApplication.processEvents()
        countHm = 0
        for feature in activeLayer.getFeatures():        
            #attrs = feature.attributes()
            attrs = feature.attributes() #[3]
            print ('value of napp field', attrs[idxN])
            countHm = countHm + 1

            
            #area
            geom= feature.geometry() 
            print ('countHm', countHm)
            print("Perimeter(m):",area.measurePerimeter(geom))
            print("Area (m2):", area.measureArea(geom))          
            print ("Feature---areaMe--%of hectart---------: ", str((area.measureArea(geom))/10000))

            applicationNrateA = float(attrs[idxN]) * ((area.measureArea(geom))/10000)

            print ('value of napp field', attrs[idxN])
            print ('value of napp kg per grid', applicationNrateA)

            attrsM = {idxNactual : float(applicationNrateA)}
            activeLayer.dataProvider().changeAttributeValues({feature.id() : attrsM})
            QCoreApplication.processEvents()   
        self.dlg.textBrowser.append('   Nitrogen applications resaclling according to size of grid finished.')  

        ############################################ add labels to the active layer - start
        
        layer = iface.activeLayer()
        layer_settings  = QgsPalLayerSettings()
        text_format = QgsTextFormat()
        text_format.setFont(QFont("Arial", 10))
        text_format.setSize(12)

        layer_settings.setFormat(text_format)
        layer_settings.fieldName = NapplicationA  #"N-app"
        layer_settings.isExpression = True
        #layer_settings.placement = 1
        layer_settings.formatNumbers = True  # checkbox
        layer_settings.decimals = 1  # decimals number
        layer_settings.enabled = True
        layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
        
        layer.setLabelsEnabled(True)
        layer.setLabeling(layer_settings)
        
        layer.triggerRepaint()
        
        QgsProject.instance().reloadAllLayers()
        QCoreApplication.processEvents()
        ############################################ add labels to the active layer - end         