# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NDVItoVariableNitrogenApplicationMap
                                 A QGIS plugin
 This plugin was developed for producing variable nitrogen application maps based index value.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-03-25
        git sha              : $Format:%H$
        copyright            : (C) 2024 by Emir Memic
        email                : emir_memic@windowslive.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .ndvi_to_variable_nitrogen_application_map_dialog import NDVItoVariableNitrogenApplicationMapDialog
import os.path

# me
from qgis.utils import reloadPlugin
from qgis.analysis import QgsZonalStatistics
from qgis.core import *
from qgis.utils import *
import processing
from PyQt5.QtGui import QFont, QColor
from qgis.PyQt import *
from qgis.PyQt.QtWidgets import QMessageBox

import matplotlib.pyplot as plt
import numpy as np

import datetime as dt
from datetime import datetime
import matplotlib.dates as mdates

from itertools import islice
import numpy as np
import re

from PyQt5.QtCore import *
from PyQt5.QtGui import *

#from random import randrange
from scipy.stats import norm
import statistics

from qgis.PyQt.QtCore import QEventLoop

class NDVItoVariableNitrogenApplicationMap:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'NDVItoVariableNitrogenApplicationMap_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&NDVI to Variable Nitrogen Application Map')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('NDVItoVariableNitrogenApplicationMap', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/ndvi_to_variable_nitrogen_application_map/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'From NDVI to variable N application map'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True


    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&NDVI to Variable Nitrogen Application Map'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.dlg = NDVItoVariableNitrogenApplicationMapDialog()

#### me-start
        reloadPlugin('ndvi_to_variable_nitrogen_application_map')
        print ('run ndvi_to_variable_nitrogen_application_map plugin')

        self.dlg.pushButton.clicked.connect(self.image_analysis)
        self.dlg.pushButton_2.clicked.connect(self.calculate_time_series_trend)
        self.dlg.pushButton_2.clicked.connect(self.plot_figures)
        self.dlg.pushButton_3.clicked.connect(self.pdf_summary)
        self.dlg.pushButton_5.clicked.connect(self.pdf_summary)
        self.dlg.pushButton_4.clicked.connect(self.nitrogen_prescriptions)
        self.dlg.pushButton_6.clicked.connect(self.guide_to_user)
        self.dlg.pushButton_7.clicked.connect(self.scale_Napp_to_actual_size_of_grid)

        self.dlg.checkBox_4.setEnabled(False)
        self.dlg.checkBox_5.setEnabled(False)

        self.dlg.checkBox_2.setChecked(True)
        self.dlg.checkBox_2.clicked.connect(self.yield_maximising_N_opt)
        self.dlg.checkBox_3.clicked.connect(self.yield_equalising_N_opt)
        
        self.dlg.listWidget.clear()
        self.dlg.listWidget_2.clear()
        self.dlg.listWidget_3.clear()
        self.dlg.comboBox.clear()
        self.dlg.comboBox_2.clear()
        
        # add available layers into interface
        layers = self.iface.mapCanvas().layers()
        listOfLayers = []
        for layer in layers:
            listOfLayers.append(str(layer.name()))
            QCoreApplication.processEvents()
        self.dlg.listWidget.addItems(listOfLayers)
        self.dlg.listWidget_2.addItems(listOfLayers)
        self.dlg.listWidget_2.sortItems()        
        self.dlg.comboBox.addItems(['mean','median','count','sum', 'stdev', 'min', 'max'])
        self.dlg.comboBox_2.addItems(['red','green','blue'])

        self.dlg.listWidget.setCurrentRow(0)
        self.dlg.listWidget_2.setCurrentRow(0)        
#### me-end

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass

    def guide_to_user(self):
        #QMessageBox.warning(self.dlg, 'Warning!', 'DSSAT directory not found! Locate manually! e.g. C:/DSSAT47')
        QMessageBox.information(None, 'Guide to user!', 
        '1. - Input layer - site-specific units deliniated based on which zonal statistics are calculated.\n'
        + '   - Input raster - raster image providing pixel based info for deliniated areas used for zonal statistics.\n\n'
        + '2. - Image analysis - produces raster based on initial site-specific polygon deliniation. Here user can setup number of index clases that are calculated from 0 to 1, with color.\n\n'
        + '3. - Calculate time-series trends - raster values added into time-series figure, and saved in FigureSaved dir. Index-map push button produces maps and saved them in SavePDFs dir.\n\n'
        + '4. - N recommendation setup - based on in-field variablity a user can define min and max N prescription that will be allocated to index values in relative terms.\n'
        + '   - N recommendation method selection - N application rates method. Yield maximising will allocate more N to polygons with higher index values, and yield equlising will allocate more N to the polygons with lower index values.\n'
        + '   - N-recommendation - this will created application maps.\n\n'
        + '   - N app. map push button will produce final N application map.'        
        )

    def yield_maximising_N_opt(self):
        self.dlg.checkBox_2.setChecked(True)
        self.dlg.checkBox_3.setChecked(False)
        
    def yield_equalising_N_opt(self):
        self.dlg.checkBox_2.setChecked(False)
        self.dlg.checkBox_3.setChecked(True)
        
    def image_analysis(self):
        print('image_analysis - start')
        self.dlg.textBrowser.append('Section 1. and 2.:')
        
        self.dlg.listWidget_3.clear()

        numberOfSelectedLayers = len(self.dlg.listWidget_2.selectedItems())
        print ('numberOfSelectedLayers-------', numberOfSelectedLayers)
        percentInc = 100/int(numberOfSelectedLayers)
        percent = 0 

        self.dlg.progressBar.setValue(0)
        listOfLayersForLater = []
        meCounterCheck = 0
        for selectedImage in self.dlg.listWidget_2.selectedItems():
            selectedLayer1 = selectedImage.text()          
            
            meCounterCheck = meCounterCheck + 1
            print ('meCounterCheck' ,meCounterCheck, 'current image', selectedLayer1)
            percent = percent + percentInc

            selectedLayer = str(self.dlg.listWidget.currentItem().text())            
            polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
            
            # specify raster filename
            #selectedLayer1 = str(self.dlg.listWidget_2.currentItem().text())
            layer=QgsProject.instance().mapLayersByName(selectedLayer1)[0]
            iface.setActiveLayer(layer)        
            activeLayer = self.iface.activeLayer()
            myfilepath1= iface.activeLayer().dataProvider().dataSourceUri()
            print ('myfilepath input image', myfilepath1)                
            #rasterLayer = QgsRasterLayer('D:/Users/ememic/Desktop/qgisPluginImageTest/me.tiff', 'raster') #'F:/temp/zonalstat/raster1.tif')
            inputLayerName = str(self.dlg.listWidget_2.currentItem().text())
            rasterLayer = QgsRasterLayer(myfilepath1, 'raster')

            # clean attrbute table of template layer
            fields = []
            for field in polygonLayer.fields():
                idx = polygonLayer.dataProvider().fieldNameIndex(field.name())
                fields.append(idx)
            print ( fields)   
            fields.remove(0)
            print ( fields)
            polygonLayer.dataProvider().deleteAttributes(fields)
            polygonLayer.updateFields()
            
            zoneStat = QgsZonalStatistics(polygonLayer, rasterLayer, rasterBand=1,
                                                                                    stats=QgsZonalStatistics.Statistics(
                                                                                    QgsZonalStatistics.Count | 
                                                                                    QgsZonalStatistics.Sum | 
                                                                                    QgsZonalStatistics.Mean | 
                                                                                    QgsZonalStatistics.Median |               
                                                                                    QgsZonalStatistics.StDev | 
                                                                                    QgsZonalStatistics.Min | 
                                                                                    QgsZonalStatistics.Max                               
                                                                                    )).calculateStatistics(None)


# added here to use directly ndvi calculated from copernicus - start
            date = str(selectedLayer1).split('_')[-1]
            if date == 'NDVI': # or date == 'EVI':
                match = re.search(r'\d{4}-\d{2}-\d{2}', selectedLayer1)
                date = datetime.strptime(match.group(), '%Y-%m-%d').date()
                print ('date', date)                    
                dateName = str(date).split('-')[1] + '-' + str(date).split('-')[2] + '-' + str(date).split('-')[0]
                print ('dateName---------', dateName)
                selectedLayer1 = selectedLayer1 + '_' + dateName
# added here to use directly ndvi calculated from copernicus - end             

            result=processing.run("native:buffer",{'INPUT':polygonLayer,
                                                    'DISTANCE': -1.0,   # brush of weird polygon edges                                                 
                                                    'OUTPUT':'memory:{}'.format(str(selectedLayer) + '-' + str(selectedLayer1))})             
            QgsProject.instance().addMapLayer(result['OUTPUT'])
            
            #QgsProject.instance().addMapLayer(polygonLayer)

            listOfLayersForLater.append(str(selectedLayer) + '-' + str(selectedLayer1))

            
            
    ############################################ add labels to the active layer - start
            layer = iface.activeLayer()
            layer_settings  = QgsPalLayerSettings()
            text_format = QgsTextFormat()
            text_format.setFont(QFont("Arial", 10))
            text_format.setSize(12)

            layer_settings.setFormat(text_format)
            layer_settings.fieldName = str(self.dlg.comboBox.currentText()) #"mean"
            layer_settings.isExpression = True
            #layer_settings.placement = 1
            layer_settings.formatNumbers = True  # checkbox
            layer_settings.decimals = 3 #2  # decimals number
            layer_settings.enabled = True
            layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
            
            layer.setLabelsEnabled(True)
            layer.setLabeling(layer_settings)
            layer.triggerRepaint()
            
            QgsProject.instance().reloadAllLayers()
    ############################################ add labels to the active layer - end  
############################################ coloring different polygons based of field value - start     
            print ('me1')
            layer = iface.activeLayer()

            QCoreApplication.processEvents()

            myRangeList= [] 
            #myOpacity= 1
            #myOpacity= 5    
            
            myTargetField = str(self.dlg.comboBox.currentText()) #"Yield"
            
            myMin= 0 #1 # float(QgsZonalStatistics.Min) #0 #self.dlg.minMe
            myMax= 1 #40 #float(QgsZonalStatistics.Max) #1 #self.dlg.maxMe 

##############
            if self.dlg.checkBox_6.isChecked():
                for field in layer.fields():
                    idxIN = layer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))  

                listOfValues = []
                for feature in layer.getFeatures():                    
                    print ('field', feature.id(), 'value',feature.attributes()[idxIN])
                    listOfValues.append(float(feature.attributes()[idxIN]))
                
                myMin = np.min(listOfValues)
                myMax = np.max(listOfValues)
                
                print ('myMin', myMin)
                print ('myMax', myMax)
############


            print  ('myMin', myMin, 'myMax', myMax)   
            
            #red
            redMe = 255
            greenMe = 255
            blueMe = 255

            colorMeSelected = str(self.dlg.comboBox_2.currentText())       
            classMeNumber = int(self.dlg.lineEdit.text()) #4
            classMe = 'Class'

            classMeDiscStep = (myMax - myMin) / classMeNumber
            colorMeIntDiscStep = int((255 - 5) / classMeNumber)
            
            for i in range(1, classMeNumber+1):
                
                myMin= myMin
                # added 0.00001 to the range myMin and myMax distorts ratios a bit, but it fixes highest myMax range not beeing included in the color map    
                myMax= myMin + (classMeDiscStep) #+ 0.00001
                
                myLabel = classMe + '_' + str(i) + ': ' + str(round(myMin,2)) + '-' + str(round(myMax, 2))   #'Group 1' 
                myColour= QtGui.QColor(redMe,greenMe,blueMe) #)'#FF0000') #'#ffee00') 
                mySymbol1= QgsSymbol.defaultSymbol(layer.geometryType()) 
                mySymbol1.setColor(myColour) 
                #mySymbol1.setOpacity(myOpacity) 
                myRange1= QgsRendererRange(myMin,myMax,mySymbol1,myLabel) 
                myRangeList.append(myRange1)

                     
                
                myMin = myMax
        
                print('R'+ str(redMe) + ' G'+ str(greenMe) + ' B'+ str(blueMe))

                if colorMeSelected == 'red':            
                    redMe = redMe
                    greenMe = greenMe - colorMeIntDiscStep
                    blueMe = blueMe - colorMeIntDiscStep
                if colorMeSelected == 'green':            
                    redMe = redMe - colorMeIntDiscStep
                    greenMe = greenMe
                    blueMe = blueMe - colorMeIntDiscStep                              
                if colorMeSelected == 'blue':            
                    redMe = redMe - colorMeIntDiscStep
                    greenMe = greenMe - colorMeIntDiscStep
                    blueMe = blueMe      

                print ('myRangeList--------', str(myRangeList))
                
            myRenderer= QgsGraduatedSymbolRenderer('',myRangeList) 
            myClassificationMethod= QgsApplication.classificationMethodRegistry().method("EqualInterval")

            myRenderer.setClassificationMethod(myClassificationMethod) 
            myRenderer.setClassAttribute(myTargetField) 

           
            layer.setRenderer(myRenderer)        
            layer.triggerRepaint()
                   
            QgsProject.instance().reloadAllLayers()

            self.dlg.progressBar.setValue(int(percent))
            QCoreApplication.processEvents()
            

         
            self.dlg.textBrowser.append('      *' + str(selectedLayer) + '-' + str(selectedLayer1) + '- Image Analysed and Layer added to Legend!')
            
            
        #percent = percent + percentInc    
        #self.dlg.progressBar.setValue(int(percent))
        QCoreApplication.processEvents()
        print ('listOfLayersForLater list', listOfLayersForLater)    
        self.dlg.listWidget_3.addItems(listOfLayersForLater)
        self.dlg.listWidget_4.addItems(listOfLayersForLater)
        self.dlg.listWidget_3.selectAll()
        
############################################ coloring different polygons based of field value - end    

    def calculate_time_series_trend(self):
        
        self.dlg.textBrowser.append('\nSection 3.:')
        
        self.dlg.checkBox_4.setChecked(True)
        self.dlg.checkBox_5.setChecked(False)
        if self.dlg.checkBox_4.isChecked():
            self.dlg.pushButton_5.setEnabled(False)
            self.dlg.pushButton_3.setEnabled(True)

        selectedLayer = str(self.dlg.listWidget.currentItem().text())            
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        fc = polygonLayer.featureCount()
        print ('fc', fc)

        percentInc = 100/fc
        percent = 0        
        #fc = 5

        myfilepath = polygonLayer.source()
        myfilepath = os.path.dirname(myfilepath)
        print ('myfilepath input image', myfilepath) 

        try:
            os.mkdir(myfilepath + '/SaveFigures')
        except:
            print ('dir exist')
        
        self.dlg.textBrowser.append('   Time-series trends of each grid and avarage will be saved in - ' + str(myfilepath) + ' - in "SaveFigures" directory')     

        with open('{}/Eavaluation.txt'.format(myfilepath), 'w') as writestatistics:
           
            for i in range(1, fc+1):
                percent = percent + percentInc            
                
                
                
                for selectedImage in self.dlg.listWidget_3.selectedItems():
                    selectedLayer = selectedImage.text()
                    
                    date = str(selectedLayer).split('_')[-1]  
                    date = date.replace('-', '/') 

                    
                    activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
                    #print ('activeLayer',activeLayer)
                    
                    for field in activeLayer.fields():
                        idx = activeLayer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))                
                    #print ('idx', idx)

                    for feature in activeLayer.getFeatures():        
                        if float(feature.id()) == i:
                            print ('field', feature.id(), 'value',feature.attributes()[idx])   

                            writestatistics.write(str(i) + '\t' + str(date)  + '\t' + str(float(feature.attributes()[idx])) + '\n')
                    QCoreApplication.processEvents()
                    QgsProject.instance().reloadAllLayers() 

                    

                self.dlg.progressBar_3.setValue(int(percent))
                QCoreApplication.processEvents()

            QCoreApplication.processEvents() 

        self.dlg.textBrowser.append('   Time-series trends for each grid Evaluated!')



    def plot_figures(self):
        print ('plot and save figures')

        selectedLayer = str(self.dlg.listWidget.currentItem().text())            
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        fc = polygonLayer.featureCount()
        print ('fc', fc)
        
        #fc = 5

        myfilepath = polygonLayer.source()
        myfilepath = os.path.dirname(myfilepath)
        print ('myfilepath input image', myfilepath) 

        for i in range (1, 2):
            listOfDates = []
            with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                for line in islice(readToA, 0, None):
                    # print ('line', line)
                    gridId = line.split()[0]
                    if str(i) == gridId:
                        print ('line', line)
                        dateToList = line.split()[1]
                        #dateToList = dateToList.replace('-', '/')
                        listOfDates.append(dateToList)
                        
        print ('listOfDates', listOfDates)                
        newList = sorted([dt.datetime.strptime(d,'%m/%d/%Y').date() for d in listOfDates])
        print ('newList', newList)
        countMe = len(newList)
        print ('countMe', countMe)

################# color i am not sure if this is good and how slow it is have to check with more years 
        colorMeTimeS = []
        yearsToUse = []
        c = np.random.rand(3,)
        colorMeTimeS.append(c)
        
        firstYear = newList[0]
        LL = str(firstYear).split('-')[0]
        yearsToUse.append(LL)
        for L in newList:
            LL = str(L).split('-')[0]
            try:
                if LL != oldLL:
                    c = np.random.rand(3,)
                    colorMeTimeS.append(c)
                    yearsToUse.append(LL)
            except:
                pass
            oldLL = LL
        print ('yearsToUse', yearsToUse)
        print ('colorMeTimeS', colorMeTimeS) 

        colorYear = []
        idxCol = 0
        for yearColor in yearsToUse:
            idxCol +=1
            idx = yearColor + '_' + str(idxCol)
            colorYear.append(idx)
        print ('colorYear' ,colorYear)    

        colorIndexToUse = 0
###################



        
        percentInc = 100/fc
        percent = 0
        #fc = 6
        for i in range (1, fc+1):
            percent = percent + percentInc
            #c = np.random.rand(3,)
            listValues = []
            dateList = []
            fig = plt.figure()
            plt.ylabel(str(self.dlg.comboBox.currentText())) #'value')
            plt.xlabel('DOY')
            plt.gca().set_ylim([0,1])
            plt.gca().set_xlim([0,365])
            plt.xticks(np.arange(0, 366, 30))
            me = 0
            for L in newList:
                LL = str(L).split('-')[0]
                try:
                    if LL != oldLL:
                        listValues = []
                        dateList = []
                        me = 0
                        #c = np.random.rand(3,)
                except:
                    pass
                me = me + 1    
                with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                    for line in islice(readToA, 0, None):
                        dateToList = line.split()[1]
                        convertedDate = dt.datetime.strptime(dateToList,'%m/%d/%Y').date()
                        doy = int(convertedDate.strftime('%j'))
                        gridId = line.split()[0]
                        value = line.split()[2]
                        if str(i) == gridId:                
                            if L == convertedDate:
                                listValues.append(float(value))
                                dateList.append(int(doy))
################# color                
                for checkColorr in colorYear:                    
                    if str(LL) == checkColorr.split('_')[0]:
                        print ('checkColorrC-----------', 'LL', LL,  checkColorr.split('_')[0], 'idx color', checkColorr.split('_')[1])
                        colorIndexToUse = int(checkColorr.split('_')[1]) - 1
                c = colorMeTimeS[colorIndexToUse]
################# color                
                #plt.plot(dateList, listValues, linestyle='--', marker='o', color = c, label=str(LL) if me == int(countMe/2) else "")
                plt.plot(dateList, listValues, linestyle='--', marker='o', color = c, label=str(LL) if me == 1 else "") # else conditions is to keep legend clean
                
                
                oldLL = LL
            plt.legend(loc='upper right')    
            #saveHere = str(i) + '_.png'
            saveHere = str(myfilepath) + '/SaveFigures' + '/' +str(i) + '__.png'
            plt.savefig(saveHere)
            self.dlg.progressBar_2.setValue(int(percent))
            QCoreApplication.processEvents()

        QCoreApplication.processEvents() 

        # box plottting
        print ('listOfDates', listOfDates)
        print ('newList', newList)
        print ('yearsToUse', yearsToUse)
        print ('colorMeTimeS', colorMeTimeS)        
        
        if self.dlg.checkBox.isChecked():
            figureall = plt.figure()

            plt.ylabel(str(self.dlg.comboBox.currentText()) + ', black dotted line is mean')
            plt.gca().set_ylim([0,1])

            firstY = yearsToUse[0]
            firstYc = 0
            labelCFirstElemenLgend = 0
            whiskerCount = 0
            labelWc = []
            labelWv = []

            labelWcF = []
            labelWvF = []            
            
            meansLineA = []
            for Lbox in newList:
                LL = str(Lbox).split('-')[0]
                print ('LL me', LL)
                #whiskerCount = whiskerCount + 1   
                labelCFirstElemenLgend = labelCFirstElemenLgend + 1
                if firstY != LL:
                    firstYc = firstYc + 1
                    firstY = LL
                    
                    labelWc = []                    
                    meansLineA = []
                    
                    labelCFirstElemenLgend = 1
                    
                colorMe = colorMeTimeS[firstYc]
                
                whiskerCount = whiskerCount + 1
                
                print ('Lbox', Lbox)
                LboxList = []
                with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                    for line in islice(readToA, 0, None):
                        dateToList = line.split()[1]
                        convertedDate = dt.datetime.strptime(dateToList,'%m/%d/%Y').date() 
                        if Lbox == convertedDate:
                            #print ('Lbox matched')
                            getValue = line.split()[2]
                            LboxList.append(float(getValue))
                
                plt.boxplot(LboxList, positions=[whiskerCount], patch_artist=True, 
                        boxprops=dict(facecolor=colorMe, color=colorMe), 
                        showmeans = True, meanline = True, meanprops = dict(color = "black", linewidth = 1.5, linestyle = 'dotted')) #, notch=True)
                  

                labelWc.append(whiskerCount)
                labelWv.append(Lbox)

                labelWcF.append(whiskerCount)
                labelWvF.append(Lbox)  
                
                meanL = np.mean(LboxList)
                meansLineA.append(meanL)
            
                plt.plot(labelWc, meansLineA, color=colorMe, label=str(LL) if labelCFirstElemenLgend == 1 else "")
            
            print ('labelWc', labelWc)
            print ('labelWv', labelWv)
            print ('meansLineA', meansLineA)
            plt.legend(loc='upper left')
            plt.xticks(labelWcF, labelWvF, fontsize=6)
            plt.xticks(rotation=15)

            saveHere = str(myfilepath) + '/SaveFigures' + '/' + 'BoxPlot.png'
            plt.savefig(saveHere, dpi=600) 

        #################
        #################
        print ('------------- lines------------')
        figureallLines = plt.figure()

        plt.ylabel(str(self.dlg.comboBox.currentText()) + ', black dotted line is mean')
        plt.gca().set_ylim([0,1])

        plt.xlabel('DOY')
        plt.gca().set_xlim([0,365])
        plt.xticks(np.arange(0, 366, 30))

        firstY = yearsToUse[0]
        firstYc = 0
        labelCFirstElemenLgend = 0
        whiskerCount = 0
        labelWc = []

        meansLineA = []
        for Lbox in newList:
            LL = str(Lbox).split('-')[0]
            print ('LL me', LL)
            #whiskerCount = whiskerCount + 1   
            labelCFirstElemenLgend = labelCFirstElemenLgend + 1
            if firstY != LL:
                firstYc = firstYc + 1
                firstY = LL
                
                labelWc = []                    
                meansLineA = []
                
                labelCFirstElemenLgend = 1
                
            colorMe = colorMeTimeS[firstYc]
            
            whiskerCount = whiskerCount + 1
            
            print ('Lbox', Lbox)
            LboxList = []
            with open('{}/Eavaluation.txt'.format(myfilepath), 'r') as readToA:
                for line in islice(readToA, 0, None):
                    dateToList = line.split()[1]
                    convertedDate = dt.datetime.strptime(dateToList,'%m/%d/%Y').date() 
                    if Lbox == convertedDate:
                        #print ('Lbox matched')
                        getValue = line.split()[2]
                        LboxList.append(float(getValue))
                        doy = int(convertedDate.strftime('%j'))

            labelWc.append(doy) #whiskerCount) 
            
            meanL = np.mean(LboxList)
            meansLineA.append(meanL)
        
            plt.plot(labelWc, meansLineA, linestyle='--', marker='o', color=colorMe, label=str(LL) if labelCFirstElemenLgend == 1 else "")
            print ('plotting the line')
            print ('labelWc-------', labelWc)
            print ('meansLineA--------', meansLineA)
        plt.legend(loc='upper left')

        saveHere = str(myfilepath) + '/SaveFigures' + '/' + 'BoxPlotLines.png'
        plt.savefig(saveHere, dpi=600) 

        self.dlg.listWidget_4.setCurrentRow(0)

        self.dlg.textBrowser.append('   Time-series trends for each grid of all selected Layers saved in SaveFigures directory!')

#####################  pdf      
    def pdf_summary(self):

        selectedLayer = str(self.dlg.listWidget.currentItem().text())            
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]

        myfilepathP = polygonLayer.source()
        myfilepathP = os.path.dirname(myfilepathP)
        print ('myfilepathP input image', myfilepathP) 

        try:
            os.mkdir(myfilepathP + '/SavePDFs')
        except:
            print ('dir exist')

        myfilepathPd = myfilepathP + '/SavePDFs' 
        print ('myfilepathPd', myfilepathPd)
        
        myfilepathPd = os.path.normpath(myfilepathPd)
        print ('myfilepathPd norm', myfilepathPd)

        self.dlg.textBrowser.append('\n   Simple map photos will be saved in - ' + str(myfilepathPd) + ' - in directory')

        QCoreApplication.processEvents()
        QgsProject.instance().reloadAllLayers()
         

        mapping = '_mapping'
        if self.dlg.checkBox_4.isChecked():
            mapping = '_indexMap'
        if self.dlg.checkBox_5.isChecked():
            mapping = '_NappMap'            

        useListWidget = self.dlg.listWidget_3.selectedItems()
        if self.dlg.checkBox_5.isChecked():
            useListWidget = self.dlg.listWidget_4.selectedItems()
        for selectedImage in useListWidget: #self.dlg.listWidget_3.selectedItems():
            selectedLayer = selectedImage.text()
            print ('--------------------------0------------------------')
            #QgsProject.instance().reloadAllLayers()
            QCoreApplication.processEvents()
            vlayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
            vlayer.triggerRepaint()
            iface.setActiveLayer(vlayer)
            
            #vlayer.triggerRepaint()                  
            QCoreApplication.processEvents()             

            #image_location = os.path.join(QgsProject.instance().homePath(), str(selectedLayer) + '.png') #"render.png")            
            image_location = os.path.join(myfilepathPd, str(selectedLayer) + str(mapping) + '.png') #"render.png")
            print ('image_location', image_location)
            QCoreApplication.processEvents()
            print ('vlayer', vlayer)
            options = QgsMapSettings()
            options.setLayers([vlayer])
            options.setBackgroundColor(QColor(255, 255, 255))
            options.setOutputSize(QSize(800, 600))
            options.setExtent(vlayer.extent())
            QCoreApplication.processEvents()
            render = QgsMapRendererParallelJob(options)
            QCoreApplication.processEvents()
            
            def finished():

                img = render.renderedImage()

                for feature in vlayer.getFeatures():
                   print (feature.id())
                   #self.dlg.textBrowser.append(str(feature.id()))

                #img.save(image_location, "png")
                img.save(image_location)
                
                
                QCoreApplication.processEvents()
                print("saved")
                self.dlg.textBrowser.append('      *' + str(selectedLayer) + '- Index Map Saved!')
                #return
                
            QCoreApplication.processEvents()
            
            render.finished.connect(finished) 
            render.start()
            
            QCoreApplication.processEvents()
            
            # loop = QEventLoop()            
            # render.finished.connect(loop.quit)            
            
            QCoreApplication.processEvents()
            vlayer.triggerRepaint() 
            print ('--------------------------1------------------------')
            QCoreApplication.processEvents()
            
##############################               

    def nitrogen_prescriptions(self):
        print ('N prescriptions')
        self.dlg.textBrowser.append('\nSection 4.:')
        self.dlg.textBrowser.append('   Nitrogen prescriptions running...')
        self.dlg.checkBox_4.setChecked(False)
        self.dlg.checkBox_5.setChecked(True)
        if self.dlg.checkBox_5.isChecked():
            self.dlg.pushButton_3.setEnabled(False)
            self.dlg.pushButton_5.setEnabled(True)

        selectedLayer = str(self.dlg.listWidget.currentItem().text())            
        polygonLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]

        myfilepathP = polygonLayer.source()
        myfilepathP = os.path.dirname(myfilepathP)
        print ('myfilepathP input image', myfilepathP) 

        try:
            os.mkdir(myfilepathP + '/SavePDFs')
        except:
            print ('dir exist')

        myfilepathPd = myfilepathP + '/SavePDFs' 
        print ('myfilepathPd', myfilepathPd)
        
        myfilepathPd = os.path.normpath(myfilepathPd)
        print ('myfilepathPd norm', myfilepathPd)


        
        selectedLayer = str(self.dlg.listWidget_4.currentItem().text())            
        activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        
        # this one changes the active layer... form of refresh qgis list
        iface.setActiveLayer(activeLayer)
        
        QCoreApplication.processEvents()
        
        for field in activeLayer.fields():
            idx = activeLayer.dataProvider().fieldNameIndex(str(self.dlg.comboBox.currentText()))                

        listOfValues = []
        for feature in activeLayer.getFeatures():                    
            print ('field', feature.id(), 'value',feature.attributes()[idx])
            listOfValues.append(float(feature.attributes()[idx]))
        
        myMin = np.min(listOfValues)
        myMax = np.max(listOfValues)
        
        print ('myMin', myMin)
        print ('myMax', myMax)

        myMinLow = myMin
        myMaxHihg = myMax
        myMaxHihgEnd = myMax
        
        Napplication = 'Napp'

        provider = activeLayer.dataProvider()
        #area_field = QgsField('Yield', QVariant.Int)
        area_field = QgsField(Napplication, QVariant.Int)
        provider.addAttributes([area_field])
        #layer.updateFields()
        idxN = provider.fieldNameIndex(Napplication)
        
        QgsProject.instance().reloadAllLayers()

        classMeNumber = int(self.dlg.lineEdit_2.text())
        classMeDiscStep = (myMax - myMin) / classMeNumber
        
        NminInp = int(self.dlg.lineEdit_3.text())       
        NmaxInp = int(self.dlg.lineEdit_4.text()) 
        NincInp = (NmaxInp - NminInp) / (classMeNumber - 1) 
        
        graphingDistribution = []
        boxPlotNumber = 1
        yAxisPlaceHolderForJitter = []
        
        countHm = 0



        fc = polygonLayer.featureCount()
        print ('fc', fc)            
        percentInc = 100/fc
        percent = 0
        
       
        QCoreApplication.processEvents()
        
        for feature in activeLayer.getFeatures():        
            attrs = feature.attributes()
            countHm = countHm + 1
            
            percent = percent + percentInc 
            

            
            myMin = myMinLow #np.min(listOfValues)
            myMax = myMaxHihg #np.max(listOfValues)
            

            NminInp = int(self.dlg.lineEdit_3.text())       
            NmaxInp = int(self.dlg.lineEdit_4.text()) 

            if self.dlg.checkBox_3.isChecked():
                NminInp = NmaxInp
            
            for i in range(1, classMeNumber+1):
                print ('----------------------------')

                myMin= myMin
                myMax= myMin + (classMeDiscStep)
                
                applicationNrate = NminInp
                
                if round(float(feature.attributes()[idx]), 3) >= round(myMin, 3) and round(float(feature.attributes()[idx]), 3) < round(myMax, 3):
                    attrsM = {idxN : int(applicationNrate)}
                    activeLayer.dataProvider().changeAttributeValues({feature.id() : attrsM})
                    QCoreApplication.processEvents()
                    
                    graphingDistribution.append(float(applicationNrate))

                    jitterAdded = np.random.normal(boxPlotNumber, 0.04)
                    yAxisPlaceHolderForJitter.append(jitterAdded)
                    print ('match found')    


                print ('     countHm', countHm, 'class number', i, 'value',str(round(feature.attributes()[idx], 3)))
                print ('     myMin', str(round(myMin, 3)), 'myMax', str(round(myMax, 3)), 'applicationNrate', applicationNrate)

                if self.dlg.checkBox_2.isChecked():
                    NminInp = NminInp + NincInp

                if self.dlg.checkBox_3.isChecked():
                    NminInp = NminInp - NincInp
                
                myMin = myMax  

            # get the last max due to condition min <=  and   < max
            if round(float(feature.attributes()[idx]), 3) == round(myMaxHihgEnd, 3):    
                attrsM = {idxN : int(applicationNrate)}
                activeLayer.dataProvider().changeAttributeValues({feature.id() : attrsM})
                QCoreApplication.processEvents()
                
                graphingDistribution.append(float(applicationNrate))

                jitterAdded = np.random.normal(boxPlotNumber, 0.04)
                yAxisPlaceHolderForJitter.append(jitterAdded)
                print ('match found') 
                # 

            
            self.dlg.progressBar_4.setValue(int(percent))
            
            QgsProject.instance().reloadAllLayers()
            activeLayer.triggerRepaint()
            QCoreApplication.processEvents()
    ############################################ add labels to the active layer - start
        
        layer = iface.activeLayer()
        layer_settings  = QgsPalLayerSettings()
        text_format = QgsTextFormat()
        text_format.setFont(QFont("Arial", 10))
        text_format.setSize(12)

        layer_settings.setFormat(text_format)
        layer_settings.fieldName = Napplication  #"N-app"
        layer_settings.isExpression = True
        #layer_settings.placement = 1
        layer_settings.formatNumbers = True  # checkbox
        layer_settings.decimals = 1  # decimals number
        layer_settings.enabled = True
        layer_settings = QgsVectorLayerSimpleLabeling(layer_settings)
        
        layer.setLabelsEnabled(True)
        layer.setLabeling(layer_settings)
        
        layer.triggerRepaint()
        
        QgsProject.instance().reloadAllLayers()
        QCoreApplication.processEvents()
    ############################################ add labels to the active layer - end 

        layer = iface.activeLayer()
        fni = layer.fields().indexFromName(Napplication) #'nom')
        unique_values = layer.uniqueValues(fni)

        unique_values = sorted(unique_values)

        if self.dlg.checkBox_3.isChecked():
            unique_values = sorted(unique_values, reverse=False)    

        print ('unique_values', unique_values)

        colorMeSelected = str(self.dlg.comboBox_2.currentText())
        redMe = 255
        greenMe = 255
        blueMe = 255
        colorMeIntDiscStep = int((255 - 5) / int(len(unique_values)))


        # fill categories
        categories = []
        
        
        
        for unique_value in unique_values:
            # initialize the default symbol for this geometry type
            symbol = QgsSymbol.defaultSymbol(layer.geometryType())
            
            # configure a symbol layer
            layer_style = {}
            layer_style['color'] = '%d, %d, %d' % (int(redMe), int(greenMe), int(blueMe)) #(randrange(0, 256), randrange(0, 256), randrange(0, 256))
            #print (layer_style['color'])
            #layer_style['outline'] = '#000000'
            #layer_style['color'] = redMe, greenMe, blueMe
            print (layer_style['color'])
            #layer_style['outline'] = '#000000'
            symbol_layer = QgsSimpleFillSymbolLayer.create(layer_style)

            # replace default symbol layer with the configured one
            #if symbol_layer is not None:
            symbol.changeSymbolLayer(0, symbol_layer)

            # create renderer object
            # category = QgsRendererCategory(unique_value, symbol, str(unique_value))
            category = QgsRendererCategory(unique_value, symbol, str(unique_value))            

            # entry for the list of category items
            categories.append(category)



            if colorMeSelected == 'red':            
                redMe = redMe
                greenMe = greenMe - colorMeIntDiscStep
                blueMe = blueMe - colorMeIntDiscStep
            if colorMeSelected == 'green':            
                redMe = redMe - colorMeIntDiscStep
                greenMe = greenMe
                blueMe = blueMe - colorMeIntDiscStep                              
            if colorMeSelected == 'blue':            
                redMe = redMe - colorMeIntDiscStep
                greenMe = greenMe - colorMeIntDiscStep
                blueMe = blueMe 



        # create renderer object
        renderer = QgsCategorizedSymbolRenderer(Napplication, categories)

        # assign the created renderer to the layer
        #if renderer is not None:
        layer.setRenderer(renderer)

        layer.triggerRepaint()
        QgsProject.instance().reloadAllLayers()


#######################

        numberOfObsPerYear = int(len(graphingDistribution)) # 1
        c = 'blue'

        boxPlotListAll = []

        figure, axis = plt.subplots(2,1, gridspec_kw={'height_ratios': [2, 1]})
      
        steps_parameter = 1

        boxPlotListAll.append(graphingDistribution)

        arrayMe = np.array(graphingDistribution)

        arrayMeMin = min(arrayMe)
        arrayMeMax = max(arrayMe)

        arrangedMe = np.arange(arrayMeMin, arrayMeMax, steps_parameter)
        meanMe = statistics.mean(arrayMe)
        medianMe = statistics.median(arrayMe)
        sdMe = statistics.stdev(arrayMe)   

        axis[0].plot(arrangedMe, norm.pdf(arrangedMe, meanMe, sdMe),
                label='grids' + ' (n={})'.format(int(numberOfObsPerYear)) +'\n' + '(Std.dev.:{})'.format(int(sdMe)) +'\n' + '(Field avg.:{})'.format(int(meanMe)), color=c)

        axis[0].axvline(meanMe, color=c, linestyle='dashed', linewidth=1)
        axis[1].axvline(meanMe, linestyle='dashed', color=c, linewidth=1)
        axis[1].scatter(arrayMe, yAxisPlaceHolderForJitter, color=c, alpha=0.5, marker='o', s=10)
        
        b = axis[1].boxplot(boxPlotListAll, vert=0)
   
        axis[1].set_xlabel('Distribution of N application rates [kg ha$^{-1}$]', fontsize=11)       
        axis[0].legend(loc='center left', bbox_to_anchor=(0.8, 0.5), facecolor='white', framealpha=1.0)    
        figure.savefig('{}/{}_DistributionMe.jpg'.format(myfilepathPd, selectedLayer)) #, dpi=300)
        
############

        nrates = np.array(graphingDistribution)
        numberOfnrates = int(len(graphingDistribution))

        mu = statistics.mean(nrates)
        sigma = statistics.stdev(nrates)
        num_bins = int(len(unique_values))
        
        print ('num_bins', num_bins)

        fig, ax = plt.subplots()

        n, bins, patches = ax.hist(nrates, num_bins, density=True, edgecolor='white', linewidth=2)
        y = ((1 / (np.sqrt(2 * np.pi) * sigma)) * np.exp(-0.5 * (1 / sigma * (bins - mu))**2))
        ax.plot(bins, y, '--')
        ax.set_xlabel('Value')
        ax.set_ylabel('Probability density')
        ax.set_title('Histogram of normal distribution sample: 'fr'$\mu={mu:.0f}$, $\sigma={sigma:.0f}$')
        fig.tight_layout()
        fig.savefig('{}/{}_Distribution.jpg'.format(myfilepathPd, selectedLayer)) #, dpi=300)

########################

        fig = plt.figure()        
        plt.hist(nrates) #, bins=25, density=True, alpha=0.6, color='b')
        plt.grid(axis = "y")
        plt.xlabel('N application rates')
        plt.ylabel('Number of N application rates')        
        fig.savefig('{}/{}_Histogram.jpg'.format(myfilepathPd, selectedLayer)) #, dpi=300)
        self.dlg.textBrowser.append('   Nitrogen prescriptions finishd.')
        
    def scale_Napp_to_actual_size_of_grid(self):
        print ('scale n to actual grid size')
        self.dlg.textBrowser.append('\n   Nitrogen applications resaclling according to size of grid running...')
        
        selectedLayer = str(self.dlg.listWidget_4.currentItem().text())            
        activeLayer = QgsProject.instance().mapLayersByName(selectedLayer)[0]
        
        iface.setActiveLayer(activeLayer)

        Napplication = 'Napp'
        provider = activeLayer.dataProvider()
        #area_field = QgsField('Yield', QVariant.Int)
        area_field = QgsField(Napplication, QVariant.Int)
        provider.addAttributes([area_field])
        #layer.updateFields()
        idxN = provider.fieldNameIndex(Napplication)


        NapplicationA = 'actualNkg'
        provider = activeLayer.dataProvider()
        #area_field = QgsField('Yield', QVariant.Int)
        area_field = QgsField(NapplicationA, QVariant.Double, 'double', 5, 2)
        provider.addAttributes([area_field])
        #layer.updateFields()
        idxNactual = provider.fieldNameIndex(NapplicationA)
        
        QgsProject.instance().reloadAllLayers()

        
        lyr_crs = activeLayer.crs()

        elps_crs = QgsCoordinateReferenceSystem()
        elps_crs.createFromUserInput('WGS84')

        trans_context = QgsCoordinateTransformContext()
        trans_context.calculateDatumTransforms(lyr_crs, elps_crs)

        area = QgsDistanceArea()
        area.setEllipsoid('WGS84')
        area.setSourceCrs(lyr_crs, trans_context)        
        QCoreApplication.processEvents()
        countHm = 0
        for feature in activeLayer.getFeatures():        
            #attrs = feature.attributes()
            attrs = feature.attributes() #[3]
            print ('value of napp field', attrs[idxN])
            countHm = countHm + 1

            
            #area
            geom= feature.geometry() 
            print ('countHm', countHm)
            print("Perimeter(m):",area.measurePerimeter(geom))
            print("Area (m2):", area.measureArea(geom))          
            print ("Feature---areaMe--%of hectart---------: ", str((area.measureArea(geom))/10000))

            applicationNrateA = float(attrs[idxN]) * ((area.measureArea(geom))/10000)

            print ('value of napp field', attrs[idxN])
            print ('value of napp kg per grid', applicationNrateA)

            attrsM = {idxNactual : float(applicationNrateA)}
            activeLayer.dataProvider().changeAttributeValues({feature.id() : attrsM})
            QCoreApplication.processEvents()   
        self.dlg.textBrowser.append('   Nitrogen applications resaclling according to size of grid finished.')            