
class NdffLibError(Exception):
    """
    A NdffLibError is a generic Exception/Error raised by the ndff library (and clients)
    """
    def __init__(self, message, errors=None):
        """
        Create a (generic) NdffLibError with given message and errors

        :param message: Message to show
        :param errors: list of errors or None
        """
        # Call the base class constructor with the parameters it needs
        super().__init__(message)
        # custom code, list of errors?
        self.errors = errors
