# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PluginApiCredentialsDialog
 This Dialog is a generic dialog to show results in a table like manner
                             -------------------
        begin                : 2021-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Zuidt
        email                : richard@zuidt.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import logging
import os

from qgis.PyQt import QtWidgets, uic
from qgis.PyQt.QtGui import (
    QStandardItem,
    QStandardItemModel,
)
from qgis.PyQt.QtWidgets import (
    QAbstractItemView,
    QHeaderView,
)

from . import LOGGER_NAME

log = logging.getLogger(LOGGER_NAME)

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ndffc_plugin_results_dialog_base.ui'))


class PluginResultsDialog(QtWidgets.QDialog, FORM_CLASS):
    """
    This class is a Qt Dialog.

    This Dialog is a generic dialog to show results in a table like manner, in which data comes from a list, array
    or dict.
    """
    def __init__(self, parent=None):
        """
        Constructor, which sets up the UI and triggers
        """
        super(PluginResultsDialog, self).__init__(parent)
        self.setupUi(self)
        self.tbl_results.setEditTriggers(QAbstractItemView.NoEditTriggers)

    def set_data(self, data):
        """
        Set data in the dialog.
        A user can hide a dialog and reuse it by calling set_data after it.
        That will clean up the model (thereby also the dialog) and create new content in the Table(view)
        Data can be a simple List/Array, OR a dictionary
        """
        results_model = QStandardItemModel()
        if isinstance(data, list):
            self.tbl_results.setModel(results_model)
            for item in data:
                results_model.appendRow([QStandardItem(item)])
        elif isinstance(data, dict):
            self.tbl_results.setModel(results_model)
            for key, value in data.items():
                results_model.appendRow([QStandardItem(key), QStandardItem(value)])

        self.tbl_results.verticalHeader().setVisible(False)
        self.tbl_results.horizontalHeader().setVisible(False)
        self.tbl_results.horizontalHeader().setSectionResizeMode(QHeaderView.Stretch)
        self.tbl_results.resizeColumnToContents(0)
        if results_model.columnCount() == 2:
            self.tbl_results.resizeColumnToContents(1)
        self.tbl_results.horizontalHeader().setStretchLastSection(True)
        self.tbl_results.horizontalHeader().setSectionResizeMode(QtWidgets.QHeaderView.ResizeToContents)
