# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Plugin
                                 A QGIS plugin
 This plugin connects to the NDFF api
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2021-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Zuidt
        email                : richard@zuidt.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import (
    QSettings,
    QCoreApplication,
    Qt,
    QUrl,
)
from qgis.PyQt.QtGui import (
    QDesktopServices,
    QIcon,
)
from qgis.PyQt.QtWidgets import (
    QAction,
    QDialog,
)
from .ndffc_plugin_dialog import PluginMainDialog
from .ext.ndff.exceptions import (
    NdffException,
)
from pathlib import Path
import logging
log = logging.getLogger(__name__)

DEV = False  # development mode: try to import pydevd, and make dialog NON-modal
if DEV:
    # show all logging!
    logging.getLogger('ndff_connector_plugin').setLevel(logging.DEBUG)
    logging.getLogger('ndff_connector_plugin.ext.ndff.api').setLevel(logging.DEBUG)
    logging.getLogger('ndff_connector_plugin.ext.ndff.connector').setLevel(logging.DEBUG)
    try:
        import pydevd
        pydevd.settrace('localhost', port=5678, stdoutToServer=True, stderrToServer=True, suspend=False)
    except NdffException as e:
        log.debug('In DEV modus, but failing to load pydevd... (can be ignored)')


class NdffConnectorPlugin:

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = Path(__file__).parent
        # Declare instance attributes
        self.actions = []
        self.menu = 'NDFF Connector Plugin'
        self.toolbar = None

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

        # TODO: move the initialisation of these properties to a function
        # in that way we are able to 're-init' these props to None in case of
        # the user reloads a new project (as it could be that the plugin is still
        # having a pointer to a (now vanished) old layer/feature/...
        # raising the dreaded: "RuntimeError: wrapped C/C++ object of type QgsVectorLayer has been deleted"
        self.connector = None
        self.current_layer = None
        self.current_feature = None
        self.current_project_settings = None
        self.observation = None
        self.data_set = None
        self.data_record = None

        self.main_dlg = None

        self.iface.projectRead.connect(self.project_loaded)
        self.iface.newProjectCreated.connect(self.project_loaded)

    def project_loaded(self):
        """
        Event when the user changes current project to a new one or other one.
        This plugin keeps track of some map object, most notable the
        'current_layer'.
        When changing the project, a possible reference to a layer in the
        just unloaded project would throw an ugly
        "RuntimeError: wrapped C/C++ object of type QgsVectorLayer has been deleted"
        exception.
        By setting the current_* props to null this is now fine...
        """
        # log.debug("Project change... cleanup of 'current_***'")
        self.current_layer = None
        self.current_feature = None
        self.current_project_settings = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('Plugin', message)

    def add_action(self,
                   icon_path,
                   text,
                   callback,
                   enabled_flag=True,
                   add_to_menu=True,
                   add_to_toolbar=True,
                   status_tip=None,
                   whats_this=None,
                   parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            self.toolbar.addAction(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):  # NOSONAR
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        self.toolbar = self.iface.addToolBar(self.menu)
        self.toolbar.setObjectName(self.menu)
        self.toolbar.setToolTip(self.menu)

        icon_path = str(self.plugin_dir / 'ndff_48x48.png')
        self.add_action(
            icon_path,
            text='NDFF Connector Dialoog',
            callback=self.run,
            parent=self.iface.mainWindow())
        icon_path = str(self.plugin_dir / 'ndff_48x48_docs.png')
        self.add_action(
            icon_path,
            text=self.tr(u'Documentatie'),
            callback=self.show_help,
            parent=self.iface.mainWindow())
        # will be set False in run()
        self.first_start = True

    @staticmethod
    def show_help():
        doc_index = 'https://ndff.zendesk.com/hc/nl/articles/9810827803805-Leveren-van-natuurdata-met-behulp-van-de-NDFF-connector-plugin-'
        QDesktopServices().openUrl(QUrl(doc_index))

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        if self.main_dlg:
            self.main_dlg.done(QDialog.Rejected)  # Close the dialog if unloading
        for action in self.actions:
            self.iface.removePluginMenu(
                self.menu,
                action)
            self.toolbar.removeAction(action)
        del self.toolbar

    def run(self):
        if self.main_dlg is None:
            self.main_dlg = PluginMainDialog(self.iface, parent=self.iface.mainWindow())
        # either in DEV mode, OR set by user, set modality to FALSE
        if DEV or QSettings().value("/ndffc_plugin/main_window_modality", False):
            log.debug(f'Set MODALITY of main window to FALSE, DEV = {DEV}, QSettings main_window_modality = {QSettings().value("/ndffc_plugin/main_window_modality", False)}')
            self.main_dlg.setModal(False)
        else:
            log.debug('Set MODALITY of main window to TRUE')
            self.main_dlg.setModal(True)
            self.main_dlg.setWindowModality(Qt.ApplicationModal)  # https://doc.qt.io/qt-5/qt.html#WindowModality-enum
        self.main_dlg.show_dialog()
