# -*- coding: utf-8 -*-
"""
/***************************************************************************
 PluginApiCredentialsDialog
 This plugin connects to the NDFF api
                             -------------------
        begin                : 2021-12-20
        git sha              : $Format:%H$
        copyright            : (C) 2021 by Zuidt
        email                : richard@zuidt.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from qgis.PyQt.QtGui import (
    QStandardItemModel,
    QStandardItem,
)
from qgis.PyQt.QtWidgets import (
    QHeaderView,
    QAbstractItemView,
)

import logging
from . import LOGGER_NAME
log = logging.getLogger(LOGGER_NAME)

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'ndffc_plugin_results_dialog_base.ui'))

class PluginResultsDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        super(PluginResultsDialog, self).__init__(parent)
        self.setupUi(self)
        self.tbl_results.setEditTriggers(QAbstractItemView.NoEditTriggers)

    def set_data(self, data):
        """
        Data can be a simple List/Array, OR a dictionary

        Can be called multiple times ????
        """
        # cleanup ??
        # self.results_model.removeRows(0, self.results_model.rowCount())
        if isinstance(data, list):
            results_model = QStandardItemModel()
            self.tbl_results.setModel(results_model)
            for item in data:
                results_model.appendRow([QStandardItem(item)])
        elif isinstance(data, dict):
            results_model = QStandardItemModel()
            self.tbl_results.setModel(results_model)
            for key, value in data.items():
                results_model.appendRow([QStandardItem(key), QStandardItem(value)])

        self.tbl_results.verticalHeader().setVisible(False)
        self.tbl_results.horizontalHeader().setVisible(False)
        self.tbl_results.horizontalHeader().setSectionResizeMode(QHeaderView.Stretch)
        self.tbl_results.resizeColumnToContents(0)
        if results_model.columnCount() == 2:
            self.tbl_results.resizeColumnToContents(1)
        self.tbl_results.horizontalHeader().setStretchLastSection(True)
        self.tbl_results.horizontalHeader().setSectionResizeMode(QtWidgets.QHeaderView.ResizeToContents)

    # def accept(self) -> None:
    #     log.debug(f'OK, clicked.')
    #     if self.test():
    #         self.done(QDialog.Accepted)
    #     else:
    #         self.done(QDialog.Rejected)
