# -*- coding: utf-8 -*-
"""
/***************************************************************************
 NavarraCadastre
                                 A QGIS plugin
 Description
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-08-24
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Asociación Geoinnova
        email                : patricio.soriano@geoinnova.org
 ***************************************************************************/

"""

from .Config import _port
from .Config import _proxy
import urllib.request
import zipfile
import urllib
from urllib import request, parse

import sys
import os.path
import shutil

import subprocess


# TimeOut para la descarga de 5 segundos
import socket

from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction

from PyQt5.QtWidgets import QFileDialog

# Initialize Qt resources from file resources.py
from .resources import *

# Import the code for the dialog
from .navarra_cadastre_dialog import NavarraCadastreDialog


from .listamuni import *
from qgis.core import Qgis, QgsProject, QgsVectorLayer, QgsLayerTreeLayer

from qgis.gui import QgsMessageBar

listMunicipios = LISTMUNI
cod_muni_navarra = ''


class NavarraCadastre:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        self.msgBar = iface.messageBar()
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)

        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'NavarraCadastre_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)

            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&Navarra Cadastre')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('NavarraCadastre', message)

    def add_action(
            self,
            icon_path,
            text,
            callback,
            enabled_flag=True,
            add_to_menu=True,
            add_to_toolbar=True,
            status_tip=None,
            whats_this=None,
            parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """
        # Create the dialog (after translation) and keep reference
        self.dlg = NavarraCadastreDialog()
        # self.dlg.setWindowFlags(Qt.WindowSystemMenuHint | Qt.WindowTitleHint)

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = ':/plugins/navarra_cadastre/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Navarra Cadastre'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        # self.first_start = True
        self.dlg = NavarraCadastreDialog()
        self.dlg.pushButton_select_path.clicked.connect(
            self.select_output_folder)
        self.dlg.pushButton_run.clicked.connect(self.download)

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&Navarra Cadastre'),
                action)
            self.iface.removeToolBarIcon(action)

    def select_output_folder(self):
        """Select output folder"""

        self.dlg.lineEdit_path.clear()
        folder = QFileDialog.getExistingDirectory(self.dlg, "Select folder")
        self.dlg.lineEdit_path.setText(folder)

    def not_data(self):
        """Message for fields without information"""
        self.msgBar.pushMessage(
            'Completar datos de municipio o indicar la ruta de descarga', level=Qgis.Critical, duration=3)

    def reporthook(self, blocknum, blocksize, totalsize):
        """Progress Download"""
        readsofar = blocknum * blocksize
        if totalsize > 0:
            percent = readsofar * 1e2 / totalsize
            self.dlg.progressBar.setValue(int(percent))

    def EncodeUrl(self, url):
        """Encode URL Download"""
        url = parse.urlsplit(url)
        url = list(url)
        url[2] = parse.quote(url[2])
        encoded_link = parse.urlunsplit(url)
        return encoded_link

    def getZipFile(self, municipality_value, datatype):
        """Get cadastre zip file from url

        :param municipality_value: Text with the code and the name of the municipality.
        :type text: str

        :param datatype: Type of data to download (grafico or alfanumerico)
        :type text: str
        """

        municod = municipality_value[0:3]
        folder = municipality_value.replace('/', '_')
        datatype_code = ''
        zip_data_type = ''

        zippath = self.dlg.lineEdit_path.text()

        wd = os.path.join(zippath, folder)

        if (datatype == '1'):
            datatype_code = 'grafico'
            zip_data_type = 'grafico'
        elif (datatype == '2'):
            datatype_code = 'alfanumerico'
            zip_data_type = 'alfanumerico'
        else:
            datatype_code = 'grafico'
            zip_data_type = 'grafico'

        url = u'https://catastro.navarra.es/descargas/municipios/%s/08/%s.zip' % (
            municod, datatype_code)
        try:
            os.makedirs(wd)
        except OSError:
            pass

        zipCartography = os.path.join(
            wd, "%s_%s.zip" % (folder, zip_data_type))

        e_url = self.EncodeUrl(url)

        try:
            urllib.request.urlretrieve(
                e_url, zipCartography, self.reporthook)
        except:
            shutil.rmtree(wd)
            raise

    def unzip_file(self, muniname, zip_data_type):
        """Unzip file

        :param muniname: Text with the name of the municipality.
        :type text: str

        :param zip_data_type: Info text
        :type text: str
        """

        zippath = self.dlg.lineEdit_path.text()
        wd = os.path.join(zippath, muniname)

        if os.path.isdir(wd):
            for zipfilecatastro in os.listdir(wd):
                if zipfilecatastro.endswith('.zip'):
                    with zipfile.ZipFile(os.path.join(wd, zipfilecatastro), "r") as z:
                        z.extractall(wd)
            self.msgBar.pushMessage(
                "%s files unzipped successfully in %s" % (zip_data_type, wd), level=Qgis.Info, duration=3)

    def addLayerGroup(self, muniname):
        """ Add all shapefiles in the dowload folder into a group """

        root = QgsProject.instance().layerTreeRoot()
        layerGroup = root.addGroup(muniname)

        zippath = self.dlg.lineEdit_path.text()
        wd = os.path.join(zippath, muniname)

        for shape_item in os.listdir(wd):
            if shape_item.endswith('.shp'):
                vlayer = QgsVectorLayer(os.path.join(
                    wd, shape_item), shape_item, "ogr")
                QgsProject.instance().addMapLayer(vlayer, False)
                layerGroup.insertChildNode(
                    1, QgsLayerTreeLayer(vlayer))

    def download(self):
        """Dowload data funtion"""

        if self.dlg.comboBox_municipality.currentText() == '' or self.dlg.lineEdit_path.text() == '':
            self.not_data()

        else:
            try:

                # QApplication.setOverrideCursor(QCursor(Qt.WaitCursor))
                cod_muni_navarra = self.dlg.comboBox_municipality.currentText()
                muniname = cod_muni_navarra.replace('/', '_')

                # download shapes zip
                if self.dlg.checkBox_cartography.isChecked():
                    self.getZipFile(cod_muni_navarra, '1')
                    self.unzip_file(muniname, 'Cartography')
                    self.addLayerGroup(muniname)

                # download data
                if self.dlg.checkBox_data.isChecked():
                    self.getZipFile(cod_muni_navarra, '2')
                    self.unzip_file(muniname, 'Data')

                # No llega al 100% aunque lo descargue,es random
                self.dlg.progressBar.setValue(100)

            except Exception as e:
                self.msgBar.pushMessage(
                    "Failed! " + str(e), level=Qgis.Warning, duration=3)
            return

    def run(self):
        """Run method that performs all the real work"""

        self.dlg.lineEdit_path.clear()
        self.dlg.checkBox_cartography.setChecked(0)
        self.dlg.checkBox_data.setChecked(0)

        self.dlg.progressBar.setValue(0)
        self.dlg.setWindowIcon(QIcon(':/plugins/navarra_cadastre/icon.png'))

        self.dlg.comboBox_municipality.clear()
        self.dlg.comboBox_municipality.addItems(listMunicipios)

        self.dlg.tabWidget.setCurrentIndex(0)

        # show the dialog
        self.dlg.show()
        # Run the dialog event loop
        result = self.dlg.exec_()
        # See if OK was pressed
        if result:
            # Do something useful here - delete the line containing pass and
            # substitute with your code.
            pass
