# -*- coding: utf-8 -*-

"""
/***************************************************************************
 EstimapRecreation
                                 A QGIS plugin
 Ecosystem services mapping at
European scale (ESTIMAP)- Recreation
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2019-02-08
        copyright            : (C) 2019 by NATCAPES
        email                : pmav99@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'NATCAPES'
__date__ = '2019-02-08'
__copyright__ = '(C) 2019 by NATCAPES'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os

from qgis.core import Qgis, QgsProcessingProvider, QgsMessageLog
from processing.algs.grass7.Grass7AlgorithmProvider import Grass7AlgorithmProvider
from processing.algs.grass7.Grass7Algorithm import Grass7Algorithm
from processing.tools.system import getTempFilename


class EstimapAlgorithm(Grass7Algorithm):
    def loadRasterLayerFromParameter(self, name, parameters, context, external=False, band=1):
        """
        Creates a dedicated command to load a raster into
        the temporary GRASS DB.
        :param name: name of the parameter.
        :param parameters: algorithm parameters dict.
        :param context: algorithm context.
        :param external: True if using r.external.
        :param band: imports only specified band. None for all bands.
        """
        layer = self.parameterAsRasterLayer(parameters, name, context)
        self.loadRasterLayer(name, layer, external, band)

    def loadRasterLayer(self, name, layer, external=False, band=1, destName=None):
        """
        Creates a dedicated command to load a raster into
        the temporary GRASS DB.
        :param name: name of the parameter.
        :param layer: QgsMapLayer for the raster layer.
        :param external: True if using r.external.
        :param band: imports only specified band. None for all bands.
        :param destName: force the destination name of the raster.
        """
        self.inputLayers.append(layer)
        self.setSessionProjectionFromLayer(layer)
        if not destName:
            destName = 'rast_{}'.format(os.path.basename(getTempFilename()))
        self.exportedLayers[name] = destName
        command = '{0} input="{1}" {2}output="{3}" --overwrite -o'.format(
            'r.external' if external else 'r.in.gdal',
            os.path.normpath(layer.source()),
            'band={} '.format(band) if band else '',
            destName)
        self.commands.append(command)


class EstimapRecreationProvider(Grass7AlgorithmProvider):

    descriptionFolder = os.path.join(os.path.dirname(__file__), 'description')

    def id(self):
        """
        Returns the unique provider id, used for identifying the provider. This
        string should be a unique, short, character only string, eg "qgis" or
        "gdal". This string should not be localised.
        """
        return 'NATCAPES'

    def name(self):
        """
        Returns the provider name, which is used to describe the provider
        within the GUI.

        This string should be short (e.g. "Lastools") and localised.
        """
        return self.tr('NATCAPES')

    def longName(self):
        """
        Returns the a longer version of the provider name, which can include
        extra details such as version numbers. E.g. "Lastools LIDAR tools
        (version 2.2.1)". This string should be localised. The default
        implementation returns the same string as name().
        """
        return self.name()

    def createAlgsList(self):
        algs = []
        folder = self.descriptionFolder
        for descriptionFile in os.listdir(folder):
            if descriptionFile.endswith('txt'):
                try:
                    alg = EstimapAlgorithm(os.path.join(folder, descriptionFile))
                    if alg.name().strip() != '':
                        algs.append(alg)
                    else:
                        QgsMessageLog.logMessage(self.tr('Could not open GRASS GIS 7 algorithm: {0}').format(descriptionFile), self.tr('Processing'), Qgis.Critical)
                except Exception as e:
                    QgsMessageLog.logMessage(
                        self.tr('Could not open GRASS GIS 7 algorithm: {0}\n{1}').format(descriptionFile, str(e)), self.tr('Processing'), Qgis.Critical)
        return algs
