# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Nadi
                                 A QGIS plugin
 Nadi (River) connections tool
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-12-21
        copyright            : (C) 2023 by Gaurav Atreya
        email                : allmanpride@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Gaurav Atreya'
__date__ = '2023-12-21'
__copyright__ = '(C) 2023 by Gaurav Atreya'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

import os
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication
from qgis.core import (
    QgsCategorizedSymbolRenderer,
    QgsMarkerSymbol,
    QgsProcessing,
    QgsProcessingAlgorithm,
    QgsProcessingLayerPostProcessorInterface,
    QgsProcessingParameterBoolean,
    QgsProcessingParameterFeatureSource,
    QgsProcessingParameterVectorDestination,
    QgsRendererCategory,
    QgsVectorLayer,
)
import pathlib
from .nadi_exe import qgis_nadi_proc


class NadiCheck(QgsProcessingAlgorithm):
    """
    Checks the stream network for invalid nodes
    """

    # Constants used to refer to parameters and outputs. They will be
    # used when calling the algorithm from another algorithm, or when
    # calling from the QGIS console.

    NODE_TYPES = 'NODE_TYPES'
    STREAMS = 'STREAMS'
    REVERSE = 'REVERSE'

    def initAlgorithm(self, config):
        # We add the input vector features source. It can have any kind of
        # geometry.
        self.addParameter(
            QgsProcessingParameterFeatureSource(
                self.STREAMS,
                self.tr('Input Streams'),
                [QgsProcessing.TypeVectorLine]
            )
        )
        self.addParameter(
            QgsProcessingParameterBoolean(
                self.REVERSE,
                self.tr('Reverse Stream Network Direction'),
                False
            )
        )

        self.addParameter(
            QgsProcessingParameterVectorDestination(
                self.NODE_TYPES,
                self.tr('Node Categories')
            )
        )

    def processAlgorithm(self, parameters, context, feedback):
        streams = self.parameterAsCompatibleSourceLayerPathAndLayerName(
            parameters, self.STREAMS, context, ["gpkg"]
        )
        reverse = self.parameterAsBool(
            parameters, self.REVERSE, context
        )
        node_cat = self.parameterAsOutputLayer(
            parameters, self.NODE_TYPES, context
        )
        cmd = ["check"]
        if reverse:
            cmd += ["--reverse"]
        if streams[1] == "":
            streams_file = f"{pathlib.Path(streams[0]).as_posix()}"
        else:
            streams_file = f"{pathlib.Path(streams[0]).as_posix()}::{streams[1]}"
        cmd += [
            streams_file,
            "--output",
            f"{pathlib.Path(node_cat).as_posix()}",
        ]

        proc = qgis_nadi_proc(feedback, cmd)
        res = proc.run(feedback)

        if feedback.isCanceled():
            feedback.pushInfo("Cancelled")
        elif res != 0:
            feedback.reportError("Error")
        else:
            feedback.pushInfo("Completed")

        context.layerToLoadOnCompletionDetails(node_cat).setPostProcessor(LayerPostProcessor.create())
        return {self.NODE_TYPES: node_cat}

    def name(self):
        return 'check_streams'

    def displayName(self):
        return self.tr("Check Streams")

    def icon(self):
        return QIcon(os.path.join(os.path.dirname(__file__), "check.png"))

    def group(self):
        return self.tr(self.groupId())

    def groupId(self):
        return 'Vector'

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return NadiCheck()


class LayerPostProcessor(QgsProcessingLayerPostProcessorInterface):
    instance = None

    def postProcessLayer(self, layer, context, feedback):
        if not isinstance(layer, QgsVectorLayer):
            return

        cats = QgsCategorizedSymbolRenderer("category", [
                get_sym("Origin", False, color='gray', size=0.5),
                get_sym("Confluence", False, color='green', size=0.8),
                get_sym("Branch", True, color='red'),
                get_sym("Outlet", True, color='blue', size=4.0),
        ])
        layer.setRenderer(cats)

    @staticmethod
    def create() -> 'LayerPostProcessor':
        LayerPostProcessor.instance = LayerPostProcessor()
        return LayerPostProcessor.instance


def get_sym(val, render, **props):
    return QgsRendererCategory(
        val,
        QgsMarkerSymbol.createSimple(props),
        val,
        render,
        "node_cat_"+val.lower()
        )
